/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.core;

//import java.util.ArrayList;
//import java.util.Map;

//import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
//import org.eclipse.core.resources.IProjectDescription;
//import org.eclipse.core.resources.IWorkspace;
//import org.eclipse.core.resources.ResourcesPlugin;
//import org.eclipse.swt.widgets.Display;



public interface INtkProjectManager{
    public String getProjectDefaultData(long prj,String var,int encoding);
    public String getProjectData(long prj,String var,int encoding);
    public int    setProjectData(long prj,String var,String val,int encodeing);
    
    public long   getStaticData(int kind,long id);
    public String getStaticData(int kind,long id,int encoding);
    public String getStaticData(int kind,String key,int encoding);
    public String getEnvironmentData(String key,int encoding);
    public int    setEnvironmentData(String key,String val,int encoding);
    public int    saveEnvironmentData();
    
    public int    doOperation(long prj,int kind);
    
    public void   closeNtkProject(IProject prj);
    public void   saveNtkProject(IProject prj);
    public void   saveCurrentNtkProject();
    
    public void   createCurrentNtkProjectSources();
    public long   loadNtkProject(String prj_name,IProject prj);
    public long   createNewNtkProject(String prj_name);
    public String getCurrentProjectFullPath();
    public String getProjectPath();
    public void   setCurrentProjectName(String name);
    public String getCurrentProjectName();
    public long   getCurrentProject();
    public void   addNature(IProject prj,String natureID);
    public void   configureNtkProject(IProject prj,String lang);
    public String getNatureId();
    public boolean existFile(String fname);
    public int    getCurrentProjectLangType();
    public int    createProcedure(String dirname,String filename,int langType,String functionName,String classname);
}
