/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/


package org.eclipse.nab.core;

import java.lang.reflect.*;
import java.util.*;

	public class NtkEventCallbackManager {
		class ProcTable {
			public long id;
			public String trigger;
			public String method;
			public Method mid;
			public Object inst;
			public Object par;		
		}
		
		ArrayList table = new ArrayList();

//		public static void main(String args[]) {
//		}
		
		public void delProc(long no) {
			try{
				boolean isFound = findId(table, no);
				if (isFound == true){
					table.set((int)no,null);
				}else{
					return;
				}		
			}catch ( Exception e ){
				System.err.println("error" + e.getMessage( )); 
			}
		}
		
		synchronized public long addProc(String trigger, Object inst, String method, Object par) {
			ProcTable addProc = new ProcTable();
			try{
				addProc.inst = inst;
				addProc.trigger = trigger;
				Method mid = null;
				Class types[] = {Object.class};		
				try {
					mid = inst.getClass().getMethod(method,types);
				} catch (SecurityException e) {
					e.printStackTrace();
				} catch (NoSuchMethodException e) {
					e.printStackTrace();
				}
				addProc.method = method;
				addProc.mid = mid;
				addProc.par = par;		
				
				if (table.size() == 0){
					addProc.id = 0;
					table.add(addProc);
				}else{
					int setIndex = -1;
					for (int i=0; i<table.size(); i++){
						try{
							if (table.get(i) == null){
								setIndex = i;
								break;
							}
						}catch ( Exception e ){
							System.err.println("error" + e.getMessage( )); 
						}
					}
					if(setIndex == -1){
						addProc.id  = table.size();
						table.add(addProc);
					}else{
						addProc.id = setIndex;
						table.set(setIndex,addProc);
					}
				}
			}catch ( Exception e ){
				System.err.println("error" + e.getMessage( )); 
			}
			return addProc.id;
		}
		
		public void execProc(String trigger) {	
			for (int i=0; i<table.size(); i++){
				try{
					ProcTable item = (ProcTable)table.get(i);
					if (item == null){
						continue;
					}else if(item.trigger == trigger){
						Method mid = item.mid;
						Object[] param = new Object[1];
						param[0] = item.par;
						mid.invoke(item.inst,param);
					}
				}catch ( Exception e ){
					System.err.println("error" + e.getMessage( )); 
				}
			}		
		}
		
		protected boolean findId(ArrayList table,long no) {			
			for (int i=0; i<table.size(); i++){
				ProcTable findtable = (ProcTable)table.get(i);
				if (findtable != null && findtable.id == no){
					return true;
				}
			}
			return false;
		}
	 }
