/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.widestudio.mwt;

import org.eclipse.nab.core.INtkInitializer;
import org.eclipse.nab.core.NtkEventCallbackManager;
import org.eclipse.nab.core.NtkManager;
import org.eclipse.swt.widgets.Display;
//import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.nab.mwt.ab.depend.MwtWindowNativeHandle;

public class MwtInitializer implements INtkInitializer{
    static private boolean _initialized = false;
    static private Thread _ws_app;
    static private Display _display = null;
    
    public MwtInitializer() {}
    
    static NtkEventCallbackManager _proc_manager = new NtkEventCallbackManager();

    public NtkEventCallbackManager getEventCallbackManager(){
        return _proc_manager;
    }
    
    
    public synchronized void initialize() {
        if (_initialized){
            return;
        }
        
//        System.err.println("Mwt is initializing.");

        _ws_app = new Thread("wsApp") {
            public void run() {
                Mwt.WSGFdeviceInitialize();
                int appType = MwtWindowNativeHandle.getPlatformType();
                WSDappDev app = Mwt.WSGIappDev();
                Mwt.WSGFwsInitialize2(appType);

                Mwt.WSGFsetDefaultEncoding(Mwt.WS_EN_UTF8);
                app.execInitHandler();

               _init_callbacks();
                
                WSDappDev appdev = Mwt.WSGIappDev();
                _initialized = true;
                appdev.handleEvents();
//                System.err.println("thread 'wsApp' is done.");
            }
        };
        _ws_app.start();
        
        //for executing external editor from nab.. 
        _proc_manager.addProc("ve-class-prop-editor-activated",this,"classPropEditorActivated",null);
        _proc_manager.addProc("ve-class-trg-editor-activated",this,"classTrgEditorActivated",null);
        _proc_manager.addProc("ve-class-utrg-editor-activated",this,"classUTrgEditorActivated",null);
        _proc_manager.addProc("ve-class-remote-method-editor-activated",this,"classRemoteMethodEditorActivated",null);

        _proc_manager.addProc("ve-color-selector-activated",this,"colorSelectorActivated",null);
        
        while(true){
            if (_initialized != false){
                break;
            }
        }
//        System.err.println("Mwt was inited.");
        return;
    }
    public void setSyncDisplay(Display disp){
        if (_display != null){
            return;
        }
        _display = disp;        
    }
    public Display getSyncDisplay(){
        return _display;
    }
    private static void _init_callbacks(){
        
        Mwt.WSGFinitializeVeLocales();
        Mwt.WSGFsetDefaultVePopupMenus();
        Mwt.WSGFsetDefaultVePropertyEditProcedures();
        Mwt.WSGIappObjectList().addEventProc(
          "org.widestudio.mwt.MwtInitializer.instance_updated",
          "ve-instance-updated",0);
        Mwt.WSGIappObjectList().addEventProc(
          "org.widestudio.mwt.MwtInitializer.instance_copied",
          "ve-instance-copied",0);
        Mwt.WSGIappObjectList().addEventProc(
          "org.widestudio.mwt.MwtInitializer.instance_pasted",
          "ve-instance-pasted",0);
        Mwt.WSGIappObjectList().addEventProc(
          "org.widestudio.mwt.MwtInitializer.prop_viewer_updated",
          "ve-property-viewer-updated",0);
        Mwt.WSGIappObjectList().addEventProc(
          "org.widestudio.mwt.MwtInitializer.procedure_viewer_updated",
          "ve-procedure-viewer-updated",0);
        Mwt.WSGIappObjectList().addEventProc(
          "org.widestudio.mwt.MwtInitializer.attr_viewer_updated",
          "ve-attr-viewer-updated",0);
        Mwt.WSGIappObjectList().addEventProc(
          "org.widestudio.mwt.MwtInitializer.instance_to_front",
          "ve-instance-to-front",0);
        Mwt.WSGIappObjectList().addEventProc(
          "org.widestudio.mwt.MwtInitializer.instance_to_back",
          "ve-instance-to-back",0);
        Mwt.WSGIappObjectList().addEventProc(
          "org.widestudio.mwt.MwtInitializer.instance_delete",
          "ve-instance-delete",0);
        Mwt.WSGIappObjectList().addEventProc(
                "org.widestudio.mwt.MwtInitializer.prop_instance_selected",
                 "ve-prop-instance-selected",0);
        Mwt.WSGIappObjectList().addEventProc(
          "org.widestudio.mwt.MwtInitializer.prop_instance_released",
          "ve-prop-instance-released",0);
        Mwt.WSGIappObjectList().addEventProc(
                "org.widestudio.mwt.MwtInitializer.prop_instance_prop_updated",
                "ve-prop-instance-prop-updated",0);
        Mwt.WSGIappObjectList().addEventProc(
                "org.widestudio.mwt.MwtInitializer.internal_window_created",
                "ve-internal-window-created",0);
        Mwt.WSGIappObjectList().addEventProc(
                "org.widestudio.mwt.MwtInitializer.internal_window_destroyed",
                "ve-internal-window-destroyed",0);
        Mwt.WSGIappObjectList().addEventProc(
                "org.widestudio.mwt.MwtInitializer.internal_window_visible",
                "ve-internal-window-visible",0);
        Mwt.WSGIappObjectList().addEventProc(
                "org.widestudio.mwt.MwtInitializer.internal_window_unvisible",
                "ve-internal-window-unvisible",0);
        Mwt.WSGIappObjectList().addEventProc(
                "org.widestudio.mwt.MwtInitializer.color_selected",
                "ve-color-selected",0);
        Mwt.WSGIappObjectList().addEventProc(
                "org.widestudio.mwt.MwtInitializer.undo_status_changed",
                "ve-undo-status-changed",0);
        Mwt.WSGIappObjectList().addEventProc(
                "org.widestudio.mwt.MwtInitializer.instance_clicked",
                "ve-instance-clicked",0);
        Mwt.WSGIappObjectList().addEventProc(
                "org.widestudio.mwt.MwtInitializer.class_library_updated",
                "ve-class-library-updated",0);
        
    }
    public boolean isInitialized() {
        return _initialized;
    }
    
    public synchronized void kill() {
        if (!_initialized){
            return;
        }       
        Mwt.WSGIappDev().exit(0);
        _initialized = false;
    }
    protected static void instance_updated(long val){
        try{
            if (_display == null){
                System.err.println("MwtInitializer:: _display=null");
            }
            _display.asyncExec(new Runnable() {
                public void run(){
                    _proc_manager.execProc("ve-instance-updated");
                }
            });
        }catch(Exception e){
            System.err.println("MwtInitializer.instance_updated exception="+e);
        }
        
    }
    protected static void instance_copied(long val){
        try{
            if (_display == null){
                System.err.println("MwtInitializer:: _display=null");
            }
            _display.asyncExec(new Runnable() {
                public void run(){
                    _proc_manager.execProc("ve-instance-copied");
                }
            });
        }catch (Exception e){
            System.err.println("MwtInitializer.instance_copied exception="+e);
        }
    }
    protected static void instance_pasted(long val){
        try{
            if (_display == null){
                System.err.println("MwtInitializer:: _display=null");
            }
            _display.asyncExec(new Runnable() {
                public void run(){
                    _proc_manager.execProc("ve-instance-pasted");
                }
            });
        }catch(Exception e){
            System.err.println("MwtInitializer.instance_pasted exception="+e);
        }
    }
    protected static void prop_viewer_updated(long val){
        try{
            if (_display == null){
                System.err.println("MwtInitializer:: _display=null");
            }
    
            _display.asyncExec(new Runnable() {
                public void run(){
                    try{
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.nab.mwt.ab.view.MwtInstancePropertyView");
                    }catch(Exception e){
                        System.err.println("MetInitializer.attr_viewer_updated Error=" + e);
                    }
                    _proc_manager.execProc("ve-property-viewer-updated");
                }
            });
        }catch(Exception e){
            System.err.println("MwtInitializer.prop_viewer_updated exception="+e);
        }
    }
    protected static void procedure_viewer_updated(long val){
        try{
            if (_display == null){
                System.err.println("MwtInitializer:: _display=null");
            }
            _display.asyncExec(new Runnable() {
                public void run(){
                    try{
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.nab.mwt.ab.view.MwtInstanceProcedureView");
                    }catch(Exception e){
                        System.err.println("MetInitializer.attr_viewer_updated Error=" + e);
                    }
                    _proc_manager.execProc("ve-procedure-viewer-updated");
                }
            });
        }catch(Exception e){
            System.err.println("MwtInitializer.procedure_viewer_updated exception="+e);
        }
    }
    protected static void attr_viewer_updated(long val){
        try{
            if (_display == null){
                System.err.println("MwtInitializer.attr_viewer_updated _display=null");
            }
     
            _display.asyncExec(new Runnable() {
                public void run(){
                    try{
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.nab.mwt.ab.view.MwtInstanceAttributeView");;
                    }catch(Exception e){
                        System.err.println("MetInitializer.attr_viewer_updated Error=" + e);
                    }
                    _proc_manager.execProc("ve-attr-viewer-updated");
                }
            });
        }catch(Exception e){
            System.err.println("MwtInitializer.attr_viewer_updated exception="+e);
        }
    }
    protected static void instance_to_front(long val){
        try{
            if (_display == null){
                System.err.println("MwtInitializer:: _display=null");
            }
            _display.asyncExec(new Runnable() {
                public void run(){
                    _proc_manager.execProc("ve-instance-to-front");
                }
            });
        }catch(Exception e){
            System.err.println("MwtInitializer.instance_to_front exception="+e);
        }
    }
    protected static void instance_to_back(long val){
        try{
            if (_display == null){
                System.err.println("MwtInitializer:: _display=null");
            }
            _display.asyncExec(new Runnable() {
                public void run(){
                    _proc_manager.execProc("ve-instance-to-back");
                }
            });
        }catch(Exception e){
            System.err.println("MwtInitializer.instance_to_back exception="+e);
        }
    }
    protected static void instance_delete(long val){
        try{
            if (_display == null){
                System.err.println("MwtInitializer:: _display=null");
            }
            _display.asyncExec(new Runnable() {
                public void run(){
                    _proc_manager.execProc("ve-instance-delete");
                }
            });
        }catch(Exception e){
            System.err.println("MwtInitializer.instance_delete exception="+e);
        }
    }
    protected static void prop_instance_selected(long val){
        try{
            if (_display == null){
                System.err.println("MwtInitializer:: _display=null");
            }
            _display.asyncExec(new Runnable() {
                public void run(){
                    _proc_manager.execProc("ve-prop-instance-selected");
                }
            });
        }catch(Exception e){
            System.err.println("MwtInitializer.prop_instance_selected exception="+e);
        }
    }
    protected static void prop_instance_released(long val){
        try{
            if (_display == null){
                System.err.println("MwtInitializer:: _display=null");
            }
            _display.asyncExec(new Runnable() {
                public void run(){
                    _proc_manager.execProc("ve-prop-instance-released");
                }
            });
        }catch(Exception e){
            System.err.println("MwtInitializer.prop_instance_released exception="+e);
        }
    }
    protected static void prop_instance_prop_updated(long val){
        try{
            if (_display == null){
                System.err.println("MwtInitializer:: _display=null");
            }
            _display.asyncExec(new Runnable() {
                public void run(){
                    _proc_manager.execProc("ve-prop-instance-prop-updated");
                }
            });
        }catch(Exception e){
            System.err.println("MwtInitializer.prop_instance_prop_updated");
        }
    }
    protected static void internal_window_created(long val){
        try{
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.nab.mwt.ab.view.MwtInstanceEditorView");;
        }catch(Exception e){
            System.err.println("MetInitializer.internal_window_created Error=" + e);
        }
        long inst_id = Mwt.WSGIappObjectList().getInstanceId(0,Mwt.WS_TARGET_INSTANCE_ID,0);
        final WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(inst_id);
        if (inst.getVisible() == 0){
            //for displaying the window instance on swt thread. 
            if (_display == null){
                System.err.println("MwtInitializer.internal_window_created _display=null");
            }else{
                
                _display.asyncExec(new Runnable() {
                    public void run(){
                        Mwt.WSGIappDev().lock();
                        inst.setVisible((short)1);
                        Mwt.WSGIappDev().unlock();
                    }
                });
            }
        }else{
            _proc_manager.execProc("ve-internal-window-created");
        }
    }
    protected static void internal_window_destroyed(long val){
        if (_display == null){
            System.err.println("MwtInitializer:: _display=null");
        }
        final long inst_id = Mwt.WSGIappObjectList().getInstanceId(0,Mwt.WS_TARGET_INSTANCE_ID,0);
        _display.asyncExec(new Runnable() {
            public void run(){
                MwtManage.setTargetInstance(inst_id);
                _proc_manager.execProc("ve-internal-window-destroyed");
            }
        });
    }
    protected static void internal_window_visible(long val){
        if (_display == null){
            System.err.println("MwtInitializer:: _display=null");
        }
        final long inst_id = Mwt.WSGIappObjectList().getInstanceId(0,Mwt.WS_TARGET_INSTANCE_ID,0);
        Mwt.WSGIappDev().setRebaseHandle(0);

        _display.asyncExec(new Runnable() {
            public void run(){
                MwtManage.setTargetInstance(inst_id);
                _proc_manager.execProc("ve-internal-window-visible");
            }
        });
    }
    protected static void internal_window_unvisible(long val){
        if (_display == null){
            System.err.println("MwtInitializer:: _display=null");
        }
        final long inst_id = Mwt.WSGIappObjectList().getInstanceId(0,Mwt.WS_TARGET_INSTANCE_ID,0);

        _display.asyncExec(new Runnable() {
            public void run(){
                MwtManage.setTargetInstance(inst_id);
                _proc_manager.execProc("ve-internal-window-unvisible");
            }
        });
    }
    protected static void color_selected(long val){
        if (_display == null){
            System.err.println("MwtInitializer:: _display=null");
        }
        _display.asyncExec(new Runnable() {
            public void run(){
                _proc_manager.execProc("ve-color-selected");
            }
        });
    }
    protected static void undo_status_changed(long val){
        if (_display == null){
            System.err.println("MwtInitializer:: _display=null");
        }
        _display.asyncExec(new Runnable() {
            public void run(){
                _proc_manager.execProc("ve-undo-status-changed");
            }
        });
    }
    protected static void instance_clicked(long val){
        if (_display == null){
            System.err.println("MwtInitializer:: _display=null");
        }
        _display.asyncExec(new Runnable() {
            public void run(){
                _proc_manager.execProc("ve-instance-clicked");
            }
        });
    }
    protected static void class_library_updated(long val){
        if (_display == null){
            System.err.println("MwtInitializer:: _display=null");
        }
        _display.asyncExec(new Runnable() {
            public void run(){
                _proc_manager.execProc("ve-class-library-updated");
            }
        });
    }
    public void classPropEditorActivated(Object obj){
        Mwt.WSGIappDev().lock();
        Mwt.WSGIappObjectList().execEventProc("ve-class-prop-editor-activated");
        Mwt.WSGIappDev().unlock();
    }
    public void classTrgEditorActivated(Object obj){
        Mwt.WSGIappDev().lock();
        Mwt.WSGIappObjectList().execEventProc("ve-class-trg-editor-activated");
        Mwt.WSGIappDev().unlock();
    }
    public void classUTrgEditorActivated(Object obj){
        Mwt.WSGIappDev().lock();
        Mwt.WSGIappObjectList().execEventProc("ve-class-utrg-editor-activated");
        Mwt.WSGIappDev().unlock();
    }
    public void classRemoteMethodEditorActivated(Object obj){
        Mwt.WSGIappDev().lock();
        Mwt.WSGIappObjectList().execEventProc("ve-class-remote-method-editor-activated");
        Mwt.WSGIappDev().unlock();
    }
    public void colorSelectorActivated(Object obj){
        Mwt.WSGIappDev().lock();
        Mwt.WSGIappObjectList().execEventProc("ve-color-selector-activated");
        Mwt.WSGIappDev().unlock();
    }
}
