/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.widestudio.mwt;

import java.util.ArrayList;

public class MwtManage {
    
    private static ArrayList copyInstanceList = null;
    private static ArrayList deleteInstanceList = null;
    private static int property_x = 0;
    private static int property_y = 20;
    private static long target=0;
    public static void setTargetInstance(long inst){
        target = inst;
    }
    public static long getTargetInstance(){
        return target;
    }
    public static void setSelectedInstance(long id){
        Mwt.WSGIappDev().lock();
        Mwt.WSGIappObjectList().setInstanceId(Mwt.WS_SET_SELECTED_INSTANCE,id);
        WSCbase ptr = Mwt.WSGIappObjectList().getInstanceFromId(id);
        ptr.setPropertyEditExecute((short)1);
        Mwt.WSGIappDev().unlock();
    }
    public static void clearSelection(long id){
        Mwt.WSGIappDev().lock();
        long selected_id = Mwt.WS_ROOT_INSTANCE_ID;
        long count = 0;
        while(true){
            long selected_next = Mwt.WSGIappObjectList().getInstanceId(
                                       selected_id,
                                       Mwt.WS_NEXT_SELECTED_INSTANCE_ID,
                                       0);
            if (selected_next == 0){
                break;
            }
            Mwt.WSGIappObjectList().setInstanceId(Mwt.WS_REMOVE_SELECTED_INSTANCE,
            		                               selected_next);
        }
        Mwt.WSGIappDev().unlock();
    }
    
    public static long checkProcedureName(String name, WSCbase inst) {

        long result = 0;
        long resStr = Mwt.WSGFcheckNameString(name);

        if(resStr == 0) {
            result = 6;
        } else {
            result = Mwt.WSGFexistName(name, inst);
        }
        return result;
    }
}
