/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.core;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.*;
import org.osgi.framework.BundleContext;
import org.widestudio.mwt.MwtInitializer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.*;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.nab.core.INtkContext;
import org.eclipse.nab.core.INtkInitializer;
import org.eclipse.nab.core.INtkInstanceManager;
import org.eclipse.nab.core.INtkProjectManager;
import org.eclipse.nab.core.NtkManager;
import org.eclipse.nab.mwt.ab.view.MwtObjectBoxView.MwtObjectBoxData;
import org.eclipse.nab.mwt.ntkif.MwtContext;
import org.eclipse.nab.mwt.ntkif.MwtInstanceManager;
import org.eclipse.nab.mwt.ntkif.MwtProjectManager;

/**
 * The main plugin class to be used in the desktop.
 */
public class CorePlugin extends AbstractUIPlugin {
	//The shared instance.
	private static CorePlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;
    private static final String DEFINITION_FILE_PATH = UIMessages.getString("MwtCorePlugin.definitionFilePath"); //$NON-NLS-1$
    String defaultDefinitionPath = "data/locale/en_US";
    private int max_definitions = 64;

	/**
	 * The constructor.
	 */
	public CorePlugin() {
        super();
		plugin = this;
		try {
			resourceBundle = ResourceBundle.getBundle("org.eclipse.nab.mwt.ab.core.CorePluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}

	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
        if (NtkManager.isInitialized() == false){
            INtkInitializer initializer = new MwtInitializer();
            NtkManager.setNtkInitializer(initializer);
            INtkContext ntk_context = new MwtContext();
            NtkManager.setNtkContext(ntk_context);
            INtkInstanceManager instanceMan = new MwtInstanceManager();
            NtkManager.setNtkInstanceManager(instanceMan);
            INtkProjectManager projectMan = new MwtProjectManager();
            NtkManager.setNtkProjectManager(projectMan);
            NtkManager.ntkInitialize();
            Display display = PlatformUI.getWorkbench().getDisplay();
            NtkManager.setSyncDisplay(display);
        }
        /*
        if (NtkManager.isInitialized == false){
            NtkInitializer initializer = new MwtInitializer();
            NtkManager.setInitializer(MwtInitializer);
            NtkManager.ntkInitialize();
            Display display = PlatformUI.getWorkbench().getDisplay();
            NtkManager.setSyncDisplay(display);
        }
        */
        
        //Library loading..
        NtkManager.getNtkInstanceManager().loadLibrary("");

        
		super.start(context);
        ResourcesPlugin.getWorkspace().getRoot().accept(new IResourceVisitor() {

            public boolean visit(IResource resource) {
                if (resource.getType() == IResource.PROJECT) {
                    IProject project = (IProject)resource;
                    
                    if (project.isOpen() == true && project.getName() != NtkManager.getNtkProjectManager().getCurrentProjectName()) {
                        if (NtkManager.getNtkProjectManager().getCurrentProjectName() == null){
                            try{
                                if (project.hasNature(NtkManager.getNtkProjectManager().getNatureId()) == true){
                                    NtkManager.getNtkProjectManager().loadNtkProject(project.getName(),project);
                                }
                            }catch(CoreException e){
                                System.err.println("CorePlugin2.visit exception: project open e="+e);
                            }
                        }else{
                            try{
                                if (project.hasNature(NtkManager.getNtkProjectManager().getNatureId()) == true){
                                    project.close(null);
                                }
                            }catch(CoreException e){
                                System.err.println("CorePlugin2.visit exception: project close e="+e);
                            }
                        }
                    }
                    return false;
                }
                return resource.getType() == IResource.ROOT;
            }
        });
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new MwtResourceChangeListener(),
              IResourceChangeEvent.PRE_BUILD | IResourceChangeEvent.PRE_DELETE | IResourceChangeEvent.PRE_CLOSE |
              IResourceChangeEvent.POST_CHANGE);
        
    }

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int num = projects.length;
        int i;
        INtkProjectManager pman = NtkManager.getNtkProjectManager();
        for(i=0; i<num; i++){
            if (projects[i].isOpen() == true){
                if (projects[i].hasNature(pman.getNatureId()) == true){
                    if (pman.getCurrentProjectName() == projects[i].getName()){
                        pman.saveNtkProject(projects[i]);
                    }
                }
            }
        }
		super.stop(context);
	}

	/**
	 * Returns the shared instance.
	 */
	public static CorePlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = CorePlugin.getDefault().getResourceBundle();
		try {
			return (bundle != null) ? bundle.getString(key) : key;
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
}
