/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.core;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.nab.core.Ntk;
import org.eclipse.nab.core.NtkManager;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class MwtMenuOpenWindow implements IWorkbenchWindowActionDelegate {
	private IWorkbenchWindow window;

    public MwtMenuOpenWindow() {
	}

	public void run(IAction action) {
        if (NtkManager.isInitialized() == false){
            NtkManager.ntkInitialize();
        }
        FileDialog fileDialog = null;
        try{
            //Mwt.WSGIappFileSelect().setProperty("maskFileName","win");
            //long ret = Mwt.WSGIappFileSelect().popup();
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            fileDialog = new FileDialog(page.getWorkbenchWindow().getShell());
            String[] ext = {"*.win"};
            fileDialog.setFilterExtensions(ext);
            fileDialog.open();
        }catch(Exception e){
            System.err.println("MwtMenuOpenProject.run exeption="+e);
        }
        try{
            NtkManager.getNtkContext().lock();
        }catch(Exception e){
            System.err.println("MwtMenuOpenWindow.run e="+e);
            return;
        }
        try{
            
            String dirName = fileDialog.getFilterPath();
            String winName = fileDialog.getFileName();
            
            if(winName == null || winName.equals("")) {
            } else { 
            //if (ret == Mwt.WS_DIALOG_OK){ 
              //WSCvariant dname = Mwt.WSGIappFileSelect().getProperty("dirName");
              //WSCvariant fname = Mwt.WSGIappFileSelect().getProperty("fileName");

              //MwtManage.setProjectRootPath(dname.getCharPtr());
              //MwtManage.setProjectRootPath(dirName);
              //WSCbase win = Mwt.WSGFreadWinFile(dname.getCharPtr(),
              //                                   fname.getCharPtr(),Mwt.WS_EN_DEFAULT);
              long win = NtkManager.getNtkInstanceManager().readInstanceDataFile(dirName,winName,Ntk.NTK_EN_DEFAULT);
              if (win != 0){
                NtkManager.getNtkContext().execEventProc("ve-prop-instance-selected");
                NtkManager.getNtkContext().execEventProc("ve-instance-updated");
              }
            }
        }catch(Exception e){
          System.err.println("MwtMenuOpenProject.run exeption="+e);
        }finally{
          NtkManager.getNtkContext().unlock();
        }
	}

	/**
	 * Selection in the workbench has been changed. We 
	 * can change the state of the 'real' action here
	 * if we want, but this can only happen after 
	 * the delegate has been created.
	 * @see IWorkbenchWindowActionDelegate#selectionChanged
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * We can use this method to dispose of any system
	 * resources we previously allocated.
	 * @see IWorkbenchWindowActionDelegate#dispose
	 */
	public void dispose() {
	}

	/**
	 * We will cache window object in order to
	 * be able to provide parent shell for the message dialog.
	 * @see IWorkbenchWindowActionDelegate#init
	 */
	public void init(IWorkbenchWindow window) {
		this.window = window;
	}
}
