/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.view;

import java.util.ArrayList;

import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Event;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.LabelRetargetAction;
import org.eclipse.ui.actions.RetargetAction;

import org.eclipse.ui.internal.ActionSetContributionItem;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PartPluginAction;
import org.eclipse.ui.internal.EditorPluginAction;

import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.core.runtime.Platform;

import org.eclipse.ui.internal.ide.IDEInternalPreferences;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.registry.ActionSetDescriptor;

import org.eclipse.nab.core.INtkContext;
import org.eclipse.nab.core.INtkInstanceManager;
import org.eclipse.nab.core.Ntk;
import org.eclipse.nab.core.NtkManager;
import org.eclipse.nab.mwt.ab.core.UIMessages;
import org.eclipse.nab.mwt.ab.depend.MwtWindowNativeHandle;
import org.eclipse.nab.mwt.ab.view.MwtInstanceTreeView.TreeObject;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.internal.EditorPluginAction;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.SaveAction;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.operations.NonLocalUndoUserApprover;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;

import com.sun.corba.se.connection.GetEndPointInfoAgainException;
//import org.widestudio.mwt.*;



public class MwtInstanceEditorView extends ViewPart implements ISaveablePart{
    private static final String UNDO_MENU_TITLE = UIMessages.getString("MwtInstanceEditorView.undoMenuTitle"); //$NON-NLS-1$
    private static final String SAVE_MENU_TITLE = UIMessages.getString("MwtInstanceEditorView.saveMenuTitle"); //$NON-NLS-1$
    
    public boolean isDirty() {
        long prj = NtkManager.getNtkProjectManager().getCurrentProject();
        if (prj ==0){
            return false;
        }
        String ret = NtkManager.getNtkProjectManager().getProjectData(prj,"#NEED_WIN_SAVE",Ntk.NTK_EN_DEFAULT);
        if (ret.compareTo("0") != 0){
            return true;
        }else{
            return false;
        }
    }
    public void doSave(IProgressMonitor monitor) {
        NtkManager.getNtkProjectManager().createCurrentNtkProjectSources();
        NtkManager.getNtkProjectManager().saveCurrentNtkProject();
        this.firePropertyChange(PROP_DIRTY);

    }
    public void doSaveAs() {
        NtkManager.getNtkProjectManager().createCurrentNtkProjectSources();
        NtkManager.getNtkProjectManager().saveCurrentNtkProject();
        this.firePropertyChange(PROP_DIRTY);

    }
    public boolean isSaveAsAllowed() {
        return false;
    }
    public boolean isSaveOnCloseNeeded() {
        return false;
    }
    
    
    /** wedget  */
    private TabFolder tabfolder = null;
    private TabItem dummy_tab_item = null;
    private ArrayList tab_array = null;
    private long copyInstance = 0;
    private ArrayList copyList = null;
    private Action undoAction = null;
    private int max_window_size = 2048;
    
    private IOperationHistory history=null;
    private IUndoableOperation undoableOperation = null;
    private IUndoContext undoContext =  null;
    private Action undo_action = null;
    private long proc1;
    private long proc2;
    private long proc3;
    private long proc4;
    private long proc5;
    private long proc6;
    private long proc7;
    private long proc8;
    private long proc9;
    private long proc10;
    private long proc11;
    private long proc12;
    private long proc13;
    private long proc14;
//    private long proc15;
    
    private class TabData{
      public TabItem tabitem;
      public long tabinst;
      public TabData(TabItem ti,long tinst){
          tabitem = ti;
          tabinst = tinst;
      };
    };
        
	/**
	 * constructor
	 */
	public MwtInstanceEditorView() {
        if (NtkManager.isInitialized() == false){
            NtkManager.ntkInitialize();
        }
        proc1 = NtkManager.getEventCallbackManager().addProc("ve-internal-window-created",this,"createNewEditor",null);
        proc2 = NtkManager.getEventCallbackManager().addProc("ve-prop-instance-selected",this,"showSelectedWindow",null);
        proc3 = NtkManager.getEventCallbackManager().addProc("ve-instance-delete",this,"deleteInstance",null);
        proc4 = NtkManager.getEventCallbackManager().addProc("ve-internal-window-unvisible",this,"closeWindow",null);
        proc5 = NtkManager.getEventCallbackManager().addProc("ve-clear-instance-editor",this,"closeAllWindow",null);
        proc6 = NtkManager.getEventCallbackManager().addProc("ve-instance-copied",this,"copyInstance",null);
        proc7 = NtkManager.getEventCallbackManager().addProc("ve-instance-pasted",this,"pasteInstance",null);
        proc8 = NtkManager.getEventCallbackManager().addProc("ve-undo-status-changed",this,"undoStatusChanged",null);
        proc9 = NtkManager.getEventCallbackManager().addProc("ve-instance-clicked",this,"instanceClicked",null);
        proc10 = NtkManager.getEventCallbackManager().addProc("ve-instance-updated",this,"updateTitle",null);
        proc11 = NtkManager.getEventCallbackManager().addProc("ve-prop-instance-selected",this,"updateTitle",null);
        proc12 = NtkManager.getEventCallbackManager().addProc("ve-instance-updated",this,"updateSaveStatus",null);
        proc13 = NtkManager.getEventCallbackManager().addProc("ve-prop-instance-prop-updated",this,"updateSaveStatus",null);
        proc14 = NtkManager.getEventCallbackManager().addProc("ve-undo-status-changed",this,"updateSaveStatus",null);
//        proc15 = NtkManager.getEventCallbackManager().addProc("ve-instance-delete",this,"updateSaveStatus",null);

    }
    public void dispose() {
        NtkManager.getEventCallbackManager().delProc(proc1);
        NtkManager.getEventCallbackManager().delProc(proc2);
        NtkManager.getEventCallbackManager().delProc(proc3);
        NtkManager.getEventCallbackManager().delProc(proc4);
        NtkManager.getEventCallbackManager().delProc(proc5);
        NtkManager.getEventCallbackManager().delProc(proc6);
        NtkManager.getEventCallbackManager().delProc(proc7);
        NtkManager.getEventCallbackManager().delProc(proc8);
        NtkManager.getEventCallbackManager().delProc(proc9);
        NtkManager.getEventCallbackManager().delProc(proc10);
        NtkManager.getEventCallbackManager().delProc(proc11);
        NtkManager.getEventCallbackManager().delProc(proc12);
        NtkManager.getEventCallbackManager().delProc(proc13);
        NtkManager.getEventCallbackManager().delProc(proc14);
//        NtkManager.getEventCallbackManager().delProc(proc15);
        super.dispose();
    }
    public void updateSaveStatus(Object obj){
        this.firePropertyChange(PROP_DIRTY);
    }
    public void updateTitle(Object obj){
        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
        int num = tab_array.size();
        int i;
        for(i=0; i<num; i++){
            TabData tab_data = (TabData)tab_array.get(i);
            if (iman.existInstance(tab_data.tabinst) != false){
                tab_data.tabitem.setText(iman.getProperty(tab_data.tabinst,"name",Ntk.NTK_EN_UTF8));
            }
        }
        this.firePropertyChange(PROP_DIRTY);
    }
    public void createNewEditor(Object obj){
        if (tabfolder == null){
            return;
        }
        TabItem ti = null;
        try{
            ti = new TabItem(tabfolder,0);
        }catch (Exception e){
            System.err.println("MwtInstanceEditorView::createNewEditor excep="+e);
        }

        Composite scrarea = new Composite(tabfolder, SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL );
        scrarea.setBackground(new Color(null,255,255,255));
        scrarea.setVisible(true);
        Composite scrframe;
        if (MwtWindowNativeHandle.needRedrawHandle()){
            scrframe = new Composite(scrarea, SWT.NO_BACKGROUND );
        }else{
            scrframe = new Composite(scrarea, 0 );
        }
        scrframe.setBackground(new Color(null,255,255,255));
        scrframe.setVisible(true);
        scrarea.setData(scrframe);
        scrframe.setSize(max_window_size,max_window_size);

        scrarea.getVerticalBar().setValues(0,0,1024,64,8,64);
        scrarea.getHorizontalBar().setValues(0,0,1024,64,8,64);
        
        ti.setControl(scrarea);
        int index = tabfolder.indexOf(ti);
        tabfolder.setSelection(index);
        
        scrarea.getVerticalBar().addSelectionListener(new SelectionListener(){
            public void widgetSelected(SelectionEvent ev) {
                ScrollBar vscr = (ScrollBar)ev.getSource();
                Composite scrarea = (Composite)vscr.getParent();
                Composite scrframe = (Composite)scrarea.getData();
                Point loc = scrframe.getLocation();
                scrframe.setLocation(loc.x,-vscr.getSelection());
            }
            public void widgetDefaultSelected(SelectionEvent ev) {
            }
        });
        scrarea.getHorizontalBar().addSelectionListener(new SelectionListener(){
            public void widgetSelected(SelectionEvent ev) {
                ScrollBar hscr = (ScrollBar)ev.getSource();
                Composite scrarea = (Composite)hscr.getParent();
                Composite scrframe = (Composite)scrarea.getData();
                Point loc = scrframe.getLocation();
                scrframe.setLocation(-hscr.getSelection(),loc.y);
                
            }
            public void widgetDefaultSelected(SelectionEvent ev) {
            }
        });

        //Called from locked process..        
        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
        long inst_id  = iman.getInstanceId(Ntk.NTK_ROOT_INSTANCE_ID,Ntk.NTK_TARGET_INSTANCE_ID,0);
        ti.setText(iman.getProperty(inst_id,"name",Ntk.NTK_EN_UTF8));
        int handle = MwtWindowNativeHandle.getWindowHandle(scrframe.handle);        
        NtkManager.getNtkContext().setRebaseHandle(handle);
        
        TabData tab_data = new TabData(ti,inst_id);
        tab_array.add(tab_data);
        if (dummy_tab_item != null){
            dummy_tab_item.getControl().dispose();
            dummy_tab_item.dispose();
            dummy_tab_item = null;
        }
        ti.setText(iman.getProperty(inst_id,"name",Ntk.NTK_EN_UTF8));
        tabfolder.redraw();
        tabfolder.getParent().redraw();
    }
    
    public void closeWindow(Object obj){
//        long id = Mwt.WSGIappObjectList().getInstanceId(0,Mwt.WS_TARGET_INSTANCE_ID,0);
        long id = NtkManager.getNtkInstanceManager().getTargetInstance();
        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();

        boolean iret = iman.existInstance(id);
        if (iret == false){
            int num = tab_array.size();
            int i;
            for(i=0; i<num; i++){
                TabData tab_data = (TabData)tab_array.get(i);
                if (iman.existInstance(tab_data.tabinst) == false){
                    tab_data.tabitem.dispose();
                    tab_array.remove(i);
                    break;
                }
                if (iman.getVisible(tab_data.tabinst) == false){
                    tab_data.tabitem.dispose();
                    tab_array.remove(i);
                    break;
                }
            }            
            return;
        }
        int num = tab_array.size();
        int i;
        for(i=0; i<num; i++){
            TabData tab_data = (TabData)tab_array.get(i);
            if (iman.existInstance(tab_data.tabinst) == false){
                tab_data.tabitem.dispose();
                tab_array.remove(i);
                break;
            }
            if (iman.getVisible(tab_data.tabinst) == false){
                tab_data.tabitem.dispose();
                tab_array.remove(i);
                break;
            }
            if (tab_data.tabinst == id ){
                if (tab_data.tabitem != null){
                    tab_data.tabitem.dispose();
                }
                tab_array.remove(i);
                break;
            }
            
            if (iman.isParent(id,tab_data.tabinst) == true){
                if (tab_data.tabitem != null){
                    tab_data.tabitem.dispose();
                }
                tab_array.remove(i);
                break;              
            }
        }
    }
    public void closeAllWindow(Object obj){
        int num = tab_array.size();
        int i;
        for(i=num -1; -1 < i; i--){
            TabData tab_data = (TabData)tab_array.get(i);
            tab_data.tabitem.dispose();
            tab_array.remove(i);
        }
    }

    public void showSelectedWindow(Object obj){
        this.firePropertyChange(PROP_DIRTY);

        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
        INtkContext context = NtkManager.getNtkContext();
        try{
            context.lock();
        }catch(Exception ex){
            System.err.println("MwtInstanceEditorView.showSeletedWindow ex="+ex);
            return;
        }

        try{
            long id  = iman.getInstanceId(Ntk.NTK_ROOT_INSTANCE_ID,Ntk.NTK_NEXT_SELECTED_INSTANCE_ID,0);

            if (id != 0){
                long twin = id;
                while(true){
                    int type = iman.getInstanceType(twin);
                    if (((type & Ntk.NTK_TYPE_MENU_WINDOW) == 0) && (type & Ntk.NTK_TYPE_WINDOW) != 0){
                        break;
                    }
                    long parent = iman.getParent(twin);
                    if (twin == parent){
                        break;
                    }
                    if (parent == 0){
                        break;
                    }
                    twin = parent;
                }

                int i;
                int num = tab_array.size();
                for(i=0; i<num; i++){
                    TabData tab_data = (TabData)tab_array.get(i);
                    long tinstid = tab_data.tabinst;
                    if (tinstid == twin){
                        int index = tabfolder.indexOf(tab_data.tabitem);
                        tabfolder.setSelection(index);
                    }
                }
            }
        }catch(Exception e){
            System.err.println("MwtInstanceEditor::showSelectedWindow exception="+e);
        }finally{
            context.unlock();
        }
    }
   
	/**
	 * make Wedget Data
	 */
	public void createPartControl(Composite parent){

        tab_array = new ArrayList();
        tabfolder = new TabFolder(parent,SWT.V_SCROLL | SWT.H_SCROLL);

        Composite  dummy_area = new Composite(tabfolder, SWT.BORDER);
        dummy_area.setBackground(new Color(null,255,255,255));
        Display display = dummy_area.getDisplay();
        NtkManager.setSyncDisplay(display);
        dummy_area.setVisible(true);
        
        dummy_tab_item = new TabItem(tabfolder,0);
        dummy_tab_item.setText("none");
        dummy_tab_item.setControl(dummy_area);        
        
        unvisibleAction();
        
        undoAction = new Action() {
            public void run() {
                INtkContext context = NtkManager.getNtkContext();
                try{
                    context.lock();
                }catch(Exception e){
                    System.err.println("MwtInstanceEditorView.undoAction");
                    return;
                }
                context.execEventProc("ve-exec-undo");
                context.unlock();
                NtkManager.getEventCallbackManager().execProc("ve-prop-instance-prop-updated");

            }
        };
        undoAction.setText(UNDO_MENU_TITLE);
        undoAction.setToolTipText(UNDO_MENU_TITLE);
        undoAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
        getImageDescriptor(ISharedImages.IMG_TOOL_UNDO_DISABLED));
        
        IActionBars bars = getViewSite().getActionBars();
        bars.getToolBarManager().add(undoAction);
/*
        saveAction = new Action() {
            public void run() {
                NtkManager.getNtkProjectManager().createCurrentNtkProjectSources();
                NtkManager.getNtkProjectManager().saveCurrentNtkProject();
            }
        };
        saveAction.setText(SAVE_MENU_TITLE);
        saveAction.setToolTipText(SAVE_MENU_TITLE);
        saveAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
        getImageDescriptor(IDEInternalWorkbenchImages.IMG_ETOOL_SAVE_EDIT_DISABLED));
        
        bars.getToolBarManager().add(saveAction);
*/
        
        undo_action = new Action(){
            public void run(){
                INtkContext context = NtkManager.getNtkContext();
                try{
                    context.lock();
                }catch(Exception e){
                    System.err.println("MwtInstanceEditorView.undo_action e="+e);
                    return;
                }
                context.execEventProc("ve-exec-undo");
                context.unlock();
                NtkManager.getEventCallbackManager().execProc("ve-prop-instance-prop-updated");
            };
            public void runWithEvent(Event event){
                INtkContext context = NtkManager.getNtkContext();
                try{
                    context.lock();
                }catch(Exception e){
                    System.err.println("MwtInstanceEditorView.runWithEvent e="+e);
                    return;
                }
                context.execEventProc("ve-exec-undo");
                context.unlock();
                NtkManager.getEventCallbackManager().execProc("ve-prop-instance-prop-updated");
            }
        };
/*
        save_action = new Action() {
            public void run() {
                NtkManager.getNtkProjectManager().createCurrentNtkProjectSources();
                NtkManager.getNtkProjectManager().saveCurrentNtkProject();
            }
            public void runWithEvent(Event event) {
                NtkManager.getNtkProjectManager().createCurrentNtkProjectSources();
                NtkManager.getNtkProjectManager().saveCurrentNtkProject();
            }
        };
*/
	}
    
    public void setFocus(){
//        undoAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
//                getImageDescriptor(ISharedImages.IMG_TOOL_UNDO_DISABLED));
        //This logic is removed, because this makes placement function of instances from ObjectBox impossible.
        /*
        int select = tabfolder.getSelectionIndex();
        if (select > -1){
            TabItem ti = tabfolder.getItem(select);
            Composite scrarea = (Composite)ti.getControl();
            scrarea.forceFocus();
        }
        tabfolder.forceFocus();
        */
    }
    
    private void unvisibleAction(){
        tabfolder.addDisposeListener(new DisposeListener(){
            public void widgetDisposed(DisposeEvent ev){
                INtkContext context = NtkManager.getNtkContext();
                try{
                    context.lock();
                }catch(Exception e){
                    System.err.println("MwtInstanceEditorView.unvisibleAction e="+e);
                    return;
                }

                try{
                    int num = tab_array.size();
                    int i;
                    for(i=num; 0<i; i--){
                        TabData tab_data = (TabData)tab_array.get(i-1);
                        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
                        if (iman.existInstance(tab_data.tabinst) == true){
                            iman.setVisible(tab_data.tabinst,false);
                        }
                    }
                }catch(Exception ex){
                    System.err.println("MwtInstanceEditor::unvisibleAction Exception=" + ex);
                }finally{
                    context.unlock();
                }
           }
        });
    }    
    public void deleteInstance(Object obj){
        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
        INtkContext context = NtkManager.getNtkContext();
        try{
            context.lock();
        }catch(Exception e){
            System.err.println("MetInstanceEditorView.deleteInstance e="+e);
            return;
        }
        long val  = iman.getInstanceId(Ntk.NTK_ROOT_INSTANCE_ID,Ntk.NTK_NEXT_SELECTED_INSTANCE_ID,0);
        boolean iret = iman.existInstance(val);
        if (iret == true){

            String name = iman.getProperty(val,"name",Ntk.NTK_EN_UTF8);
            long parent = iman.getParent(val);
            context.unlock();
            
            MessageDialog dlg = new MessageDialog(
                    tabfolder.getShell(), "", null, "Delete instance:" + name + "?",
                    MessageDialog.NONE, new String[] { "OK", "Cancel", }, 0);
            if (dlg.open() == 0) {
                int num = tab_array.size();
                int i;
                for(i=0; i<num; i++){
                    TabData tab_data = (TabData)tab_array.get(i);
                    if (tab_data.tabinst == val ){
                        if (tab_data.tabitem != null){
                            tab_data.tabitem.dispose();
                        }
                        tab_array.remove(i);
                        break;
                    }
                    
                    if (iman.isParent(val,tab_data.tabinst) == true){
                        if (tab_data.tabitem != null){
                            tab_data.tabitem.dispose();
                        }
                        tab_array.remove(i);
                        break;              
                    }
                }
                try{
                    context.lock();
                }catch(Exception e){
                    System.err.println("MwtInstanceEditorView.deleteInstance e="+e);
                    return;
                }
                iman.deleteInstance(val);
                boolean iret2 = iman.existInstance(parent);
                if ( iret2 == true){
                    iman.redraw(parent);
                }
                context.unlock();
                NtkManager.getEventCallbackManager().execProc("ve-instance-updated");             
            }
        }else{
            context.unlock();
        }
    }
    public void copyInstance(Object obj){
        copyInstance = 0;
        if (copyList == null){
            copyList = new ArrayList();
        }
        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
        INtkContext context = NtkManager.getNtkContext();
        try{
            context.lock();
        }catch(Exception e){
            System.err.println("MwtInstanceEditorView.copyInstance");
            return;
        }
        long val  = iman.getInstanceId(Ntk.NTK_ROOT_INSTANCE_ID,Ntk.NTK_NEXT_SELECTED_INSTANCE_ID,0);
        boolean iret = iman.existInstance(val);
        if (iret == true){
            copyInstance = val;
            Long v = new Long(val);
            copyList.add(v);
            NtkManager.getNtkInstanceManager().setCopyList(copyList);
        }else{
            copyList.clear();
            NtkManager.getNtkInstanceManager().setCopyList(copyList);
        }
        context.unlock();        
    }
    public void pasteInstance(Object obj){
        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
        if (iman.getCopyList() != null){
            if (iman.getCopyList().size()<0){
                MessageDialog dlg = new MessageDialog(
                        tabfolder.getShell(), "", null, "Error: please select the instances to copy.",
                        MessageDialog.NONE, new String[] { "OK"}, 0);
                dlg.open();

                return;
            }
        }
        long val  = iman.getInstanceId(Ntk.NTK_ROOT_INSTANCE_ID,Ntk.NTK_NEXT_SELECTED_INSTANCE_ID,0);

        int property_x = 0;
        int property_y = 20;
        INtkContext context = NtkManager.getNtkContext();
        try{
            context.lock();
        }catch(Exception e){
            System.err.println("MwtInstanceEditorView.pasteInstance e="+e);
            return;
        }
        boolean err = false;
        boolean iret = iman.existInstance(val);
        if (iret == true){
            if (iman.getCopyList() != null){
                for(int i=0;i<iman.getCopyList().size();i++){
                    Long tmp = (Long)iman.getCopyList().get(i);
                    long cpinst = tmp.longValue();

                    int ret = iman.pasteInstance(val,cpinst);
                    if(ret == 0){
                        cpinst = iman.getInstanceId(Ntk.NTK_ROOT_INSTANCE_ID,Ntk.NTK_NEXT_SELECTED_INSTANCE_ID,0);
                        int instWidthSize = iman.getProperty(val,"width");
                        int instHeightSize = iman.getProperty(val,"height");

                        if (iman.existProperty(val,"workWidth") == true){
                            instWidthSize = iman.getProperty(val,"workWidth");
                        }
                        if (iman.existProperty(val,"workHeight") == true){
                            instHeightSize = iman.getProperty(val,"workHeight");
                        }
                        int pasteWidthSize = iman.getProperty(cpinst,"width");
                        int pasteHeightSize = iman.getProperty(cpinst,"height");
                        
//                        int inst_x_coordinate = iman.getProperty(val,"x");
//                        int inst_y_coordinate = iman.getProperty(val,"y");
                        
//                        int paste_x_coordinate = iman.getProperty(cpinst,"x");
//                        int paste_y_coordinate = iman.getProperty(cpinst,"y");
                        
                        if(instWidthSize < pasteWidthSize){
                            iman.setProperty(cpinst,"width",instWidthSize);
                            iman.setProperty(cpinst,"x",property_x);
                            iman.setProperty(cpinst,"y",property_y);
                        }
                        
                        if(instHeightSize < pasteHeightSize) {
                            iman.setProperty(cpinst,"height",instHeightSize);
                            iman.setProperty(cpinst,"x",property_x);
                            iman.setProperty(cpinst,"y",property_y);
                        }
                    }else{
                        err = true;
                        break;
                    }
                }
                iman.getCopyList().clear();
            }
        }
        context.unlock();
        if (err == true){
            MessageDialog dlg = new MessageDialog(
                    tabfolder.getShell(), "", null, "Error: can not paste the instances.",
                    MessageDialog.NONE, new String[] { "OK"}, 0);
            dlg.open();
        }
        if (iret == true){
            NtkManager.getEventCallbackManager().execProc("ve-instance-updated");
        }else{
            MessageDialog dlg = new MessageDialog(
                    tabfolder.getShell(), "", null, "Error: can not paste the instances.",
                    MessageDialog.NONE, new String[] { "OK"}, 0);
            dlg.open();
        }
        
        this.firePropertyChange(PROP_DIRTY);
    }
    public void undoStatusChanged(Object obj){
        INtkContext context = NtkManager.getNtkContext();
        try{
            context.lock();
        }catch(Exception e){
            System.err.println("MwtInstanceEditorView.undoStatusChange e="+e);
            return;
        }
        long num = NtkManager.getNtkProjectManager().getStaticData(Ntk.NTK_UNDO_NUM,0);
        context.unlock();
        IActionBars bars = getViewSite().getActionBars();
        if (num == 0){
            bars.setGlobalActionHandler("undo", null);
            bars.updateActionBars();
            undoAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
                    getImageDescriptor(ISharedImages.IMG_TOOL_UNDO_DISABLED));
        }else{
          bars.setGlobalActionHandler("undo", undo_action);
            bars.updateActionBars();
            undoAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
                    getImageDescriptor(ISharedImages.IMG_TOOL_UNDO));
        }
        this.firePropertyChange(PROP_DIRTY);
        
        return;
    }
    public void instanceClicked(Object obj){
        tabfolder.forceFocus();
    }
}
