/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.graphics.Image;
//import org.eclipse.cdt.internal.core.index.impl.Int;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.SWT;
import org.eclipse.nab.core.INtkContext;
import org.eclipse.nab.core.INtkInstanceManager;
import org.eclipse.nab.core.INtkProjectManager;
import org.eclipse.nab.core.Ntk;
import org.eclipse.nab.core.NtkEventCallbackManager;
import org.eclipse.nab.core.NtkManager;
import org.eclipse.nab.mwt.ab.core.UIMessages;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;



public class MwtInstanceListView extends ViewPart {
    private static final String DELETE_DIALOG_TITLE1 = UIMessages.getString("MwtInstanceListView.deleteDialogTitle1"); //$NON-NLS-1$
    private static final String DELETE_DIALOG_TITLE2 = UIMessages.getString("MwtInstanceListView.deleteDialogTitle2"); //$NON-NLS-1$
    private static final String DELETE_MENU_TITLE = UIMessages.getString("MwtInstanceListView.deleteMenuTitle"); //$NON-NLS-1$
    private static final String PASTE_MENU_TITLE = UIMessages.getString("MwtInstanceListView.pasteMenuTitle"); //$NON-NLS-1$
    private static final String COPY_MENU_TITLE = UIMessages.getString("MwtInstanceListView.copyMenuTitle"); //$NON-NLS-1$
    private static final String DISPLAY_MENU_TITLE = UIMessages.getString("MwtInstanceListView.displayMenuTitle"); //$NON-NLS-1$
    private static final String DISMISS_MENU_TITLE = UIMessages.getString("MwtInstanceListView.dismissMenuTitle"); //$NON-NLS-1$
    private static final String SAVE_MENU_TITLE = UIMessages.getString("MwtInstanceListView.saveMenuTitle"); //$NON-NLS-1$
    private static final String ERR_TITLE1 = UIMessages.getString("MwtInstanceListView.errorMessageTitle1"); //$NON-NLS-1$
    private static final String ERR_TITLE2 = UIMessages.getString("MwtInstanceListView.errorMessageTitle2"); //$NON-NLS-1$

    private static final String BACK_MENU_TITLE = UIMessages.getString("MwtInstanceListView.backMenuTitle"); //$NON-NLS-1$
    private static final String FORWARD_MENU_TITLE = UIMessages.getString("MwtInstanceListView.forwardMenuTitle"); //$NON-NLS-1$
    private static final String DLG_OK = UIMessages.getString("Common.dialogOk"); //$NON-NLS-1$
    private static final String DLG_CANCEL = UIMessages.getString("Common.dialogCancel"); //$NON-NLS-1$
    private static final String DLG_DELALL = UIMessages.getString("Common.dialogDelAll"); //$NON-NLS-1$
    
	private TableViewer viewer = null;
	private Action displayAction = null;
    private Action dismissAction = null;
    private Action saveAction = null;
//    private Action searchAction = null;
//    private Action compileAction = null;
//    private Action registerAction = null;
    private Action copyAction = null;
    private Action pasteAction = null;
    private Action deleteAction = null;
	private Action doubleClickAction = null;
    private Action backAction = null;
    private Action forwardAction = null;
    
	private ArrayList list = null;
    private ArrayList copyList = null;
    private ArrayList deleteList = null;
    private List selectionList = null;
    private int columnWidthsize = 150;
    private int property_x = 0;
    private int property_y = 20;
    private ArrayList forward_list = null;
    private long selected_target = 0;
    
    private long proc1;
    private long proc2;
    
    class ListElement {
        private String name;
        private String className;
        private int instance_type;
        private long instance_id;
        public void setname(String value) {
            name = value;
        }
        public String getname() {
            return name;
        }
        public void setInstanceType(int value) {
            instance_type = value;
        }
        public int getInstanceType() {
            return instance_type;
        }
        public void setInstanceId(long value) {
            instance_id = value;
        }
        public long getInstanceId() {
            return instance_id;
        }
        public void setclassName(String value) {
            className = value;
        }
        public String getclassName() {
            return className;
        }
    }
    
	class ViewContentProvider implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            java.util.List array = (java.util.List)inputElement;
            return array.toArray();
        }
        public void dispose() {
        }
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
	}
    
	class ViewLabelProvider extends LabelProvider implements ITableLabelProvider {
		public String getColumnText(Object obj, int index) {
            ListElement Element = (ListElement) obj;
            switch(index){
                case 0:
                return Element.getname();
                case 1:
                return Element.getclassName();
            }
            return null;
        }
        
        public String getText(Object obj) {
            ListElement Element = (ListElement) obj;
            return Element.getname();
		}
        
		public Image getColumnImage(Object obj, int index) {
            switch(index){
            case 0:
            return getImage(obj);
        }
            return null;
		}
        
		public Image getImage(Object obj) {
            int itype = ((ListElement) obj).getInstanceType();
            if ((itype & Ntk.NTK_TYPE_MANAGER) == 0 ){
                return PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages.IMG_OBJ_FILE);
            }else{
                return PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages.IMG_OBJ_FOLDER);
            }
		}
	}
	class NameSorter extends ViewerSorter {
	}
	/**
	 * The constructor.
	 */
	public MwtInstanceListView() {
        if (NtkManager.isInitialized() == false){
            NtkManager.ntkInitialize();
        }
        proc1 = NtkManager.getEventCallbackManager().addProc("ve-prop-instance-selected",this,"updateList",null);
        proc2 = NtkManager.getEventCallbackManager().addProc("ve-instance-updated",this,"updateList",null);
	}
    public void dispose() {
        NtkManager.getEventCallbackManager().delProc(proc1);
        NtkManager.getEventCallbackManager().delProc(proc2);
        super.dispose();
    }
    public void clearForwardList(){
        INtkContext context = NtkManager.getNtkContext();
        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
        try{
            context.lock();
        }catch(Exception e){
            System.err.println("MwtInstanceListView.clearForwardList e="+e);
            return;
        }
        long selected_id = Ntk.NTK_ROOT_INSTANCE_ID;
        long count = 0;
        while(true){
            long selected_next = iman.getInstanceId(selected_id,Ntk.NTK_NEXT_SELECTED_INSTANCE_ID,0);
            if (selected_next == 0){
                break;
            }
            count++;
            selected_id = selected_next;
        }
        context.unlock();
        if (selected_target == 0 || count == 0 || selected_target != selected_id){
            forward_list.clear();
            forwardAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
                    getImageDescriptor(ISharedImages.IMG_TOOL_FORWARD_DISABLED));
        }
        selected_target = 0;
    }
    public void updateList(Object obj){
        clearForwardList();
        
        readInstance();
        try{
            viewer.setInput(list);
        }catch(Exception e){
            System.err.println("MwtInstanceListView updateList(): " + e.getMessage());
            System.err.println("MwtInstanceListView updateList(): " + e.toString());
        }
    }
    
    public void selectExecute(){
        clearForwardList();
		ISelection selection = viewer.getSelection();
		Object obj = ((IStructuredSelection)selection).getFirstElement();
        ListElement Element = (ListElement) obj;
        long val = Element.getInstanceId();
        try{
            NtkManager.getNtkContext().lock();
        }catch(Exception e){
            System.err.println("MwtInstanceListView.selectExecute e="+e);
            return;
        }

        if ((Ntk.NTK_TYPE_MANAGER & NtkManager.getNtkInstanceManager().getInstanceType(val)) != 0){
            NtkManager.getNtkInstanceManager().setSelectedInstance(val);
        }
        NtkManager.getNtkContext().unlock();
    }
	/**
	 * This is a callback that will allow us
	 * to create the viewer and initialize it.
	 */
	public void createPartControl(Composite parent) {
        viewer = new TableViewer(parent, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION);
        viewer.setContentProvider(new ArrayContentProvider());
        viewer.setLabelProvider(new ViewLabelProvider());
        viewer.setSorter(new NameSorter());
        Display display = viewer.getControl().getDisplay();
        NtkManager.setSyncDisplay(display);
        readInstance();        
        viewer.setInput(list);
        forward_list = new ArrayList();
        
        makeActions();
        hookContextMenu();
        hookDoubleClickAction();
        contributeToActionBars();
        Table table = viewer.getTable();
        TableColumn col1 = new TableColumn(table, SWT.LEFT);
        col1.setText("Name");
        col1.setWidth(columnWidthsize);
        TableColumn col2 = new TableColumn(table, SWT.LEFT);
        col2.setText("Class");
        col2.setWidth(columnWidthsize);
        table.setHeaderVisible(true);
        updateList(null);
	}

	private void hookContextMenu() {
		MenuManager menuMgr = new MenuManager("#PopupMenu");
		menuMgr.setRemoveAllWhenShown(true);
		menuMgr.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				MwtInstanceListView.this.fillContextMenu(manager);
			}
		});
		Menu menu = menuMgr.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(menuMgr, viewer);
	}

	private void contributeToActionBars() {
		IActionBars bars = getViewSite().getActionBars();
		fillLocalPullDown(bars.getMenuManager());
		fillLocalToolBar(bars.getToolBarManager());
	}

	private void fillLocalPullDown(IMenuManager manager) {
        manager.add(backAction);
        manager.add(forwardAction);
        
        manager.add(displayAction);
        manager.add(dismissAction);
        manager.add(saveAction);
//        manager.add(searchAction);
//        manager.add(compileAction);
//        manager.add(registerAction);
        manager.add(copyAction);
        manager.add(pasteAction);
        manager.add(deleteAction);
		manager.add(new Separator());
	}

	private void fillContextMenu(IMenuManager manager) {
        manager.add(backAction);
        manager.add(forwardAction);

        manager.add(displayAction);
        manager.add(dismissAction);
        manager.add(saveAction);
//        manager.add(searchAction);
//        manager.add(compileAction);
//        manager.add(registerAction);
        manager.add(copyAction);
        manager.add(pasteAction);
        manager.add(deleteAction);
		manager.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS));
	}
	
	private void fillLocalToolBar(IToolBarManager manager) {
        manager.add(backAction);
        manager.add(forwardAction);

        manager.add(displayAction);
        manager.add(dismissAction);
        manager.add(saveAction);
//        manager.add(searchAction);
//        manager.add(compileAction);
//        manager.add(registerAction);
        manager.add(copyAction);
        manager.add(pasteAction);
        manager.add(deleteAction);
	}

	private void makeActions() {
        backAction = new Action() {
            public void run() {
                INtkContext context = NtkManager.getNtkContext();
                INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
                try{
                    context.lock();
                }catch(Exception e){
                    System.err.println("MwtInstanceListView.backAction e="+e);
                    return;
                }

                long selected_id = Ntk.NTK_ROOT_INSTANCE_ID;
                long count = 0;
                while(true){
                    long selected_next = iman.getInstanceId( selected_id, Ntk.NTK_NEXT_SELECTED_INSTANCE_ID, 0);
                    if (selected_next == 0){
                        break;
                    }
                    count++;
                    selected_id = selected_next;
                }
                if (count > 1 || count == 0){
                    context.unlock();
                    return;
                }
                long parent = iman.getParent(selected_id);
                if (parent != 0){
                    forward_list.add(new Long(selected_id));
                    forwardAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
                            getImageDescriptor(ISharedImages.IMG_TOOL_FORWARD));
                    selected_target = parent;
                    NtkManager.getNtkInstanceManager().setSelectedInstance(parent);
                }
                context.unlock();
            }
        };
        backAction.setText(BACK_MENU_TITLE);
        backAction.setToolTipText(BACK_MENU_TITLE);
        backAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
                getImageDescriptor(ISharedImages.IMG_TOOL_BACK));

        forwardAction = new Action() {
            public void run() {
                if (forward_list.size() < 1){
                    return;
                }
                Long val = (Long)forward_list.get(forward_list.size()-1);
                long target = val.longValue();
                forward_list.remove(forward_list.size()-1);
                if (forward_list.size() == 0){
                    selected_target = 0;
                }else{
                    selected_target = target;
                }
                try{
                    NtkManager.getNtkContext().lock();
                }catch(Exception e){
                    System.err.println("MwtInstanceListView.forwardAction e="+e);
                    return;
                }

                NtkManager.getNtkInstanceManager().setSelectedInstance(target);
                
                NtkManager.getNtkContext().unlock();
            }
        };
        forwardAction.setText(FORWARD_MENU_TITLE);
        forwardAction.setToolTipText(FORWARD_MENU_TITLE);
        forwardAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
                getImageDescriptor(ISharedImages.IMG_TOOL_FORWARD_DISABLED));

        
        displayAction = new Action() {
            public void run() {
                ISelection selection = viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                ListElement Element = (ListElement) obj;
                long val = Element.getInstanceId();
                try{
                    NtkManager.getNtkContext().lock();
                }catch(Exception e){
                    System.err.println("MwtInstanceListView.displayAction e="+e);
                    return;
                }

                INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
                long win = iman.getParentWindow(val);
                NtkManager.getNtkInstanceManager().setVisible(win,true);
                NtkManager.getNtkContext().unlock();
            }
        };
        displayAction.setText(DISPLAY_MENU_TITLE);
        displayAction.setToolTipText(DISPLAY_MENU_TITLE);
        displayAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
                getImageDescriptor(ISharedImages.IMG_DEF_VIEW));
        
        dismissAction = new Action() {
            public void run() {
                ISelection selection = viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                ListElement Element = (ListElement) obj;
                long val = Element.getInstanceId();
                try{
                    NtkManager.getNtkContext().lock();
                }catch(Exception e){
                    System.err.println("MwtInstanceListView.dismissAction e="+e);
                    return;
                }

                INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
                long win = iman.getParentWindow(val);
                NtkManager.getNtkInstanceManager().setVisible(win,false);
                NtkManager.getNtkContext().unlock();
            }
        };
        
        dismissAction.setText(DISMISS_MENU_TITLE);
        dismissAction.setToolTipText(DISMISS_MENU_TITLE);
        dismissAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
              getImageDescriptor(IDEInternalWorkbenchImages.IMG_ETOOL_DEF_PERSPECTIVE));
        
        saveAction = new Action() {
            public void run() {
                /*
                ISelection selection = viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                ListElement Element = (ListElement) obj;
                long val = Element.getInstanceId();
                if (val == 0){
                    System.err.println("MwtInstanceTreeView.saveAction instance=null..");
                    return;
                }
                INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
                while(true){
                    long parent = iman.getParent(val);
                    if (val == 0){
                        break;
                    }
                    val = parent;
                }
                INtkProjectManager pman = NtkManager.getNtkProjectManager();
                long prj = pman.getCurrentProject();
                Long enc = Long.valueOf(pman.getProjectData(prj,"#ENCODING",Ntk.NTK_EN_DEFAULT));
                
                NtkManager.getNtkInstanceManager().saveInstanceDataFile(pman.getCurrentProjectFullPath(),val,enc.intValue());
                */
                NtkManager.getNtkProjectManager().createCurrentNtkProjectSources();
                NtkManager.getNtkProjectManager().saveCurrentNtkProject();
            }
        };
        saveAction.setText(SAVE_MENU_TITLE);
        saveAction.setToolTipText(SAVE_MENU_TITLE);
        saveAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
                getImageDescriptor(IDEInternalWorkbenchImages.IMG_ETOOL_SAVE_EDIT));        
        
//        searchAction = new Action() {
//            public void run() {
//                showMessage("Action 3 executed");
//            }
//        };
//        searchAction.setText("Search");
//        searchAction.setToolTipText("Search");
//        searchAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
//                getImageDescriptor(ISharedImages.IMG_OBJS_WARN_TSK));
        
//        compileAction = new Action() {
//            public void run() {
//                showMessage("Action 4 executed");
//            }
//        };
//        compileAction.setText("Compile");
//        compileAction.setToolTipText("Compile");
//        compileAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
//                getImageDescriptor(ISharedImages.IMG_OBJS_ERROR_TSK));
        
//        registerAction = new Action() {
//            public void run() {
//                showMessage("Action 5 executed");
//            }
//        };
//        registerAction.setText("Remove from project");
//        registerAction.setToolTipText("Remove from project");
//        registerAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
//                getImageDescriptor(ISharedImages.IMG_TOOL_FORWARD));
        
        copyAction = new Action() {
            public void run() {
                if (copyList == null){
                    copyList = new ArrayList();
                }
                copyList.clear();
                ISelection selection = viewer.getSelection();
                selectionList = ((IStructuredSelection)selection).toList();
                INtkContext context = NtkManager.getNtkContext();
                INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
                for(int i=0;i<selectionList.size();i++){
                    Object obj = selectionList.get(i);
                    ListElement Element = (ListElement) obj;
                    long val = Element.getInstanceId();
                    try{
                        context.lock();
                    }catch(Exception e){
                        System.err.println("MwtInstanceListView.copyAction e="+e);
                        return;
                    }

                    if (iman.existInstance(val) == true){
                        copyList.add(new Long(val));
                        iman.setCopyList(copyList);
                    }
                    context.unlock();
                }
            }
        };
        copyAction.setText(COPY_MENU_TITLE);
        copyAction.setToolTipText(COPY_MENU_TITLE);
        copyAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
                getImageDescriptor(ISharedImages.IMG_TOOL_COPY));
        
        pasteAction = new Action() {
            public void run() {
                INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
                if (iman.getCopyList() == null || (iman.getCopyList() != null && iman.getCopyList().size()<0)){
                        MessageDialog dlg = new MessageDialog(
                                viewer.getControl().getShell(), "", null, ERR_TITLE1,
                                MessageDialog.NONE, new String[] { "OK"}, 0);
                        dlg.open();

                        return;
                }

                ISelection selection = viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                ListElement Element = (ListElement) obj;
                long val = Element.getInstanceId();
                INtkContext context = NtkManager.getNtkContext();
                boolean err_fl = false;
                try{
                    context.lock();
                }catch(Exception e){
                    System.err.println("MwtInstanceListView.pasteAction e="+e);
                    return;
                }

                boolean iret = iman.existInstance(val);
                if (iret == true){
                    if (iman.getCopyList() != null){
                        for(int i=0;i<iman.getCopyList().size();i++){
                            Long tmp = (Long)iman.getCopyList().get(i);
                            long cpinst = tmp.longValue();
                            int ret = iman.pasteInstance(val,cpinst);
                            if(ret == Ntk.NTK_NO_ERR){
                                cpinst = iman.getInstanceId(Ntk.NTK_ROOT_INSTANCE_ID,Ntk.NTK_NEXT_SELECTED_INSTANCE_ID,0);
                                int instWidthSize = iman.getProperty(val,"width");
                                int instHeightSize = iman.getProperty(val,"height");

                                if (iman.existProperty(val,"workWidth") == true){
                                    instWidthSize = iman.getProperty(val,"workWidth");
                                }
                                if (iman.existProperty(val,"workHeight") == true){
                                    instHeightSize = iman.getProperty(val,"workHeight");
                                }
                                int pasteWidthSize = iman.getProperty(cpinst,"width");
                                int pasteHeightSize = iman.getProperty(cpinst,"height");
                                
//                                int inst_x_coordinate = iman.getProperty(val,"x");
//                                int inst_y_coordinate = iman.getProperty(val,"y");
                                
//                                int paste_x_coordinate = iman.getProperty(cpinst,"x");
//                                int paste_y_coordinate = iman.getProperty(cpinst,"y");
                                
                                if(instWidthSize < pasteWidthSize){
                                    iman.setProperty(cpinst,"width",instWidthSize);
                                    iman.setProperty(cpinst,"x",property_x);
                                    iman.setProperty(cpinst,"y",property_y);
                                }
                                
                                if(instHeightSize < pasteHeightSize) {
                                    iman.setProperty(cpinst,"height",instHeightSize);
                                    iman.setProperty(cpinst,"x",property_x);
                                    iman.setProperty(cpinst,"y",property_y);
                                }
                            }else{
                                err_fl = true;
                                break;
                            }
                        }
                    }
                    iman.getCopyList().clear();
                }
                context.unlock();
                if (err_fl != false){
                    MessageDialog dlg = new MessageDialog(
                            viewer.getControl().getShell(), "", null, ERR_TITLE2,
                            MessageDialog.NONE, new String[] { "OK"}, 0);
                    dlg.open();
                }

                if (iret == true){
                    NtkManager.getEventCallbackManager().execProc("ve-instance-updated");
                }
            }
        };
        pasteAction.setText(PASTE_MENU_TITLE);
        pasteAction.setToolTipText(PASTE_MENU_TITLE);
        pasteAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
                getImageDescriptor(ISharedImages.IMG_TOOL_PASTE));
        
        deleteAction = new Action() {
            public void run() {
                if (deleteList == null){
                    deleteList = new ArrayList();
                }
                ISelection selection = viewer.getSelection();
                selectionList = ((IStructuredSelection)selection).toList();
                INtkContext context = NtkManager.getNtkContext();
                INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
                try{
                    context.lock();
                }catch(Exception e){
                    System.err.println("MwtInstanceListView.deleteAction e="+e);
                    return;
                }
                for(int i=0;i<selectionList.size();i++){
                    Object obj = selectionList.get(i);
                    ListElement Element = (ListElement) obj;
                    long val = Element.getInstanceId();
                    if (iman.existInstance(val) == true){
                        deleteList.add(new Long(val));
                        iman.setDeleteList(deleteList);
                    }
                }
                context.unlock();

                boolean delall = false;
                for(int j=0;j<deleteList.size();j++){
                    try{
                        context.lock();
                    }catch(Exception e){
                        System.err.println("MwtInstanceListView.deleteAction e="+e);
                        return;
                    }
                    Long temp = (Long)iman.getDeleteList().get(j);
                    long inst = temp.longValue();
                    String name = iman.getProperty(inst,"name",Ntk.NTK_EN_DEFAULT);
                    context.unlock();
                    if (delall == true){
                        try{
                            context.lock();
                        }catch(Exception e){
                            System.err.println("MwtInstanceListView.deleteAction e="+e);
                            return;
                        }
                        long parent = iman.getParent(inst);
                        iman.deleteInstance(inst);
                        if (iman.existInstance(parent) == true){
                            iman.redraw(parent);
                        }
                        context.unlock();
                        continue;
                    }
                    MessageDialog dlg;
                    if (deleteList.size() == 1){
                        dlg= new MessageDialog(
                            viewer.getControl().getShell(), "", null, DELETE_DIALOG_TITLE1 + name + DELETE_DIALOG_TITLE2,
                            MessageDialog.NONE, new String[] { DLG_OK,DLG_CANCEL, }, 0);
                        if (dlg.open() == 0) {
                            try{
                                context.lock();
                            }catch(Exception e){
                                System.err.println("MwtInstanceListView.deleteAction e="+e);
                                return;
                            }
                            long parent = iman.getParent(inst);
                            iman.deleteInstance(inst);
                            if (iman.existInstance(parent) == true){
                                iman.redraw(parent);
                            }
                            context.unlock();
                        }
                    }else{
                        dlg= new MessageDialog(
                                viewer.getControl().getShell(), "", null, DELETE_DIALOG_TITLE1 + name + DELETE_DIALOG_TITLE2,
                                MessageDialog.NONE, new String[] { DLG_OK, DLG_DELALL,DLG_CANCEL, }, 0);
                        int res = dlg.open();
                        if (res == 0 || res == 1) {
                            if (res == 1){
                                delall = true;
                            }
                            try{
                                context.lock();
                            }catch(Exception e){
                                System.err.println("MwtInstanceListView.deleteAction e="+e);
                                return;
                            }
                            long parent = iman.getParent(inst);
                            iman.deleteInstance(inst);
                            if (iman.existInstance(parent) == true){
                                iman.redraw(parent);
                            }
                            context.unlock();
                        }
                    }
                }
                iman.getDeleteList().clear();
                NtkManager.getEventCallbackManager().execProc("ve-instance-updated");
            }
        };
        deleteAction.setText(DELETE_MENU_TITLE);
        deleteAction.setToolTipText(DELETE_MENU_TITLE);
        deleteAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
                getImageDescriptor(ISharedImages.IMG_TOOL_DELETE));
        
		doubleClickAction = new Action() {
			public void run() {
				ISelection selection = viewer.getSelection();
				Object obj = ((IStructuredSelection)selection).getFirstElement();
				selectExecute();
			}
		};
	}

	private void hookDoubleClickAction() {
		viewer.addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {
				doubleClickAction.run();
			}
		});
	}
/*    
	private void showMessage(String message) {
		MessageDialog.openInformation(
			viewer.getControl().getShell(),
			"Dialog",
			message);
	}
*/
	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
		viewer.getControl().setFocus();
	}
    
    private void readInstance(){
        INtkContext context = NtkManager.getNtkContext();
        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
        try{
            context.lock();
        }catch(Exception e){
            System.err.println("MwtInstanceListView.readInstance e="+e);
            return;
        }
        if (list == null){
            list = new ArrayList();
        }else{
            list.clear();
        }
        
        /* do something...*/
        long selected_id = Ntk.NTK_ROOT_INSTANCE_ID;
        long count = 0;
        while(true){
            long selected_next = iman.getInstanceId(selected_id,Ntk.NTK_NEXT_SELECTED_INSTANCE_ID,0);
            if (selected_next == 0){
                break;
            }
            count++;
            selected_id = selected_next;
        }
        if (count > 1 || count == 0){
            context.unlock();
            return;
        }
        long child_id = Ntk.NTK_ROOT_INSTANCE_ID;
        while(true){
            long child_next = iman.getInstanceId(selected_id,Ntk.NTK_NEXT_CHILD_INSTANCE_ID,child_id);
            if (child_next == 0){
                break;
            }
            ListElement Element = new ListElement();
            Element.setname(iman.getProperty(child_next,"name",Ntk.NTK_EN_UTF8));
            
            int ws_type = iman.getInstanceType(child_next);
            String str = iman.getClassName(child_next);
            Element.setclassName(str);
            Element.setInstanceType(ws_type);
            Element.setInstanceId(child_next);
            list.add(Element);
            child_id = child_next;
        }
        context.unlock();
    }
}
