/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ntkif;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.*;
import org.osgi.framework.BundleContext;
import org.widestudio.mwt.Mwt;
import org.widestudio.mwt.MwtInitializer;
import org.eclipse.core.runtime.Plugin;
import java.util.*;

import org.eclipse.nab.core.INtkContext;
import org.eclipse.nab.core.INtkInitializer;
import org.eclipse.nab.core.INtkInstanceManager;
import org.eclipse.nab.core.INtkProjectManager;
import org.eclipse.nab.core.NtkManager;


/**
 * The main plugin class to be used in the desktop.
 */
public class MwtPlugin extends AbstractUIPlugin {
	//The shared instance.
	private static MwtPlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;
    
    static {
        System.loadLibrary("mwt_java");
    }
	
	/**
	 * The constructor.
	 */
	public MwtPlugin() {
		super();
		plugin = this;
		try {
			resourceBundle = ResourceBundle.getBundle("org.eclipse.nab.core.mwtif.SwigPluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
        if (NtkManager.isInitialized() == false){
            INtkInitializer initializer = new MwtInitializer();
            NtkManager.setNtkInitializer(initializer);
            INtkContext context = new MwtContext();
            NtkManager.setNtkContext(context);
            INtkInstanceManager instanceMan = new MwtInstanceManager();
            NtkManager.setNtkInstanceManager(instanceMan);
            INtkProjectManager projectMan = new MwtProjectManager();
            NtkManager.setNtkProjectManager(projectMan);
            NtkManager.ntkInitialize();
            Display display = PlatformUI.getWorkbench().getDisplay();
            NtkManager.setSyncDisplay(display);
            
        }
	}
	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
	}

	/**
	 * Returns the shared instance.
	 */
	public static MwtPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = MwtPlugin.getDefault().getResourceBundle();
		try {
			return (bundle != null) ? bundle.getString(key) : key;
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
}
