/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ntkif;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.io.File;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaProject;

import org.eclipse.nab.core.INtkProjectManager;
import org.eclipse.nab.core.Ntk;
//import org.eclipse.nab.core.NtkEventCallbackManager;
import org.eclipse.nab.core.NtkManager;

import org.widestudio.mwt.Mwt;
import org.widestudio.mwt.WSCbase;
import org.widestudio.mwt.WSCvariant;
import org.widestudio.mwt.WSCstring;

public class MwtProjectManager implements INtkProjectManager {
    final static String cdtBuilderID = "org.eclipse.cdt.make.core.makeBuilder";
    final static String cdtBuilderID2 = "org.eclipse.cdt.make.core.ScannerConfigBuilder";
    final static String mwtBuilderID = "org.eclipse.nab.mwt.mwtbuilder";
    final static String mwtProjectID = "org.eclipse.nab.mwt.projectName";
    final static String mwtNatureID = "org.eclipse.nab.mwt.mwtnature";
    final static String cdtNatureID = "org.eclipse.cdt.core.cnature";
    final static String cdtNatureID2 = "org.eclipse.cdt.core.ccnature";
    final static String cdtNatureID3 = "org.eclipse.cdt.make.core.makeNature";
    final static String cdtNatureID4 = "org.eclipse.cdt.make.core.ScannerConfigNature";
    final static String cdtBinaryParser1 = "org.eclipse.cdt.core.Cygwin_PE";

    final static String jdtNatureID = "org.eclipse.jdt.core.javanature";
    final static String jdtBuilderID = "org.eclipse.jdt.core.javabuilder";
    
    public String getNatureId(){
        return mwtNatureID;
    }
    private static String projectName = null;
    private static long currentProject = 0;
    private static IProject currentIProject = null;
    
    public void syncProjectData(long prj){
        //sync between the cdt project data and ntk project data.
        if (prj != 0){
            
//            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            try{
                IProjectDescription description = currentIProject.getDescription();
                ICommand[] buildSpec = description.getBuildSpec();
                String lang = getProgrammingLang(prj);
                if (lang.compareTo("C++") == 0){
                    int cdtMakeBuilderIndex = getMwtCommandIndex(buildSpec,cdtBuilderID);
                    if (cdtMakeBuilderIndex > -1){
                        ICommand cdtMakeBuilder = buildSpec[cdtMakeBuilderIndex];
            
                        Map args = cdtMakeBuilder.getArguments();
                        String str = (String)args.get("org.eclipse.cdt.make.core.build.command");
                        Mwt.WSGFsetProjectData(prj,"#MAKE",str,Ntk.NTK_EN_DEFAULT);
                    }else{
                        
                    }
                }else if (lang.compareTo("Java") == 0){

                }
            }catch(Exception e){
                System.err.println("org.eclipse.nab.mwt.ntkif.NwtProjectManager.getProjectData: e1="+e);
            }
        }
    }
    public void refrectNtkProject(){
//        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (currentIProject == null){
            return;
        }
        if (currentProject == 0){
            return;
        }
        
        try{
            String lang = getProgrammingLang(currentProject);
            if (lang.compareTo("C++") == 0){
                IProjectDescription description = currentIProject.getDescription();
                ICommand[] buildSpec = description.getBuildSpec();
                int cdtMakeBuilderIndex = getMwtCommandIndex(buildSpec,cdtBuilderID);
                if (cdtMakeBuilderIndex > -1){
                    ICommand cdtMakeBuilder = buildSpec[cdtMakeBuilderIndex];
    
                    String str = Mwt.WSGFgetProjectData(currentProject,"#MAKE").getString(Ntk.NTK_EN_DEFAULT);
                    Map args = cdtMakeBuilder.getArguments();
                    args.put("org.eclipse.cdt.make.core.build.command", str);
                    cdtMakeBuilder.setArguments(args);
    
                    description.setBuildSpec(buildSpec);
                    currentIProject.setDescription(description, null);
                }
            }
        }catch(Exception e){
            System.err.println("org.eclipse.nab.mwt.ntkif.NwtProjectManager.refrectNtkProject: e1="+e);
        }
    }
    public void closeNtkProject(IProject prj){
        if (currentProject == 0){
            return;
        }
        Mwt.WSGIappDev().lock();

        syncProjectData(currentProject);
        String prj_name = getMwtProjectName(prj);
        
        Mwt.WSGFsaveProject(currentProject,getCurrentProjectFullPath(),prj_name + ".prj",Mwt.WS_EN_DEFAULT);

        long win_id = Mwt.WS_ROOT_INSTANCE_ID;
        ArrayList win_array = new ArrayList();
        while(true){
            long win_next = Mwt.WSGIappObjectList().getInstanceId(
                                             Mwt.WS_ROOT_INSTANCE_ID,
                                             Mwt.WS_NEXT_CHILD_INSTANCE_ID,
                                             win_id);
            if (win_next == 0){
              break;
            }
            WSCbase win = Mwt.WSGIappObjectList().getInstanceFromId(win_next);
            WSCvariant val = new WSCvariant();
            val.setValue( Mwt.WSGFgetEncodingValue(Mwt.WSGFgetProjectData(currentProject,"#ENCODING").getString()));

            Mwt.WSGFsaveWinFile(getCurrentProjectFullPath(),win,val.getInt());
            win_array.add(win);
            win_id = win_next;
        }
        
        int i;
        int num = win_array.size();
//        NtkEventCallbackManager pm = NtkManager.getEventCallbackManager();
        for(i=0; i<num; i++){
            WSCbase win = (WSCbase)win_array.get(i);
            Mwt.WSGFdestroyWindow(win);
        }
        Mwt.WSGIappObjectList().execEventProc("ve-instance-updated");
        Mwt.WSGFdestroyProject(currentProject);
        Mwt.WSGIappDev().unlock();
        

        currentProject = 0;
        projectName = null;
        currentIProject = null;
        
        NtkManager.getSyncDisplay().asyncExec(new Runnable() {
            public void run(){
                NtkManager.getEventCallbackManager().execProc("ve-clear-instance-editor");
            }
        });


    }
    public void saveCurrentNtkProject(){
        saveNtkProject(currentIProject);
    }
    public void saveNtkProject(IProject prj){
        if (currentProject == 0){
            return;
        }
        Mwt.WSGIappDev().lock();
        
        syncProjectData(currentProject);
        String prj_name = getMwtProjectName(prj);

        Mwt.WSGFsaveProject(currentProject,getCurrentProjectFullPath(),prj_name + ".prj",Mwt.WS_EN_DEFAULT);

        long win_id = Mwt.WS_ROOT_INSTANCE_ID;
        ArrayList win_array = new ArrayList();
        while(true){
            long win_next = Mwt.WSGIappObjectList().getInstanceId(
                                             Mwt.WS_ROOT_INSTANCE_ID,
                                             Mwt.WS_NEXT_CHILD_INSTANCE_ID,
                                             win_id);
            if (win_next == 0){
              break;
            }
            WSCbase win = Mwt.WSGIappObjectList().getInstanceFromId(win_next);
            WSCvariant val = new WSCvariant();
            val.setValue( Mwt.WSGFgetEncodingValue(Mwt.WSGFgetProjectData(currentProject,"#ENCODING").getString()));

            Mwt.WSGFsaveWinFile(getCurrentProjectFullPath(),win,val.getInt());
            win_array.add(win);
            win_id = win_next;
        }
        Mwt.WSGIappDev().unlock();
        refreshLocal(prj);
    }

    public void createCurrentNtkProjectSources(){
        String dirname = getCurrentProjectFullPath();
        if (currentProject == 0){
            return;
        }
        if (currentIProject == null){
            return;
        }
        Mwt.WSGIappDev().lock();

        syncProjectData(currentProject);
        String pname = getMwtProjectName(currentIProject);
        
        Mwt.WSGFcreateMakefiles(dirname,pname,currentProject,Mwt.WS_EN_UTF8);
        Mwt.WSGFcreateProjectSrcFile(dirname,pname,currentProject,Mwt.WS_EN_UTF8);
        Mwt.WSGFcreateWindowSrcFiles(dirname,currentProject,Mwt.WS_EN_UTF8);
        Mwt.WSGIappDev().unlock();
        try{
//            currentIProject.refreshLocal(10,null);
            currentIProject.refreshLocal(IResource.DEPTH_INFINITE,null);
            currentIProject.touch(null);
        }catch (CoreException e){
            System.err.println("MwtProjectManager.createNtkProjectSources e="+e);
        }
    }
    public void refreshLocal(IProject prj){
        try{
          prj.refreshLocal(IResource.DEPTH_INFINITE,null);
          prj.touch(null);
      }catch (CoreException e){
          System.err.println("MwtProjectManager.refreshLocal e="+e);
      }
      return;  
    }
    private String getRawMwtProjectName(IProject prj){
        try{
            IProjectDescription description = prj.getDescription();
            ICommand[] bspec = description.getBuildSpec();
            int cindex = getMwtCommandIndex(bspec,mwtBuilderID);
            if (cindex != -1){
                ICommand command = bspec[cindex];
                Map args = command.getArguments();
                String pname = args.get(mwtProjectID).toString();
                if (pname != null){
                    return pname;
                }
            }
        }catch(CoreException e){
            System.err.println("MwtProjectManager.getMwtProjectName exception=" + e);
        }
        return prj.getName();
    }
    private String getMwtProjectName(IProject prj){
        String pname = getRawMwtProjectName(prj);
        String prj_name = adjustMwtProjectName(pname);
        if (pname.equals(prj_name) == false){
            setMwtProjectName(prj,prj_name);
        }
        return prj_name;
    }

    private String adjustMwtProjectName(String pname){
        if (pname.indexOf(" ") != -1){
            String ret = pname.replace(' ','_');
            ret = ret.replace('\t','_');
            return ret;
        }
        return pname;
    }
    private void setMwtProjectName(IProject prj,String pname){
        String prj_name = adjustMwtProjectName(pname);
        try{
            IProjectDescription description = prj.getDescription();
            ICommand[] bspec = description.getBuildSpec();
            int cindex = getMwtCommandIndex(bspec,mwtBuilderID);
            if (cindex != -1){
                ICommand command = bspec[cindex];
                Map args = command.getArguments();
                String original_prj_name = args.get(mwtProjectID).toString();
                if (original_prj_name.equals(prj_name) == false){
                    args.put(mwtProjectID,prj_name);
                    command.setArguments(args);
                    description.setBuildSpec(bspec);
                    
                    try{
                      prj.setDescription(description, null);
                    }catch(Exception e){
                        System.err.println("MwtProjectManager.setMwtProjectName: e1="+e);
                    }
                }
            }
        }catch(CoreException e){
            System.err.println("MwtProjectManager.loadNtkProject prj_name=" + prj_name + " exception=" + e);
        }
    }
    
    
    public long loadNtkProject(String proj_name,IProject prj){
        setCurrentProjectName(proj_name);
        String prj_name = adjustMwtProjectName(proj_name);
        currentIProject = prj;
        String dirName = getCurrentProjectFullPath();
        String prjName = prj_name + ".prj";
        
        String original_prj_name = getRawMwtProjectName(prj);
        if (original_prj_name.equals(prj_name) == false){
            //It required to rename the mwt project files,
            // old.prj -> new.prj
            // old.wns -> new.wns
            // old.col -> new.col
            // old.cpp -> new.cpp
            // old.o   -> new.o
            // old.obj -> new.obj
            
            IPath oldfn = new Path(dirName + "/" + original_prj_name + ".prj");
            IPath newfn = new Path(dirName + "/" + prj_name + ".prj");
            File oldf = oldfn.toFile();
            File newf = newfn.toFile();
            if (newf.exists() == true){
                newf.delete();
            }
            oldf.renameTo(newf);
            
            oldfn = new Path(dirName + "/" + original_prj_name + ".wns");
            newfn = new Path(dirName + "/" + prj_name + ".wns");
            oldf = oldfn.toFile();
            newf = newfn.toFile();
            if (newf.exists() == true){
                newf.delete();
            }
            oldf.renameTo(newf);

            oldfn = new Path(dirName + "/" + original_prj_name + ".col");
            newfn = new Path(dirName + "/" + prj_name + ".col");
            oldf = oldfn.toFile();
            newf = newfn.toFile();
            if (newf.exists() == true){
                newf.delete();
            }
            oldf.renameTo(newf);
            
            oldfn = new Path(dirName + "/" + original_prj_name + ".cpp");
            newfn = new Path(dirName + "/" + prj_name + ".cpp");
            oldf = oldfn.toFile();
            newf = newfn.toFile();
            if (oldf.exists() == true){
                if (newf.exists() == true){
                    newf.delete();
                }
                oldf.renameTo(newf);
            }
            
            oldfn = new Path(dirName + "/" + original_prj_name + ".o");
            newfn = new Path(dirName + "/" + prj_name + ".o");
            oldf = oldfn.toFile();
            newf = newfn.toFile();
            if (oldf.exists() == true){
                if (newf.exists() == true){
                    newf.delete();
                }
                oldf.renameTo(newf);
            }
            
            oldfn = new Path(dirName + "/" + original_prj_name + ".obj");
            newfn = new Path(dirName + "/" + prj_name + ".obj");
            oldf = oldfn.toFile();
            newf = newfn.toFile();
            if (oldf.exists() == true){
                if (newf.exists() == true){
                    newf.delete();
                }
                oldf.renameTo(newf);
            }
            
            setMwtProjectName(prj,prj_name);
        }

        Mwt.WSGIappDev().lock();
        long ret_prj = Mwt.WSGFloadProjectAndWinFiles(dirName,prjName,Mwt.WS_EN_DEFAULT);
        if (ret_prj != 0){
            Mwt.WSGIappObjectList().execEventProc("ve-prop-instance-selected");
            Mwt.WSGIappObjectList().execEventProc("ve-instance-updated");
        }else{
            String fname = Mwt.WSGFgetMgrStrData(Mwt.WS_DEFAULT_PROJECT_FILE_NAME,0).getString();
            ret_prj = Mwt.WSGFloadProject(fname,Mwt.WS_EN_DEFAULT);
            if (ret_prj !=0){
                Mwt.WSGFsetProjectData(ret_prj,"#OUTPUT",prj_name,Mwt.WS_EN_DEFAULT);
                Mwt.WSGFsetProjectData(ret_prj,"#STOUTPUT",prj_name,Mwt.WS_EN_DEFAULT);
                Mwt.WSGFsetProjectData(ret_prj,"#DBG_OUTPUT",prj_name,Mwt.WS_EN_DEFAULT);
                Mwt.WSGFsetProjectData(ret_prj,"#DBG_STOUTPUT",prj_name,Mwt.WS_EN_DEFAULT);
            }
        }
        Mwt.WSGIappDev().unlock();

        currentProject = ret_prj;
        
        refrectNtkProject();
        return ret_prj;
    }
    public long createNewNtkProject(String prj_name){
        setCurrentProjectName(prj_name);
        Mwt.WSGIappDev().lock();
        String fname = Mwt.WSGFgetMgrStrData(Mwt.WS_DEFAULT_PROJECT_FILE_NAME,0).getString();
        long ret_prj = Mwt.WSGFloadProject(fname,Mwt.WS_EN_DEFAULT);
        if (ret_prj !=0){
            Mwt.WSGFsetProjectData(ret_prj,"#OUTPUT",prj_name,Mwt.WS_EN_DEFAULT);
            Mwt.WSGFsetProjectData(ret_prj,"#STOUTPUT",prj_name,Mwt.WS_EN_DEFAULT);
            Mwt.WSGFsetProjectData(ret_prj,"#DBG_OUTPUT",prj_name,Mwt.WS_EN_DEFAULT);
            Mwt.WSGFsetProjectData(ret_prj,"#DBG_STOUTPUT",prj_name,Mwt.WS_EN_DEFAULT);
        }
        Mwt.WSGIappDev().unlock();
        currentProject = ret_prj;
        
        return ret_prj;

    }
    public String getCurrentProjectFullPath(){
        if (currentIProject != null){
            IPath location = currentIProject.getRawLocation();
            if (location != null){
                return location.toString();
            }
            return ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toString() + "/" + currentIProject.getName();
        }
        return ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toString() + "/" 
        + projectName;
    }
    
    public String getProjectPath(){
        if (currentIProject != null){
            return "/" + currentIProject.getName();
        }
        return "/" + projectName;
    }
    public void setCurrentProjectName(String name){
        projectName = name;
    }
    public String getCurrentProjectName(){
        if (currentIProject != null){
            return currentIProject.getName();
        }
        return projectName;
    }

    public long getCurrentProject(){
        return currentProject;
    }
    
    public void addNature(IProject prj,String natureID){
        try{
            if (!prj.hasNature(natureID)){
                IProjectDescription description = prj.getDescription();
                String[] prevNatures= description.getNatureIds();
                String[] newNatures= new String[prevNatures.length + 1];
                System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
                newNatures[prevNatures.length]= natureID;
                description.setNatureIds(newNatures);
                
                prj.setDescription(description, IProject.AVOID_NATURE_CONFIG,null);
            }
        }catch(Exception e){
            System.err.println("MwtNewProjectWizard.addNature e="+e);
        }
    }
    private int getMwtCommandIndex(ICommand[] buildSpec,String bid) {
        for (int i = 0; i < buildSpec.length; ++i) {
            if (buildSpec[i].getBuilderName().equals(bid)) {
                return i;
            }
        }
        return -1;
    }

    public void configureNtkProject(IProject prj,String lang){
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(prj.getName());
        currentIProject = prj;
        ICommand command = description.newCommand();
        
        ICommand[] oldBuildSpec;
        ICommand[] newCommands;
        
        if (lang.compareTo("C++") == 0){

            Map args = command.getArguments();
            args.put("org.eclipse.cdt.make.core.build.arguments","");
            args.put("org.eclipse.cdt.core.errorOutputParser", "org.eclipse.cdt.core.MakeErrorParser;org.eclipse.cdt.core.GCCErrorParser;org.eclipse.cdt.core.GASErrorParser;org.eclipse.cdt.core.GLDErrorParser;org.eclipse.cdt.core.VCErrorParser;");
            args.put("org.eclipse.cdt.make.core.enableAutoBuild", "false");
            args.put("org.eclipse.cdt.make.core.environment", "");
            args.put("org.eclipse.cdt.make.core.enableFullBuild", "true");
            args.put("org.eclipse.cdt.make.core.build.target.inc", "all");
            args.put("org.eclipse.cdt.make.core.enabledIncrementalBuild", "true");
            args.put("org.eclipse.cdt.make.core.build.target.clean", "clean");
            args.put("org.eclipse.cdt.make.core.build.command", "make");
            args.put("org.eclipse.cdt.make.core.enableCleanBuild", "true");
            args.put("org.eclipse.cdt.make.core.append_environment", "true");
            args.put("org.eclipse.cdt.make.core.build.target.full", "clean all");
            args.put("org.eclipse.cdt.make.core.useDefaultBuildCmd", "false");
            args.put("org.eclipse.cdt.make.core.build.target.auto", "all");
            args.put("org.eclipse.cdt.make.core.stopOnError", "false");
            command.setArguments(args);
            //MakeProjectNature.setBuildSpec(description, command);
            
            command.setBuilderName(cdtBuilderID);

        
            oldBuildSpec = description.getBuildSpec();
            int oldMwtCommandIndex = getMwtCommandIndex(oldBuildSpec,cdtBuilderID);
        
            if (oldMwtCommandIndex == -1) {
                // Add a Java build spec before other builders (1FWJK7I)
                newCommands = new ICommand[oldBuildSpec.length + 1];
                System.arraycopy(oldBuildSpec, 0, newCommands, 1, oldBuildSpec.length);
                newCommands[0] = command;
            } else {
                oldBuildSpec[oldMwtCommandIndex] = command;
                newCommands = oldBuildSpec; 
            }
        
            // Commit the spec change into the project
            description.setBuildSpec(newCommands);
    
            ICommand command2 = description.newCommand();
            command2.setBuilderName(cdtBuilderID2);
    
            oldBuildSpec = newCommands;
            oldMwtCommandIndex = getMwtCommandIndex(oldBuildSpec,cdtBuilderID2);
        
            if (oldMwtCommandIndex == -1) {
                // Add a Java build spec before other builders (1FWJK7I)
                newCommands = new ICommand[oldBuildSpec.length + 1];
                System.arraycopy(oldBuildSpec, 0, newCommands, 1, oldBuildSpec.length);
                newCommands[0] = command2;
            } else {
                oldBuildSpec[oldMwtCommandIndex] = command2;
                newCommands = oldBuildSpec; 
            }
    
            description.setBuildSpec(newCommands);
            
            ICommand command3 = description.newCommand();
            command3.setBuilderName(mwtBuilderID);
            Map args3 = command3.getArguments();
            args3.put(mwtProjectID,prj.getName());
            command3.setArguments(args3);

            oldBuildSpec = newCommands;
            oldMwtCommandIndex = getMwtCommandIndex(oldBuildSpec,mwtBuilderID);
        
            if (oldMwtCommandIndex == -1) {
                // Add a Java build spec before other builders (1FWJK7I)
                newCommands = new ICommand[oldBuildSpec.length + 1];
                System.arraycopy(oldBuildSpec, 0, newCommands, 1, oldBuildSpec.length);
                newCommands[0] = command3;
            } else {
                oldBuildSpec[oldMwtCommandIndex] = command3;
                newCommands = oldBuildSpec; 
            }

            description.setBuildSpec(newCommands);

            
            try{
              prj.setDescription(description, null);
            }catch(Exception e){
                System.err.println("org.eclipse.nab.core.mwtif.MwtProjectManager.configureNtkProject: e1="+e);
            }
            addNature(prj,mwtNatureID);
            addNature(prj,cdtNatureID);
            addNature(prj,cdtNatureID2);
            addNature(prj,cdtNatureID3);
            addNature(prj,cdtNatureID4);
            
            addBinaryParser(prj, cdtBinaryParser1);

        }else if (lang.compareTo("Java") == 0){
            command.setBuilderName(jdtBuilderID);
            oldBuildSpec = description.getBuildSpec();
            int oldMwtCommandIndex = getMwtCommandIndex(oldBuildSpec,jdtBuilderID);
        
            if (oldMwtCommandIndex == -1) {
                // Add a Java build spec before other builders (1FWJK7I)
                newCommands = new ICommand[oldBuildSpec.length + 1];
                System.arraycopy(oldBuildSpec, 0, newCommands, 1, oldBuildSpec.length);
                newCommands[0] = command;
            } else {
                oldBuildSpec[oldMwtCommandIndex] = command;
                newCommands = oldBuildSpec; 
            }
        
            // Commit the spec change into the project
            description.setBuildSpec(newCommands);
            ICommand command3 = description.newCommand();
            command3.setBuilderName(mwtBuilderID);
            Map args3 = command3.getArguments();
            args3.put(mwtProjectID,prj.getName());
            command3.setArguments(args3);

            oldBuildSpec = newCommands;
            
            oldMwtCommandIndex = getMwtCommandIndex(oldBuildSpec,mwtBuilderID);
        
            if (oldMwtCommandIndex == -1) {
                // Add a Java build spec before other builders (1FWJK7I)
                newCommands = new ICommand[oldBuildSpec.length + 1];
                System.arraycopy(oldBuildSpec, 0, newCommands, 1, oldBuildSpec.length);
                newCommands[0] = command3;
            } else {
                oldBuildSpec[oldMwtCommandIndex] = command3;
                newCommands = oldBuildSpec; 
            }

            description.setBuildSpec(newCommands);

            
            try{
              prj.setDescription(description, null);
            }catch(Exception e){
                System.err.println("org.eclipse.nab.core.mwtif.MwtProjectManager.configureNtkProject: e1="+e);
            }
            addNature(prj,mwtNatureID);
            addNature(prj,jdtNatureID);
            IJavaProject jprj = JavaCore.create(prj);
            try{
                IClasspathEntry[] oldEntries= jprj.getRawClasspath();
                int nEntries= oldEntries.length;
                IClasspathEntry[] newEntries= new IClasspathEntry[nEntries + 2];
                System.arraycopy(oldEntries, 0, newEntries, 0, nEntries);
                newEntries[nEntries] = JavaCore.newContainerEntry(new Path("org.eclipse.jdt.launching.JRE_CONTAINER"));
//                newEntries[nEntries+1] = JavaCore.newLibraryEntry(new Path("/mwt.jar"),new Path(""),new Path(""));
                newEntries[nEntries+1] = new ClasspathEntry(
                        IPackageFragmentRoot.K_BINARY,
                        IClasspathEntry.CPE_LIBRARY,
                        JavaProject.canonicalizedPath(new Path("mwt.jar")),
                        ClasspathEntry.INCLUDE_ALL, // inclusion patterns
                        ClasspathEntry.EXCLUDE_NONE, // exclusion patterns
                        null,
                        null,
                        null, // specific output folder
                        false,
                        ClasspathEntry.NO_ACCESS_RULES,
                        false, // no access rules to combine
                        ClasspathEntry.NO_EXTRA_ATTRIBUTES);
                
                jprj.setRawClasspath(newEntries, null);
            }catch(JavaModelException e){
                System.err.println("MwtProjectManager.configureNtkProject");
            }
        }

        
    }
    public void addBinaryParser(IProject prj,String id){
        try{
            ICDescriptor cdescriptor = CCorePlugin.getDefault().getCDescriptorManager().getDescriptor(prj);
            ICExtensionReference[] list = cdescriptor.get(CCorePlugin.BINARY_PARSER_UNIQ_ID);
            int num = list.length;
            int i;
            boolean fl = false;
            for(i=0; i<num; i++){
                if (list[i].getID().equals(id)){
                    fl = true;
                }
            }
            if (fl == false){
                cdescriptor.create(CCorePlugin.BINARY_PARSER_UNIQ_ID,id);
            }
        }catch(Exception e){
            System.err.println("org.eclipse.nab.core.mwtif.MwtProjectManager.configureNtkProject: e2="+e);
        }
    }
    public String getProjectDefaultData(long prj,String var,int encoding){
        String str = Mwt.WSGFgetProjectDefaultData(prj,var).getString(encoding);
        return str;
    }
    public String getProjectData(long prj,String var,int encoding){
        syncProjectData(prj);
        String str = Mwt.WSGFgetProjectData(prj,var).getString(encoding);
        return str;
    }
    public int getProjectData(long prj,String var){
        WSCvariant ret = new WSCvariant();
        ret.setValue(Mwt.WSGFgetProjectData(prj,var).getString());
        return ret.getInt();
    }

    public int setProjectData(long prj,String var,String val,int encoding){
        int ret = Mwt.WSGFsetProjectData(prj,var,val,encoding);
        if (ret == Mwt.WS_NO_ERR){
            refrectNtkProject();
            return Ntk.NTK_NO_ERR;
        }
        return Ntk.NTK_ERR;
    }
    public long getStaticData(int kind,long id){
        long ret = Mwt.WSGFgetMgrData(kind,id);
        return ret;
    }
    public String getStaticData(int kind,long id,int encoding){
        String ret = Mwt.WSGFgetMgrStrData(kind,id).getString(encoding);
        return ret;
    }
    public String getStaticData(int kind,String id,int encoding){
        String ret = Mwt.WSGFgetMgrStrStrData(kind,id).getString(encoding);
        return ret;
    }
    public String getEnvironmentData(String id,int encoding){
        String ret = Mwt.WSGFgetProjectEnvironmentData(id).getString(encoding);
        return ret;
    }
    public int setEnvironmentData(String id,String val,int encoding){
        int ret = Mwt.WSGFsetProjectEnvironmentData(id,val,encoding);
        if (ret == Mwt.WS_NO_ERR){
            return Ntk.NTK_NO_ERR;
        }
        return Ntk.NTK_ERR;
    }
    public int saveEnvironmentData(){
        int ret = Mwt.WSGFsaveProjectEnvironment();
        if (ret == Mwt.WS_NO_ERR){
            return Ntk.NTK_NO_ERR;
        }
        return Ntk.NTK_ERR;
    }
    public int doOperation(long prj,int kind){
        if (kind == Ntk.NTK_LOAD_LINKOPTIONS){
            int ret = Mwt.WSGFloadLinkOptions(prj);
            if (ret == Mwt.WS_NO_ERR){
                return Ntk.NTK_NO_ERR;
            }
            return Ntk.NTK_ERR;
        }
        return Ntk.NTK_ERR;
    }
    public boolean existFile(String fname){
        short ret = Mwt.WSGFcheckExistFile(fname);
        if (ret == (short)0){
            return false;
        }
        return true;
    }
    public int createProcedure(String dirName,String fileName,int langType,String functionName,String className){
        int ret = Mwt.WSGFcreateProcedure(dirName,fileName,langType,functionName,className,Mwt.WS_EN_UTF8);
        if (currentIProject != null){
            refreshLocal(currentIProject);
        }
        return ret;
    }
    public String getProgrammingLang(long prj){
        String str = Mwt.WSGFgetProjectData(prj,"#LANG").getString(Ntk.NTK_EN_DEFAULT);
        return str;
    }
    public int getCurrentProjectLangType(){
        if (currentProject == 0){
            return Ntk.NTK_LANG_CPP;
        }
        String str = Mwt.WSGFgetProjectData(currentProject,"#LANG").getString(Ntk.NTK_EN_DEFAULT);
        if (str.compareTo("C++") == 0){
            return Ntk.NTK_LANG_CPP;
        }else if (str.compareTo("Java") == 0){
            return Ntk.NTK_LANG_JAVA;
        }else if (str.compareTo("Ruby") == 0){
            return Ntk.NTK_LANG_RUBY;
        }else if (str.compareTo("Python") == 0){
            return Ntk.NTK_LANG_PYTHON;
        }else if (str.compareTo("Perl") == 0){
            return Ntk.NTK_LANG_PERL;
        }else if (str.compareTo("Ocaml") == 0){
            return Ntk.NTK_LANG_OCAML;
        }
        return Ntk.NTK_LANG_CPP;    
    }

}
