/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.core;

import org.eclipse.nab.core.Ntk;
import org.eclipse.nab.core.NtkManager;
import org.eclipse.ui.wizards.newresource.*;
//import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.MessageDialog;
//import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.resources.IFolder;
//import org.eclipse.core.resources.IFile;
import org.eclipse.nab.mwt.ab.core.CorePlugin;

import org.eclipse.core.resources.IContainer;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
//import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;

public class MwtImportProjectWizard extends BasicNewProjectResourceWizard {
    private static final String PAGE_TITLE1 = UIMessages.getString("MwtImportProjectWizardPage.pageTitle1"); //$NON-NLS-1$

    MwtImportProjectWizardPage page;    
    public MwtImportProjectWizard() {
        super();
        
    }
    public void addPages(){
//        super.addPages();
        page = new MwtImportProjectWizardPage(selection);
        addPage(page);
        setWindowTitle(PAGE_TITLE1);
    }
    public IProject getNewProject() {
        return mwt_project;
    }

    public boolean performFinish() {
        createNewProject();

        if (mwt_project == null){
            return false;
        }
        updatePerspective();

        selectAndReveal(mwt_project);

        IProject prj = mwt_project;
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int num = projects.length;
        int i;
        for(i=0; i<num; i++){
            if (projects[i] != prj){
                try{
                    if (projects[i].isOpen() == true){
                        if (projects[i].hasNature(NtkManager.getNtkProjectManager().getNatureId()) == true){
                            projects[i].close(null);
                        }
                    }
                }catch(CoreException e){
                    System.err.println("MwtImportProjectWizard.performFinish exception: project close e="+e);
                }
            }
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(new Path(page.getProjectName()));

        if (!resource.exists() || !(resource instanceof IContainer)) {
            ErrorDialog.openError(getShell(), ResourceMessages.NewProject_errorMessage,
                    "Container \"" + page.getProjectName() + "\" does not exist.", null);
            return false;
        }
        IContainer container = (IContainer) resource;

        if (container == null){
            return false;
        }
        try{
            String src_dir[] = new String[1];
            src_dir[0] = page.getFolderName();
            IPath loc = container.getRawLocation();
            String dest_path;
            if (loc == null){
                dest_path = ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toString() + container.getFullPath();
            }else{
                dest_path = loc.toString();
            }
            if (dest_path.compareTo(src_dir[0]) != 0){
                
                CopyFilesAndFoldersOperation op = new CopyFilesAndFoldersOperation(getShell());
                op.copyFiles(src_dir, container);
                IPath tmp = new Path(page.getFolderName());
                IPath tmp_dir = new Path(tmp.lastSegment());
                IPath tmp_dir_dest = new Path(tmp.lastSegment() + "-temp-dir");
                
                IFolder tmp_folder = container.getFolder(tmp_dir);
    //            IFolder folder = root.getFolder(new Path(page.getFolderName()));
                tmp_folder.move(tmp_dir_dest,true,false,null);
                IFolder folder = container.getFolder(tmp_dir_dest);
                IResource file_members[] = folder.members();
                num = file_members.length;
    //            String files[] = new String[num];
                for(i=0; i<num; i++){
                    IPath dest = container.getFullPath();
                    IPath destf = dest.append(file_members[i].getFullPath().lastSegment());
                    String fname = file_members[i].getFullPath().lastSegment();
                    if (fname.compareTo(".project") == 0){
                        continue;
                    }
                    if (fname.compareTo(".cdtproject") == 0){
                        continue;
                    }
                    file_members[i].move(destf,true,null);
    //                files[i] = file_members[i].getFullPath().toString();
                }
                
    //            op.copyFiles(files, container);
                folder.delete(true,null);
            }
            String lang = page.getLangType();
            NtkManager.getNtkProjectManager().configureNtkProject(prj,lang);
            long current_project = NtkManager.getNtkProjectManager().getCurrentProject();
            if (current_project == 0){
                NtkManager.getNtkProjectManager().loadNtkProject(prj.getName(),prj);
                current_project = NtkManager.getNtkProjectManager().getCurrentProject();
            }
            NtkManager.getNtkProjectManager().setProjectData(current_project,"#LANG",lang,Ntk.NTK_EN_DEFAULT);

            NtkManager.getNtkProjectManager().createCurrentNtkProjectSources();
            
        }catch(CoreException e){
            System.err.println("MwtImportProjectWizard.performFinish e="+e);
        }
        
        return true;
    }
    private IProject mwt_project;

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(
                page.getProjectName());
    }

    private IProject createNewProject() {
        if (mwt_project != null){
            return mwt_project;
        }
        final IProject newProjectHandle = getProjectHandle();

        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace
                .newProjectDescription(newProjectHandle.getName());
        description.setLocation(null);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation() {
            protected void execute(IProgressMonitor monitor)
                    throws CoreException {
                createProject(description, newProjectHandle, monitor);
            }
        };
        try {
            getContainer().run(true, true, op);
        } catch (InterruptedException e) {
            return null;
        } catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException) t).getStatus().getCode() == IResourceStatus.CASE_VARIANT_EXISTS) {
                    MessageDialog.openError(
                                    getShell(),
                                    ResourceMessages.NewProject_errorMessage,
                                    NLS.bind(ResourceMessages.NewProject_caseVariantExistsError, newProjectHandle.getName())
                            );
                } else {
                    ErrorDialog.openError(getShell(), ResourceMessages.NewProject_errorMessage,
                            null, ((CoreException) t).getStatus());
                }
            } else {
                IDEWorkbenchPlugin.getDefault().getLog().log(
                        new Status(IStatus.ERROR,
                                IDEWorkbenchPlugin.IDE_WORKBENCH, 0, t
                                        .toString(), t));
                MessageDialog.openError(
                                getShell(),
                                ResourceMessages.NewProject_errorMessage,
                                NLS.bind(ResourceMessages.NewProject_internalError, t.getMessage()));
            }
            return null;
        }
        mwt_project = newProjectHandle;
        return mwt_project;
    }
    void createProject(IProjectDescription description, IProject projectHandle,
            IProgressMonitor monitor) throws CoreException,
            OperationCanceledException {

        try {
            monitor.beginTask("", 2000);//$NON-NLS-1$

            projectHandle.create(description, new SubProgressMonitor(monitor,
                    1000));

            if (monitor.isCanceled())
                throw new OperationCanceledException();

//            CorePlugin.setAllowLoadingNtkProject(false);
            projectHandle.open(IResource.BACKGROUND_REFRESH, new SubProgressMonitor(monitor, 1000));

        } finally {
//            CorePlugin.setAllowLoadingNtkProject(true);
            monitor.done();
        }
    }

}
