/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.core;

import java.util.ArrayList;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.nab.core.INtkProjectManager;
import org.eclipse.nab.core.Ntk;
import org.eclipse.nab.core.NtkManager;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class MwtImportProjectWizardPage extends WizardPage {
    private static final String TEXT_TITLE = UIMessages.getString("MwtImportProjectWizardPage.dirTitle"); //$NON-NLS-1$
    private static final String BBTN_TITLE = UIMessages.getString("MwtImportProjectWizardPage.bbtnTitle"); //$NON-NLS-1$
    private static final String LANG_TITLE = UIMessages.getString("MwtImportProjectWizardPage.langTitle"); //$NON-NLS-1$
    private static final String STATUS_MESSAGE1 = UIMessages.getString("MwtImportProjectWizardPage.statusMessage1"); //$NON-NLS-1$
    private static final String STATUS_MESSAGE2 = UIMessages.getString("MwtImportProjectWizardPage.statusMessage2"); //$NON-NLS-1$
    private static final String PAGE_TITLE1 = UIMessages.getString("MwtImportProjectWizardPage.pageTitle1"); //$NON-NLS-1$
    private static final String PAGE_TITLE2 = UIMessages.getString("MwtImportProjectWizardPage.pageTitle2"); //$NON-NLS-1$

    
	private Text fileText;
	private ISelection selection;
    private Combo langTypeCombo;
    private boolean input_flag = false;
    
	public MwtImportProjectWizardPage(ISelection selection) {
        
		super("wizardPage");
        setTitle(PAGE_TITLE1);
        setDescription(PAGE_TITLE2);

		this.selection = selection;
	}

	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 3;
		layout.verticalSpacing = 9;
		Label label = new Label(container, SWT.NULL);
		label.setText(TEXT_TITLE);

		fileText = new Text(container, SWT.BORDER | SWT.SINGLE);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		fileText.setLayoutData(gd);
		fileText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});

		Button button = new Button(container, SWT.PUSH);
		button.setText(BBTN_TITLE);
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				handleBrowse();
			}
		});
        
        Label label2 = new Label(container, SWT.NULL);
        label2.setText(LANG_TITLE);
       
        
        langTypeCombo = new Combo(container, SWT.READ_ONLY);
        INtkProjectManager pman = NtkManager.getNtkProjectManager();
        ArrayList itemNameArray = new ArrayList();
        ArrayList itemValueArray = new ArrayList();

        long cnt = 0;
        String firstitem = pman.getStaticData(Ntk.NTK_LANG_STR,cnt,Ntk.NTK_EN_DEFAULT);
        while(true){
            String item = pman.getStaticData(Ntk.NTK_LANG_STR,cnt,Ntk.NTK_EN_DEFAULT);
            itemNameArray.add(item);
            Long val = new Long(cnt);
            itemValueArray.add(val);
            cnt = pman.getStaticData(Ntk.NTK_NEXT_LANG_ID,cnt);
            if (cnt != Ntk.NTK_LANG_CPP && cnt != Ntk.NTK_LANG_JAVA){
                break;
            }
        }
        langTypeCombo.setItems((String[]) itemNameArray.toArray(new String[0]));
        langTypeCombo.setText(firstitem);
        gd = new GridData(GridData.FILL_HORIZONTAL);
        langTypeCombo.setLayoutData(gd);

		initialize();
		dialogChanged();
		setControl(container);
	}
		
	private void initialize() {
	}
	
	private void handleBrowse() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        FileDialog fileDialog = new FileDialog(page.getWorkbenchWindow().getShell());
        String[] ext = {"*.prj"};
        fileDialog.setFilterExtensions(ext);
        String ret = fileDialog.open();
        if (ret != null){
            fileText.setText(ret);
        }
	}
	
	private void dialogChanged() {
		String fileName = getPathName();
        if (fileName.length() > 0){
            input_flag = true;
        }
        if (input_flag == false){
            return;
        }
		if (input_flag == true && fileName.length() == 0) {
			updateStatus(STATUS_MESSAGE1);
			return;
		}
        IPath path = new Path(fileName);
        String ext = path.getFileExtension();

        if (ext == null || ext.equalsIgnoreCase("prj") == false) {
            updateStatus(STATUS_MESSAGE2);
            return;
        }

        /*
		int dotLoc = fileName.lastIndexOf('.');
		if (dotLoc != -1) {
			String ext = fileName.substring(dotLoc + 1);
			if (ext.equalsIgnoreCase("prj") == false) {
				updateStatus(STATUS_MESSAGE2);
				return;
			}
		}
        */
		updateStatus(null);
	}

	private void updateStatus(String message) {
		setErrorMessage(message);
		setPageComplete(message == null);
	}
    public String getFolderName() {
        String path_name = fileText.getText();
        IPath path = new Path(path_name);
        IPath dir = path.removeLastSegments(1);
        
        return dir.toString();
    }
    public String getFileName() {
        String path_name = fileText.getText();
        IPath path = new Path(path_name);
        return path.lastSegment();
    }
    public String getProjectName(){
        IPath path = new Path(getFileName());
        IPath ret = path.removeFileExtension();
        return ret.toString();
    }

	public String getPathName() {
		return fileText.getText();
	}
    public String getLangType(){
        return langTypeCombo.getText();
    }
}
