/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.core;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class MwtPerspectiveFactory implements IPerspectiveFactory {

    public MwtPerspectiveFactory() {
        super();
    }

    public void createInitialLayout(IPageLayout layout) {
        String editorArea = layout.getEditorArea();


        IFolderLayout folder1= layout.createFolder("MwtTopLeft", IPageLayout.LEFT, (float)0.15, editorArea); //$NON-NLS-1$
//      folder1.addView(IPageLayout.ID_RES_NAV);
        folder1.addView("org.eclipse.cdt.ui.CView");

        IFolderLayout folder6= layout.createFolder("MwtBottom", IPageLayout.BOTTOM,(float)0.8, editorArea); //$NON-NLS-1$
        folder6.addView("org.eclipse.ui.console.ConsoleView");
        folder6.addView(IPageLayout.ID_PROBLEM_VIEW);

        IFolderLayout folder2= layout.createFolder("MwtRight", IPageLayout.RIGHT,(float)0.6, editorArea); //$NON-NLS-1$
        folder2.addView("org.eclipse.nab.mwt.ab.view.MwtInstancePropertyView");
        folder2.addView("org.eclipse.nab.mwt.ab.view.MwtInstanceAttributeView");
        
        IFolderLayout folder3= layout.createFolder("MwtTopLeft2", IPageLayout.BOTTOM, (float)0.5, "MwtTopLeft"); //$NON-NLS-1$
        folder3.addView("org.eclipse.nab.mwt.ab.view.MwtInstanceTreeView");
        folder3.addView("org.eclipse.nab.mwt.ab.view.MwtInstanceListView");

        IFolderLayout folder4= layout.createFolder("MwtRight2", IPageLayout.RIGHT, (float)0.8, "MwtRight"); //$NON-NLS-1$
        folder4.addView("org.eclipse.nab.mwt.ab.view.MwtObjectBoxView");
 
        IFolderLayout folder5= layout.createFolder("MwtTop", IPageLayout.TOP,(float)0.5, editorArea); //$NON-NLS-1$
        folder5.addView("org.eclipse.nab.mwt.ab.view.MwtInstanceEditorView");

        IFolderLayout folder7= layout.createFolder("MwtRight3", IPageLayout.BOTTOM, (float)0.6, "MwtRight"); //$NON-NLS-1$
        folder7.addView("org.eclipse.nab.mwt.ab.view.MwtInstanceProcedureView");

        
        layout.addShowViewShortcut("org.eclipse.nab.mwt.ab.view.MwtInstanceListView");
        layout.addShowViewShortcut("org.eclipse.nab.mwt.ab.view.MwtInstanceTreeView");
        layout.addShowViewShortcut("org.eclipse.nab.mwt.ab.view.MwtInstanceAttributeView");
        layout.addShowViewShortcut("org.eclipse.nab.mwt.ab.view.MwtInstancePropertyView");
        layout.addShowViewShortcut("org.eclipse.nab.mwt.ab.view.MwtInstanceProcedureView");
        layout.addShowViewShortcut("org.eclipse.nab.mwt.ab.view.MwtInstanceEditorView");
        layout.addShowViewShortcut("org.eclipse.nab.mwt.ab.view.MwtObjectBoxView");
        
        // views - standard workbench
        layout.addShowViewShortcut("org.eclipse.ui.console.ConsoleView");
        layout.addShowViewShortcut(IPageLayout.ID_PROBLEM_VIEW);
//        layout.addShowViewShortcut(IPageLayout.ID_RES_NAV);
        layout.addShowViewShortcut("org.eclipse.cdt.ui.CView");

        // link - things we should do
        layout.addShowInPart(IPageLayout.ID_RES_NAV);
    }
}
