/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.core;

import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.nab.core.INtkProjectManager;
import org.eclipse.nab.core.Ntk;
import org.eclipse.nab.core.NtkManager;

public class MwtResourceChangeListener implements IResourceChangeListener {

    public void resourceChanged(IResourceChangeEvent event) {        
        switch (event.getType()) {
        case IResourceChangeEvent.PRE_DELETE :
        case IResourceChangeEvent.PRE_CLOSE :{
            IResource dResource = event.getResource();
                        if (dResource.getType() == IResource.PROJECT) {
                            IProject project = (IProject)dResource;
                            try{
                                INtkProjectManager pman = NtkManager.getNtkProjectManager();
                                if (project.hasNature(pman.getNatureId()) == true){
                                    if (pman.getCurrentProjectName() == project.getName()){
                                        pman.closeNtkProject(project);
                                    }
                                }
                            }catch(CoreException e){
                                System.err.println("MwtResourceChangeListener.resourceChanged exception: project close e="+e);
                            }
                        }
            break;
        }
        case IResourceChangeEvent.PRE_BUILD : {
            break;
        }
        case IResourceChangeEvent.POST_CHANGE : {
            IResourceDelta resDelta = event.getDelta();
            if (resDelta == null) {
                break;
            }
            try{
                resDelta.accept(new IResourceDeltaVisitor() {

                    public boolean visit(IResourceDelta delta){
                        IResource dResource = delta.getResource();
                        if (dResource.getType() == IResource.PROJECT) {
                            IProject project = (IProject)dResource;
                            try{
                                INtkProjectManager pman = NtkManager.getNtkProjectManager();
                                if ((project.isOpen() == true) && 
                                        !dResource.getName().equalsIgnoreCase(pman.getCurrentProjectName()) &&
                                        (project.hasNature(pman.getNatureId()) == true)){
                                    
                                    IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                                    int num = projects.length;
                                    int i;
                                    for(i=0; i<num; i++){
                                        if (projects[i] != dResource){
                                            if (projects[i].isOpen() == true){
                                                if (projects[i].hasNature(pman.getNatureId()) == true){
                                                    if (pman.getCurrentProjectName() == projects[i].getName()){
                                                        pman.closeNtkProject(projects[i]);
                                                    }
                                                    //delayed closing project..
                                                    Display disp = NtkManager.getSyncDisplay();
                                                    final IProject close_project = projects[i];
                                                    if (disp != null){
                                                        disp.asyncExec(new Runnable() {
                                                          public void run(){
                                                              try{
                                                                  close_project.close(null);
                                                              }catch(CoreException e){
                                                                  System.err.println("MwtResourceChangeListener.resourceChanged exception: project close e="+e);
                                                              }
                                                          }
                                                        });
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    //delayed closing project..
                                    Display disp = NtkManager.getSyncDisplay();
                                    final IProject load_project = project;
                                    if (disp != null){
                                        disp.asyncExec(new Runnable() {
                                          public void run(){
                                              INtkProjectManager pman = NtkManager.getNtkProjectManager();
                                              if (!load_project.getName().equalsIgnoreCase(pman.getCurrentProjectName()) && pman.getCurrentProject() == 0){
                                                  pman.loadNtkProject(load_project.getName(),load_project);
                                                  pman.createCurrentNtkProjectSources();

                                              }
                                          }
                                        });
                                    }

                                }
                            }catch(CoreException e){
                                System.err.println("MwtResourceChangeListener.resourceChanged exception: project close e="+e);
                            }
                            
                        }
                        return true;
                    }
                });
            }catch(Exception e){
                System.err.println("MwtResourceChangeListener.resourceChanged e="+e);
            }
            break;
        }
        default:
        break;
        }
        
        IResourceDelta rdelta = event.getDelta();
        try{
        rdelta.accept(new IResourceDeltaVisitor() {
            public boolean visit(IResourceDelta delta){
                IResource dResource = delta.getResource();
//                if (dResource.getType() == IResource.PROJECT) {
//                }
                return true;
            }
        });
        }catch (Exception e){
        
        }

    }

}
