/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.core;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class UIMessages {
    private static final String RESOURCE_BUNDLE_NAME= "org.eclipse.nab.mwt.ab.core.UIMessages";//$NON-NLS-1$
    private static ResourceBundle resourceBundle;

    static {
        try {
            resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME);
        } catch (MissingResourceException x) {
            resourceBundle = null;
        }
    }
    public static String getString(String index){
        try {
            return resourceBundle.getString(index);
        } catch (MissingResourceException e) {
            return '!' + index + '!';
        } catch (NullPointerException e) {
            return "#" + index + "#"; //$NON-NLS-1$ //$NON-NLS-2$
        }
    }
    
}
