/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.view;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.swt.SWT;
import org.eclipse.nab.core.INtkContext;
import org.eclipse.nab.core.INtkInstanceManager;
import org.eclipse.nab.core.Ntk;
import org.eclipse.nab.core.NtkManager;
import org.eclipse.nab.mwt.ab.core.CorePlugin;
import org.eclipse.nab.mwt.ab.core.UIMessages;

public class MwtObjectBoxView extends ViewPart{
//This code can not select the locale ja_JP.eucjp or ja_JP.sjis
    private static final String DEFINITION_FILE_PATH = UIMessages.getString("MwtCorePlugin.definitionFilePath"); //$NON-NLS-1$

    //    String DEFINITION_FILE_PATH = "data/locale/en_US";

    private int max_definitions = 64;
    
    private int iconsize = 40;
    private int icon_offset_x = 5;
    private int icon_count = 20;
    private int font_size = 10;
    private int label_height = 40;
    private int label_width = 20;
    private int button_height = 40;
    private int button_width = 40;
    private int mainCanvas_width = 1024;
    private int mainCanvas_height = 3000;   
    private Canvas baseCanvas = null;
    private Canvas mainCanvas = null;
    private Color whiteColor = new Color(null, 255, 255, 255);
    private Color propLabelBackColor = new Color(null, 240, 240, 240);
    private Color propSelectedBackColor = new Color(null, 80, 80, 80);
    private Action reloadAction = null;
    
    String defaultDefinitionPath = "data/locale/en_US";
    
    private MwtObjectBoxData propData;
    
    /** ObjectData save array  */
    private ArrayList propList;
    private ArrayList fileList;

    private ArrayList extClassList;

    /** wedget  */
    private Canvas canvas;
    
    private int regNum = 0;
    private int checkSelNum = 0;
    private boolean reloadFlg = false;
    
    private long proc1;
    private long proc2;
    private long proc3;
    
    /** Event action */
    private Action vScrollAction;
    
    public class DATAFilenameFilter implements FilenameFilter {
        public boolean accept(File dir, String name){
          return name.toLowerCase().endsWith(".data");
        }
    }
        
    public class MwtObjectBoxData {

        private Label label = null;
        private String type =null;
//        private Text text = null;
        private Button button =null;

        public MwtObjectBoxData(){
            super();
        }
        public void setLabel(Label _label){
            label = _label;
        }
//        public void setText(Text _text){
//            text = _text;
//        }
        public void setType(String _type){
            type = _type;
        }       
        public void setButton(Button _button){
            button = _button;
        } 
        public Label getLabel(){
            return label;
        }       
//        public Text getText(){
//            return text;
//        }
        public String getType(){
            return type;
        }
        public Button getButton(){
            return button;
        }
    }
    
    /**
     * constructor
     */
    public MwtObjectBoxView() {
        if (NtkManager.isInitialized() == false){
            NtkManager.ntkInitialize();
        }
        proc1 = NtkManager.getEventCallbackManager().addProc("",this,"reloadObject",null);
        proc2 = NtkManager.getEventCallbackManager().addProc("ve-instance-updated",this,"ButtonRelease",null);
        proc3 = NtkManager.getEventCallbackManager().addProc("ve-class-library-updated",this,"classLibraryUpdated",null);
    }
    public void dispose() {
        NtkManager.getEventCallbackManager().delProc(proc1);
        NtkManager.getEventCallbackManager().delProc(proc2);
        NtkManager.getEventCallbackManager().delProc(proc3);
        super.dispose();
    }
    public void reloadObject(Object obj){        
        regNum = 0;
        checkSelNum = 0;
        reloadFlg = true;
        vScrollAction.run();
    }
    public void classLibraryUpdated(Object param){
        readExtObjectData();
        Point viewSize = baseCanvas.getSize();
        int item = 0;
        if (viewSize.x !=0){
            int s = 0;
            s = ((viewSize.x-21)/iconsize);
            if (s < 1) {
                item = 1;
            }else if(s >icon_count){
                item = icon_count;
            }else{
                item = s;
            }
            setRepositionParts(0,item);
        }
    }
    
    public void ButtonRelease(Object param){
        INtkContext context = NtkManager.getNtkContext();
        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
        try{
            context.lock();
        }catch(Exception e){
            System.err.println("MwtInstanceProcedureView.ButtonRelease e="+e);
            return;
        }
        MwtObjectBoxData bean;
        iman.setNewInstancePositionMode(false);
        if (baseCanvas.isDisposed() == true){
            context.unlock();
            return;
        }
        for(int i=0;i<propList.size();i++){
            bean = (MwtObjectBoxData)propList.get(i);
            if (bean.getType() == "Button"){
                if (bean.getButton().getSelection() == true){
                    bean.getButton().setSelection(false);
                }
            }
        }
        context.unlock();
    }
    
    /**
     * make Wedget Data
     */
    public void createPartControl(Composite parent){
        baseCanvas = new Canvas(parent , SWT.V_SCROLL | SWT.H_SCROLL);
        baseCanvas.setBackground(whiteColor);
        baseCanvas.setVisible(true);
        mainCanvas = new Canvas(baseCanvas, 0);
        mainCanvas.setBackground(whiteColor);
        mainCanvas.setVisible(true);
        baseCanvas.setData(mainCanvas);
        mainCanvas.setSize(mainCanvas_width, mainCanvas_height);
        baseCanvas.getVerticalBar().setValues(0, 0, 2500, 64, 8, 64);
        baseCanvas.getHorizontalBar().setValues(0, 0, 1024, 64, 8, 64);
        Display display = mainCanvas.getDisplay();
        NtkManager.setSyncDisplay(display);

        readObjectData();
        makeAction();
        setVerticalBarAction();
        setHorizontalBarAction();
        resizeAction();
        setRepositionParts(0,icon_count);
        setDisposeAction();
    }

    /**
     * set widget location
     * 
     * @param position
     */
    private void setUnfocusedAction(Button btn) {
        btn.addFocusListener(new FocusListener() {
            public void focusGained(FocusEvent e){
            };
            public void focusLost(FocusEvent e){
                Button selectButton = (Button)e.getSource();
                if (selectButton.getSelection() == true){
                    selectButton.setBackground(propLabelBackColor);
                    selectButton.setSelection(false);
                    INtkContext context = NtkManager.getNtkContext();
                    try{
                        context.lock();
                    }catch(Exception ex){
                        System.err.println("MwtInstanceProcedureView.ButtonRelease ex="+ex);
                        return;
                    }
                    NtkManager.getNtkInstanceManager().setNewInstancePositionMode(false);
                    context.unlock();
                
                }
            }
        });
    }
    private void setRepositionParts(int position ,int x){        
        MwtObjectBoxData bean;
        int j = 0;
        int posy = 0; 
        int i;
        int num = propList.size();
        for(i=0;i<num;i++){
            bean = (MwtObjectBoxData)propList.get(i);
            if (bean.getType().equals("Label")){
                if (j != 0){
                    posy++;
                }
                bean.getLabel().setLocation(icon_offset_x,(posy+position/x)*iconsize+10);
                bean.getLabel().setSize(iconsize*x,iconsize-10);
                posy++;
                j = 0;
            }else{
                bean.getButton().setLocation(icon_offset_x+(iconsize*j),(posy+position/x)*iconsize);
                j = j + 1;
                if (j == x){
                    j = 0;
                    posy++;
                }
            }
        }
        if (extClassList == null){
            return;
        }
        num = extClassList.size();
        for(i=0;i<num;i++){
            bean = (MwtObjectBoxData)extClassList.get(i);
            if (bean.getType().equals("Label")){
                if (j != 0){
                    posy++;
                }
                bean.getLabel().setLocation(icon_offset_x,(posy+position/x)*iconsize+10);
                bean.getLabel().setSize(iconsize*x,iconsize-10);
                posy++;
                j = 0;
            }else{
                bean.getButton().setLocation(icon_offset_x+(iconsize*j),(posy+position/x)*iconsize);
                j = j + 1;
                if (j == x){
                    j = 0;
                    posy++;
                }
            }
        }
        
    }
    
    private void makeAction(){
        reloadAction = new Action(){
            public void run(){
                Display display = canvas.getDisplay();
                display.asyncExec(new Runnable(){
                    public void run(){
                        Display display = baseCanvas.getDisplay();
                        display.asyncExec(new Runnable(){
                            public void run(){
                                Control[] control = mainCanvas.getChildren();
                                for(int i=0; i < control.length; i++){
                                    control[i].dispose();
                                }
                                    readObjectData();
                            }
                        });
                }});
            }
        };
    }

    private void setVerticalBarAction(){
        baseCanvas.getVerticalBar().addSelectionListener(new SelectionListener(){
            public void widgetSelected(SelectionEvent ev) {
                ScrollBar vscr = (ScrollBar)ev.getSource();
                Canvas baseCanvas = (Canvas)vscr.getParent();
                Canvas mainCanvas = (Canvas)baseCanvas.getData();
                Point loc = mainCanvas.getLocation();
                mainCanvas.setLocation(loc.x, -vscr.getSelection());
            }
            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }
    
    private void setHorizontalBarAction(){
        baseCanvas.getHorizontalBar().addSelectionListener(new SelectionListener(){
                public void widgetSelected(SelectionEvent ev) {
                    ScrollBar hscr = (ScrollBar)ev.getSource();
                    Composite baseCanvas = (Canvas)hscr.getParent();
                    Composite mainCanvas = (Canvas)baseCanvas.getData();
                    Point loc = mainCanvas.getLocation();
                    mainCanvas.setLocation(-hscr.getSelection(), loc.y);               
                }
                public void widgetDefaultSelected(SelectionEvent e) {}
            }
        );
    }
    
    private void resizeAction(){
        baseCanvas.addControlListener(new ControlListener() {
            public void controlMoved(ControlEvent e){
            }
            public void controlResized(ControlEvent e){
                Point viewSize = baseCanvas.getSize();
                int item = 0;
                if (viewSize.x !=0){
                    int s = 0;
                    s = ((viewSize.x-21)/iconsize);
                    if (s < 1) {
                        item = 1;
                    }else if(s >icon_count){
                        item = icon_count;
                    }else{
                        item = s;
                    }
                    setRepositionParts(0,item);
                }
            }
        });
    }
    
    private void setDisposeAction(){
        baseCanvas.addDisposeListener(new DisposeListener() {
            public void widgetDisposed(DisposeEvent e) {
                INtkContext context = NtkManager.getNtkContext();
                try{
                    context.lock();
                }catch(Exception ex){
                    System.err.println("MwtInstanceProcedureView.widgetDisposed ex="+ex);
                    return;
                }
                NtkManager.getNtkInstanceManager().setNewInstancePositionMode(false);
                context.unlock();
            }
        });
    }
    
    public void setFocus() {
        baseCanvas.forceFocus();
    }

    public void readObjectData(){      
        propList = new ArrayList();
        fileList = new ArrayList();
        
        for (int i = 1; i<max_definitions; i++){
            String str = ("lib" + i + ".data");
            fileList.add(str); 
        }
        
        for(int s = 0;  s<fileList.size(); s++){
            URL url = CorePlugin.getDefault().find(new Path(DEFINITION_FILE_PATH + "/" + fileList.get(s)));
            if (url == null){
                url = CorePlugin.getDefault().find(new Path(defaultDefinitionPath + "/" + fileList.get(s)));
            }
            if (url != null){
                try{
                    String line = null;
                    String className = "";
                    String classNamebk = "";
                    String pngPath = null;
                    String toolTip = null;

                    BufferedReader in = new BufferedReader( new InputStreamReader( url.openStream(),"UTF-8"));
                    while ((line = in.readLine()) != null) {
                        Label propLabel = new Label(mainCanvas,0);
                        propData = new MwtObjectBoxData();
                        Button propButton = new Button(mainCanvas,SWT.TOGGLE);
                        propButton.setBackground(propLabelBackColor);
                        selectAction(propButton);
                        setUnfocusedAction(propButton);
                        int i = line.indexOf(" ");
                        if (i == -1){
                            className = line;
                        }else{
                            className = line.substring(0,i);
                        }
                        if(className.equals("Windows") | className.equals("Forms") | className.equals("Commands") | className.equals("Drawing") | className.equals("NonGUI")){
                            Font font = new Font(null, "", font_size, SWT.BOLD);
                            propLabel.setAlignment(SWT.CENTER);
                            propLabel.setBackground(propLabelBackColor);
                            propLabel.setSize(label_height,label_width);                    
                            propLabel.setText(className);
                            propLabel.setFont(font);
                            propLabel.setToolTipText(className);
                            propData.setType("Label");
                            propData.setLabel(propLabel);
                            propList.add(propData);
                        }else if (!className.equals(classNamebk)){
                            int j = line.indexOf("/");
                            if (j != -1){
                                int k = line.indexOf(".png");
                                pngPath = line.substring(j,k+4);
                                String libname = line.substring(k+4);
                                while(libname.indexOf(" ") == 0){
                                    libname = libname.substring(1);
                                }
                                if (libname.equals("") == false){
                                    NtkManager.getNtkInstanceManager().loadLibrary(libname);
                                }
                                URL urlbmp = CorePlugin.getDefault().find(new Path(pngPath));
                                ImageDescriptor id = ImageDescriptor.createFromURL(urlbmp);
                                Image image = id.createImage();
                                image.setBackground(propButton.getBackground());
                                toolTip = in.readLine();
                                propButton.setSize(button_height,button_width);
                                propButton.setImage(image);
                                propButton.setToolTipText(toolTip);
                                propButton.setData(className);
                                propData.setType("Button");
                                propData.setButton(propButton);
                                propList.add(propData);
                            }
                        }
                        classNamebk = className;
                    }
                    in.close();
                }catch(IOException  e){
                    System.err.println("MwtInstanceListView readObjectData(): " + e.getMessage());
                    System.err.println("MwtInstanceListView readObjectData(): " + e.toString());
                }
            }
        }
    }
    
    public void readExtObjectData(){
        if (extClassList == null){
            extClassList = new ArrayList();
        }
        int i;
        int num = extClassList.size();
        for(i=0; i<num; i++){
            propData = (MwtObjectBoxData)extClassList.get(i);
            if (propData.button != null){
                propData.button.dispose();
            }
            if (propData.label != null){
                propData.label.dispose();
            }
        }
        extClassList.clear();

        long prj = NtkManager.getNtkProjectManager().getCurrentProject();
        
        String classes = NtkManager.getNtkProjectManager().getProjectData(prj,"#EXT_CLASSES",Ntk.NTK_EN_DEFAULT);
        if (classes.compareTo("") == 0){
            return;
        }
        
        Label propLabel = new Label(mainCanvas,0);
        propData = new MwtObjectBoxData();
        Font font = new Font(null, "", font_size, SWT.BOLD);
        propLabel.setAlignment(SWT.CENTER);
        propLabel.setBackground(propLabelBackColor);
        propLabel.setSize(label_height,label_width);                    
        propLabel.setText("Imported");
        propLabel.setFont(font);
        propLabel.setToolTipText("Imported");
        propData.setType("Label");
        propData.setLabel(propLabel);
        extClassList.add(propData);

        
        String[] lines = classes.split("\n");
        num = lines.length;
        
        String className ="";
        String classNamebk ="";
        for(i=0; i<num; i++){
            propData = new MwtObjectBoxData();
            Button propButton = new Button(mainCanvas,SWT.TOGGLE);
            propButton.setBackground(propLabelBackColor);
            selectAction(propButton);
            setUnfocusedAction(propButton);
            
            String line = lines[i];
            int pos = line.indexOf(" ");
            if (pos == -1){
                className = line;
            }else{
                className = line.substring(0,pos);
            }
            String imagePath = line.substring(pos);
            
            if (imagePath.indexOf("$(WSDIR)/sys/pixmaps") != -1){
                imagePath = imagePath.replaceFirst("\\$\\(WSDIR\\)\\/sys\\/pixmaps","/icons");
                imagePath = imagePath.replaceFirst("xpm","png");
            }
                    
            URL urlbmp = CorePlugin.getDefault().find(new Path(imagePath));
            if (urlbmp == null){
                urlbmp = CorePlugin.getDefault().find(new Path("/icons/obj/obj.png"));
            }
            
            ImageDescriptor id = ImageDescriptor.createFromURL(urlbmp);
            Image image = id.createImage();
            image.setBackground(propButton.getBackground());
            i++;
                   
            String toolTip = lines[i];
            propButton.setSize(button_height,button_width);
            propButton.setImage(image);
            propButton.setToolTipText(toolTip);
            propButton.setData(className);
            propData.setType("Button");
            propData.setButton(propButton);
            extClassList.add(propData);
            classNamebk = className;
        }
    }

    
    private void selectAction(Button propButton){
        propButton.addSelectionListener(new SelectionListener(){
            public void widgetSelected(SelectionEvent e) {
                INtkContext context = NtkManager.getNtkContext();
                INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
                try{
                    context.lock();
                }catch(Exception ex){
                    System.err.println("MwtInstanceProcedureView.selectAction ex="+ex);
                    return;
                }
                try{
                    MwtObjectBoxData bean;
                    Button selectButton = (Button)e.getSource();
                    if (selectButton.getSelection() == false){
                        iman.setNewInstancePositionMode(false);
                        selectButton.setBackground(propLabelBackColor);
                    }else{
                        iman.setNewInstanceClassName((String)selectButton.getData());
                        iman.setNewInstancePositionMode(true);
                        selectButton.setBackground(propSelectedBackColor);
                        for(int i=0;i<propList.size();i++){
                            bean = (MwtObjectBoxData)propList.get(i);
                            if(!bean.getType().equals("Label")){
                                if (!selectButton.equals(bean.getButton())){
                                    bean.getButton().setBackground(propLabelBackColor);
                                    bean.getButton().setSelection(false);
                                }
                            }
                        }
                    }
                }catch(Exception ex){
                    System.err.println("MwtInstanceListView selectAction(): " + ex.toString());
                }
                context.unlock();
            }
            public void widgetDefaultSelected(SelectionEvent e) {
            }          
        });
    }
    
    private String replace(String line){
        String newLine = null;
        if (line.indexOf("$(WSDIR)") != -1){
            newLine = line.replaceFirst("^\\$\\(WSDIR\\)","");
        }
        if (line.indexOf("xpm") != -1){
            newLine = newLine.replaceFirst("xpm","png");
        }
        return newLine;
    }
}
