/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.core;

import org.eclipse.nab.core.Ntk;
import org.eclipse.nab.core.NtkManager;
import org.eclipse.ui.wizards.newresource.*;
//import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.MessageDialog;
//import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.resources.IFolder;
//import org.eclipse.core.resources.IFile;
import org.eclipse.nab.mwt.ab.core.CorePlugin;

import org.eclipse.core.resources.IContainer;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
//import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;

public class MwtImportWindowWizard extends BasicNewProjectResourceWizard {
    private static final String PAGE_TITLE1 = UIMessages.getString("MwtImportWindowWizardPage.pageTitle1"); //$NON-NLS-1$

    MwtImportWindowWizardPage page;    
    public MwtImportWindowWizard() {
        super();
        
    }
    public void addPages(){
//        super.addPages();
        page = new MwtImportWindowWizardPage(selection);
        addPage(page);
        setWindowTitle(PAGE_TITLE1);
    }

    public boolean performFinish() {
        try{
            NtkManager.getNtkContext().lock();
        }catch(Exception e){
            System.err.println("MwtMenuOpenWindow.run e="+e);
            return false;
        }
        try{
            String dirName = page.getFolderName();
            String winName = page.getFileName();
            
            if(winName == null || winName.equals("")) {
            } else { 
            //if (ret == Mwt.WS_DIALOG_OK){ 
              //WSCvariant dname = Mwt.WSGIappFileSelect().getProperty("dirName");
              //WSCvariant fname = Mwt.WSGIappFileSelect().getProperty("fileName");

              //MwtManage.setProjectRootPath(dname.getCharPtr());
              //MwtManage.setProjectRootPath(dirName);
              //WSCbase win = Mwt.WSGFreadWinFile(dname.getCharPtr(),
              //                                   fname.getCharPtr(),Mwt.WS_EN_DEFAULT);
              long win = NtkManager.getNtkInstanceManager().readInstanceDataFile(dirName,winName,Ntk.NTK_EN_DEFAULT);
              if (win != 0){
                NtkManager.getNtkContext().execEventProc("ve-prop-instance-selected");
                NtkManager.getNtkContext().execEventProc("ve-instance-updated");
              }
            }
        }catch(Exception e){
          System.err.println("MwtMenuOpenProject.run exeption="+e);
        }finally{
          NtkManager.getNtkContext().unlock();
        }

        
        
        
        return true;
    }

}
