/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.view;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
//import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;

import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.SWT;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.nab.core.INtkContext;
import org.eclipse.nab.core.INtkInstanceManager;
import org.eclipse.nab.core.INtkProjectManager;
import org.eclipse.nab.core.Ntk;
import org.eclipse.nab.core.NtkManager;
import org.eclipse.nab.mwt.ab.core.MwtNewWindowWizard;
import org.eclipse.nab.mwt.ab.core.UIMessages;

public class MwtInstanceTreeView extends ViewPart {
    private static final String DELETE_DIALOG_TITLE1 = UIMessages.getString("MwtInstanceTreeView.deleteDialogTitle1"); //$NON-NLS-1$
    private static final String DELETE_DIALOG_TITLE2 = UIMessages.getString("MwtInstanceTreeView.deleteDialogTitle2"); //$NON-NLS-1$
    private static final String DELETE_MENU_TITLE = UIMessages.getString("MwtInstanceTreeView.deleteMenuTitle"); //$NON-NLS-1$
    private static final String PASTE_MENU_TITLE = UIMessages.getString("MwtInstanceTreeView.pasteMenuTitle"); //$NON-NLS-1$
    private static final String COPY_MENU_TITLE = UIMessages.getString("MwtInstanceTreeView.copyMenuTitle"); //$NON-NLS-1$
//    private static final String CREATE_MENU_TITLE = UIMessages.getString("MwtInstanceTreeView.createMenuTitle"); //$NON-NLS-1$
    private static final String DISPLAY_MENU_TITLE = UIMessages.getString("MwtInstanceTreeView.displayMenuTitle"); //$NON-NLS-1$
    private static final String DISMISS_MENU_TITLE = UIMessages.getString("MwtInstanceTreeView.dismissMenuTitle"); //$NON-NLS-1$
    private static final String SAVE_MENU_TITLE = UIMessages.getString("MwtInstanceTreeView.saveMenuTitle"); //$NON-NLS-1$
    private static final String ERR_TITLE1 = UIMessages.getString("MwtInstanceTreeView.errorMessageTitle1"); //$NON-NLS-1$
    private static final String ERR_TITLE2 = UIMessages.getString("MwtInstanceTreeView.errorMessageTitle2"); //$NON-NLS-1$
    private static final String dBtn_001 = UIMessages.getString("Common.dialogOk"); //$NON-NLS-1$
    private static final String dBtn_002 = UIMessages.getString("Common.dialogCancel"); //$NON-NLS-1$
    private static final String dBtn_DELALL = UIMessages.getString("Common.dialogDelAll"); //$NON-NLS-1$

    
	private TreeViewer viewer = null;
	//private DrillDownAdapter drillDownAdapter = null;   
    private Action createAction = null;
    private Action displayAction = null;
    private Action dismissAction = null;
	private Action saveAction = null;
//    private Action searchAction = null;
//    private Action compileAction = null;
//    private Action registerAction = null;
    private Action copyAction = null;
    private Action pasteAction = null;
    private Action deleteAction = null;
    private Action singleClickAction = null;
//    private StructuredSelection keepSelection = null;
    private ArrayList copyList = null;
    private ArrayList deleteList = null;
    private List selectionList = null;
    private int property_x = 0;
    private int property_y = 20;
    
    private long proc1;
    private long proc2;
    
    TreeParent selectedItem = null;
    TreeParent rootTree = null;

    String selectedInstanceName ="";
    
	class TreeObject implements IAdaptable {
		private TreeParent parent;
		private String instance_name;
        private long nest_level;
        private long instance_id;
        private int instance_type;
        
		public TreeObject(String name) {
			this.instance_name = name;
		}
		public void setParent(TreeParent parent) {
			this.parent = parent;
		}
		public TreeParent getParent() {
			return parent;
		}
		public String toString() {
			return getInstanceName();
		}
		public Object getAdapter(Class key) {
			return null;
		}
        public void setLevel(long value) {
            nest_level = value;
        }
        public long getLevel() {
            return nest_level;
        }
        public void setInstanceName(String value) {
            instance_name = value;
        }
        public String getInstanceName() {
            return instance_name;
        }
        public void setInstanceId(long value) {
            instance_id = value;
        }
        public long getInstanceId() {
            return instance_id;
        }
        public void setInstanceType(int value) {
            instance_type = value;
        }
        public int getInstanceType() {
            return instance_type;
        }
        public TreeObject getInstanceById(long id){
            if(getInstanceId() == id){
                return this;
            }else{
                return null;
            }
        }
	}
	
	class TreeParent extends TreeObject {
		private ArrayList children;
       
     	public TreeParent(String name) {
			super(name);
			children = new ArrayList();
		}
		public void addChild(TreeObject child) {
			children.add(child);
			child.setParent(this);
		}
		public void removeChild(TreeObject child) {
			children.remove(child);
			child.setParent(null);
		}
		public TreeObject [] getChildren() {
			return (TreeObject [])children.toArray(new TreeObject[children.size()]);
		}
		public boolean hasChildren() {
			return (children.size() > 0);
		}
        public TreeObject getInstanceById(long id){
            TreeObject ret = super.getInstanceById(id);
            if(ret == null){
                int num = children.size();
                for(int i =0; i < num;i++){
                    TreeObject child = (TreeObject)children.get(i);
                    ret = child.getInstanceById(id);
                    if(ret != null){
                        return ret;
                    }
                }
            }
            return ret;
        }
	}

	class ViewContentProvider implements IStructuredContentProvider, 
										   ITreeContentProvider {
		private TreeParent invisibleRoot;

		public void inputChanged(Viewer v, Object oldInput, Object newInput) {
		}
		public void dispose() {
		}
		public Object[] getElements(Object parent) {
			if (parent.equals(getViewSite())) {
				if (invisibleRoot==null){
                    initialize();
                }
				return getChildren(invisibleRoot);
			}
			return getChildren(parent);
		}
		public Object getParent(Object child) {
			if (child instanceof TreeObject) {
				return ((TreeObject)child).getParent();
			}
			return null;
		}
		public Object [] getChildren(Object parent) {
			if (parent instanceof TreeParent) {
				return ((TreeParent)parent).getChildren();
			}
			return new Object[0];
		}
		public boolean hasChildren(Object parent) {
			if (parent instanceof TreeParent)
				return ((TreeParent)parent).hasChildren();
			return false;
		}

		private void initialize() {
		}
	}
	class ViewLabelProvider extends LabelProvider {

		public String getText(Object obj) {
            return obj.toString();
		}
        
        public Image getImage(Object obj) {
        String imageKey = ISharedImages.IMG_OBJ_ELEMENT;
        int itype = ((TreeParent) obj).getInstanceType();
            if ((itype & Ntk.NTK_TYPE_MANAGER) == 0 ){
                imageKey = ISharedImages.IMG_OBJ_FILE;
                return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
            }else{
                imageKey = ISharedImages.IMG_OBJ_FOLDER;
                return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
            }
        }
	}
    
	class NameSorter extends ViewerSorter {
	}
    
 
	/**
	 * The constructor.
	 */
	public MwtInstanceTreeView() {
        if (NtkManager.isInitialized() == false){
            NtkManager.ntkInitialize();
        }
        proc1 = NtkManager.getEventCallbackManager().addProc("ve-instance-updated",this,"asyncUpdateTree",null);
        proc2 = NtkManager.getEventCallbackManager().addProc("ve-prop-instance-selected",this,"asyncUpdateSelection",null);
	}
    public void dispose() {
        NtkManager.getEventCallbackManager().delProc(proc1);
        NtkManager.getEventCallbackManager().delProc(proc2);
        super.dispose();
    }
    public void asyncUpdateTree(Object param){
        Display display = viewer.getControl().getDisplay();
        display.asyncExec(new Runnable() {
          public void run(){
              updateTree();
          }
        });
    }
    
    public void updateTree(){
        rootTree = getMwtInstanceTree();
        if (rootTree.getChildren().length == 0){
            viewer.setInput(null);
            return;
        }

        try{
            Object tree = viewer.getInput();
            if (tree != null){
                try{
                    TreeParent tree_org = (TreeParent)tree;
                    _updateTree(rootTree,tree_org);
                    viewer.refresh();
                }catch(Exception e){
                    viewer.setInput(rootTree);
                }
            }else{
                viewer.setInput(rootTree);
            }
        }catch(Exception e){
            System.err.println("MwtInstanceTreeView updateTree(): " + e.getMessage());
            System.err.println("MwtInstanceTreeView updateTree(): " + e.toString());
        }
    }
    public void _updateTree(TreeParent parent,TreeParent parent_org){
        TreeObject[] children = parent.getChildren();
        int i;
        int num = children.length;
        for(i=0; i<num; i++){
            boolean found = false;
            TreeObject[] children_org = parent_org.getChildren();
            int j;
            int jnum =  children_org.length;
            for(j=0; j<jnum; j++){
                if (children[i].instance_id == children_org[j].instance_id){
                    children_org[j].instance_name = children[i].instance_name;
                    viewer.refresh(children_org[j]);
                    found = true;
                    TreeParent parent1 = (TreeParent)children[i];
                    TreeParent parent2 = (TreeParent)children_org[j];
                    if (parent1 != null && parent2 != null){
                        _updateTree(parent1,parent2);
                    }
                    break;
                }
            }
            if (found == false){
                /*
                TreeParent new_tree = new TreeParent(children[i].instance_name);
                new_tree.setInstanceId(children[i].instance_id);
                new_tree.setLevel(children[i].getLevel());
                new_tree.setInstanceType(children[i].instance_type);
                parent_org.addChild(new_tree);
                viewer.add(parent_org,new_tree);
                */
                parent_org.addChild(children[i]);
                viewer.add(parent_org,children[i]);
//                viewer.refresh(parent_org);
            }
        }
        children = parent_org.getChildren();
        num = children.length;
        for(i=0; i<num; i++){
            boolean found = false;
            TreeObject[] children_new = parent.getChildren();
            int j;
            int jnum = children_new.length;
            for(j=0; j<jnum; j++){
                if (children[i].instance_id == children_new[j].instance_id){
                    found = true;
                    break;
                }
            }
            if (found == false){
                parent_org.removeChild(children[i]);
                viewer.remove(children[i]);
            }
        }
    }
    public void asyncUpdateSelection(Object param){
        Display display = viewer.getControl().getDisplay();
        display.asyncExec(new Runnable() {
          public void run(){
              updateSelection();
          }
        });
    }
    public void _updateSelection(TreeItem parent,TreeParent target){
        int i;
        TreeItem[] items = parent.getItems();
        if (items == null){
            return;
        }
        int num = items.length;
        for(i=0; i<num; i++){
            TreeItem item = items[i];
            TreeParent tp = (TreeParent)item.getData();
            if (tp == null){
                continue;
            }
            if (target.getInstanceId() == tp.getInstanceId()){
                TreeItem[] selection = new TreeItem[1];
                selection[0] = item;
                viewer.getTree().setSelection(selection);
                selectedItem = target;
                return;
            }
            _updateSelection(item,target);
        }
    }
    public void updateSelection(){
        try{
            viewer.refresh();
            long mwtId = findSelectedMwtId();
            if (mwtId != 0){
                TreeParent ret = (TreeParent)rootTree.getInstanceById(mwtId);
                if (ret == null){
                    return;
                }
                if (selectedItem != null && ret.getInstanceId() == selectedItem.getInstanceId()){
                    return;
                }
                
                TreeItem[] items = viewer.getTree().getItems();
                if (items == null){
                    return;
                }

                int i;
                int num = items.length;
                for(i=0; i<num; i++){
                    TreeItem item = items[i];
                    TreeParent tp = (TreeParent)item.getData();
                    if (tp == null){
                        continue;
                    }
                    if (ret.getInstanceId() == tp.getInstanceId()){
                        TreeItem[] selection = new TreeItem[1];
                        selection[0] = item;
                        viewer.getTree().setSelection(selection);
                        selectedItem = ret;
                        return;
                    }
                    _updateSelection(item,ret);
                }
                selectedItem = ret;
            }
        }catch(Exception e){
            System.err.println("MwtInstanceTreeView updateSelection(): " + e.getMessage());
            System.err.println("MwtInstanceTreeView updateSelection(): " + e.toString());
        }
    }
    
    public void selectExecute(){
        IStructuredSelection selection = (StructuredSelection)viewer.getSelection();
        try{
            Object obj = selection.getFirstElement();
            TreeParent selected = (TreeParent)selection.getFirstElement();
            if (selected == null){
                return;
            }
            long inst_id = selected.getInstanceId();
            INtkContext context = NtkManager.getNtkContext();
            context.lock();
            long selected_inst_id = 0;
            boolean exist = false;
            INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
            while(true){
                selected_inst_id = iman.getInstanceId(selected_inst_id,Ntk.NTK_NEXT_SELECTED_INSTANCE_ID,0);
                if (selected_inst_id == 0){
                    break;
                }
                if (selected_inst_id == inst_id){
                    exist = true;
                }
            }
            if (exist == false){
                if (iman.existInstance(inst_id) == true){
                    iman.setSelectedInstance(inst_id);
                }
            }
            context.unlock();
            selectedItem = selected;
            
        }catch(Exception e){
            System.err.println("MwtInstanceTreeView selectExecute(): " + e.getMessage());
            System.err.println("MwtInstanceTreeView selectExecute(): " + e.toString());
        }
    }
    private String selectTreeName(){
        TreeItem[] TreeItem = viewer.getTree().getSelection();
        String strName =TreeItem[0].toString();
        String selectName = strName.substring(strName.indexOf("{")+1,strName.indexOf("}"));
        return selectName;
    }
    
	/**
	 * This is a callback that will allow us
	 * to create the viewer and initialize it.
	 */
	public void createPartControl(Composite parent) {
		viewer = new TreeViewer(parent, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);
		//drillDownAdapter = new DrillDownAdapter(viewer);
		viewer.setContentProvider(new ViewContentProvider());
		viewer.setLabelProvider(new ViewLabelProvider());
		viewer.setSorter(new NameSorter());
		viewer.setInput(getViewSite());
		makeActions();
		hookContextMenu();
        hookSingleClickAction();
		contributeToActionBars();
        asyncUpdateTree(null);
	}

	private void hookContextMenu() {
		MenuManager menuMgr = new MenuManager("#PopupMenu");
		menuMgr.setRemoveAllWhenShown(true);
		menuMgr.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				MwtInstanceTreeView.this.fillContextMenu(manager);
			}
		});
		Menu menu = menuMgr.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(menuMgr, viewer);
	}

	private void contributeToActionBars() {
		IActionBars bars = getViewSite().getActionBars();
		fillLocalPullDown(bars.getMenuManager());
		fillLocalToolBar(bars.getToolBarManager());
	}

	private void fillLocalPullDown(IMenuManager manager) {
		manager.add(displayAction);
        manager.add(dismissAction);
		manager.add(saveAction);
//        manager.add(searchAction);
//        manager.add(compileAction);
//        manager.add(registerAction);
        manager.add(copyAction);
        manager.add(pasteAction);
        manager.add(deleteAction);
        manager.add(new Separator());
	}

	private void fillContextMenu(IMenuManager manager) {
		manager.add(displayAction);
        manager.add(dismissAction);
		manager.add(saveAction);
//        manager.add(searchAction);
//        manager.add(compileAction);
//        manager.add(registerAction);
        manager.add(copyAction);
        manager.add(pasteAction);
        manager.add(deleteAction);
		manager.add(new Separator());
		//drillDownAdapter.addNavigationActions(manager);
		manager.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS));
	}
	
	private void fillLocalToolBar(IToolBarManager manager) {
		manager.add(displayAction);
        manager.add(dismissAction);
		manager.add(saveAction);
//        manager.add(searchAction);
//        manager.add(compileAction);
//        manager.add(registerAction);
        manager.add(copyAction);
        manager.add(pasteAction);
        manager.add(deleteAction);
		manager.add(new Separator());
		//drillDownAdapter.addNavigationActions(manager);
	}

	private void makeActions() {
		displayAction = new Action() {
			public void run() {
                ISelection selection = viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                TreeObject Element = (TreeObject) obj;
                long val = Element.getInstanceId();
                final INtkContext context = NtkManager.getNtkContext();
                final INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
                try{
                    context.lock();
                }catch(Exception e){
                    System.err.println("MwtInstanceTreeView.displayAction e="+e);
                    return;
                }

                final long win = iman.getParentWindow(val);
                iman.setVisible(win,true);
                context.unlock();
			}
		};
		displayAction.setText(DISPLAY_MENU_TITLE);
		displayAction.setToolTipText(DISPLAY_MENU_TITLE);
		displayAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
        getImageDescriptor(ISharedImages.IMG_DEF_VIEW));
		
        viewer.addDoubleClickListener(new IDoubleClickListener() {
            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                TreeObject Element = (TreeObject) obj;
                long val = Element.getInstanceId();
                final INtkContext context = NtkManager.getNtkContext();
                final INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
                try{
                    context.lock();
                }catch(Exception e){
                    System.err.println("MwtInstanceTreeView.doubleClick e="+e);
                    return;
                }
                final long win = iman.getParentWindow(val);
                iman.setVisible(win,true);
                context.unlock();
            }
        });

        
        dismissAction = new Action() {
            public void run() {
                ISelection selection = viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                TreeObject Element = (TreeObject) obj;
                long val = Element.getInstanceId();
                INtkContext context = NtkManager.getNtkContext();
                INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
                try{
                    context.lock();
                }catch(Exception e){
                    System.err.println("MwtInstanceTreeView.dismissAction e="+e);
                    return;
                }
                long win = iman.getParentWindow(val);
                iman.setVisible(win,false);
                context.unlock();
            }
        };
        dismissAction.setText(DISMISS_MENU_TITLE);
        dismissAction.setToolTipText(DISMISS_MENU_TITLE);
        dismissAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
        getImageDescriptor(IDEInternalWorkbenchImages.IMG_ETOOL_DEF_PERSPECTIVE));
        
        
        saveAction = new Action() {
			public void run() {
                /*
                ISelection selection = viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                TreeObject Element = (TreeObject) obj;
                long val = Element.getInstanceId();
                if (val == 0){
                    System.err.println("MwtInstanceTreeView.saveAction instance=null..");
                    return;
                }
                INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
				while(true){
                    long parent = NtkManager.getNtkInstanceManager().getParent(val);
                    if (parent == 0){
                        break;
                    }
                    val = parent;
                }
                INtkProjectManager pman = NtkManager.getNtkProjectManager();
                long prj = pman.getCurrentProject();
                Long enc = Long.valueOf(pman.getProjectData(prj,"#ENCODING",Ntk.NTK_EN_DEFAULT));
                iman.saveInstanceDataFile(pman.getCurrentProjectFullPath(),val, enc.intValue());
                */
                NtkManager.getNtkProjectManager().createCurrentNtkProjectSources();
                NtkManager.getNtkProjectManager().saveCurrentNtkProject();

			}
		};
		saveAction.setText(SAVE_MENU_TITLE);
		saveAction.setToolTipText(SAVE_MENU_TITLE);
		saveAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
				getImageDescriptor(IDEInternalWorkbenchImages.IMG_ETOOL_SAVE_EDIT));        
        
//        searchAction = new Action() {
//            public void run() {
//                showMessage("Action 3 executed");
//            }
//        };
//        searchAction.setText("Search");
//        searchAction.setToolTipText("Search");
//        searchAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
//                getImageDescriptor(ISharedImages.IMG_OBJS_WARN_TSK));
        
//        compileAction = new Action() {
//            public void run() {
//                showMessage("Action 4 executed");
//            }
//        };
//        compileAction.setText("Compile");
//        compileAction.setToolTipText("Compile");
//        compileAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
//                getImageDescriptor(ISharedImages.IMG_OBJS_ERROR_TSK));
        
//        registerAction = new Action() {
//            public void run() {
//                showMessage("Action 5 executed");
//            }
//        };
//        registerAction.setText("Remove from project");
//        registerAction.setToolTipText("Remove from project");
//        registerAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
//                getImageDescriptor(ISharedImages.IMG_TOOL_FORWARD));
        
        copyAction = new Action() {
            public void run() {
                if (copyList == null){
                    copyList = new ArrayList();
                }
                copyList.clear();
                ISelection selection = viewer.getSelection();
                selectionList = ((IStructuredSelection)selection).toList();
                INtkContext context = NtkManager.getNtkContext();
                INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
                for(int i=0;i<selectionList.size();i++){
                    Object obj = selectionList.get(i);
                    TreeObject Element = (TreeObject) obj;
                    long val = Element.getInstanceId();
                    try{
                        context.lock();
                    }catch(Exception e){
                        System.err.println("MwtInstanceTreeView.copyAction e="+e);
                        return;
                    }
                    if (iman.existInstance(val) == true){
                        copyList.add(new Long(val));
                        iman.setCopyList(copyList);
                    }
                    context.unlock();
                }
            }
        };
        copyAction.setText(COPY_MENU_TITLE);
        copyAction.setToolTipText(COPY_MENU_TITLE);
        copyAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
                getImageDescriptor(ISharedImages.IMG_TOOL_COPY));
        
        pasteAction = new Action() {
            public void run() {
                INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
                if (iman.getCopyList() == null || (iman.getCopyList() != null && iman.getCopyList().size()<0)){
                        MessageDialog dlg = new MessageDialog(
                                viewer.getControl().getShell(), "", null, ERR_TITLE1,
                                MessageDialog.NONE, new String[] { "OK"}, 0);
                        dlg.open();

                        return;
                }
                ISelection selection = viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                TreeObject Element = (TreeObject) obj;
                long val = Element.getInstanceId();
//                boolean updated = iman.pasgeInstance(val);
               
                INtkContext context = NtkManager.getNtkContext();
                boolean err_fl = false;
                try{
                    context.lock();
                }catch(Exception e){
                    System.err.println("MwtInstanceTreeView.posteAction e="+e);
                    return;
                }
                boolean iret = iman.existInstance(val);
                if (iret == true){
                    if (iman.getCopyList() != null){
                        for(int i=0;i<iman.getCopyList().size();i++){
                            Long tmp = (Long)iman.getCopyList().get(i);
                            long cpinst = tmp.longValue();

                            int ret = iman.pasteInstance(val,cpinst);
                            if(ret == 0){
                                cpinst = iman.getInstanceId(Ntk.NTK_ROOT_INSTANCE_ID,Ntk.NTK_NEXT_SELECTED_INSTANCE_ID,0);
                                int instWidthSize = iman.getProperty(val,"width");
                                int instHeightSize = iman.getProperty(val,"height");

                                if (iman.existProperty(val,"workWidth") == true){
                                    instWidthSize = iman.getProperty(val,"workWidth");
                                }
                                if (iman.existProperty(val,"workHeight") == true){
                                    instHeightSize = iman.getProperty(val,"workHeight");
                                }
                                int pasteWidthSize = iman.getProperty(cpinst,"width");
                                int pasteHeightSize = iman.getProperty(cpinst,"height");
                                
//                                int inst_x_coordinate = iman.getProperty(val,"x");
//                                int inst_y_coordinate = iman.getProperty(val,"y");
                                
//                                int paste_x_coordinate = iman.getProperty(cpinst,"x");
//                                int paste_y_coordinate = iman.getProperty(cpinst,"y");
                                
                                if(instWidthSize < pasteWidthSize){
                                    iman.setProperty(cpinst,"width",instWidthSize);
                                    iman.setProperty(cpinst,"x",property_x);
                                    iman.setProperty(cpinst,"y",property_y);
                                }
                                
                                if(instHeightSize < pasteHeightSize) {
                                    iman.setProperty(cpinst,"height",instHeightSize);
                                    iman.setProperty(cpinst,"x",property_x);
                                    iman.setProperty(cpinst,"y",property_y);
                                }
                            }else{
                                err_fl = true;
                                break;
                            }
                        }
                    }
                    iman.getCopyList().clear();
                }
                context.unlock();
                if (err_fl != false){
                    MessageDialog dlg = new MessageDialog(
                            viewer.getControl().getShell(), "", null, ERR_TITLE2,
                            MessageDialog.NONE, new String[] { "OK"}, 0);
                    dlg.open();
                }
                if (iret == true){
                    NtkManager.getEventCallbackManager().execProc("ve-instance-updated");
                }else{
                    MessageDialog dlg = new MessageDialog(
                            viewer.getControl().getShell(), "", null, ERR_TITLE2,
                            MessageDialog.NONE, new String[] { "OK"}, 0);
                    dlg.open();
                }
            }
        };
        pasteAction.setText(PASTE_MENU_TITLE);
        pasteAction.setToolTipText(PASTE_MENU_TITLE);
        pasteAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
                getImageDescriptor(ISharedImages.IMG_TOOL_PASTE));
        
        deleteAction = new Action() {
            public void run() {
                if (deleteList == null){
                    deleteList = new ArrayList();
                }
                ISelection selection = viewer.getSelection();
                selectionList = ((IStructuredSelection)selection).toList();
                INtkContext context = NtkManager.getNtkContext();
                INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
                try{
                    context.lock();
                }catch(Exception e){
                    System.err.println("MwtInstanceTreeView.deleteAction e="+e);
                    return;
                }
                for(int i=0;i<selectionList.size();i++){
                    Object obj = selectionList.get(i);
                    TreeObject Element = (TreeObject) obj;
                    long val = Element.getInstanceId();
                    if (iman.existInstance(val) == true){
                        deleteList.add(new Long(val));
                        iman.setDeleteList(deleteList);
                    }
                }
                context.unlock();
                boolean delall = false;
                for(int j=0;j<deleteList.size();j++){
                    try{
                        context.lock();
                    }catch(Exception e){
                        System.err.println("MwtInstanceTreeView.deleteAction e="+e);
                        return;
                    }
                    Long temp = (Long)iman.getDeleteList().get(j);
                    long inst = temp.longValue();
                    if (iman.existInstance(inst) == false){
                        context.unlock();
                        continue;
                    }
                    String name = iman.getProperty(inst,"name",Ntk.NTK_EN_DEFAULT);
                    context.unlock();
                    
                    if (delall == true){
                        try{
                            context.lock();
                        }catch(Exception e){
                            System.err.println("MwtInstanceTreeView.deleteAction e="+e);
                            return;
                        }
                        long parent = iman.getParent(inst);
                        iman.deleteInstance(inst);
                        if (iman.existInstance(parent) == true){
                            iman.redraw(parent);
                        }
                        context.unlock();
                        continue;
                    }
                    MessageDialog dlg;
                    if (deleteList.size() == 1){
                        dlg = new MessageDialog(
                            viewer.getControl().getShell(), "", null, DELETE_DIALOG_TITLE1 + name + DELETE_DIALOG_TITLE2,
                            MessageDialog.NONE, new String[] { dBtn_001, dBtn_002, }, 0);
                        if (dlg.open() == 0) {
                            try{
                                context.lock();
                            }catch(Exception e){
                                System.err.println("MwtInstanceTreeView.deleteAction e="+e);
                                return;
                            }
                            long parent = iman.getParent(inst);
                            iman.deleteInstance(inst);
                            if (iman.existInstance(parent) == true){
                                iman.redraw(parent);
                            }
                            context.unlock();
                        }
                    }else{
                        dlg = new MessageDialog(
                                viewer.getControl().getShell(), "", null, DELETE_DIALOG_TITLE1 + name + DELETE_DIALOG_TITLE2,
                                MessageDialog.NONE, new String[] { dBtn_001, dBtn_DELALL,dBtn_002, }, 0);
                        int res = dlg.open();
                        if (res == 0 || res == 1) {
                            if (res == 1){
                                delall = true;
                            }
                            try{
                                context.lock();
                            }catch(Exception e){
                                System.err.println("MwtInstanceTreeView.deleteAction e="+e);
                                return;
                            }
                            long parent = iman.getParent(inst);
                            iman.deleteInstance(inst);
                            if (iman.existInstance(parent) == true){
                                iman.redraw(parent);
                            }
                            context.unlock();
                        }
                    }
                }
                iman.getDeleteList().clear();
                NtkManager.getEventCallbackManager().execProc("ve-instance-updated");
            }
        };
        deleteAction.setText(DELETE_MENU_TITLE);
        deleteAction.setToolTipText(DELETE_MENU_TITLE);
        deleteAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
                getImageDescriptor(ISharedImages.IMG_TOOL_DELETE));
        
        singleClickAction = new Action() {
            public void run() {
                selectExecute();
            }
        };
	}
    
    private void hookSingleClickAction() {
        viewer.addPostSelectionChangedListener(new ISelectionChangedListener() {
            public void selectionChanged(SelectionChangedEvent event) {
                singleClickAction.run();
            }
        });
    }
    
	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
		viewer.getControl().setFocus();
	}

    private TreeParent getMwtInstanceTree(){
        INtkContext context = NtkManager.getNtkContext();
        try{
            context.lock();
        }catch(Exception e){
            System.err.println("MwtInstanceTreeView.getMwtInstanceTree e="+e);
            return null;
        }
        long child_id = Ntk.NTK_ROOT_INSTANCE_ID;
        long nest_level = 0;
        TreeParent root = new TreeParent("");
        _getMwtInstanceTree(child_id, nest_level, root);
        context.unlock();
        return root;
    }
    
    private void _getMwtInstanceTree(long parent_id, long nest_level, TreeParent tree_parent){
        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
        nest_level = nest_level + 1;
        long child_id = Ntk.NTK_ROOT_INSTANCE_ID;
        while(true){
            long child_next = iman.getInstanceId( parent_id, Ntk.NTK_NEXT_CHILD_INSTANCE_ID, child_id);
            if (child_next == 0){
              break;
            }
            String inst_name = iman.getInstanceData(child_next,Ntk.NTK_INSTANCE_NAME, 0, Ntk.NTK_EN_UTF8);
            long inst_id = child_next;
            long inst_level = nest_level;
            child_id = child_next;
            if (inst_level != 0){           
                TreeParent new_tree = new TreeParent(inst_name);
                _getMwtInstanceTree(child_next,inst_level,new_tree);
                ((TreeParent) new_tree).setInstanceId(inst_id);
                ((TreeParent) new_tree).setLevel(inst_level);
                int inst_type = iman.getInstanceType(inst_id);
                ((TreeParent) new_tree).setInstanceType(inst_type);
                tree_parent.addChild(new_tree);
            }
        }
    }
    
    private long findSelectedMwtId(){
        INtkContext context = NtkManager.getNtkContext();
        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
        try{
            context.lock();
        }catch(Exception e){
            System.err.println("MwtInstanceTreeView.deleteAction e="+e);
            return 0;
        }
        long selected_id = Ntk.NTK_ROOT_INSTANCE_ID;
        long count = 0;
        while(true){
            long selected_next = iman.getInstanceId( selected_id, Ntk.NTK_NEXT_SELECTED_INSTANCE_ID, 0);
            if (selected_next == 0){
                break;
            }
            count++;
            selected_id = selected_next;
        }
        if (count > 1 || count == 0){
            context.unlock();
            return 0;
        }
        context.unlock();
        return selected_id;
    }
}
