/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.core;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.nab.core.INtkInstanceManager;
import org.eclipse.nab.core.Ntk;
import org.eclipse.nab.core.NtkManager;



public class MwtNewWindowWizard extends Wizard implements INewWizard {
    private static final String dTitle_001 = UIMessages.getString("MwtNewWindowWizard.message1"); //$NON-NLS-1$
    private static final String dMes_001 = UIMessages.getString("MwtNewWindowWizard.message2"); //$NON-NLS-1$
    private static final String dBtn_001 = UIMessages.getString("Common.dialogOk"); //$NON-NLS-1$
    private static final String dBtn_002 = UIMessages.getString("Common.dialogCancel"); //$NON-NLS-1$
    private static final String err_mes1 = UIMessages.getString("MwtNewWindowWizard.errorMessage1"); //$NON-NLS-1$
    private static final String err_mes2 = UIMessages.getString("MwtNewWindowWizard.errorMessage2"); //$NON-NLS-1$
    private static final String invalid_inst_name1 = UIMessages.getString("MwtNewWindowWizard.invalidInstanceNameMessage1"); //$NON-NLS-1$
    private static final String invalid_inst_name2 = UIMessages.getString("MwtNewWindowWizard.invalidInstanceNameMessage2"); //$NON-NLS-1$
    private static final String invalid_inst_name3 = UIMessages.getString("MwtNewWindowWizard.invalidInstanceNameMessage3"); //$NON-NLS-1$
    private static final String page_title1 = UIMessages.getString("MwtNewWindowWizardPage.pageTitle1"); //$NON-NLS-1$

    
	private MwtNewWindowWizardPage page;
	private ISelection selection;

	public MwtNewWindowWizard() {
		super();
        if (NtkManager.isInitialized() == false){
            NtkManager.ntkInitialize();
        }

		setNeedsProgressMonitor(true);
	}
	
	public void addPages() {
		page = new MwtNewWindowWizardPage(selection);
		addPage(page);
        setWindowTitle(page_title1);

	}

	/**
	 * This method is called when 'Finish' button is pressed in
	 * the wizard. We will create an operation and run it
	 * using wizard as execution context.
	 */
	public boolean performFinish() {
		final String className = page.getWindowClassName().trim();
		final String windowName = page.getWindowName().trim();
        final int winType = page.getWindowType();
        
        if(windowName == null || windowName.equals("")) {
            MessageDialog dlg = new MessageDialog(
                    page.getShell(),dTitle_001, null, dMes_001,
                    MessageDialog.WARNING, new String[] { dBtn_001, dBtn_002 }, 0);
            dlg.open();
            return false;
        }

        boolean resflg = Utils.checkSpace(windowName);
        if(!resflg) {
            openErrorDialog(invalid_inst_name1);
            return false;
        }
        try{
            NtkManager.getNtkContext().lock();
        }catch(Exception e){
            System.err.println("MwtNewWindowWizard.performFinish e="+e);
            return false;
        }

        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
        
        long check = iman.checkInstanceName(0,windowName);

        if(check != 0) {
            NtkManager.getNtkContext().unlock();
            openErrorDialog(invalid_inst_name2);
            return false;
        }
        if (windowName.indexOf("[") >-1){
            NtkManager.getNtkContext().unlock();
            openErrorDialog(invalid_inst_name3);
            return false;
        }
        
        long inst = iman.getNewInstance(className,windowName,0);

        if (inst == 0){
            openErrorDialog(err_mes1 + " " + className + err_mes2);
        }
        
        iman.setProperty(inst,"x",0);
        iman.setProperty(inst,"y",0);
        iman.setProperty(inst,"width",400);
        iman.setProperty(inst,"height",400);
        iman.setupInstance(inst);
        iman.setUserLongData(inst,Ntk.NTK_VISIBLE,1);
        iman.setUserLongData(inst,Ntk.NTK_REGISTERED,1);
        if (winType == 0){
            iman.setUserLongData(inst,Ntk.NTK_CLASS_DEF,0);
            iman.setUserLongData(inst,Ntk.NTK_STORE_DEF,0);
        }else if (winType == 1){
            iman.setUserLongData(inst,Ntk.NTK_CLASS_DEF,1);
            iman.setUserLongData(inst,Ntk.NTK_STORE_DEF,0);
        }else if (winType == 2){
            iman.setUserLongData(inst,Ntk.NTK_CLASS_DEF,0);
            iman.setUserLongData(inst,Ntk.NTK_STORE_DEF,1);
        }

        NtkManager.getNtkInstanceManager().setInstanceId(Ntk.NTK_SET_ROOT_INSTANCE,inst);
        NtkManager.getNtkContext().unlock();
		return true;
	}

    private void openErrorDialog(String data){
        MessageDialog dlg = new MessageDialog(
                page.getShell(), dTitle_001, null, dMes_001 + data,
                MessageDialog.WARNING, new String[] { dBtn_001, dBtn_002 }, 0);
        dlg.open();
    }

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.selection = selection;
	}
}
