/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.view;

import java.util.ArrayList;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor.LayoutData;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.swt.SWT;

import org.eclipse.nab.core.INtkContext;
import org.eclipse.nab.core.INtkInstanceManager;
import org.eclipse.nab.core.Ntk;
import org.eclipse.nab.core.NtkManager;
import org.eclipse.nab.mwt.ab.core.UIMessages;
import org.eclipse.nab.mwt.ab.core.Utils;

public class MwtInstancePropertyView extends ViewPart{
    private static final String dMes_001 = UIMessages.getString("MwtInstancePropertyView.dialogMessage1"); //$NON-NLS-1$
    private static final String dMes_002 = UIMessages.getString("MwtInstancePropertyView.dialogMessage2"); //$NON-NLS-1$
    private static final String dMes_003 = UIMessages.getString("MwtInstancePropertyView.dialogMessage3"); //$NON-NLS-1$
    private static final String dMes_004 = UIMessages.getString("MwtInstancePropertyView.dialogMessage4"); //$NON-NLS-1$
    private static final String dMes_005 = UIMessages.getString("MwtInstancePropertyView.dialogMessage5"); //$NON-NLS-1$
    private static final String dTitle = UIMessages.getString("Common.warningTitle"); //$NON-NLS-1$
    private static final String dBtn_001 = UIMessages.getString("Common.dialogOk"); //$NON-NLS-1$
    private static final String dBtn_002 = UIMessages.getString("Common.dialogCancel"); //$NON-NLS-1$
    private static final String UNDO_MENU_TITLE = UIMessages.getString("MwtInstancePropertyView.undoMenuTitle"); //$NON-NLS-1$
    private static final String dMes_browse = UIMessages.getString("Common.browse"); //$NON-NLS-1$

    private int widgetHSize = 25;
    private int labelSize = 0;
    private int labelXLocation = 5;
    private int comboSize = 0;
    private int comboXLocation = 0;
    private int textSize = 0;
    private int textXLocation = 0;
    private int colorInputFieldSize = 0;
    private int colorBtnXLocation = 0;
    private int colorBtnSize = 0;
    private int selectionInputFieldSize = 0;
    private int selectionBtnXLocation = 0;
    private int selectionBtnSize = 60;
     
    private String comboBoxOrTextType = "0";
    private String colorType = new Integer(Ntk.NTK_PROPERTY_TYPE_COLOR).toString();
    private String pixmapType = new Integer(Ntk.NTK_PROPERTY_TYPE_PIXMAP).toString();
    private String fileSelectType = new Integer(Ntk.NTK_PROPERTY_TYPE_FILE_SELECT).toString();
    
    private int TYPE_NONE = 0;
    private int TYPE_COMBO = 1;
    private int TYPE_PIXMAP = 2;
    private int TYPE_COLOR = 3;
    private int TYPE_FILE = 4;
    private int TYPE_TEXT = 5;
    
    /** PropertyData save array  */
    private ArrayList propList = new ArrayList();
    /** wedget  */
    private Canvas baseCanvas = null;
    private Canvas mainCanvas = null;
    /** Event action */
//    private Action reloadAction = null;
    /** target Instance Id */
    private long targetId = 0;
    private String targetName = null;
    /** wedget main color */
    private Color whiteColor = new Color(null, 255, 255, 255);
    
    private boolean procFlag = false;
    //private boolean reloadFlag = false;
    private boolean lockFlag = false;
    private MwtPropertyData selectedProperty = null;
    private Action undoAction = null;
    private Action undo_action = null;

    private long proc1;
    private long proc2;
    private long proc3;
    private long proc4;
    private long proc5;

    public class MwtPropertyData {

        private Label propTitle = null;
        private String propName = null;
//        private String propType = null;
        private Text propText = null;
        private Combo propCombo = null;
        private Button propFileButton = null;
        private Button propColorButton = null;
        private ArrayList propComboItem = null;
        public int prop_type=0;
        public int prop_no = 0;
        public boolean last_one = false;
        
        

        public MwtPropertyData() {
            propTitle = new Label(mainCanvas, 0);
            
            propCombo = new Combo(mainCanvas, SWT.READ_ONLY);
            setComboFocusAction(propCombo);

            propText = new Text(mainCanvas, SWT.BORDER);
            setCommonInputAction(propText);

            propFileButton = new Button(mainCanvas, 0);
            setFileSelectAction(propFileButton);
            propFileButton.setText(dMes_browse);
            
            propColorButton = new Button(mainCanvas, 0);
            setColorSelectAction(propColorButton);
            
            prop_type = TYPE_NONE;
            propCombo.setVisible(false);
            propText.setVisible(false);
            propFileButton.setVisible(false);
            propColorButton.setVisible(false);
            propTitle.setVisible(false);
            
            propText.addTraverseListener(new TraverseListener() {
                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == SWT.TRAVERSE_TAB_PREVIOUS && prop_no == 0){
                        e.doit = false;
                    }
                    if (e.detail == SWT.TRAVERSE_TAB_NEXT && last_one == true){
                        e.doit = false;
                    }
                }
            });
            propCombo.addTraverseListener(new TraverseListener() {
                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == SWT.TRAVERSE_TAB_PREVIOUS && prop_no == 0){
                        e.doit = false;
                    }
                    if (e.detail == SWT.TRAVERSE_TAB_NEXT && last_one == true){
                        e.doit = false;
                    }
                }
            });
            propFileButton.addTraverseListener(new TraverseListener() {
                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == SWT.TRAVERSE_TAB_PREVIOUS && prop_no == 0){
                        e.doit = false;
                    }
                    if (e.detail == SWT.TRAVERSE_TAB_NEXT && last_one == true){
                        e.doit = false;
                    }
                }
            });
            propColorButton.addTraverseListener(new TraverseListener() {
                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == SWT.TRAVERSE_TAB_PREVIOUS && prop_no == 0){
                        e.doit = false;
                    }
                    if (e.detail == SWT.TRAVERSE_TAB_NEXT && last_one == true){
                        e.doit = false;
                    }
                }
            });
        }
        public void update(){
            if (prop_type == TYPE_NONE){
                propCombo.setVisible(false);
                propText.setVisible(false);
                propFileButton.setVisible(false);
                propColorButton.setVisible(false);
                propTitle.setVisible(false);
            }else if (prop_type == TYPE_TEXT){
                propCombo.setVisible(false);
                propText.setVisible(true);
                propFileButton.setVisible(false);
                propColorButton.setVisible(false);
                propTitle.setVisible(true);
            }else if (prop_type == TYPE_COMBO){
                propCombo.setVisible(true);
                propText.setVisible(false);
                propFileButton.setVisible(false);
                propColorButton.setVisible(false);
                propTitle.setVisible(true);
            }else if (prop_type == TYPE_PIXMAP){
                propCombo.setVisible(false);
                propText.setVisible(true);
                propFileButton.setVisible(true);
                propColorButton.setVisible(false);
                propTitle.setVisible(true);
            }else if (prop_type == TYPE_COLOR){
                propCombo.setVisible(false);
                propText.setVisible(true);
                propFileButton.setVisible(false);
                propColorButton.setVisible(true);
                propTitle.setVisible(true);
            }else if (prop_type == TYPE_FILE){
                propCombo.setVisible(false);
                propText.setVisible(true);
                propFileButton.setVisible(true);
                propColorButton.setVisible(false);
                propTitle.setVisible(true);
            }                
        }
        public void setName(String name){
            propName = name;
        }
        public void setComboItem(ArrayList comboItem){
            propComboItem = comboItem;
        }
        public Label getTitle(){
            return propTitle;
        }
        public String getName(){
            return propName;
        }
        public Text getText(){
            return propText;
        }
        public Combo getCombo(){
            return propCombo;
        }
        public Button getFileButton(){
            return propFileButton;
        }
        public Button getColorButton(){
            return propColorButton;
        }
        public ArrayList getComboItem(){
            return propComboItem;
        }
    }
    
	/**
	 * constructor
	 */
	public MwtInstancePropertyView() {
        if (NtkManager.isInitialized() == false){
            NtkManager.ntkInitialize();
        }
        proc1 = NtkManager.getEventCallbackManager().addProc(
                "ve-prop-instance-selected", this, "reloadProperty", null);
        proc2 = NtkManager.getEventCallbackManager().addProc(
                "ve-instance-updated",this,"reloadProperty",null);
        proc3 = NtkManager.getEventCallbackManager().addProc(
                "ve-prop-instance-prop-updated",this,"reloadProperty",null);
        proc4 = NtkManager.getEventCallbackManager().addProc(
                "ve-color-selected",this,"colorSelected",null);
        proc5 = NtkManager.getEventCallbackManager().addProc(
                "ve-undo-status-changed",this,"undoStatusChanged",null);

	}
	public void dispose() {
        NtkManager.getEventCallbackManager().delProc(proc1);
        NtkManager.getEventCallbackManager().delProc(proc2);
        NtkManager.getEventCallbackManager().delProc(proc3);
        NtkManager.getEventCallbackManager().delProc(proc4);
        NtkManager.getEventCallbackManager().delProc(proc5);
	    super.dispose();
	}
	public void reloadProperty(Object obj){
        getMwtPropertyData();
	}
    
	/**
	 * make Wedget Data
	 */
	public void createPartControl(Composite parent){
        try {
            //canvas = new Canvas(parent , SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
            baseCanvas = new Canvas(parent , SWT.BORDER | SWT.V_SCROLL);
            baseCanvas.setBackground(whiteColor);
            baseCanvas.setVisible(true);
            mainCanvas = new Canvas(baseCanvas, 0);
            mainCanvas.setBackground(whiteColor);
            mainCanvas.setVisible(true);
            baseCanvas.setData(mainCanvas);
            mainCanvas.setSize(1024, 1024);
            baseCanvas.getVerticalBar().setValues(0, 0, 1024, 64, 8, 64);
            //baseCanvas.getHorizontalBar().setValues(0, 0, 1024, 64, 8, 64);
            Display display = mainCanvas.getDisplay();
            NtkManager.setSyncDisplay(display);
            
            resizedCanvas();
            getMwtPropertyData();
            makeAction(); 
        } catch(Exception e) {
            System.err.println("MwtInstancePropertyView createPartControl() : " + e.toString());
        }
        undo_action = new Action(){
            public void run(){
                INtkContext context = NtkManager.getNtkContext();
                try{
                    context.lock();
                }catch(Exception e){
                    System.err.println("MwtInstancePropertyView.undo_action e="+e);
                    return;
                }
                context.execEventProc("ve-exec-undo");
                context.unlock();
                NtkManager.getEventCallbackManager().execProc("ve-prop-instance-prop-updated");
            };
            public void runWithEvent(Event event){
                INtkContext context = NtkManager.getNtkContext();
                try{
                    context.lock();
                }catch(Exception e){
                    System.err.println("MwtInstancePropertyView.runWithEvent e="+e);
                    return;
                }
                context.execEventProc("ve-exec-undo");
                
                context.unlock();
                NtkManager.getEventCallbackManager().execProc("ve-prop-instance-prop-updated");
            }
        };
	}
    
	private void makeAction(){
        setVerticalBarAction();
        //setHorizontalBarAction();
        setResizeAction();
        undoAction = new Action() {
            public void run() {
                INtkContext context = NtkManager.getNtkContext();
//                INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
                try{
                    context.lock();
                }catch(Exception e){
                    System.err.println("MwtInstancePropertyView.undoAction e="+e);
                    return;
                }
                context.execEventProc("ve-exec-undo");
                context.unlock();
                NtkManager.getEventCallbackManager().execProc("ve-prop-instance-prop-updated");
            }
        };
        undoAction.setText(UNDO_MENU_TITLE);
        undoAction.setToolTipText(UNDO_MENU_TITLE);
        undoAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
        getImageDescriptor(ISharedImages.IMG_TOOL_UNDO_DISABLED));
        
        IActionBars bars = getViewSite().getActionBars();
        bars.getToolBarManager().add(undoAction);
	}

    private void setVerticalBarAction(){
        baseCanvas.getVerticalBar().addSelectionListener(
            new SelectionListener(){
                public void widgetSelected(SelectionEvent ev) {                
                    ScrollBar vscr = (ScrollBar)ev.getSource();
                    Canvas baseCanvas = (Canvas)vscr.getParent();
                    Canvas mainCanvas = (Canvas)baseCanvas.getData();
                    Point loc = mainCanvas.getLocation();
                    mainCanvas.setLocation(loc.x, -vscr.getSelection());
                }
                public void widgetDefaultSelected(SelectionEvent e) {}
            }
        );
    }
    
    private void setCommonInputAction(Text propText){

        propText.addFocusListener(new FocusListener(){
            public void focusGained(FocusEvent e) {}
            public void focusLost(FocusEvent e) {
                if(!procFlag) {
                    procFlag = true;
                    int selectedNum = ((Integer)(((Widget)e.getSource()).getData())).intValue();
                    setTextFieldData(selectedNum);
                    procFlag = false;
                }
            }
        });
        propText.addSelectionListener(new SelectionListener(){
            public void widgetSelected(SelectionEvent e) {}
            public void widgetDefaultSelected(SelectionEvent e) {
                if(!procFlag) {
                    procFlag = true;
                    int selectedNum = ((Integer)(((Widget)e.getSource()).getData())).intValue();
                    setTextFieldData(selectedNum);
                    procFlag = false;
                }
            }
        });
    }
    
    private void setTextFieldData(int selectedNum) {        
        // MWT lock
        INtkContext context = NtkManager.getNtkContext();
        boolean lock = false;
        boolean flag = false;
        String propData = null;
        try{
            // set property data
            INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
            MwtPropertyData pData = (MwtPropertyData)propList.get(selectedNum);
            propData = pData.getText().getText().trim();
            if(pData.getName().equals("name")) {
                if(propData.equals(targetName)) {
                    // no change
                    return;
                }
                if (lockFlag == false && lock == false){
                    context.lock();
                    lock = true;
                }

                boolean existInst = iman.existInstance(targetId);
                if(existInst == true) {
                    boolean resflg = Utils.checkSpace(propData);
                    if(resflg) {
                        iman.setProperty(targetId,"name","-NO NAME-");
                        long existNameNum = iman.checkInstanceName(targetId, propData);
                        iman.setProperty(targetId,"name",targetName);
                        if (lock == true){
                            // MWT unlock
                            context.unlock();
                            lock = false;
                        }
                        
                        if(existNameNum == 0) {
                            // normal value
                            flag = true;                            
                        } else if(existNameNum == Ntk.NTK_PROCEDURE_NAME) {
                            openErrorDialog(dMes_001);
                            return;
                        } else if(existNameNum == Ntk.NTK_OBJECT_NAME) {
                            openErrorDialog(dMes_002);
                            return;
                        } else if(existNameNum == Ntk.NTK_OBJECT_ARRAY_NAME) {
//                            openErrorDialog(dMes_003);
//                            return;
                            flag = true;                            
                        } else if(existNameNum == Ntk.NTK_OBJECT_ARRAY_NAME_INVALID) {
                            openErrorDialog(dMes_004);
                            return;
                        } else if(existNameNum == Ntk.NTK_OTHER_NAME) {
                            openErrorDialog(dMes_005);
                            return;
                        } else {
                            openErrorDialog(dMes_004);
                            return;
                        }
                    } else {
                        if (lock == true){
                            // MWT unlock
                            context.unlock();
                            lock = false;
                        }
                        openErrorDialog(dMes_004);
                        return;
                    }
                } else {
                    if (lock == true){
                        // MWT unlock
                        context.unlock();
                        lock = false;
                    }
                    System.err.println("This instance is not exist");
                    return;
                }
            }
            if (lockFlag == false && lock == false){
                context.lock();
                lock = true;
            }

            String original_val = iman.getProperty(targetId,pData.getName(),Ntk.NTK_EN_UTF8);
            
            if (original_val.compareTo(propData) != 0){
                iman.setInstanceId(Ntk.NTK_TARGET_INSTANCE_ID,targetId);
                if (lock == true){
                    // MWT unlock
                    context.unlock();
                    lock = false;
                }
                context.execEventProc("ve-set-property-undo");
            }
            if (lockFlag == false && lock == false){
                context.lock();
                lock = true;
            }
            
            iman.setProperty(targetId,pData.getName(), propData);
            long parent = iman.getParent(targetId);
            if (iman.existInstance(parent) == true){
                iman.redraw(parent);
            }
            if (lock == true){
                // MWT unlock
                context.unlock();
                lock = false;
            }

        }catch(Exception ex){
            System.err.println("MwtInstancePropertyView setCommonInputAction() : " + ex.toString());
        }finally{
            if (lock == true){
                // MWT unlock
                context.unlock();
            }
            if(flag){
                NtkManager.getEventCallbackManager().execProc("ve-instance-updated");
                targetName = propData;
            }
            
        }
    }
    
    private void openErrorDialog(String data){
        MessageDialog dlg = new MessageDialog(
                mainCanvas.getShell(), dTitle, null, data,
              MessageDialog.WARNING, new String[] { dBtn_001}, 0);
        dlg.open();
    }
    
    private void setComboFocusAction(Combo propCombo){
        //propCombo.addFocusListener(new FocusListener(){
        propCombo.addSelectionListener(new SelectionListener(){
            
            int selectedNum = 0;
            //public void focusGained(FocusEvent e) {}
            public void widgetDefaultSelected(SelectionEvent e) {}
            //public void focusLost(FocusEvent e) {
            public void widgetSelected(SelectionEvent e) {
                // MWT lock
                INtkContext context = NtkManager.getNtkContext();
                boolean lock = false;
                if (lockFlag == false){
                    try{
                        context.lock();
                    }catch (Exception ex){
                        System.err.println("MwtInstancePropertyView.widgetSelected ex="+ex);
                        return;
                    }
                    lock = true;
                }
                try{
                    // set property data
                    selectedNum = ((Integer)(((Widget)e.getSource()).getData())).intValue();
                    MwtPropertyData pData = (MwtPropertyData)propList.get(selectedNum);
                    int selectedComboNum = pData.getCombo().getSelectionIndex();
                    int val = Integer.parseInt((String)pData.getComboItem().get(selectedComboNum));
                    int original_val = NtkManager.getNtkInstanceManager().getProperty(targetId,pData.getName());
                    if (original_val != val){
                        NtkManager.getNtkInstanceManager().setInstanceId(Ntk.NTK_TARGET_INSTANCE_ID,targetId);
                        if (lock == true){
                            context.unlock();
                            lock = false;
                        }

                        context.execEventProc("ve-set-property-undo");
                    }
                    if (lockFlag == false && lock == false){
                        try{
                            context.lock();
                        }catch(Exception ex2){
                            System.err.println("MwtInstancePropertyView.widgetSelected ex="+ex2);
                            return;
                        }
                        lock = true;
                    }

                    if (pData.getName().equals("vis")){
                        NtkManager.getNtkInstanceManager().setProperty(targetId,pData.getName(),val);
                        NtkManager.getNtkInstanceManager().setUserLongData(targetId,Ntk.NTK_VISIBLE,val);
                    }else{
                        NtkManager.getNtkInstanceManager().setProperty(targetId,pData.getName(),val);
                    }
                }catch(Exception ex){
                    System.err.println("MwtInstancePropertyView setComboFocusAction() : " + e.toString());
                }finally{
                    // MWT unlock
                    if (lock == true){
                        context.unlock();
                    }
                }
            }        
        });
    }
    public void setColorValueToText(String prop,String val){
        int num = propList.size();
        int i;
        for(i=0; i<num; i++){
            MwtPropertyData pData = (MwtPropertyData)propList.get(i);
            if (pData.getName().equals(prop)){
                pData.getText().setText(val);
                break;
            }
        }
    }
    public void colorSelected(Object obj){
        INtkContext context = NtkManager.getNtkContext();
        try{
            context.lock();
        }catch(Exception e){
            System.err.println("MwtInstancePropertyView.colorSelected e="+e);
            return;
        }
        try{
            // set property data
            if (selectedProperty != null){
                String color1 = NtkManager.getNtkInstanceManager().getUserStringData(0,"selected-color1");
                String original_val = NtkManager.getNtkInstanceManager().getProperty(targetId,selectedProperty.getName(),Ntk.NTK_EN_UTF8);
                if (original_val.compareTo(color1) != 0){
                    NtkManager.getNtkInstanceManager().setInstanceId(Ntk.NTK_TARGET_INSTANCE_ID,targetId);
                    context.execEventProc("ve-set-property-undo");
                }

                NtkManager.getNtkInstanceManager().setProperty(targetId,selectedProperty.getName(),color1);
                selectedProperty.getText().setText(color1);
                if (selectedProperty.getName().equals("backColor")){
                    String color2 = NtkManager.getNtkInstanceManager().getUserStringData(0,"selected-color2");
                    NtkManager.getNtkInstanceManager().setProperty(targetId,"topShadowColor",color2);
                    setColorValueToText("topShadowColor",color2);
                    String color3 = NtkManager.getNtkInstanceManager().getUserStringData(0,"selected-color3");
                    NtkManager.getNtkInstanceManager().setProperty(targetId,"bottomShadowColor",color3);
                    setColorValueToText("bottomShadowColor",color3);
                }
            }
        }catch(Exception ex){
            System.err.println("MwtInstancePropertyView colorSelected() : " + ex.toString());
        }finally{
            // MWT unlock
            context.unlock();
        }

    }
    private void setColorSelectAction(Button propButton){
        propButton.addSelectionListener(new SelectionListener(){
            int selectedNum = 0;
//            RGB rgb = null;
            public void widgetSelected(SelectionEvent e) {
                if (targetId == 0){
                    return;
                }
                selectedNum = ((Integer)(((Widget)e.getSource()).getData())).intValue();
                selectedProperty = (MwtPropertyData)propList.get(selectedNum);

                NtkManager.getNtkInstanceManager().setInstanceId(Ntk.NTK_TARGET_INSTANCE_ID,targetId);
                NtkManager.getEventCallbackManager().execProc("ve-color-selector-activated");

                /*
                try{
                    // open color dialog
                    ColorDialog colorDialog = new ColorDialog(mainCanvas.getShell());
                    rgb = colorDialog.open();
                }catch(Exception ex){
                    System.err.println("MwtInstancePropertyView setColorSelectAction() : " + e.toString());
                }
                // MWT lock
                INtkContext context = NtkManager.getNtkContext();
                context.lock();
                try{
                    // set property data
                    if(rgb != null){
                        selectedNum = ((Integer)(((Widget)e.getSource()).getData())).intValue();
                        MwtPropertyData pData = (MwtPropertyData)propList.get(selectedNum);
                        String rgbStr = changeHexRGB(rgb);
                        NtkManager.getNtkInstanceManager().setProperty(targetId,pData.getName(),rgbStr);
                        pData.getText().setText(rgbStr);
                    }
                }catch(Exception ex){
                    System.err.println("MwtInstancePropertyView setColorSelectAction() : " + e.toString());
                }finally{
                    // MWT unlock
                    context.unlock();
                }
                */
            }
            public void widgetDefaultSelected(SelectionEvent e) {}          
        });
    }
    
    private void setFileSelectAction(Button propButton){
        propButton.addSelectionListener(new SelectionListener(){
            int selectedNum = 0;
            String filename = null;
            public void widgetSelected(SelectionEvent e) {
                try{
                    // open color dialog                   
                    FileDialog fileDialog = new FileDialog(mainCanvas.getShell());
                    filename = fileDialog.open();
                }catch(Exception ex){
                    System.err.println("MwtInstancePropertyView setFileSelectAction() : " + e.toString());
                }
                // MWT lock
                INtkContext context = NtkManager.getNtkContext();
                try{
                    context.lock();
                }catch(Exception ex){
                    System.err.println("MwtInstancePropertyView.setFileSelectAction ex="+ex);
                    return;
                }
                try{
                    if(filename != null){
                        selectedNum = ((Integer)(((Widget)e.getSource()).getData())).intValue();
                        MwtPropertyData pData = (MwtPropertyData)propList.get(selectedNum);
                        String original_val = NtkManager.getNtkInstanceManager().getProperty(targetId,pData.getName(),Ntk.NTK_EN_UTF8);

                        
                        if (original_val.compareTo(filename) != 0){
                            NtkManager.getNtkInstanceManager().setInstanceId(Ntk.NTK_TARGET_INSTANCE_ID,targetId);
                            context.execEventProc("ve-set-property-undo");
                        }
                        NtkManager.getNtkInstanceManager().setProperty(targetId,pData.getName(),filename);
                        pData.getText().setText(filename);
                    }

                }catch(Exception ex){
                    System.err.println("MwtInstancePropertyView setFileSelectAction() : " + ex);
                }finally{
                    // MWT unlock
                    context.unlock();
                }
            }
            public void widgetDefaultSelected(SelectionEvent e) {}          
        });
    }

    private void setResizeAction(){
        baseCanvas.addControlListener(new ControlListener() {
            public void controlMoved(ControlEvent e){
            }
            public void controlResized(ControlEvent e){
                mainCanvas.setVisible(false);
                resizedCanvas();
                setLocation();
                mainCanvas.setVisible(true);
                mainCanvas.update();
            }
        });
    }
    
    private void resizedCanvas(){
        
        Point viewSize = baseCanvas.getSize();
        
        // set labal, combo, text size
        int commonWidthSize = (viewSize.x - 30) / 2;
        labelSize = commonWidthSize;
        comboSize = commonWidthSize;
        textSize = commonWidthSize;
        
        // set common widget location
        int commonWidgetLocation = commonWidthSize + 5;
        comboXLocation = commonWidgetLocation;
        textXLocation = commonWidgetLocation;
        
        // set color widget size
        int colorSize = commonWidthSize / 2;
        colorInputFieldSize = colorSize;
        colorBtnSize = colorSize;
        
        // set color button location        
        colorBtnXLocation = commonWidgetLocation + colorSize;
        
        // set selection input field size
        selectionInputFieldSize = commonWidthSize - selectionBtnSize;
        
        // set selection button location
        //selectionBtnXLocation = viewSize.x - 25;
        selectionBtnXLocation = commonWidgetLocation + selectionInputFieldSize;
        Point orgSize = mainCanvas.getSize();
        mainCanvas.setSize(viewSize.x, orgSize.y);

    }
    
    private void setLocation(){
        
        MwtPropertyData pData;
        int label_y_offset = -1;
        
        try{
            for(int i=0;i<propList.size();i++){
                pData = (MwtPropertyData)propList.get(i);
                if (label_y_offset == -1){
                    Point pt = pData.getTitle().computeSize(SWT.DEFAULT,SWT.DEFAULT);
                    label_y_offset = (widgetHSize - pt.y)/2;
                }
                pData.getTitle().setLocation(labelXLocation,label_y_offset + i*widgetHSize + 5);
                pData.getTitle().setSize(labelSize,widgetHSize);
                
                if(pData.prop_type == TYPE_TEXT){
                    pData.getText().setLocation(textXLocation,i*widgetHSize + 5);
                    pData.getText().setSize(textSize,widgetHSize);
                    
                }else if(pData.prop_type == TYPE_COMBO){
                    Point pt = pData.getCombo().computeSize(SWT.DEFAULT,SWT.DEFAULT);
                    int diff = (widgetHSize - pt.y)/2;

                    pData.getCombo().setLocation(comboXLocation,i*widgetHSize + 5 + diff/2);
                    pData.getCombo().setSize(comboSize,widgetHSize);
                    
                }else if(pData.prop_type == TYPE_COLOR){
                    pData.getText().setLocation(textXLocation,i*widgetHSize + 5);
                    pData.getText().setSize(colorInputFieldSize,widgetHSize);
                    
                    pData.getColorButton().setLocation(colorBtnXLocation,i*widgetHSize + 5);
                    pData.getColorButton().setSize(colorBtnSize,widgetHSize);
                    
                }else if(pData.prop_type == TYPE_PIXMAP){
                    pData.getText().setLocation(textXLocation,i*widgetHSize + 5);
                    pData.getText().setSize(selectionInputFieldSize,widgetHSize);
                    
                    pData.getFileButton().setLocation(selectionBtnXLocation,i*widgetHSize + 5);
                    pData.getFileButton().setSize(selectionBtnSize,widgetHSize);
                }else if(pData.prop_type == TYPE_FILE){                   
                    pData.getText().setLocation(textXLocation,i*widgetHSize + 5);
                    pData.getText().setSize(selectionInputFieldSize,widgetHSize);
                    
                    pData.getFileButton().setLocation(selectionBtnXLocation,i*widgetHSize + 5);
                    pData.getFileButton().setSize(selectionBtnSize,widgetHSize);
                }
            }
        }catch(Exception e){
            System.err.println("MwtInstancePropertyView setLocation() : " + e.toString());
        }
    }
    
	public void setFocus() {
        baseCanvas.forceFocus();
	}

	public void getMwtPropertyData(){
        selectedProperty = null;
        MwtPropertyData propData = null;
        
        Label propTitle = null;
//        Text propTitle = null;
        Text propText = null;
        Combo propCombo = null;
//        Button propButton = null;
        
        String propName = null;
        String propToolTipText = null;
        String propAttribute = null;
        int propNo = 0;
        
        // MWT lock
        INtkContext context = NtkManager.getNtkContext();
        try{
            context.lock();
        }catch(Exception e){
            System.err.println("MwtInstancePropertyView.getMwtPropertyData e="+e);
            return;
        }
        lockFlag = true;
        try{
            
            long selectedId = Ntk.NTK_ROOT_INSTANCE_ID;
            long targetCount = 0;
            INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
            while(true){    
                long selectedNext = iman.getInstanceId(selectedId, Ntk.NTK_NEXT_SELECTED_INSTANCE_ID, 0);
                if (selectedNext == 0){
                    break;
                }
                targetCount++;
                selectedId = selectedNext;
            }
            // if target is not only one, method return
            //if (targetCount > 1 || targetCount == 0){
            if (targetCount > 1){
                targetId = 0;
                mainCanvas.setVisible(false);
                return;
            }
            
            if(targetId == selectedId) {
                // instance id is not change
                long propId = Ntk.NTK_ROOT_INSTANCE_ID;
                while(true){
                    long propNextId = iman.getInstanceId(targetId, Ntk.NTK_NEXT_PROPERTY_ID, propId);
                    if (propNextId == 0){
                        break;
                    }
                    propData = (MwtPropertyData)propList.get(propNo);
                    propAttribute = iman.getInstanceData( propNextId, Ntk.NTK_PROPERTY_ATTRIBUTE, 0, Ntk.NTK_EN_UTF8);
                
                    if(propAttribute.equals(comboBoxOrTextType)){
                        boolean itemCheckFlg = false;
                        String propVal = iman.getInstanceData( targetId, Ntk.NTK_PROPERTY_VALUE, propNextId, Ntk.NTK_EN_UTF8);
                        int selectCount = 0;
                        int selectionNum = 0;
                        long itemId = Ntk.NTK_ITEM_ROOT;
                        
                        while(true){
                            long itemNext = iman.getInstanceId( propNextId, Ntk.NTK_NEXT_PROPERTY_SELECT_ITEM_ID, itemId);
                            if(itemNext == 0){
                                break;
                            }else{                           
                                // select name
//                                String selectName = iman.getInstanceData(
//                                        propNextId, Ntk.NTK_PROPERTY_SELECT_VALUE_NAME, itemNext ,Ntk.NTK_EN_UTF8);
                                // select value
                                String selectValue = iman.getInstanceData(
                                        propNextId, Ntk.NTK_PROPERTY_SELECT_VALUE, itemNext ,Ntk.NTK_EN_UTF8);
                                
                                // check default  selecion number
                                if(propVal.equals(selectValue)){
                                    selectionNum = selectCount;
                                }
                                selectCount++;
                                itemCheckFlg = true;
                            }
                            itemId = itemNext;
                        }
                        
                        if(itemCheckFlg){
                            // ComboBox
                            propCombo = propData.getCombo();

                            propCombo.select(selectionNum);
                        }else{
                            // Text
                            propText = propData.getText();
                            propText.setText(propVal);
                        }
                        
                    }else{
                        String propVal = iman.getInstanceData(
                                targetId, Ntk.NTK_PROPERTY_VALUE, propNextId, Ntk.NTK_EN_UTF8);                  
                        setPushButtonWidget(propData, propAttribute, propNo, propVal);
                    }
                    propId = propNextId;
                    // count up the property number
                    propNo++;
                }
                return;
            }
//            mainCanvas.setVisible(false);
            // instance id is change, delete widget
            // set target Instance Id                
            targetId = selectedId;
//            Control[] control = mainCanvas.getChildren();

            if (propList == null){
                propList = new ArrayList();
//            }else{
//                propList.clear();
            }
            long propId = Ntk.NTK_ROOT_INSTANCE_ID;
            while(true){

                long propNextId = iman.getInstanceId(targetId, Ntk.NTK_NEXT_PROPERTY_ID, propId);

                if (propNextId == 0){
                    if (propData != null){
                        propData.last_one = true;
                    }
                    break;
                }
                if (propNo < propList.size()){
                    propData = (MwtPropertyData)propList.get(propNo);
                }else{
                    propData = new MwtPropertyData();
                    propList.add(propData);
                }
                propData.prop_no = propNo;
                propData.last_one = false;
                
                // PropertyName set
                propTitle = propData.getTitle();
                propTitle.setText( iman.getInstanceData(propNextId, Ntk.NTK_PROPERTY_TITLE, 0,Ntk.NTK_EN_UTF8));
                propName = iman.getInstanceData(propNextId, Ntk.NTK_PROPERTY_NAME, 0,Ntk.NTK_EN_UTF8);
                propData.setName(propName);
                propToolTipText = "NAME:WSN" + propName
                    + " TYPE:" + iman.getInstanceData(
                            propNextId, Ntk.NTK_PROPERTY_TYPE, 0, Ntk.NTK_EN_UTF8);
                propTitle.setToolTipText(propToolTipText);

                Point size = propTitle.computeSize(SWT.DEFAULT,SWT.DEFAULT);
                int diff = widgetHSize - size.y;
                
                propTitle.setLocation(labelXLocation, propNo*widgetHSize + 5 + diff/2);
                propTitle.setSize(labelSize, widgetHSize);
                propTitle.setBackground(whiteColor);               
                propTitle.setData(new Integer(propNo));
                
                propAttribute = iman.getInstanceData( propNextId, Ntk.NTK_PROPERTY_ATTRIBUTE, 0, Ntk.NTK_EN_UTF8);
            
                if(propAttribute.equals(comboBoxOrTextType)){
            
                    ArrayList itemNameArray = new ArrayList();
                    ArrayList itemValueArray = new ArrayList();
                    
                    boolean itemCheckFlg = false;
                    String propVal = iman.getInstanceData( targetId, Ntk.NTK_PROPERTY_VALUE, propNextId, Ntk.NTK_EN_UTF8);
                    int selectCount = 0;
                    int selectionNum = 0;
                    long itemId = Ntk.NTK_ITEM_ROOT;
                    
                    while(true){
                        long itemNext = iman.getInstanceId( propNextId, Ntk.NTK_NEXT_PROPERTY_SELECT_ITEM_ID, itemId);
                        if(itemNext == 0){
                            break;
                        }else{                           
                            // select name
                            String selectName = iman.getInstanceData(
                                    propNextId, Ntk.NTK_PROPERTY_SELECT_VALUE_NAME, itemNext ,Ntk.NTK_EN_UTF8);
                            itemNameArray.add(selectName);
                            // select value
                            String selectValue = iman.getInstanceData(
                                    propNextId, Ntk.NTK_PROPERTY_SELECT_VALUE, itemNext ,Ntk.NTK_EN_UTF8);
                            itemValueArray.add(selectValue);
                            
                            // check default  selecion number
                            if(propVal.equals(selectValue)){
                                selectionNum = selectCount;
                            }
                            selectCount++;
                            itemCheckFlg = true;
                        }
                        itemId = itemNext;
                    }
                    
                    if(itemCheckFlg){
                        // ComboBox
                        propData.prop_type = TYPE_COMBO;
                        propCombo = propData.getCombo();
                        propCombo.setLocation(comboXLocation, propNo*widgetHSize + 5);
                        propCombo.setItems((String[]) itemNameArray.toArray(new String[0]));
                        propCombo.setSize(comboSize, widgetHSize);
                        propCombo.select(selectionNum);
                        propCombo.setData(new Integer(propNo));
                        propData.setComboItem(itemValueArray);
                    }else{
                        // Text
                        propData.prop_type = TYPE_TEXT;
                        propText = propData.getText();
                        
                        propText.setLocation(textXLocation, propNo*widgetHSize + 5);
                        propText.setSize(textSize, widgetHSize);
                        propText.setText(propVal);
                        propText.setData(new Integer(propNo));
                        
                        if(propName.equals("name")) {
                            targetName = propVal;
                        }
                    }
                    
                }else{
                    String propVal = iman.getInstanceData(
                            targetId, Ntk.NTK_PROPERTY_VALUE, propNextId, Ntk.NTK_EN_UTF8);                  
                    setPushButtonWidget(propData, propAttribute, propNo, propVal);
                }
                propId = propNextId;
                // count up the property number
                propNo++;
            }
            while(propNo < propList.size()){
                propData = (MwtPropertyData)propList.get(propNo);
                propData.prop_type = TYPE_NONE;
                propNo++;
            }
            propNo = 0;
            while(propNo < propList.size()){
                propData = (MwtPropertyData)propList.get(propNo);
                propData.update();
                propNo++;
            }
            Point viewSize = baseCanvas.getSize();
            int vsize = propNo * widgetHSize + 50;
            mainCanvas.setSize(viewSize.x, vsize);
            baseCanvas.getVerticalBar().setMaximum(vsize);
            mainCanvas.setVisible(true);
        }catch(Exception e){
            System.err.println("MwtInstancePropertyView getMwtPropertyData() : " + e.toString());
        }finally{
            context.unlock();
            lockFlag = false;
        }
	}
    
    private void setPushButtonWidget(MwtPropertyData pData, String pAttribute, int pNo, String pVal){

        try {
            Text propText = pData.getText();
//            setCommonInputAction(propText);
            propText.setLocation(textXLocation, pNo*widgetHSize + 5);
            propText.setText(pVal);
            propText.setData(new Integer(pNo));
            
//            Button propButton = new Button(mainCanvas, 0);
            
            if(pAttribute.equals(colorType)){
                Button propButton = pData.getColorButton();
                propButton.setData(new Integer(pNo));
                // ColorDialog
                propText.setSize(colorInputFieldSize, widgetHSize);
                propButton.setLocation(colorBtnXLocation, pNo*widgetHSize + 5);
                propButton.setSize(colorBtnSize, widgetHSize);
                pData.prop_type = TYPE_COLOR;
            }else if(pAttribute.equals(pixmapType) || pAttribute.equals(fileSelectType)){
                Button propButton = pData.getFileButton();
                propButton.setData(new Integer(pNo));
                // PixmapDialog and FileSelectDialog
                propText.setSize(selectionInputFieldSize, widgetHSize);
                propButton.setLocation(selectionBtnXLocation, pNo*widgetHSize + 5);
                propButton.setSize(selectionBtnSize, widgetHSize);
                if(pAttribute.equals(pixmapType)){
                    pData.prop_type = TYPE_PIXMAP;
                }else{
                    pData.prop_type = TYPE_FILE;
                }
            }else{
                // error
                propText.setVisible(false);
            }
        } catch(Exception e) {
            System.err.println("MwtInstancePropertyView setPushButtonWedget() : " + e.toString());
        }

    }
    
//    private String changeHexRGB(RGB rgb){
//        String redHex = changeHexValue(Integer.toHexString(rgb.red));
//        String greenHex = changeHexValue(Integer.toHexString(rgb.green));
//        String blueHex = changeHexValue(Integer.toHexString(rgb.blue));
//        String hexRGB =  "#" + redHex + greenHex + blueHex;
//        return hexRGB;
//    }
    
    private String changeHexValue(String strHex){
        if(strHex.length() == 1){
            strHex = "0" + strHex;
        }
        return strHex;
    }
    public void undoStatusChanged(Object obj){
        INtkContext context = NtkManager.getNtkContext();
        try{
            context.lock();
        }catch(Exception e){
            System.err.println("MwtInstancePropertyView.undoStatusChanged e="+e);
            return;
        }
        long num = NtkManager.getNtkProjectManager().getStaticData(Ntk.NTK_UNDO_NUM,0);
        context.unlock();
        IActionBars bars = getViewSite().getActionBars();

        if (num == 0){
            bars.setGlobalActionHandler("undo", null);
            bars.updateActionBars();
            undoAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
                    getImageDescriptor(ISharedImages.IMG_TOOL_UNDO_DISABLED));
        }else{
            bars.setGlobalActionHandler("undo", undo_action);
            bars.updateActionBars();
            undoAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
                    getImageDescriptor(ISharedImages.IMG_TOOL_UNDO));
        }
//      IActionBars bars = getViewSite().getActionBars();
//        bars.getToolBarManager().add(undoAction);

        return;
    }
}
