/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.core;

import org.eclipse.swt.widgets.Display;

public class NtkManager {
    private static INtkInitializer initializer = null;
    public static void setNtkInitializer(INtkInitializer inst){
        initializer = inst;
    }
    
    private static INtkContext ntkContext = null;
    public static void setNtkContext(INtkContext inst){
        ntkContext = inst;
    }

    private static INtkInstanceManager ntkInstanceManager = null;
    public static void setNtkInstanceManager(INtkInstanceManager inst){
        ntkInstanceManager = inst;
    }

    private static INtkProjectManager ntkProjectManager = null;
    public static void setNtkProjectManager(INtkProjectManager inst){
        ntkProjectManager = inst;
    }

    public static NtkEventCallbackManager getEventCallbackManager(){
        return initializer.getEventCallbackManager();
    }
    public static synchronized void ntkInitialize() {
        if (initializer == null){
            return;
        }
        initializer.initialize();
    }
    public static boolean isInitialized() {
        if (initializer == null){
            return false;
        }
        return initializer.isInitialized();
    }
    public static void setSyncDisplay(Display disp){
        if (initializer == null){
            return;
        }
        initializer.setSyncDisplay(disp);
    }
    public static Display getSyncDisplay(){
        if (initializer == null){
            return null;
        }
        return initializer.getSyncDisplay();
    }
    public static INtkContext getNtkContext(){
        return ntkContext;
    }
    public static INtkInstanceManager getNtkInstanceManager(){
        return ntkInstanceManager;
    }
    public static INtkProjectManager getNtkProjectManager(){
        return ntkProjectManager;
    }
}
