/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.core;

import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.cdt.make.core.MakeBuilder;
import org.eclipse.nab.core.NtkManager;

public class MwtProjectBuilder extends MakeBuilder {

    public MwtProjectBuilder (){
        super();
    }
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor)
            throws CoreException {
        
        NtkManager.getNtkProjectManager().createCurrentNtkProjectSources();
        
        return super.build(kind, args, monitor);
    }
    public void clean(IProgressMonitor monitor){
        try{
            super.clean(monitor);

        }catch(Exception e){
            System.err.println("MwtProjectBuilder.clean e="+e);
        }
    }
}
