/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.core;

import java.text.DecimalFormat;
import java.util.ArrayList;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.nab.core.NtkManager;

public class MwtNewWindowWizardPage extends WizardPage {
    private static final String page_title1 = UIMessages.getString("MwtNewWindowWizardPage.pageTitle1"); //$NON-NLS-1$
    private static final String page_title2 = UIMessages.getString("MwtNewWindowWizardPage.pageTitle2"); //$NON-NLS-1$
    private static final String win_title = UIMessages.getString("MwtNewWindowWizardPage.winTitle"); //$NON-NLS-1$
    private static final String cname_title = UIMessages.getString("MwtNewWindowWizardPage.cnameTitle"); //$NON-NLS-1$
    private static final String statusMessage1 = UIMessages.getString("MwtNewWindowWizardPage.statusMessage1"); //$NON-NLS-1$
    private static final String statusMessage2 = UIMessages.getString("MwtNewWindowWizardPage.statusMessage2"); //$NON-NLS-1$
    
    private static final String WIN_TYPE_TITLE = UIMessages.getString("MwtInstanceAttributeView.windowTypeTitle"); //$NON-NLS-1$
    private static final String WIN_TYPE_APP1 = UIMessages.getString("MwtInstanceAttributeView.windowTypeApp1"); //$NON-NLS-1$
    private static final String WIN_TYPE_APP2 = UIMessages.getString("MwtInstanceAttributeView.windowTypeApp2"); //$NON-NLS-1$
    private static final String WIN_TYPE_APP3 = UIMessages.getString("MwtInstanceAttributeView.windowTypeApp3"); //$NON-NLS-1$

    static private int cnt = 0;
	private Text classNameText;
	private Text nameText;
    private Combo winTypeCombo;
	private ISelection selection;

	public MwtNewWindowWizardPage(ISelection selection) {
		super("wizardPage");
		setTitle(page_title1);
		setDescription(page_title2);
		this.selection = selection;
	}

	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 2;
		layout.verticalSpacing = 9;
        
		Label label = new Label(container, SWT.NULL);
		label.setText(win_title);

		nameText = new Text(container, SWT.BORDER | SWT.SINGLE);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		nameText.setLayoutData(gd);
		nameText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});
/*
		Button button = new Button(container, SWT.PUSH);
		button.setText("Browse...");
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				handleBrowse();
			}
		});
*/
		label = new Label(container, SWT.NULL);
		label.setText(cname_title);

		classNameText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		classNameText.setLayoutData(gd);
		classNameText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});
        
        label = new Label(container, SWT.NULL);
        label.setText(WIN_TYPE_TITLE);

        winTypeCombo = new Combo(container, SWT.READ_ONLY);
        gd = new GridData(GridData.FILL_HORIZONTAL);
        winTypeCombo.setLayoutData(gd);        
        ArrayList itemNameArray = new ArrayList();
        itemNameArray.add(WIN_TYPE_APP1);
        itemNameArray.add(WIN_TYPE_APP2);
        itemNameArray.add(WIN_TYPE_APP3);
        winTypeCombo.setItems((String[]) itemNameArray.toArray(new String[0]));
        winTypeCombo.setText(WIN_TYPE_APP1);
        
		initialize();
		dialogChanged();
		setControl(container);
	}
		
	private void initialize() {

        classNameText.setText("WSCmainWindow");
        DecimalFormat nf = new DecimalFormat("000");
        
        String name = "newwin" + nf.format(cnt);
        try{
            NtkManager.getNtkContext().lock();
        }catch(Exception e){
            System.err.println("MwtNewWindowWizardPage.initialize e="+e);
            return;
        }
        while(true){
            long inst = NtkManager.getNtkInstanceManager().getInstance("WSCbase",name);
            if (inst == 0){
                break;
            }
            cnt++;
            if (cnt > 9){
                name = "newwin0" + cnt;
            }else{
                name = "newwin00" + cnt;
            }
        }
        NtkManager.getNtkContext().unlock();
        nameText.setText(name);
        cnt++;
	}
	private void dialogChanged() {//		String container = getDirectoryName();
        String winClassName = getWindowClassName();

        if (winClassName.length() == 0) {
            updateStatus(statusMessage1);
            return;
        }
        String winName = getWindowName();

        if (winName.length() == 0) {
            updateStatus(statusMessage2);
            return;
        }
		updateStatus(null);
	}

	private void updateStatus(String message) {
		setErrorMessage(message);
		setPageComplete(message == null);
	}

    public String getWindowClassName() {
        return classNameText.getText();
    }
    public String getWindowName() {
        return nameText.getText();
    }
    public int getWindowType(){
        return winTypeCombo.getSelectionIndex();
    }
}
