/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.core;

import java.util.ArrayList;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.internal.formatter.align.Alignment;
import org.eclipse.nab.core.INtkContext;
import org.eclipse.nab.core.INtkProjectManager;
import org.eclipse.nab.core.Ntk;
import org.eclipse.nab.core.NtkManager;
import org.eclipse.nab.mwt.ab.view.MwtInstancePropertyView.MwtPropertyData;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PropertyPage;

public class MwtProjectPlatformEnvPropertyPage extends PropertyPage {
    private static final String BTRON_ENV_TITLE = "BTRON SDK PAH:";
    private static final String TE_ENV_TITLE1 = "T-Engine SH7751R SDK PAH:";
    private static final String TE_ENV_TITLE2 = "T-Engine SH7727 SDK PAH:";
    private static final String TE_ENV_TITLE3 = "T-Engine Vr5500 SDK PAH:";
    private static final String TE_ENV_TITLE4 = "T-Engine ARM920-MX1 SDK PAH:";
    private static final String TE_ENV_TITLE5 = "T-Engine ARM926-MB8 SDK PAH:";
    private static final String TE_ENV_TITLE6 = "T-Engine SH7760 SDK PAH:";
    private static final String TE_ENV_TITLE7 = "T-Engine Vr5701 SDK PAH:";
    private static final String TE_ENV_TITLE8 = "T-Engine TX4956 SDK PAH:";
    private static final String dMes_browse = UIMessages.getString("Common.browse"); //$NON-NLS-1$


	private static final int TEXT_FIELD_WIDTH = 50;
    private ArrayList texts;
    
	/**
	 * Constructor for MwtProjectCompilerPropertyPage.
	 */
	public MwtProjectPlatformEnvPropertyPage() {
		super();
	}
	private void addSeparator(Composite parent) {
		Label separator = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		separator.setLayoutData(gridData);
	}
    private void addSection(Composite parent,String title_key) {
        Composite composite = createDefaultComposite(parent);
        
        GridData pgd = new GridData();
        pgd.heightHint = 40;
        pgd.widthHint = 800;
        pgd.horizontalSpan = GridData.FILL;
        composite.setLayoutData(pgd);
        
        Label titleLabel = new Label(composite, SWT.NONE);
        String title = NtkManager.getNtkProjectManager().getStaticData(Ntk.NTK_TARGET_ENV_TITLE,title_key,Ntk.NTK_EN_DEFAULT);
        titleLabel.setText(title);
        GridData gdt = new GridData();
        gdt.widthHint = 150;
//        gdt.horizontalAlignment = GridData.BEGINNING;
     
        titleLabel.setLayoutData(gdt);

        Text text = new Text(composite, SWT.SINGLE | SWT.BORDER);
        GridData gd = new GridData();
        gd.widthHint = convertWidthInCharsToPixels(TEXT_FIELD_WIDTH);
        
        text.setLayoutData(gd);
        text.setData(title_key);
        texts.add(text);

        Button fd_button = new Button(composite,0);
        GridData gd2 = new GridData();
        gd2.widthHint = 100;
//        gd2.horizontalAlignment = GridData.END;
        fd_button.setLayoutData(gd2);
        fd_button.setData(text);
        fd_button.setText(dMes_browse);
        
        fd_button.addSelectionListener(new SelectionListener(){
            int selectedNum = 0;
            String filename = null;
            public void widgetSelected(SelectionEvent e) {
                try{
                    // open color dialog                   
                    DirectoryDialog fileDialog = new DirectoryDialog(getShell());
                    filename = fileDialog.open();
                }catch(Exception ex){
                    System.err.println("MwtInstancePropertyView setFileSelectAction() : " + e.toString());
                }
                if (filename != null){
                    Button btn = (Button)e.getSource();
                    Text text = (Text)btn.getData();
                    text.setText(filename);
                }
            }
            public void widgetDefaultSelected(SelectionEvent e) {}          
        });

        
        
    }

    /**
	 * @see PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		composite.setLayout(layout);
		GridData data = new GridData(GridData.FILL);
		data.grabExcessHorizontalSpace = true;
		composite.setLayoutData(data);
        int langType = NtkManager.getNtkProjectManager().getCurrentProjectLangType();
        if (langType != Ntk.NTK_LANG_CPP){
            return composite;
        }

        texts = new ArrayList();
        addSection(composite,"#ENV1");
        addSection(composite,"#ENV2");
        addSection(composite,"#ENV3");
        addSection(composite,"#ENV4");
        addSection(composite,"#ENV5");
        addSection(composite,"#ENV6");
        addSection(composite,"#ENV7");
        addSection(composite,"#ENV8");
        addSection(composite,"#ENV9");
        
        INtkProjectManager pman = NtkManager.getNtkProjectManager();
        int num = texts.size();
        int i;
        for(i=0; i<num; i++){
            Text text = (Text)texts.get(i);
            String key = (String)text.getData();
            String str = pman.getEnvironmentData(key,Ntk.NTK_EN_DEFAULT);
            text.setText(str);
        }
        noDefaultAndApplyButton();
        
        
		return composite;
	}

	private Composite createDefaultComposite(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 3;
		composite.setLayout(layout);

		GridData data = new GridData();
		data.verticalAlignment = GridData.FILL;
		data.horizontalAlignment = GridData.FILL;
		composite.setLayoutData(data);

		return composite;
	}

	protected void performDefaults() {
        /*
        int langType = NtkManager.getNtkProjectManager().getCurrentProjectLangType();
        if (langType != Ntk.NTK_LANG_CPP){
            return;
        }

	    INtkProjectManager pman = NtkManager.getNtkProjectManager();
        int num = texts.size();
        int i;
        for(i=0; i<num; i++){
            Text text = (Text)texts.get(i);
            String key = (String)text.getData();
            String str = pman.getEnvironmentData(key,Ntk.NTK_EN_DEFAULT);
            text.setText(str);
        }
        */
    }
	
	public boolean performOk() {
        int langType = NtkManager.getNtkProjectManager().getCurrentProjectLangType();
        if (langType != Ntk.NTK_LANG_CPP){
            return true;
        }
		try {
            INtkProjectManager pman = NtkManager.getNtkProjectManager();
            int num = texts.size();
            int i;
            for(i=0; i<num; i++){
                Text text = (Text)texts.get(i);
                String key = (String)text.getData();
                pman.setEnvironmentData(key,text.getText(),Ntk.NTK_EN_DEFAULT);
            }
            pman.saveEnvironmentData();
		} catch (Exception e) {
			return false;
		}
		return true;
	}

}
