/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.*;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.jface.action.*;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.*;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.SWT;

import org.eclipse.nab.core.INtkContext;
import org.eclipse.nab.core.INtkInstanceManager;
import org.eclipse.nab.core.INtkProjectManager;
import org.eclipse.nab.core.Ntk;
import org.eclipse.nab.core.NtkManager;
import org.eclipse.nab.mwt.ab.core.UIMessages;
import org.eclipse.nab.mwt.ab.core.Utils;

public class MwtInstanceProcedureView extends ViewPart {
    private static final String createMessage1 = UIMessages.getString("MwtInstanceProcedureView.createMessage1"); //$NON-NLS-1$
    private static final String createMessage2 = UIMessages.getString("MwtInstanceProcedureView.createMessage2"); //$NON-NLS-1$

    private static final String newProcedureName = "new_ep";
    private static final String createMenuTitle = UIMessages.getString("MwtInstanceProcedureView.createMenuTitle"); //$NON-NLS-1$
    private static final String createMenuToolTipTitle = UIMessages.getString("MwtInstanceProcedureView.createMenuToolTipTitle"); //$NON-NLS-1$
    private static final String fixMenuTitle = UIMessages.getString("MwtInstanceProcedureView.fixMenuTitle"); //$NON-NLS-1$
    private static final String fixMenuToolTipTitle = UIMessages.getString("MwtInstanceProcedureView.fixMenuToolTipTitle"); //$NON-NLS-1$
    private static final String editMenuTitle = UIMessages.getString("MwtInstanceProcedureView.editMenuTitle"); //$NON-NLS-1$
    private static final String editMenuToolTipTitle = UIMessages.getString("MwtInstanceProcedureView.editMenuToolTipTitle"); //$NON-NLS-1$
    private static final String deleteMenuTitle = UIMessages.getString("MwtInstanceProcedureView.deleteMenuTitle"); //$NON-NLS-1$
    private static final String deleteMenuToolTipTitle = UIMessages.getString("MwtInstanceProcedureView.deleteMenuToolTipTitle"); //$NON-NLS-1$
    private static final String columnName1 = UIMessages.getString("MwtInstanceProcedureView.columnName1"); //$NON-NLS-1$
    private static final String columnName2 = UIMessages.getString("MwtInstanceProcedureView.columnName2"); //$NON-NLS-1$
    private static final String columnName3 = UIMessages.getString("MwtInstanceProcedureView.columnName3"); //$NON-NLS-1$
    
    private static final String dTitle_001 = UIMessages.getString("MwtInstanceProcedureView.dialogTitle1"); //$NON-NLS-1$
    private static final String dMes_001 = UIMessages.getString("MwtInstanceProcedureView.dialogMessage1"); //$NON-NLS-1$
    private static final String dMes_002 = UIMessages.getString("MwtInstanceProcedureView.dialogMessage2"); //$NON-NLS-1$
    private static final String dMes_003 = UIMessages.getString("MwtInstanceProcedureView.dialogMessage3"); //$NON-NLS-1$
    private static final String dMes_005 = UIMessages.getString("MwtInstanceProcedureView.dialogMessage5"); //$NON-NLS-1$
    private static final String dMes_006 = UIMessages.getString("MwtInstanceProcedureView.dialogMessage6"); //$NON-NLS-1$
    private static final String dMes_007 = UIMessages.getString("MwtInstanceProcedureView.dialogMessage7"); //$NON-NLS-1$
    private static final String dMes_008 = UIMessages.getString("MwtInstanceProcedureView.dialogMessage8"); //$NON-NLS-1$

    private static final String dMes_del1 = UIMessages.getString("MwtInstanceProcedureView.dialogMessageDel1"); //$NON-NLS-1$
    private static final String dMes_del2 = UIMessages.getString("MwtInstanceProcedureView.dialogMessageDel2"); //$NON-NLS-1$

    
    private static final String dBtn_001 = UIMessages.getString("MwtInstanceProcedureView.dialogOk"); //$NON-NLS-1$
    private static final String dBtn_002 = UIMessages.getString("MwtInstanceProcedureView.dialogCancel"); //$NON-NLS-1$
    private static final String dBtn_003 = UIMessages.getString("MwtInstanceProcedureView.dialogUpdate"); //$NON-NLS-1$
    private static final String dBtn_004 = UIMessages.getString("Common.dialogDelAll"); //$NON-NLS-1$
    private static final String[] dBtnLbl = new String[] { dBtn_001, dBtn_002 };
    private static final String[] dBtnLbl2 = new String[] { dBtn_001};
    private static final String[] dBtnLbl3 = new String[] { dBtn_001, dBtn_004,dBtn_002 };
    
//    private static String sourceExt = ".cpp";
//    private static int langType = Ntk.NTK_LANG_CPP;
    
	private TableViewer viewer = null;
	private Action createAction = null;
	private Action fixAction = null;
	private Action editAction = null;
	private Action deleteAction = null;
	private Action doubleClickAction = null;
	private ArrayList procList = null;
	private String selectedInstanceName = null;
    private long targetInstId = 0;
    private long targetProcID = 0;
    
    private CreateProcedureDialog createDialog = null;
    private TriggerTable triggerTable = null;
    
    private long proc1;
    private long proc2;
    
	class ListElement {
        private String procedureName = null;
        private String triggerName = null;
        //private int triggerNumber = 0;
        private String functionName = null;      
        private long id = 0;
        private boolean independent = true;
        
        public void setProcedureName(String value) {
            procedureName = value;
        }
        public String getProcedureName() {
            return procedureName;
        }
        public void setTriggerName(String value) {
            triggerName = value;
        }
        public String getTriggerName() {
            return triggerName;
        }
//        public void setTriggerNumber(int value) {
//            triggerNumber = value;
//        }
//        public long getTriggerNumber() {
//            return triggerNumber;
//        }
        public void setFunctionName(String value) {
            functionName = value;
        }
        public String getFunctionName() {
            return functionName;
        }       
        public void setId(long value) {
            id = value;
        }
        public long getId() {
            return id;
        }
        public boolean getIndependentFile(){
            return independent;
        }
        public void setIndependentFile(boolean fl){
            independent = fl;
        }
	}
    
    class TriggerTable {
        private String WSEV_NONE = "NONE";
        private String WSEV_INITIALIZE = "INITIALIZE";
        private String WSEV_DELETE = "DELETE";
        private String WSEV_ACTIVATE = "ACTIVATE";
        private String WSEV_VALUE_CH = "VALUE-CH";
        private String WSEV_FOCUS_CH = "FOCUS-CH";
        private String WSEV_VISIBLE_CH = "VISIBLE-CH";
        private String WSEV_SENSITIVE_CH = "SENSITIVE-CH";
        private String WSEV_PARENT_VISIBLE_CH = "PARENT-VISIBLE-CH";
        private String WSEV_PARENT_SENSITIVE_CH = "PARENT-SENSITIVE-CH";
        private String WSEV_EXPOSE = "EXPOSE";
        private String WSEV_RESIZE = "RESIZE";
        private String WSEV_MOUSE_IN = "MOUSE-IN";
        private String WSEV_MOUSE_OUT = "MOUSE-OUT";
        private String WSEV_MOUSE_PRESS = "MOUSE-PRESS";
        private String WSEV_MOUSE_RELEASE = "MOUSE-RELEASE";
        private String WSEV_MOUSE_MOVE = "MOUSE-MOVE";
        private String WSEV_KEY_PRESS = "KEY-PRESS";
        private String WSEV_KEY_RELEASE = "KEY-RELEASE";
        private String WSEV_KEY_HOOK = "KEY-HOOK";
        private String WSEV_MOUSE_DOUBLE_CLICK = "MOUSE-DOUBLE-CLICK";

        private ArrayList triggerNumberList = null;
        private ArrayList triggerNameList = null;
        private HashMap map = null;
        
        public TriggerTable() {
            triggerNumberList = new ArrayList();
            triggerNameList = new ArrayList();
            map = new HashMap();
            INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
            for(int i = -1; i <= 19; i++) {
                if(iman.existTrigger(targetInstId,i) == true) {
                    triggerNumberList.add(new Integer(i));
                    triggerNameList.add(getTriggerName(i));
                }
            }
            ArrayList nlist = new ArrayList();
            ArrayList vlist = new ArrayList();
            int num = iman.getExtTriggerList(targetInstId,nlist,vlist);
            
            for(int i = 0; i < num; i++) {
                triggerNumberList.add(vlist.get(i));
                triggerNameList.add(nlist.get(i));
                map.put(vlist.get(i), nlist.get(i));
            }
        }
        
        private ArrayList getNumberList() {
            return triggerNumberList;
        }
        
        private ArrayList getNameList() {
            return triggerNameList;
        }
        
        private String getTriggerName(int num) {
            switch(num){
                case -1 :
                    return WSEV_NONE;
                case 0 :
                    return WSEV_INITIALIZE;
                case 1 :
                    return WSEV_DELETE;
                case 2 :
                    return WSEV_ACTIVATE;
                case 3 :
                    return WSEV_VALUE_CH;
                case 4 :
                    return WSEV_FOCUS_CH;
                case 5 :
                    return WSEV_VISIBLE_CH;
                case 6 :
                    return WSEV_SENSITIVE_CH;
                case 7 :
                    return WSEV_PARENT_VISIBLE_CH;
                case 8 :
                    return WSEV_PARENT_SENSITIVE_CH;
                case 9 :
                    return WSEV_EXPOSE;
                case 10 :
                    return WSEV_RESIZE;
                case 11 :
                    return WSEV_MOUSE_IN;
                case 12 :
                    return WSEV_MOUSE_OUT;
                case 13 :
                    return WSEV_MOUSE_PRESS;
                case 14 :
                    return WSEV_MOUSE_RELEASE;
                case 15 :
                    return WSEV_MOUSE_MOVE;
                case 16 :
                    return WSEV_KEY_PRESS;
                case 17 :
                    return WSEV_KEY_RELEASE;
                case 18 :
                    return WSEV_KEY_HOOK;
                case 19 :
                    return WSEV_MOUSE_DOUBLE_CLICK;
                default:
                    return (String)map.get(new Integer(num));
            }
        }
    }
    
	class ViewContentProvider implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            java.util.List array = (java.util.List)inputElement;
            return array.toArray();
        }
    
        public void dispose() {
        }
    
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
	}
	class ViewLabelProvider extends LabelProvider implements ITableLabelProvider {
		public String getColumnText(Object obj, int index) {
            ListElement Element = (ListElement) obj;
            switch(index){
                case 0:
                    return Element.getProcedureName();
                case 1:
                    return Element.getTriggerName();
                case 2:
                    return Element.getFunctionName();
            }
            return null;
        }
        public String getText(Object obj) {
            ListElement Element = (ListElement) obj;
            return Element.getProcedureName();
		}
		public Image getColumnImage(Object obj, int index) {
            switch(index){
            case 0:
            return getImage(obj);
        }
            return null;
		}
		public Image getImage(Object obj) {
            return null;
		}
	}
	class NameSorter extends ViewerSorter {
	}
	/**
	 * The constructor.
	 */
	public MwtInstanceProcedureView() {
        if (NtkManager.isInitialized() == false){
            NtkManager.ntkInitialize();
        }

        proc1 = NtkManager.getEventCallbackManager().addProc(
                "ve-prop-instance-selected",this,"updateProcedureList",null);
        proc2 = NtkManager.getEventCallbackManager().addProc(
                "ve-instance-updated",this,"updateProcedureList",null);
	}
    public void dispose() {
        NtkManager.getEventCallbackManager().delProc(proc1);
        NtkManager.getEventCallbackManager().delProc(proc2);
        super.dispose();
    }
    public void updateProcedureList(Object obj){        
        try{
            getMwtProcedureData();
            viewer.setInput(procList);
        }catch(Exception e){
            System.err.println("MwtInstanceProcedureView updateList() : " + e.toString());
        }
    }

	public void createPartControl(Composite parent) {
        try{
            viewer = new TableViewer(parent, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION);
            viewer.setContentProvider(new ArrayContentProvider());
            viewer.setLabelProvider(new ViewLabelProvider());
            viewer.setSorter(new NameSorter());
            Table table = viewer.getTable();
            TableColumn col1 = new TableColumn(table, SWT.LEFT);
            col1.setText(columnName1);
            col1.setWidth(100);
            TableColumn col2 = new TableColumn(table, SWT.LEFT);
            col2.setText(columnName2);
            col2.setWidth(100);
            TableColumn col3 = new TableColumn(table, SWT.LEFT);
            col3.setText(columnName3);
            col3.setWidth(100);
            table.setHeaderVisible(true);
            
            Display display = viewer.getControl().getDisplay();
            NtkManager.setSyncDisplay(display);
            getMwtProcedureData();        
            viewer.setInput(procList);
            makeActions();
            hookContextMenu();
            hookDoubleClickAction();
            contributeToActionBars();
        } catch(Exception e) {
            System.err.println("MwtInstanceProcedureView createPartControl() : " + e.toString());
        }
	}

	private void hookContextMenu() {
		MenuManager menuMgr = new MenuManager("#PopupMenu");
		menuMgr.setRemoveAllWhenShown(true);
		menuMgr.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				MwtInstanceProcedureView.this.fillContextMenu(manager);
			}
		});
		Menu menu = menuMgr.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(menuMgr, viewer);
	}

	private void contributeToActionBars() {
		IActionBars bars = getViewSite().getActionBars();
		//fillLocalPullDown(bars.getMenuManager());
		fillLocalToolBar(bars.getToolBarManager());
	}

	private void fillLocalPullDown(IMenuManager manager) {
        manager.add(createAction);
        manager.add(fixAction);
        manager.add(editAction);
        manager.add(deleteAction);
		manager.add(new Separator());
	}

	private void fillContextMenu(IMenuManager manager) {
        manager.add(createAction);
        manager.add(fixAction);
        manager.add(editAction);
        manager.add(deleteAction);
		// Other plug-ins can contribute there actions here
		manager.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS));
	}
	
	private void fillLocalToolBar(IToolBarManager manager) {
        manager.add(createAction);
        manager.add(fixAction);
        manager.add(editAction);
        manager.add(deleteAction);
	}

    private void makeCreateDialog() {
        Combo combo = null;
        ArrayList triggerNameList = null;
        
        try {
            createDialog = new CreateProcedureDialog();
            createDialog.createSShell();
            createDialog.getInstanceData().setText(selectedInstanceName);

            combo = createDialog.getTriggerCombo();
            triggerTable = new TriggerTable();
            triggerNameList = triggerTable.getNameList();
            combo.setItems((String[]) triggerNameList.toArray(new String[0]));
            setFileSelectAction(createDialog.getFileSelectButton());
            setTemplateAction(createDialog.getTemplateButton());
            setCancelAction(createDialog.getCancelButton());
            
        } catch (Exception e) {
            System.err.println("MwtInstanceProcedureView makeCreateDialog() : " + e.toString());
        }
    }
    private int openMsgDialog(
            Shell shell, String title, Image image, String msg, int type, String[] btnLbl, int defIdx) {
        MessageDialog dlg = new MessageDialog(
                shell, title, image, msg,
                type, btnLbl, defIdx);
        return dlg.open();
    }
    void validatePath(String path,String fullpath){
        int i;
        IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(path));
        try{
            resource.create(null,IResource.NONE,null);
        }catch(Exception e){
            System.err.println("MwtInstanceProcedureView.validatePath Exception e="+e);
        }
        
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null){
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null){
            return;
        }
        
        IWorkbenchPartReference[] ref_list = page.getViewReferences();
        ArrayList parts = new ArrayList();
        for (i = 0; i < ref_list.length; i++) {
            IWorkbenchPart part = ref_list[i].getPart(false);
            if(part != null){
                parts.add(part);
            }
        }
        ref_list = page.getEditorReferences();
        
        for (i = 0; i < ref_list.length; i++) {
            if (ref_list[i].getPart(false) != null){
                parts.add(ref_list[i].getPart(false));
            }
        }
        Iterator items = parts.iterator();
        final ISelection selection = new StructuredSelection(resource);
        while (items.hasNext()) {
            ISetSelectionTarget target = null;
            IWorkbenchPart part = (IWorkbenchPart)items.next();
            if (part instanceof ISetSelectionTarget){
                target = (ISetSelectionTarget) part;
            }else{
                target = (ISetSelectionTarget) part.getAdapter(ISetSelectionTarget.class);
            }
            if (target != null) {
                final ISetSelectionTarget async_target = target;
                window.getShell().getDisplay().asyncExec(new Runnable() {
                    public void run() {
                        async_target.selectReveal(selection);
                    }
                });
            }
        }
    }
	private void makeActions() {

        try {             
            createAction = new Action() {
                public void run() {
                    if(targetInstId == 0) {
                        openMsgDialog(
                                viewer.getControl().getShell(), "", null,
                                dMes_006, MessageDialog.WARNING, dBtnLbl2, 0);
                        return;
                    }                  
                    // make dialog
                    makeCreateDialog();
                    
                    createDialog.getProcedureData().setText(newProcedureName);
                    createDialog.getTriggerCombo().select(0);
                    createDialog.getAttrCheckBox().setSelection(true);
                    
                    createDialog.getOkButton().addSelectionListener(new SelectionListener(){
                        public void widgetSelected(SelectionEvent e) {
                            INtkProjectManager pman = NtkManager.getNtkProjectManager();
//                            WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(targetInstId);
                            String procedureName = createDialog.getProcedureData().getText().trim();
                            String functionName = createDialog.getFunctionData().getText().trim();
                            if(checkInputData(procedureName, functionName) == -1) {
                                return;
                            }

                            int index = createDialog.getTriggerCombo().getSelectionIndex();
                            int triggerNum = ((Integer)triggerTable.getNumberList().get(index)).intValue();
                            
                            int langType = pman.getCurrentProjectLangType();
                            String sourceExt = getSourceExt();
                            String fileName = pman.getCurrentProjectFullPath() + "/" + functionName + sourceExt;
                            String path = pman.getCurrentProjectName() + "/" + functionName + sourceExt;
                            String cname = null;
                            INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
                            long win = iman.getParentWindow(targetInstId);
                            if (iman.getUserLongData(win,Ntk.NTK_CLASS_DEF) == 1){
                                if (langType == Ntk.NTK_LANG_CPP){
                                    cname = iman.getProperty(win,"name",Ntk.NTK_EN_UTF8);
                                    fileName = pman.getCurrentProjectFullPath() + "/" + cname + "_" + functionName + sourceExt;
                                    path = pman.getCurrentProjectName() + "/" + cname + "_" + functionName + sourceExt;
                                }
                            }
                            if(pman.existFile(fileName) == false) {
                                validatePath(path,fileName);
                                pman.createProcedure( pman.getCurrentProjectFullPath(), functionName, langType, functionName, cname);
                                
                                openEditor(path);
                            } 
                            int procid = iman.addProcedure(targetInstId,procedureName, functionName, triggerNum);
                            String val = "true";
                            if (createDialog.getAttrCheckBox().getSelection() == false){
                                val = "false";
                            }
                            NtkManager.getNtkInstanceManager().setProcedureAttribute(procid,"independence",val);

                            updateProcedureList(null);                            
                            createDialog.getCreateProcedureDialog().close();
                        }
                        public void widgetDefaultSelected(SelectionEvent e) {}
                    });
                    createDialog.getCreateProcedureDialog().open();
                }
            };
            setActionProperties(createAction, createMenuTitle,
                    createMenuToolTipTitle, ISharedImages.IMG_TOOL_NEW_WIZARD);
            
            fixAction = new Action() {
                ArrayList triggerNameList = null;
                public void run() {
                    int selectedCombo = 0;
                    //ISelection selection = viewer.getSelection();
                    Object obj = ((IStructuredSelection)viewer.getSelection()).getFirstElement();
                    if (obj == null) {
                        openMsgDialog(
                                viewer.getControl().getShell(), "", null,
                                dMes_003, MessageDialog.WARNING, dBtnLbl2, 0);
                        return;
                    }
                    
                    ListElement element = (ListElement) obj;

                    makeCreateDialog();
                    createDialog.getInstanceData().setText(selectedInstanceName);
                    
                    createDialog.getProcedureData().setText(element.getProcedureName());
                    createDialog.getFunctionData().setText(element.getFunctionName());
                    createDialog.getAttrCheckBox().setSelection(element.getIndependentFile());
                    targetProcID = element.getId();
                                        
                    triggerNameList = triggerTable.getNameList();
                    for(int i = 0; i < triggerNameList.size(); i++) {
                        if(triggerNameList.get(i).equals(element.getTriggerName())){
                            selectedCombo = i;
                            break;
                        }
                    }
                    createDialog.getTriggerCombo().select(selectedCombo);
 
                    createDialog.getOkButton().setText(dBtn_003);
                    createDialog.getOkButton().addSelectionListener(new SelectionListener(){
                        public void widgetSelected(SelectionEvent e) {

                            String procedureName = createDialog.getProcedureData().getText().trim();
                            String functionName = createDialog.getFunctionData().getText().trim();
                            if(checkInputData(procedureName, functionName) == -1) {
                                return;
                            }

                            int index = createDialog.getTriggerCombo().getSelectionIndex();
                            int triggerNum = ((Integer)triggerTable.getNumberList().get(index)).intValue();
                            NtkManager.getNtkInstanceManager().configureProcedure(targetProcID,
                                     procedureName,functionName,triggerNum);
                            
                            String val = "true";
                            if (createDialog.getAttrCheckBox().getSelection() == false){
                                val = "false";
                            }
                            NtkManager.getNtkInstanceManager().setProcedureAttribute(targetProcID,"independence",val);

                            updateProcedureList(null);
                            
                            createDialog.getCreateProcedureDialog().close();
                        }
                        public void widgetDefaultSelected(SelectionEvent e) {}
                    });                    
                    createDialog.getCreateProcedureDialog().open();
                }
            };
            setActionProperties(fixAction, fixMenuTitle,
                    fixMenuToolTipTitle, ISharedImages.IMG_TOOL_UP);
            
            editAction = new Action() {
                public void run() {
                    openEditor();
                }
            };
            setActionProperties(editAction, editMenuTitle,
                    editMenuToolTipTitle, ISharedImages.IMG_DEF_VIEW);
            
            deleteAction = new Action() {
                public void run() {
                    //ISelection selection = viewer.getSelection();
                    Object obj = ((IStructuredSelection)viewer.getSelection()).getFirstElement();
                    if (obj == null) {
                        openMsgDialog(
                                viewer.getControl().getShell(), dTitle_001, null,
                                dMes_003, MessageDialog.WARNING, dBtnLbl2, 0);
                        return;
                    }
                    Object[] elements = ((IStructuredSelection)viewer.getSelection()).toArray();
                    int i;
                    int num = elements.length;
                    boolean need_update = false;
                    
                    boolean delall = false;
                    for(i=0; i<num; i++){
                        ListElement element = (ListElement) elements[i];
                        if (delall == true){
                            NtkManager.getNtkInstanceManager().delProcedure(targetInstId,new Long(element.getId()).intValue());
                            need_update = true;
                            continue;
                        }
                        if (num == 1){
                            int res = openMsgDialog(
                                    viewer.getControl().getShell(), "", null,
                                    dMes_del1 + element.procedureName + dMes_del2, MessageDialog.NONE, dBtnLbl, 0);
                            if(res == 0) {
                                NtkManager.getNtkInstanceManager().delProcedure(targetInstId,new Long(element.getId()).intValue());
                                need_update = true;
                            }
                        }else{
                            int res = openMsgDialog(
                                    viewer.getControl().getShell(), "", null,
                                    dMes_del1 + element.procedureName + dMes_del2, MessageDialog.NONE, dBtnLbl3, 0);
                            if(res == 0|| res == 1) {
                                if (res == 1){
                                    delall = true;
                                }
                                NtkManager.getNtkInstanceManager().delProcedure(targetInstId,new Long(element.getId()).intValue());
                                need_update = true;
                            }
                        }
                    }
                    if (need_update == true){
                        updateProcedureList(null);
                    }

                }
            };
            setActionProperties(deleteAction, deleteMenuTitle,
                    deleteMenuToolTipTitle, ISharedImages.IMG_TOOL_DELETE);
    
    		doubleClickAction = new Action() {
    			public void run() {
    			    openEditor();               
    			}
    		};
        } catch (Exception e) {
            System.err.println("MwtInstanceProcedureView makeActions() : " + e.toString());
        }
	}

    private int checkInputData(String pName, String fName) {
        // procedure data check
        if(pName == null || pName.equals("")) {
            openMsgDialog(
                    createDialog.getCreateProcedureDialog(), dTitle_001, null,
                    dMes_001, MessageDialog.WARNING, dBtnLbl2, 0);
            return -1;
        }
        // function data check
        if(fName == null || fName.equals("")) {
            openMsgDialog(
                    createDialog.getCreateProcedureDialog(), dTitle_001, null,
                    dMes_002, MessageDialog.WARNING, dBtnLbl2, 0);
            return -1;
        }
        boolean resflg = Utils.checkSpace(fName);
        if(resflg) {
            long existNameNum = NtkManager.getNtkInstanceManager().checkProcedureName(fName);
            if(existNameNum == 0 || existNameNum == Ntk.NTK_PROCEDURE_NAME) {
                return 0;
            //} else if(existNameNum == Mwt.WS_PROCEDURE_NAME) {
            //    openErrorDialog("WS_PROCEDURE_NAME");
            //    return;
            } else if(existNameNum == Ntk.NTK_OBJECT_NAME) {
                openErrorDialog("WS_OBJECT_NAME");
                return -1;
            } else if(existNameNum == Ntk.NTK_OBJECT_ARRAY_NAME) {
                openErrorDialog("WS_OBJECT_ARRAY_NAME");
                return -1;
            } else if(existNameNum == Ntk.NTK_OBJECT_ARRAY_NAME_INVALID) {
                openErrorDialog("WS_OBJECT_ARRAY_NAME_INVALID");
                return -1;
            } else if(existNameNum == Ntk.NTK_OTHER_NAME) {
                openErrorDialog("WS_OTHER_NAME");
                return -1;
            } else if(existNameNum == 6) {
                openErrorDialog("");
                return -1;
            } else {
                openErrorDialog("");
                return -1;
            }
        } else {
            openErrorDialog("space");
            return -1;
        }
    }
    
    private void openErrorDialog(String data){
        openMsgDialog(
                createDialog.getCreateProcedureDialog(), dTitle_001, null,
                dMes_002 + data, MessageDialog.WARNING, dBtnLbl2, 0);
    }
    
    private void setFileSelectAction(Button button) {
        button.addSelectionListener(new SelectionListener(){
            public void widgetSelected(SelectionEvent ev) {
                try{
                    // open color dialog                   
                    FileDialog fileDialog = new FileDialog(createDialog.getCreateProcedureDialog());
                    fileDialog.open();

                    String fileName = fileDialog.getFileName();

                    if(fileName == null || fileName.equals("")) {
                    } else {
                        String ext = fileName.substring(fileName.length() - 4, fileName.length());
                        String sourceExt = getSourceExt();

                        if(ext.equals(sourceExt)) {
                            createDialog.getFunctionData().setText(fileName.substring(0,fileName.length() - 4));
                        } else {
                            openMsgDialog(
                                    createDialog.getCreateProcedureDialog(), dTitle_001, null,
                                    dMes_005, MessageDialog.WARNING, dBtnLbl, 0);
                        }
                    }
                }catch(Exception e){
                    System.err.println("MwtInstanceProcedureView setFileSelectAction() : " + e.toString());
                }
            }
            public void widgetDefaultSelected(SelectionEvent e) {}
        });
    }
    
    private void setTemplateAction(Button button) {
        //setTemplateAction
        button.addSelectionListener(new SelectionListener(){
            public void widgetSelected(SelectionEvent ev) {
                try{
                    INtkProjectManager pman = NtkManager.getNtkProjectManager();
                    String functionName = createDialog.getFunctionData().getText();
                    
                    if(functionName == null || functionName.equals("")) {
                        openMsgDialog(
                                createDialog.getCreateProcedureDialog(), dTitle_001, null,
                                dMes_002, MessageDialog.WARNING, dBtnLbl2, 0);
                    } else {
                        String sourceExt = getSourceExt();
                        String fileName = pman.getCurrentProjectFullPath() + "/" + functionName + sourceExt;
                        String path = pman.getCurrentProjectName() + "/" + functionName + sourceExt;
                        int langType = NtkManager.getNtkProjectManager().getCurrentProjectLangType();
                        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
                        String cname = null;
                        long win = iman.getParentWindow(targetInstId);

                        if (iman.getUserLongData(win,Ntk.NTK_CLASS_DEF) == 1 && langType == Ntk.NTK_LANG_CPP ){
                            cname = iman.getProperty(win,"name",Ntk.NTK_EN_UTF8);
                            fileName = pman.getCurrentProjectFullPath() + "/" + cname + "_" + functionName + sourceExt;
                            path = pman.getCurrentProjectName() + "/" + cname + "_" + functionName + sourceExt;

                        }

                        int res1 = openMsgDialog(
                                createDialog.getCreateProcedureDialog(), "", null,
                                createMessage1 + fileName + " " + createMessage2,
                                MessageDialog.NONE, dBtnLbl, 0);
                        if(res1 == 0) {

                            if(pman.existFile(fileName) == true) {
                                int res2 = openMsgDialog(
                                        createDialog.getCreateProcedureDialog(), "", null,
                                        dMes_007 + fileName + " " + dMes_008,
                                        MessageDialog.NONE, dBtnLbl, 0);
                                if(res2 == 0){
                                    validatePath(path,fileName);
                                    pman.createProcedure(
                                            pman.getCurrentProjectFullPath(), functionName, langType, functionName, cname);
                                    openEditor(path);
                                }
                            } else {
                                validatePath(path,fileName);
                                pman.createProcedure(
                                        pman.getCurrentProjectFullPath(), functionName, langType, functionName, cname);
                                openEditor(path);
                            }
                        }
                    }
                }catch(Exception e){
                    System.err.println("MwtInstanceProcedureView setFileSelectAction() : " + e.toString());
                }
            }
            public void widgetDefaultSelected(SelectionEvent e) {}
        });
    }
    
    private void setCancelAction(Button button) {
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                createDialog.getCreateProcedureDialog().close();
            }
            public void widgetDefaultSelected(SelectionEvent e) {}                 
        });
    }
    
    private void setActionProperties(
            Action action, String text, String toolTipText, String image) {
        action.setText(text);
        action.setToolTipText(toolTipText);
        action.setImageDescriptor(
                PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(image));
    }
    
    private void openEditor() {
        
        try {
            INtkProjectManager pman = NtkManager.getNtkProjectManager();
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

            Object obj = ((IStructuredSelection)viewer.getSelection()).getFirstElement();
            if (obj == null) {
                MessageDialog dlg = new MessageDialog(
                        viewer.getControl().getShell(), dTitle_001, null, dMes_003,
                        MessageDialog.WARNING, new String[] { dBtn_001, dBtn_002 }, 0);
                dlg.open();
                return;
            }            
            ListElement element = (ListElement) obj;
            String sourceExt = getSourceExt();

			String fileName = pman.getProjectPath() + "/" + element.getFunctionName() + sourceExt;
            int langType = NtkManager.getNtkProjectManager().getCurrentProjectLangType();

            INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
            NtkManager.getNtkContext().lock();
            long win = iman.getParentWindow(targetInstId);
            if (iman.getUserLongData(win,Ntk.NTK_CLASS_DEF) == 1){
                if (langType == Ntk.NTK_LANG_CPP){
                    String cname = iman.getProperty(win,"name",Ntk.NTK_EN_UTF8);
                    fileName = pman.getProjectPath() + "/" + cname + "_" + element.getFunctionName() + sourceExt;
                }
            }
            NtkManager.getNtkContext().unlock();

            
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = workspaceRoot.getFile(new Path(fileName).makeAbsolute());

            String editorID = null;
            if (langType == Ntk.NTK_LANG_CPP){
                editorID = "org.eclipse.cdt.ui.editor.CEditor";
            }else if (langType == Ntk.NTK_LANG_JAVA){
                editorID = "org.eclipse.jdt.ui.CompilationUnitEditor";
                
            }else{
                editorID = "org.eclipse.ui.DefaultTextEditor";
            }

            //IEditorPart ab = IDE.openEditor(page,new FileEditorInput(file),"org.eclipse.jdt.ui.CompilationUnitEditor");
            //IEditorPart ab = IDE.openEditor(page,new FileEditorInput(file),"org.eclipse.cdt.ui.editors.textfont");
//            IEditorPart ep = IDE.openEditor(page,new FileEditorInput(file),"org.eclipse.ui.DefaultTextEditor");
          IEditorPart ep = IDE.openEditor(page,new FileEditorInput(file),editorID);

        } catch (Exception e) {    
            System.err.println("MwtInstanceProcedureView openEditor() : " + e.toString());
        }
    }
    private void openEditor(String path) {
        
        try {
            int langType = NtkManager.getNtkProjectManager().getCurrentProjectLangType();
            String editorID = null;
            if (langType == Ntk.NTK_LANG_CPP){
                editorID = "org.eclipse.cdt.ui.editor.CEditor";
            }else if (langType == Ntk.NTK_LANG_JAVA){
                editorID = "org.eclipse.jdt.ui.CompilationUnitEditor";
                
            }else{
                editorID = "org.eclipse.ui.DefaultTextEditor";
            }

            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = workspaceRoot.getFile(new Path(path).makeAbsolute());
            IEditorPart ep = IDE.openEditor(page,new FileEditorInput(file),editorID);
        } catch (Exception e) {    
            System.err.println("MwtInstanceProcedureView openEditor(path) : " + e.toString());
        }
    }
	private void hookDoubleClickAction() {
		viewer.addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {
				doubleClickAction.run();
			}
		});
	}
	private void showMessage(String message) {
		MessageDialog.openInformation(
			viewer.getControl().getShell(),
			"Dialog",
			message);
	}

	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
		viewer.getControl().setFocus();
	}
    
    private void getMwtProcedureData(){
        String triggerName = null;
        int triggerNumber = 0;
        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
        INtkContext context = NtkManager.getNtkContext();
        try{
            context.lock();
        }catch(Exception e){
            System.err.println("MwtInstanceProcedureView.getMwtProcedureData e="+e);
            return;
        }

        try{ 
            /* do something...*/
            long selectedId = Ntk.NTK_ROOT_INSTANCE_ID;
            long targetCount = 0;
            
            if (procList == null){
                procList = new ArrayList();
            }else{
                procList.clear();
            }
            
            while(true){
                
                long selectedNext = iman.getInstanceId(selectedId, Ntk.NTK_NEXT_SELECTED_INSTANCE_ID, 0);
                if (selectedNext == 0){
                    break;
                }
                targetCount++;
                selectedId = selectedNext;
            }
            if (targetCount > 1 || targetCount == 0){
            //if (targetCount > 1){
                targetInstId = 0;
                return;
            }

            targetInstId = selectedId;
            
            triggerTable = new TriggerTable();
            
            selectedInstanceName = iman.getProperty(targetInstId,"name",Ntk.NTK_EN_UTF8);
            
            long childId = Ntk.NTK_ROOT_INSTANCE_ID;
    
            while(true){
                long childNext = iman.getInstanceId(targetInstId, Ntk.NTK_NEXT_PROCEDURE_ID, childId);
                if (childNext == 0){
                    break;
                }
                ListElement Element = new ListElement();

                triggerNumber = iman.getTrigger(childNext);
                triggerName = triggerTable.getTriggerName(triggerNumber);

                Element.setProcedureName(iman.getProcedureName(childNext));
                Element.setTriggerName(triggerName);
                //Element.setTriggerNumber(triggerNumber);
                Element.setFunctionName(iman.getFunctionName(childNext));
                String attr = iman.getProcedureAttribute(childNext,"independence");
                if (attr.compareTo("true")==0){
                    Element.setIndependentFile(true);
                }else{
                    Element.setIndependentFile(false);
                }
                Element.setId(childNext);
                
                procList.add(Element);
                           
                childId = childNext;
    
            }
        }catch(Exception e){
            System.err.println("MwtInstanceProcedureView getMwtProcedureData() : " + e.toString());        
        }finally{
            context.unlock();
        } 
    }
    String getSourceExt(){
        int langType = NtkManager.getNtkProjectManager().getCurrentProjectLangType();
        String sourceExt = ".cpp";
        if (langType == Ntk.NTK_LANG_CPP){
            sourceExt = ".cpp";
        }else if (langType == Ntk.NTK_LANG_JAVA){
            sourceExt = ".java";
        }else if (langType == Ntk.NTK_LANG_PYTHON){
            sourceExt = ".py";
        }else if (langType == Ntk.NTK_LANG_RUBY){
            sourceExt = ".rb";
        }else if (langType == Ntk.NTK_LANG_PERL){
            sourceExt = ".pl";
        }else if (langType == Ntk.NTK_LANG_OCAML){
            sourceExt = ".ml";
        }
        return sourceExt;
    }
}
