/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.core;

import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.nab.core.Ntk;
import org.eclipse.nab.core.NtkManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.*;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;


public class MwtNewProjectWizard extends BasicNewProjectResourceWizard
implements IExecutableExtension {
    private static final String PAGE_TITLE1 = UIMessages.getString("MwtNewProjectWizardPage.pageTitle1"); //$NON-NLS-1$
    
    MwtNewProjectWizardPage page;    
    private ISelection selection;
    
    public MwtNewProjectWizard() {
        super();

    }
    public void addPages(){
        page = new MwtNewProjectWizardPage(selection);
        addPage(page);
        setWindowTitle(PAGE_TITLE1);
        super.addPages();
    }
    public boolean performFinish() {
        boolean ret = super.performFinish();
        IProject prj = super.getNewProject();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int num = projects.length;
        int i;
        for(i=0; i<num; i++){
            if (projects[i] != prj){
                try{
                    if (projects[i].isOpen() == true){
                        if (projects[i].hasNature(NtkManager.getNtkProjectManager().getNatureId()) == true){
                            projects[i].close(null);
                        }
                    }
                }catch(CoreException e){
                    System.err.println("MwtImportProjectWizard.performFinish exception: project close e="+e);
                }
            }
        }
        
        
        String lang = page.getLang();
        NtkManager.getNtkProjectManager().configureNtkProject(prj,lang);
        NtkManager.getNtkProjectManager().createNewNtkProject(prj.getName());   
        long current_project = NtkManager.getNtkProjectManager().getCurrentProject();
        NtkManager.getNtkProjectManager().setProjectData(current_project,"#LANG",lang,Ntk.NTK_EN_DEFAULT);
        NtkManager.getNtkProjectManager().createCurrentNtkProjectSources();
        NtkManager.getNtkProjectManager().saveNtkProject(prj);
        return ret;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        super.init(workbench,selection);
    }
}
