/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.core;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.internal.formatter.align.Alignment;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.nab.core.INtkContext;
import org.eclipse.nab.core.INtkInstanceManager;
import org.eclipse.nab.core.INtkProjectManager;
import org.eclipse.nab.core.Ntk;
import org.eclipse.nab.core.NtkManager;

public class MwtProjectClassLibraryPage extends PropertyPage {

    private static final String ADD_BTN_TITLE = UIMessages.getString("MwtProjectClassLibraryPage.addBtnTitle"); //$NON-NLS-1$
    private static final String DEL_BTN_TITLE = UIMessages.getString("MwtProjectClassLibraryPage.delBtnTitle"); //$NON-NLS-1$


    private static final int BTN_WIDTH = 200;
    private static final int BTN_HEIGHT = 25;
    private static final int BTN_SPACE = 10;
    private static final int AREA_HEIGHT = 400;
    
    private Composite base = null;
    private TableViewer viewer = null;
    private ArrayList list = null;

    class ListElement {
        public String libname;
    }
    
    class ViewContentProvider implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            java.util.List array = (java.util.List)inputElement;
            return array.toArray();
        }
        public void dispose() {
        }
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
    
    class ViewLabelProvider extends LabelProvider implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            ListElement Element = (ListElement) obj;
            switch(index){
                case 0:
                return Element.libname;
            }
            return null;
        }
        
        public String getText(Object obj) {
            ListElement Element = (ListElement) obj;
            return Element.libname;
        }
        
        public Image getColumnImage(Object obj, int index) {
            switch(index){
                case 0:
                return getImage(obj);
            }
            return null;
        }
        
        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages.IMG_OBJ_FILE);
        }
    }
    class NameSorter extends ViewerSorter {
    }
    
	/**
	 * Constructor for MwtProjectCompilerPropertyPage.
	 */
	public MwtProjectClassLibraryPage() {
		super();
	}

	private void addSeparator(Composite parent) {
		Label separator = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		separator.setLayoutData(gridData);
	}




    private void addLibrarySection(Composite parent) {
        Composite composite = createDefaultComposite(parent);

    }


    protected void reloadValues(){
        INtkProjectManager pman = NtkManager.getNtkProjectManager();
        long prj = pman.getCurrentProject();
        
        String str = pman.getProjectData(prj,"#WS_DLL",Ntk.NTK_EN_DEFAULT);
        list = null;
        list = new ArrayList();
        String[] llist = str.split(",");
        int num = llist.length;
        int i;
        for(i=0; i<num; i++){
            if (llist[i].compareTo("") == 0){
                continue;
            }
            ListElement item = new ListElement();
            item.libname = llist[i];
            list.add(item);
        }
        num = list.size();
        if (num > 0){
            viewer.setInput(list);
        }else{
            viewer.setInput(null);
        }
    }
	protected Control createContents(Composite parent) {
        base = createDefaultComposite(parent);

        viewer = new TableViewer(base, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.BORDER);
        viewer.setContentProvider(new ArrayContentProvider());
        viewer.setLabelProvider(new ViewLabelProvider());
        viewer.setSorter(new NameSorter());
        GridData gdt1 = new GridData();
        gdt1.widthHint = GridData.FILL_HORIZONTAL;
        gdt1.heightHint = AREA_HEIGHT;
        viewer.getTable().setLayoutData(gdt1);


        Composite cmd_area = new Composite(base, SWT.NONE);
//        cmd_area.setBackground(new Color(null,255,255,255));
        GridData gdt = new GridData();
        gdt.widthHint = BTN_WIDTH;
        gdt.heightHint = AREA_HEIGHT;
        cmd_area.setLayoutData(gdt);


        Button addBtn = new Button(cmd_area, 0);
        addBtn.addSelectionListener(new SelectionListener(){
            public void widgetSelected(SelectionEvent e) {
                try{
                    // open color dialog                   
                    FileDialog fileDialog = new FileDialog(base.getShell());
                    String filename = fileDialog.open();
                    if (filename == null){
                        return;
                    }
                    int num = list.size();
                    int i;
                    boolean exist = false;
                    for(i=0; i<num; i++){
                        ListElement element = (ListElement)list.get(i);
                        if (element.libname.compareTo(filename) == 0){
                            exist = true;
                            break;
                        }
                    }
                    if (exist == false){
                        ListElement item = new ListElement();
                        item.libname = filename;
                        list.add(item);
                        viewer.setInput(list);
                    }
                }catch(Exception ex){
                    System.err.println("MwtInstancePropertyView setFileSelectAction() : " + e.toString());
                }
            }
            public void widgetDefaultSelected(SelectionEvent e) {}          
        });
        
        addBtn.setLocation(0,0);
        addBtn.setSize(BTN_WIDTH,BTN_HEIGHT);
        addBtn.setText(ADD_BTN_TITLE);
    
        Button delBtn = new Button(cmd_area, 0);
        delBtn.addSelectionListener(new SelectionListener(){
            public void widgetSelected(SelectionEvent e) {
                try{
                    ISelection selection = viewer.getSelection();
                    List selectionList = ((IStructuredSelection)selection).toList();
                    int i;
                    int num = selectionList.size();
                    if (num > 0){
                        for(i=0;i<selectionList.size();i++){
                            Object obj = selectionList.get(i);
                            ListElement element = (ListElement) obj;
                            int lnum = list.size();
                            int j;
                            for(j=0; j<lnum; j++){
                                ListElement item = (ListElement)list.get(j);
                                if (item.libname.compareTo(element.libname) == 0){
                                    list.remove(item);
                                }
                            }
                        }
                        viewer.setInput(list);
                    }
                }catch(Exception ex){
                    System.err.println("MwtInstancePropertyView setFileSelectAction() : " + e.toString());
                }
            }
            public void widgetDefaultSelected(SelectionEvent e) {}          
        });
        
        delBtn.setLocation(0,BTN_HEIGHT+BTN_SPACE);
        delBtn.setSize(BTN_WIDTH,BTN_HEIGHT);
        delBtn.setText(DEL_BTN_TITLE);
    
        
        
        
        reloadValues();

		return base;
	}

	private Composite createDefaultComposite(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		composite.setLayout(layout);
		return composite;
	}

	protected void performDefaults() {
        int langType = NtkManager.getNtkProjectManager().getCurrentProjectLangType();
        if (langType != Ntk.NTK_LANG_CPP){
            return;
        }

	    INtkProjectManager pman = NtkManager.getNtkProjectManager();
        long prj = pman.getCurrentProject();
        String str = pman.getProjectDefaultData(prj,"#WS_DLL",Ntk.NTK_EN_DEFAULT);
    }
	
	public boolean performOk() {
		try {
            
            INtkProjectManager pman = NtkManager.getNtkProjectManager();
            long prj = pman.getCurrentProject();
            String str = "";
            int num = list.size();
            if (num > 0){
                ListElement item = (ListElement)list.get(0);
                str = item.libname;
                if (num > 1){
                    int i=0;
                    for(i=1; i<num; i++){
                        item = (ListElement)list.get(i);
                        str += ",";
                        str += item.libname;
                    }
                }
            }
            pman.setProjectData(prj,"#WS_DLL",str,Ntk.NTK_EN_DEFAULT);

            
		} catch (Exception e) {
			return false;
		}
		return true;
	}

}
