/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.view;

import java.net.URL;

import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.nab.mwt.ab.core.CorePlugin;
import org.eclipse.nab.mwt.ab.core.UIMessages;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Shell;

public class CreateProcedureDialog {
    private static final String dbtn_001 = UIMessages.getString("CreateProcedureDialog.dialogOk"); //$NON-NLS-1$
    private static final String dbtn_002 = UIMessages.getString("CreateProcedureDialog.dialogCancel"); //$NON-NLS-1$
    private static final String dialogTitle = UIMessages.getString("CreateProcedureDialog.dialogTitle"); //$NON-NLS-1$
    private static final String instanceLabel = UIMessages.getString("CreateProcedureDialog.instanceLabel"); //$NON-NLS-1$
    private static final String pnameLabel = UIMessages.getString("CreateProcedureDialog.pnameLabel"); //$NON-NLS-1$
    private static final String fnameLabel = UIMessages.getString("CreateProcedureDialog.fnameLabel"); //$NON-NLS-1$
    private static final String triggerLabel = UIMessages.getString("CreateProcedureDialog.triggerLabel"); //$NON-NLS-1$
    private static final String fileLabel = UIMessages.getString("CreateProcedureDialog.fileLabel"); //$NON-NLS-1$
    private static final String templateLabel = UIMessages.getString("CreateProcedureDialog.templateLabel"); //$NON-NLS-1$
    private static final String attrLabel = UIMessages.getString("CreateProcedureDialog.attrLabel"); //$NON-NLS-1$

    private Shell sShell = null;  //  @jve:decl-index=0:visual-constraint="234,22"
    //private Dialog dDialog = null;
    private Label instanceTitle = null;
    private Label instanceData = null;
    //private Label label = null;
    private Label procedureTitle = null;
    private Text procedureData = null;
    private Label triggerTitle = null;
    private Combo triggerCombo = null;
    private Label functionTitle = null;
    private Text functionData = null;
    private Button fileSelectButton = null;
    private Button templateButton = null;
    private Button attrCheckBox = null;
    private Label attrCheckBoxTitle = null;
    private Button okButton = null;
    private Button cancelButton = null;
    
	public void createSShell() {

        createDialog();
        createInstanceTitle();
        createInstanceField();
        createProcedureTitle();
        createProcedureInputField();
        createFunctionTitle();
        createFunctionInputField();
        createTriggerTitle();
        createTriggerCombo();
        createFileSelectButton();
        createTemplateButton();
        createAttrCheckBoxTitle();
        createAttrCheckBox();
        createOkButton();
        createCancelButton();
      
    }
    private void createDialog() {
        sShell = new Shell(SWT.BORDER | SWT.SHELL_TRIM | SWT.APPLICATION_MODAL);
        sShell.setText(dialogTitle);
        sShell.setSize(new Point(355, 221));
        try{
            URL url = CorePlugin.getDefault().find(new Path("icons/main.png"));
            if (url != null){
                ImageDescriptor id = ImageDescriptor.createFromURL(url);
                Image image = id.createImage();

                sShell.setImage(image);
            }
        }catch(Exception e){
            System.err.println("CreateProcedureDialog.createDialog() e="+e);
        }
    }    
    private void createInstanceTitle() {
        instanceTitle = new Label(sShell, SWT.RIGHT);
        instanceTitle.setText(instanceLabel);
        instanceTitle.setBounds(new Rectangle(40, 7, 100, 20));
        instanceTitle.setFont(
                new Font(Display.getDefault(), "MS UI Gothic", 9, SWT.BOLD));
    }
    private void createInstanceField() {
        instanceData = new Label(sShell, SWT.NONE);
        instanceData.setBounds(new Rectangle(150, 7, 140, 20));
//        instanceData.setText("");
        instanceData.setFont(
                new Font(Display.getDefault(), "MS UI Gothic", 9, SWT.BOLD));
    }
    private void createProcedureTitle() {
        procedureTitle = new Label(sShell, SWT.RIGHT);
        procedureTitle.setText(pnameLabel);
        procedureTitle.setBounds(new Rectangle(0, 35, 140, 20));
        procedureTitle.setFont(
                new Font(Display.getDefault(), "MS UI Gothic", 9, SWT.BOLD));
    }
    private void createProcedureInputField() {
        procedureData = new Text(sShell, SWT.BORDER);
        procedureData.setBounds(new Rectangle(150, 35, 140, 20));
        procedureData.setFont(
                new Font(Display.getDefault(), "MS UI Gothic", 9, SWT.BOLD));
    }
    private void createFunctionTitle() {
        functionTitle = new Label(sShell, SWT.RIGHT);
        functionTitle.setBounds(new Rectangle(0, 55, 140, 20));
        functionTitle.setText(fnameLabel);
        functionTitle.setFont(
                new Font(Display.getDefault(), "MS UI Gothic", 9, SWT.BOLD)); 
    }
    private void createFunctionInputField() {
        functionData = new Text(sShell, SWT.BORDER);
        functionData.setBounds(new Rectangle(150, 55, 140, 20));
        functionData.setFont(
                new Font(Display.getDefault(), "MS UI Gothic", 9, SWT.BOLD));
    }
    private void createTriggerTitle() {
        triggerTitle = new Label(sShell, SWT.RIGHT);
        triggerTitle.setBounds(new Rectangle(0, 75, 140, 20));
        triggerTitle.setText(triggerLabel);
        triggerTitle.setFont(
                new Font(Display.getDefault(), "MS UI Gothic", 9, SWT.BOLD));
    }
    private void createTriggerCombo() {
        triggerCombo = new Combo(sShell, SWT.READ_ONLY);
        triggerCombo.setBounds(new Rectangle(150, 75, 140, 20));
        triggerCombo.setFont(new Font(Display.getDefault(), "MS UI Gothic", 9, SWT.BOLD));
    }
    private void createFileSelectButton() {
        fileSelectButton = new Button(sShell, SWT.NONE);
        fileSelectButton.setBounds(new Rectangle(110, 100, 90, 22));
        fileSelectButton.setText(fileLabel);
        fileSelectButton.setFont(
                new Font(Display.getDefault(), "MS UI Gothic", 9, SWT.BOLD));
    }
    private void createTemplateButton() {
        templateButton = new Button(sShell, SWT.NONE);
        templateButton.setBounds(new Rectangle(200, 100, 90, 22));
        templateButton.setText(templateLabel);
        templateButton.setFont(
                new Font(Display.getDefault(), "MS UI Gothic", 9, SWT.BOLD));
    }
    private void createAttrCheckBoxTitle() {
        attrCheckBoxTitle = new Label(sShell, SWT.NONE);
        attrCheckBoxTitle.setBounds(new Rectangle(140, 128, 150, 22));
        attrCheckBoxTitle.setText(attrLabel);
        attrCheckBoxTitle.setFont(
                new Font(Display.getDefault(), "MS UI Gothic", 9, SWT.BOLD));
    }
    private void createAttrCheckBox() {
        attrCheckBox = new Button(sShell, SWT.CHECK);
        attrCheckBox.setBounds(new Rectangle(120, 125, 16, 18));
        attrCheckBox.setFont(
                new Font(Display.getDefault(), "MS UI Gothic", 9, SWT.BOLD));
    }
    private void createOkButton() {
        okButton = new Button(sShell, SWT.NONE);
        okButton.setBounds(new Rectangle(125, 160, 90, 22));
        okButton.setText(dbtn_001);
        okButton.setFont(
                new Font(Display.getDefault(), "MS UI Gothic", 9, SWT.BOLD));
    }
    private void createCancelButton() {
        cancelButton = new Button(sShell, SWT.NONE);
        cancelButton.setBounds(new Rectangle(220, 160, 90, 22));
        cancelButton.setText(dbtn_002);
        cancelButton.setFont(
                new Font(Display.getDefault(), "MS UI Gothic", 9, SWT.BOLD));
    }    
    public Shell getCreateProcedureDialog() {
        return sShell;
    }
    public Label getInstanceData() {
        return instanceData;
    }
    public Text getProcedureData() {
        return procedureData;
    }
    public Combo getTriggerCombo() {
        return triggerCombo;
    }
    public Text getFunctionData() {
        return functionData;
    }
    public Button getFileSelectButton() {
        return fileSelectButton;
    }
    public Button getTemplateButton() {
        return templateButton;
    }
    public Button getAttrCheckBox() {
        return attrCheckBox;
    }
    public Button getOkButton() {
        return okButton;
    }
    public Button getCancelButton() {
        return cancelButton;
    }
 }
