/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ntkif;

import org.eclipse.nab.core.INtkContext;
import org.eclipse.nab.core.Ntk;
import org.widestudio.mwt.Mwt;
import org.widestudio.mwt.WSDappDev;

public class MwtContext implements INtkContext{
    public MwtContext() {}
    public int lock() throws Exception{
        long ret = Mwt.WSGIappDev().lock();
        if (ret == Mwt.WS_NO_ERR){
            return Ntk.NTK_NO_ERR;
        }
        throw new Exception();
//        return Ntk.NTK_ERR;
    }
    public int unlock(){
        long ret = Mwt.WSGIappDev().unlock();
        if (ret == Mwt.WS_NO_ERR){
            return Ntk.NTK_NO_ERR;
        }
        return Ntk.NTK_ERR;
    }
    public int execEventProc(String procName){
        Mwt.WSGIappObjectList().execEventProc(procName);
        return Ntk.NTK_NO_ERR;
    }
    public int setRebaseHandle(int handle){
        Mwt.WSGIappDev().setRebaseHandle(handle);
        return Ntk.NTK_NO_ERR;
    }
}
