#!/bin/sh
#*******************************************************************************
# Copyright (c) 2006, 2008 Wind River Systems, Inc.
# All rights reserved. This program and the accompanying materials 
# are made available under the terms of the Eclipse Public License v1.0 
# which accompanies this distribution, and is available at 
# http://www.eclipse.org/legal/epl-v10.html 
# 
# Contributors: 
# Martin Oberhuber - initial API and implementation 
#*******************************************************************************
# Convert normal "site.xml" to "testUpdates"
#
# Prerequisites: 
# - Eclipse 3.3Mx installed in $HOME/ws2/eclipse
# - Java5 in the PATH or in /shared/dsdp/tm/ibm-java2-ppc64-50

curdir=`pwd`
cd `dirname $0`
mydir=`pwd`
cd "${curdir}"

umask 022

#Use Java5 on build.eclipse.org - need JRE for pack200
JDK=/shared/dsdp/JDKs/ibm-java2-ppc-50
if [ ! -d ${JDK} ]; then
   HOST=`hostname`
   echo "${HOST}: JDK missing in ${JDK}"
   exit 1
fi
export PATH=${JDK}/jre/bin:${JDK}/bin:$PATH

#Get an Eclipse Basebuilder
basebuilder=${HOME}/org.eclipse.releng.basebuilder
basebuilderTag=RC2_34
if [ ! -f ${basebuilder}/plugins/org.eclipse.pde.core_3.4.0.v20080515-2000.jar \
  -o ! -f ${basebuilder}/plugins/org.eclipse.pde.build_3.4.0.v20080522/pdebuild.jar \
  -o ! -f ${basebuilder}/plugins/org.eclipse.equinox.p2.metadata.generator_1.0.0.v20080523-0001.jar ]; then
  if [ -d ${basebuilder} ]; then
    echo "Re-getting basebuilder from CVS..."
    rm -rf org.eclipse.releng.basebuilder
  else
    echo "Getting basebuilder from CVS..."
  fi
  bb_parent=`dirname "${basebuilder}"`
  if [ ! -d "${bb_parent}" ]; then
      mkdir -p "${bb_parent}"
      if [ ! -d "${bb_parent}" ]; then
        echo "Failed to create ${bb_parent}"
        exit 1
      fi
  fi
  cd "${bb_parent}"
  cvs -Q -d :pserver:anonymous@dev.eclipse.org:/cvsroot/eclipse co -r ${basebuilderTag} org.eclipse.releng.basebuilder
fi

#chdir to site
cd "${mydir}/.."
SITE=`pwd`
cd "${curdir}"

# optimize the site
# see http://wiki.eclipse.org/Platform-releng-faq
echo "Packing the site... $SITE"
# Workaround for downgrading effort of pack200 to avoid VM bug
# See https://bugs.eclipse.org/bugs/show_bug.cgi?id=154069
#java -Dorg.eclipse.update.jarprocessor.pack200=$mydir \
java -jar ${basebuilder}/plugins/org.eclipse.equinox.launcher.jar \
  -application org.eclipse.update.core.siteOptimizer \
  -jarProcessor -outputDir $SITE \
  -processAll -pack $SITE

#Create the digest
echo "Creating digest..."
java -jar ${basebuilder}/plugins/org.eclipse.equinox.launcher.jar \
    -application org.eclipse.update.core.siteOptimizer \
    -digestBuilder -digestOutputDir=$SITE \
    -siteXML=$SITE/site.xml

#Create P2 metadata
echo "Creating P2 metadata..."
#Always create from scratch
cd ${SITE}
for x in content.xml content.jar content.jar.pack.gz artifacts.xml artifacts.jar artifacts.jar.pack.gz ; do
  if [ -f $x ]; then rm -f $x; fi
done
java -jar ${basebuilder}/plugins/org.eclipse.equinox.launcher.jar \
    -application org.eclipse.equinox.p2.metadata.generator.EclipseGenerator \
    -updateSite ${SITE}/ \
    -site file:${SITE}/site.xml \
    -metadataRepository file:${SITE}/ \
    -metadataRepositoryName "NAB Update Site" \
    -artifactRepository file:${SITE}/ \
    -artifactRepositoryName "NAB Artifacts" \
    -compress \
    -reusePack200Files \
    -noDefaultIUs \
    -vmargs -Xmx256M

cd "${SITE}"
chgrp -R dsdp-nabadmin .
chmod -R g+w .
chmod -R a+r .
cd "${curdir}"
