/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.core;

import java.util.ArrayList;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.nab.core.INtkProjectManager;
import org.eclipse.nab.core.Ntk;
import org.eclipse.nab.core.NtkManager;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;


public class MwtNewProjectWizardPage extends WizardPage {
    private static final String PAGE_TITLE1 = UIMessages.getString("MwtNewProjectWizardPage.pageTitle1"); //$NON-NLS-1$
    private static final String PAGE_TITLE2 = UIMessages.getString("MwtNewProjectWizardPage.pageTitle2"); //$NON-NLS-1$
    private static final String LANG_TITLE = UIMessages.getString("MwtNewProjectWizardPage.langTitle"); //$NON-NLS-1$
//    private static final String BBTN_TITLE = UIMessages.getString("MwtNewProjectWizardPage.bbtnTitle"); //$NON-NLS-1$
//    private static final String STATUS_MESSAGE1 = UIMessages.getString("MwtNewProjectWizardPage.statusMessage1"); //$NON-NLS-1$
//    private static final String STATUS_MESSAGE2 = UIMessages.getString("MwtNewProjectWizardPage.statusMessage2"); //$NON-NLS-1$
//    private static final String STATUS_MESSAGE3 = UIMessages.getString("MwtNewProjectWizardPage.statusMessage3"); //$NON-NLS-1$

    
	private Text containerText;
	private Text fileText;
	private ISelection selection;
    private Combo langTypeCombo;

	public MwtNewProjectWizardPage(ISelection selection) {
		super("wizardPage");
		setTitle(PAGE_TITLE1);
		setDescription(PAGE_TITLE2);
		this.selection = selection;
	}

	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 3;
		layout.verticalSpacing = 9;
		Label label = new Label(container, SWT.NULL);
		label.setText(LANG_TITLE);

        langTypeCombo = new Combo(container, SWT.READ_ONLY);
        INtkProjectManager pman = NtkManager.getNtkProjectManager();
        ArrayList itemNameArray = new ArrayList();
        ArrayList itemValueArray = new ArrayList();

        long cnt = 0;
        String firstitem = pman.getStaticData(Ntk.NTK_LANG_STR,cnt,Ntk.NTK_EN_DEFAULT);
        while(true){
            String item = pman.getStaticData(Ntk.NTK_LANG_STR,cnt,Ntk.NTK_EN_DEFAULT);
            itemNameArray.add(item);
            Long val = new Long(cnt);
            itemValueArray.add(val);
            cnt = pman.getStaticData(Ntk.NTK_NEXT_LANG_ID,cnt);
            if (cnt != Ntk.NTK_LANG_CPP && cnt != Ntk.NTK_LANG_JAVA){
                break;
            }
        }
        langTypeCombo.setItems((String[]) itemNameArray.toArray(new String[0]));
        langTypeCombo.setText(firstitem);
        GridData gd = new GridData(GridData.FILL_HORIZONTAL);
        langTypeCombo.setLayoutData(gd);
        
		setControl(container);
	}

	private void updateStatus(String message) {
		setErrorMessage(message);
		setPageComplete(message == null);
	}

    public String getLang(){
        return langTypeCombo.getText();
    }
}
