/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.core;

import java.util.ArrayList;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.internal.formatter.align.Alignment;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.nab.core.INtkContext;
import org.eclipse.nab.core.INtkProjectManager;
import org.eclipse.nab.core.Ntk;
import org.eclipse.nab.core.NtkManager;
import org.eclipse.nab.mwt.ab.view.MwtInstancePropertyView.MwtPropertyData;

public class MwtProjectPropertyPage extends PropertyPage {

    private static final String ENCODE_TITLE = UIMessages.getString("MiscPropertyPage.encodeTitle"); //$NON-NLS-1$
    private static final String APP_TYPE_TITLE = UIMessages.getString("MiscPropertyPage.appTypeTitle"); //$NON-NLS-1$
    private static final String TARGET_TITLE = UIMessages.getString("MiscPropertyPage.targetTitle"); //$NON-NLS-1$
    private static final String UPDATE_MESSAGE = UIMessages.getString("MiscPropertyPage.updateDialogMessage"); //$NON-NLS-1$
    private static final String INCLUDE_PATH_TITLE = UIMessages.getString("CompilerPropertyPage.includePathTitle"); //$NON-NLS-1$
    private static final String COMPILER_FLAGS_TITLE = UIMessages.getString("CompilerPropertyPage.compilerFlagsTitle"); //$NON-NLS-1$
    private static final String COMPILER_TITLE = UIMessages.getString("CompilerPropertyPage.compilerTitle"); //$NON-NLS-1$
    private static final String COMPILE_MODE_TITLE = UIMessages.getString("CompilerPropertyPage.compileModeTitle"); //$NON-NLS-1$
    private static final String COMPILE_MODE_TITLE2 = UIMessages.getString("CompilerPropertyPage.compileModeTitle2"); //$NON-NLS-1$
    private static final String CINDEX_TITLE1 = UIMessages.getString("CompilerPropertyPage.indexTitle1"); //$NON-NLS-1$
    private static final String CINDEX_TITLE2 = UIMessages.getString("CompilerPropertyPage.indexTitle2"); //$NON-NLS-1$
    private static final String INCLUDE_PATH_TITLE2 = UIMessages.getString("CompilerPropertyPage.includePathTitle2"); //$NON-NLS-1$
    private static final String COMPILER_FLAGS_TITLE2 = UIMessages.getString("CompilerPropertyPage.compilerFlagsTitle2"); //$NON-NLS-1$
    private static final String LIB_TITLE = UIMessages.getString("LinkerPropertyPage.libTitle"); //$NON-NLS-1$
    private static final String LINKER_FLAGS_TITLE = UIMessages.getString("LinkerPropertyPage.linkerFlagsTitle"); //$NON-NLS-1$
    private static final String LINKER_TITLE = UIMessages.getString("LinkerPropertyPage.linkerTitle"); //$NON-NLS-1$
    private static final String LINK_MODE_TITLE = UIMessages.getString("LinkerPropertyPage.linkerModeTitle"); //$NON-NLS-1$
    private static final String LINK_MODE_TITLE2 = UIMessages.getString("LinkerPropertyPage.linkerModeTitle2"); //$NON-NLS-1$
    private static final String INDEX_TITLE1 = UIMessages.getString("LinkerPropertyPage.indexTitle1"); //$NON-NLS-1$
    private static final String INDEX_TITLE2 = UIMessages.getString("LinkerPropertyPage.indexTitle2"); //$NON-NLS-1$
    private static final String INDEX_TITLE3 = UIMessages.getString("LinkerPropertyPage.indexTitle3"); //$NON-NLS-1$
    private static final String INDEX_TITLE4 = UIMessages.getString("LinkerPropertyPage.indexTitle4"); //$NON-NLS-1$
    private static final String LIB_TITLE2 = UIMessages.getString("LinkerPropertyPage.libTitle2"); //$NON-NLS-1$
    private static final String OUTPUT_TITLE = UIMessages.getString("LinkerPropertyPage.outputTitle"); //$NON-NLS-1$
    private static final String dTitle = UIMessages.getString("Common.warningTitle"); //$NON-NLS-1$
    private static final String dBtn_001 = UIMessages.getString("Common.dialogOk"); //$NON-NLS-1$
    private static final String dBtn_002 = UIMessages.getString("Common.dialogCancel"); //$NON-NLS-1$
    private static final String LANG_TITLE = UIMessages.getString("MiscPropertyPage.langTitle"); //$NON-NLS-1$
    private static final String TAB1_TITLE = UIMessages.getString("MiscPropertyPage.tab1Title"); //$NON-NLS-1$
    private static final String TAB2_TITLE = UIMessages.getString("MiscPropertyPage.tab2Title"); //$NON-NLS-1$
    private static final String TAB3_TITLE = UIMessages.getString("MiscPropertyPage.tab3Title"); //$NON-NLS-1$


    private static final int TEXT_FIELD_WIDTH = 50;

    private Text linkerFlagText;
    private Text linkerText;
    private Text libFlagText;
    private Button linkModeButton;
    private TabFolder ttabfolder = null;
    private Text outputText_runtime;
    private Text libFlagText_runtime;
    private Text outputText_debug;
    private Text libFlagText_debug;
    private Text outputText_st_runtime;
    private Text libFlagText_st_runtime;
    private Text outputText_st_debug;
    private Text libFlagText_st_debug;

    private Text includeFlagText;
    private Text compilerText;
    private Text compilerFlagText;
    private Button compileModeButton;
    private TabFolder tabfolder2 = null;
    private TabFolder tabfolder3 = null;
    private Text includeFlagText_runtime;
    private Text compilerFlagText_runtime;
    private Text includeFlagText_debug;
    private Text compilerFlagText_debug;

//	private static final int TEXT_FIELD_WIDTH = 100;

    private Combo encodingCombo;
    private Combo appTypeCombo;
    private Combo targetCombo;
    private Long target_type = null;
    
	/**
	 * Constructor for MwtProjectCompilerPropertyPage.
	 */
	public MwtProjectPropertyPage() {
		super();
	}

	private void addSeparator(Composite parent) {
		Label separator = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		separator.setLayoutData(gridData);
	}

    private void addEncodingSection(Composite parent) {
        Composite composite = createDefaultComposite(parent);

        Label titleLabel = new Label(composite, SWT.NONE);
        titleLabel.setText(ENCODE_TITLE);
        GridData gdt = new GridData();
        gdt.widthHint = 150;
        titleLabel.setLayoutData(gdt);
        ArrayList itemNameArray = new ArrayList();

        INtkProjectManager pman = NtkManager.getNtkProjectManager();
        encodingCombo = new Combo(composite, SWT.READ_ONLY);
        long cnt = 0;
        while(true){
            cnt = pman.getStaticData(Ntk.NTK_NEXT_ENCODING_ID,cnt);
            if (cnt== 0){
                break;
            }
            String item = pman.getStaticData(Ntk.NTK_ENCODING_NAME,cnt,Ntk.NTK_EN_DEFAULT);
            itemNameArray.add(item);
//            itemValueArray.add(cnt);

        }
        encodingCombo.setItems((String[]) itemNameArray.toArray(new String[0]));
        GridData gd = new GridData();
        gd.widthHint = 400;
        encodingCombo.setLayoutData(gd);
    }
    private void addAppTypeSection(Composite parent) {
        Composite composite = createDefaultComposite(parent);

        Label titleLabel = new Label(composite, SWT.NONE);
        titleLabel.setText(APP_TYPE_TITLE);
        GridData gdt = new GridData();
        gdt.widthHint = 150;
        titleLabel.setLayoutData(gdt);
        ArrayList itemNameArray = new ArrayList();
        ArrayList itemValueArray = new ArrayList();
        INtkProjectManager pman = NtkManager.getNtkProjectManager();
        long prj = pman.getCurrentProject();

        appTypeCombo = new Combo(composite, SWT.READ_ONLY);

        pman.doOperation(prj,Ntk.NTK_LOAD_LINKOPTIONS);
        long cnt = 0;
        while(true){
            cnt = pman.getStaticData(Ntk.NTK_NEXT_LINK_OPT_ID,cnt);
            if (cnt== 0){
                break;
            }
            String item = pman.getStaticData(Ntk.NTK_LINK_OPT_NAME,cnt,Ntk.NTK_EN_DEFAULT);
            itemNameArray.add(item);
            Long val = new Long(cnt);
            itemValueArray.add(val);
        }
        appTypeCombo.setItems((String[]) itemNameArray.toArray(new String[0]));
        GridData gd = new GridData();
        gd.widthHint = 400;
        appTypeCombo.setLayoutData(gd);
        appTypeCombo.setData(itemValueArray);
    }
    private void addTargetSection(Composite parent) {
        Composite composite = createDefaultComposite(parent);
        Label titleLabel = new Label(composite, SWT.NONE);
        titleLabel.setText(TARGET_TITLE);
        GridData gdt = new GridData();
        gdt.widthHint = 150;
        titleLabel.setLayoutData(gdt);
        ArrayList itemNameArray = new ArrayList();
        ArrayList itemValueArray = new ArrayList();
        INtkProjectManager pman = NtkManager.getNtkProjectManager();
        long prj = pman.getCurrentProject();

        
        targetCombo = new Combo(composite, SWT.READ_ONLY);
        long cnt = 0;
        while(true){
            cnt = pman.getStaticData(Ntk.NTK_NEXT_TARGET_ID,cnt);
            if (cnt== 0){
                break;
            }
            String item = pman.getStaticData(Ntk.NTK_TARGET_NAME,cnt,Ntk.NTK_EN_DEFAULT);
            itemNameArray.add(item);
            Long val = new Long(cnt);
            itemValueArray.add(val);
        }
        targetCombo.setItems((String[]) itemNameArray.toArray(new String[0]));
        GridData gd = new GridData();
        gd.widthHint = 400;
        targetCombo.setLayoutData(gd);
        targetCombo.setData(itemValueArray);
    }
    private void addLanguageIndication(Composite parent) {
        Composite composite = createDefaultComposite(parent);
        Label titleLabel = new Label(composite, SWT.NONE);
        titleLabel.setText(LANG_TITLE);
        GridData gdt = new GridData();
        gdt.widthHint = 150;
        titleLabel.setLayoutData(gdt);
        
        INtkProjectManager pman = NtkManager.getNtkProjectManager();
        long prj = pman.getCurrentProject();

        Label lang_label = new Label(composite, SWT.READ_ONLY);
        String item = pman.getProjectData(pman.getCurrentProject(),"#LANG",Ntk.NTK_EN_UTF8);
        lang_label.setText(item);
        GridData gd = new GridData();
        gd.widthHint = 400;
        lang_label.setLayoutData(gd);
    }

    private void addIncludeFlagSection(Composite parent) {
        Composite composite = createDefaultComposite(parent);

        Label titleLabel = new Label(composite, SWT.NONE);
        titleLabel.setText(INCLUDE_PATH_TITLE);
        GridData gdt = new GridData();
        gdt.widthHint = 150;
        titleLabel.setLayoutData(gdt);

        includeFlagText = new Text(composite, SWT.SINGLE | SWT.BORDER);
        GridData gd = new GridData();
        gd.widthHint = convertWidthInCharsToPixels(TEXT_FIELD_WIDTH);
        includeFlagText.setLayoutData(gd);
    }
    private void addCompilerFlagSection(Composite parent) {
        Composite composite = createDefaultComposite(parent);

        Label titleLabel = new Label(composite, SWT.NONE);
        titleLabel.setText(COMPILER_FLAGS_TITLE);
        GridData gdt = new GridData();
        gdt.widthHint = 150;
        titleLabel.setLayoutData(gdt);

        compilerFlagText = new Text(composite, SWT.SINGLE | SWT.BORDER);
        GridData gd = new GridData();
        gd.widthHint = convertWidthInCharsToPixels(TEXT_FIELD_WIDTH);
        compilerFlagText.setLayoutData(gd);
    }

    private void addCompilerSection(Composite parent) {
        Composite composite = createDefaultComposite(parent);

        Label titleLabel = new Label(composite, SWT.NONE);
        titleLabel.setText(COMPILER_TITLE);
        GridData gdt = new GridData();
        gdt.widthHint = 150;
        titleLabel.setLayoutData(gdt);

        compilerText = new Text(composite, SWT.SINGLE | SWT.BORDER);
        compilerText.setText("");
        GridData gd = new GridData();
        gd.widthHint = convertWidthInCharsToPixels(TEXT_FIELD_WIDTH);
        compilerText.setLayoutData(gd);
    }

    private void addCompileModeSection(Composite parent) {
        Composite composite = createDefaultComposite(parent);

        Label titleLabel = new Label(composite, SWT.NONE );
        titleLabel.setText(COMPILE_MODE_TITLE);
        GridData gdt = new GridData();
        gdt.widthHint = 150;
        titleLabel.setLayoutData(gdt);

        compileModeButton = new Button(composite, SWT.CHECK | SWT.LEFT);
        compileModeButton.setText(COMPILE_MODE_TITLE2);
        GridData gd = new GridData();
        gd.widthHint = convertWidthInCharsToPixels(TEXT_FIELD_WIDTH);
        compileModeButton.setLayoutData(gd);
    }

    private void addCFlagsSection(Composite parent) {
        Composite composite = createDefaultComposite(parent);

        tabfolder2 = new TabFolder(composite,SWT.V_SCROLL | SWT.H_SCROLL);
        tabfolder2.setSize(400,100);

        TabItem ti = new TabItem(tabfolder2,0);
        ti.setText(CINDEX_TITLE1);
        Composite area = new Composite(tabfolder2, SWT.BORDER);
        area.setVisible(true);
        area.setSize(600,600);

        ti.setControl(area);
        int index = tabfolder2.indexOf(ti);
        tabfolder2.setSelection(index);

        Composite composite2 = createDefaultComposite(area);
        composite2.setSize(500,70);
        composite2.setVisible(true);
        Label titleLabel = new Label(composite2, SWT.NONE);
        titleLabel.setText(INCLUDE_PATH_TITLE2);
        titleLabel.setBounds(10,10,150,25);

        includeFlagText_runtime= new Text(composite2, SWT.SINGLE | SWT.BORDER);
        includeFlagText_runtime.setText("");
        includeFlagText_runtime.setBounds(160,10,300,25);
        
        Label titleLabel2 = new Label(composite2, SWT.NONE);
        titleLabel2.setText(COMPILER_FLAGS_TITLE2);
        titleLabel2.setBounds(10,40,150,25);

        compilerFlagText_runtime= new Text(composite2, SWT.SINGLE | SWT.BORDER);
        compilerFlagText_runtime.setText("");
        compilerFlagText_runtime.setBounds(160,40,300,25);

        TabItem ti2 = new TabItem(tabfolder2,0);
        ti2.setText(CINDEX_TITLE2);
        Composite area2 = new Composite(tabfolder2, SWT.BORDER);
        area2.setVisible(true);
        ti2.setControl(area2);
        
        Composite composite3 = createDefaultComposite(area2);
        composite3.setSize(500,140);
        composite3.setVisible(true);
        Label titleLabel3 = new Label(composite3, SWT.NONE);
        titleLabel3.setText(INCLUDE_PATH_TITLE2);
        titleLabel3.setBounds(10,10,150,25);

        includeFlagText_debug = new Text(composite3, SWT.SINGLE | SWT.BORDER);
        includeFlagText_debug.setText("");
        includeFlagText_debug.setBounds(160,10,300,25);
        
        Label titleLabel4 = new Label(composite3, SWT.NONE);
        titleLabel4.setText(COMPILER_FLAGS_TITLE2);
        titleLabel4.setBounds(10,40,150,25);

        compilerFlagText_debug = new Text(composite3, SWT.SINGLE | SWT.BORDER);
        compilerFlagText_debug.setText("");
        compilerFlagText_debug.setBounds(160,40,300,25);
        
    }
    private void addLibraryFlagSection(Composite parent) {
        Composite composite = createDefaultComposite(parent);

        Label titleLabel = new Label(composite, SWT.NONE);
        titleLabel.setText(LIB_TITLE);
        GridData gdt = new GridData();
        gdt.widthHint = 150;
        titleLabel.setLayoutData(gdt);

        libFlagText = new Text(composite, SWT.SINGLE | SWT.BORDER);
        GridData gd = new GridData();
        gd.widthHint = convertWidthInCharsToPixels(TEXT_FIELD_WIDTH);
        libFlagText.setLayoutData(gd);
    }
    private void addLinkerFlagSection(Composite parent) {
        Composite composite = createDefaultComposite(parent);

        Label titleLabel = new Label(composite, SWT.NONE);
        titleLabel.setText(LINKER_FLAGS_TITLE);
        GridData gdt = new GridData();
        gdt.widthHint = 150;
        titleLabel.setLayoutData(gdt);

        linkerFlagText = new Text(composite, SWT.SINGLE | SWT.BORDER);
        GridData gd = new GridData();
        gd.widthHint = convertWidthInCharsToPixels(TEXT_FIELD_WIDTH);
        linkerFlagText.setLayoutData(gd);
    }

    private void addLinkerSection(Composite parent) {
        Composite composite = createDefaultComposite(parent);

        Label titleLabel = new Label(composite, SWT.NONE);
        titleLabel.setText(LINKER_TITLE);
        GridData gdt = new GridData();
        gdt.widthHint = 150;
        titleLabel.setLayoutData(gdt);

        linkerText = new Text(composite, SWT.SINGLE | SWT.BORDER);
        linkerText.setText("");
        GridData gd = new GridData();
        gd.widthHint = convertWidthInCharsToPixels(TEXT_FIELD_WIDTH);
        linkerText.setLayoutData(gd);
    }
    /*
    private void addMakeCommandSection(Composite parent) {
        Composite composite = createDefaultComposite(parent);

        Label titleLabel = new Label(composite, SWT.NONE);
        titleLabel.setText(MAKE_COMMAND_TITLE);
        GridData gdt = new GridData();
        gdt.widthHint = 150;
        titleLabel.setLayoutData(gdt);

        makeCommandText = new Text(composite, SWT.SINGLE | SWT.BORDER);
        makeCommandText.setText("");
        GridData gd = new GridData();
        gd.widthHint = convertWidthInCharsToPixels(TEXT_FIELD_WIDTH);
        makeCommandText.setLayoutData(gd);
    }
    */
    private void addLinkModeSection(Composite parent) {
        Composite composite = createDefaultComposite(parent);

        Label titleLabel = new Label(composite, SWT.NONE );
        titleLabel.setText(LINK_MODE_TITLE);
        GridData gdt = new GridData();
        gdt.widthHint = 150;
        titleLabel.setLayoutData(gdt);

        linkModeButton = new Button(composite, SWT.CHECK | SWT.LEFT);
        linkModeButton.setText(LINK_MODE_TITLE2);
        GridData gd = new GridData();
        gd.widthHint = convertWidthInCharsToPixels(TEXT_FIELD_WIDTH);
        linkModeButton.setLayoutData(gd);
    }

    private void addFlagsSection(Composite parent) {
        Composite composite = createDefaultComposite(parent);

        tabfolder3 = new TabFolder(composite,SWT.V_SCROLL | SWT.H_SCROLL);
        tabfolder3.setSize(400,200);

        TabItem ti = new TabItem(tabfolder3,0);
        ti.setText(INDEX_TITLE1);
        Composite area = new Composite(tabfolder3, SWT.BORDER);
        area.setVisible(true);
        area.setSize(600,600);

        ti.setControl(area);
        int index = tabfolder3.indexOf(ti);
        tabfolder3.setSelection(index);

        Composite composite2 = createDefaultComposite(area);
        composite2.setSize(500,140);
        composite2.setVisible(true);
        Label titleLabel = new Label(composite2, SWT.NONE);
        titleLabel.setText(LIB_TITLE2);
        titleLabel.setBounds(10,10,150,40);

        libFlagText_runtime= new Text(composite2, SWT.SINGLE | SWT.BORDER);
        libFlagText_runtime.setText("");
        libFlagText_runtime.setBounds(160,10,300,30);
        
        Label titleLabel2 = new Label(composite2, SWT.NONE);
        titleLabel2.setText(OUTPUT_TITLE);
        titleLabel2.setBounds(10,60,150,40);

        outputText_runtime= new Text(composite2, SWT.SINGLE | SWT.BORDER);
        outputText_runtime.setText("");
        outputText_runtime.setBounds(160,50,300,30);

        TabItem ti2 = new TabItem(tabfolder3,0);
        ti2.setText(INDEX_TITLE2);
        Composite area2 = new Composite(tabfolder3, SWT.BORDER);
        area2.setVisible(true);
        ti2.setControl(area2);
        
        Composite composite3 = createDefaultComposite(area2);
        composite3.setSize(500,140);
        composite3.setVisible(true);
        Label titleLabel3 = new Label(composite3, SWT.NONE);
        titleLabel3.setText(LIB_TITLE2);
        titleLabel3.setBounds(10,10,150,40);

        libFlagText_debug = new Text(composite3, SWT.SINGLE | SWT.BORDER);
        libFlagText_debug.setText("");
        libFlagText_debug.setBounds(160,10,300,30);
        
        Label titleLabel4 = new Label(composite3, SWT.NONE);
        titleLabel4.setText(OUTPUT_TITLE);
        titleLabel4.setBounds(10,60,150,40);

        outputText_debug = new Text(composite3, SWT.SINGLE | SWT.BORDER);
        outputText_debug.setText("");
        outputText_debug.setBounds(160,50,300,30);
        
        TabItem ti3 = new TabItem(tabfolder3,0);
        ti3.setText(INDEX_TITLE3);
        Composite area3 = new Composite(tabfolder3, SWT.BORDER);
        area3.setVisible(true);
        ti3.setControl(area3);
        
        Composite composite4 = createDefaultComposite(area3);
        composite4.setSize(500,140);
        composite4.setVisible(true);
        Label titleLabel5 = new Label(composite4, SWT.NONE);
        titleLabel5.setText(LIB_TITLE2);
        titleLabel5.setBounds(10,10,150,40);

        libFlagText_st_runtime = new Text(composite4, SWT.SINGLE | SWT.BORDER);
        libFlagText_st_runtime.setText("");
        libFlagText_st_runtime.setBounds(160,10,300,30);
        
        Label titleLabel6 = new Label(composite4, SWT.NONE);
        titleLabel6.setText(OUTPUT_TITLE);
        titleLabel6.setBounds(10,60,150,40);

        outputText_st_runtime = new Text(composite4, SWT.SINGLE | SWT.BORDER);
        outputText_st_runtime.setText("");
        outputText_st_runtime.setBounds(160,50,300,30);

        
        
        TabItem ti4 = new TabItem(tabfolder3,0);
        ti4.setText(INDEX_TITLE4);
        Composite area4 = new Composite(tabfolder3, SWT.BORDER);
        area4.setVisible(true);
        ti4.setControl(area4);
        
        Composite composite5 = createDefaultComposite(area4);
        composite5.setSize(500,140);
        composite5.setVisible(true);
        Label titleLabel7 = new Label(composite5, SWT.NONE);
        titleLabel7.setText(LIB_TITLE2);
        titleLabel7.setBounds(10,10,150,40);

        // Owner text field
        libFlagText_st_debug = new Text(composite5, SWT.SINGLE | SWT.BORDER);
        libFlagText_st_debug.setText("");
        libFlagText_st_debug.setBounds(160,10,300,30);
        
        // Label for owner field
        Label titleLabel8 = new Label(composite5, SWT.NONE);
        titleLabel8.setText(OUTPUT_TITLE);
        titleLabel8.setBounds(10,60,150,40);

        // Owner text field
        outputText_st_debug = new Text(composite5, SWT.SINGLE | SWT.BORDER);
        outputText_st_debug.setText("");
        outputText_st_debug.setBounds(160,50,300,30);
    }


    /**
	 * @see PreferencePage#createContents(Composite)
	 */
    protected Composite createTabBlock(String title){
        TabItem ti = new TabItem(ttabfolder,0);
        ti.setText(title);
        Composite area = new Composite(ttabfolder, SWT.BORDER);
        
        GridLayout layout1 = new GridLayout();
        area.setLayout(layout1);
        GridData data1 = new GridData(GridData.FILL);
        data1.grabExcessHorizontalSpace = true;
        data1.grabExcessVerticalSpace = true;
        area.setLayoutData(data1);
        ti.setControl(area);

        return area;        

    }
    protected void reloadValues(){
        INtkProjectManager pman = NtkManager.getNtkProjectManager();
        long prj = pman.getCurrentProject();
        
        String str = pman.getProjectData(prj,"#ENCODING",Ntk.NTK_EN_DEFAULT);
        encodingCombo.setText(str);

        str = pman.getProjectData(prj,"#LIB_CREATE",Ntk.NTK_EN_DEFAULT);
        Long val = Long.valueOf(str);
        ArrayList itemValueArray = (ArrayList)appTypeCombo.getData();
        int pos = itemValueArray.indexOf(val);
        appTypeCombo.select(pos);
        
        str = pman.getProjectData(prj,"#COMPAT",Ntk.NTK_EN_DEFAULT);
        val = Long.valueOf(str);
        target_type = val;
        itemValueArray = (ArrayList)targetCombo.getData();
        pos = itemValueArray.indexOf(val);
        targetCombo.select(pos);

        
        str = pman.getProjectData(prj,"#CC",Ntk.NTK_EN_DEFAULT);
        compilerText.setText(str);

        str = pman.getProjectData(prj,"#USER_INCLUDE",Ntk.NTK_EN_DEFAULT);
        includeFlagText.setText(str);

        str = pman.getProjectData(prj,"#USER_INCLUDE",Ntk.NTK_EN_DEFAULT);
        includeFlagText.setText(str);

        str = pman.getProjectData(prj,"#USER_RT_INCLUDE",Ntk.NTK_EN_DEFAULT);
        includeFlagText_runtime.setText(str);
        
        str = pman.getProjectData(prj,"#USER_DBG_INCLUDE",Ntk.NTK_EN_DEFAULT);
        includeFlagText_debug.setText(str);

        str = pman.getProjectData(prj,"#USER_FL",Ntk.NTK_EN_DEFAULT);
        compilerFlagText.setText(str);

        str = pman.getProjectData(prj,"#USER_RT_FL",Ntk.NTK_EN_DEFAULT);
        compilerFlagText_runtime.setText(str);

        str = pman.getProjectData(prj,"#USER_DBG_FL",Ntk.NTK_EN_DEFAULT);
        compilerFlagText_debug.setText(str);

        str = pman.getProjectData(prj,"#CMODE",Ntk.NTK_EN_DEFAULT);
        if (str == "1"){
           compileModeButton.setSelection(true);
        }else{
            compileModeButton.setSelection(false);
        }
        str = pman.getProjectData(prj,"#LD",Ntk.NTK_EN_DEFAULT);
        linkerText.setText(str);
        
        str = pman.getProjectData(prj,"#USER_LIB",Ntk.NTK_EN_DEFAULT);
        libFlagText.setText(str);

        str = pman.getProjectData(prj,"#USER_LD_FL",Ntk.NTK_EN_DEFAULT);
        linkerFlagText.setText(str);

        str = pman.getProjectData(prj,"#USER_RT_LIB",Ntk.NTK_EN_DEFAULT);
        libFlagText_runtime.setText(str);
        
        str = pman.getProjectData(prj,"#USER_DBG_LIB",Ntk.NTK_EN_DEFAULT);
        libFlagText_debug.setText(str);

        str = pman.getProjectData(prj,"#USER_RT_STLIB",Ntk.NTK_EN_DEFAULT);
        libFlagText_st_runtime.setText(str);
        
        str = pman.getProjectData(prj,"#USER_DBG_STLIB",Ntk.NTK_EN_DEFAULT);
        libFlagText_st_debug.setText(str);

        str = pman.getProjectData(prj,"#OUTPUT",Ntk.NTK_EN_DEFAULT);
        outputText_runtime.setText(str);
 
        str = pman.getProjectData(prj,"#DBG_OUTPUT",Ntk.NTK_EN_DEFAULT);
        outputText_debug.setText(str);

        str = pman.getProjectData(prj,"#STOUTPUT",Ntk.NTK_EN_DEFAULT);
        outputText_st_runtime.setText(str);

        str = pman.getProjectData(prj,"#DBG_STOUTPUT",Ntk.NTK_EN_DEFAULT);
        outputText_st_debug.setText(str);

        str = pman.getProjectData(prj,"#ST_LINK",Ntk.NTK_EN_DEFAULT);
        if (str == "1"){
           linkModeButton.setSelection(true);
        }else{
            linkModeButton.setSelection(false);
        }


    }
	protected Control createContents(Composite parent) {
        Composite base = new Composite(parent, SWT.NONE);
        
        GridLayout layout1 = new GridLayout();
        layout1.marginWidth = 0;
        layout1.marginTop = 0;
        base.setLayout(layout1);


/*        
        GridData data1 = new GridData(GridData.FILL);
        data1.grabExcessHorizontalSpace = true;
        data1.grabExcessVerticalSpace = true;
        base.setLayoutData(data1);
*/        
        ttabfolder = new TabFolder(base,SWT.NONE);

/*
        GridData data = new GridData(GridData.FILL);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        ttabfolder.setLayoutData(data);
*/
//        ttabfolder.setSize(600,600);
        int langType = NtkManager.getNtkProjectManager().getCurrentProjectLangType();
        
        Composite composite = createTabBlock(TAB1_TITLE);        
        if (langType == Ntk.NTK_LANG_CPP){
            addEncodingSection(composite);
            addAppTypeSection(composite);
            addTargetSection(composite);
        }
        addLanguageIndication(composite);

        if (langType == Ntk.NTK_LANG_CPP){
            Composite composite2 = createTabBlock(TAB2_TITLE);        
    
            addCompilerSection(composite2);
            addSeparator(composite2);
            addIncludeFlagSection(composite2);
            addCompilerFlagSection(composite2);
            addCompileModeSection(composite2);
            addCFlagsSection(composite2);
    
            Composite composite3 = createTabBlock(TAB3_TITLE);        
            addLinkerSection(composite3);
            addLibraryFlagSection(composite3);
            addLinkerFlagSection(composite3);
            addLinkModeSection(composite3);
            addFlagsSection(composite3);
        }else{
            return composite;
        }
        
        reloadValues();

        /*                
        INtkProjectManager pman = NtkManager.getNtkProjectManager();
        final long prj = pman.getCurrentProject();
        final MwtProjectPropertyPage page = this;
        
        targetCombo.addSelectionListener(new SelectionListener(){
            
            public void widgetDefaultSelected(SelectionEvent e) {}
            public void widgetSelected(SelectionEvent e) {
                MessageDialog dlg = new MessageDialog(
                        ttabfolder.getShell(), dTitle, null, UPDATE_MESSAGE,
                        MessageDialog.WARNING, new String[] { dBtn_001,dBtn_002}, 0);
                dlg.open();

                INtkProjectManager pman = NtkManager.getNtkProjectManager();
                int pos = targetCombo.getSelectionIndex();
                ArrayList itemValueArray = (ArrayList)targetCombo.getData();
                Long val = (Long)itemValueArray.get(pos);
                pman.setProjectData(prj,"#COMPAT",val.toString(),Ntk.NTK_EN_DEFAULT);
                page.reloadValues();
            }
        });
        */


        
		return composite;
	}

	private Composite createDefaultComposite(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		composite.setLayout(layout);
/*
		GridData data = new GridData();
		data.verticalAlignment = GridData.FILL;
		data.horizontalAlignment = GridData.FILL;
		composite.setLayoutData(data);
*/
		return composite;
	}

	protected void performDefaults() {
        int langType = NtkManager.getNtkProjectManager().getCurrentProjectLangType();
        if (langType != Ntk.NTK_LANG_CPP){
            return;
        }

	    INtkProjectManager pman = NtkManager.getNtkProjectManager();
        long prj = pman.getCurrentProject();
        String str = pman.getProjectDefaultData(prj,"#ENCODING",Ntk.NTK_EN_DEFAULT);
        encodingCombo.setText(str);

        str = pman.getProjectDefaultData(prj,"#LIB_CREATE",Ntk.NTK_EN_DEFAULT);
        Long val = Long.valueOf(str);
        ArrayList itemValueArray = (ArrayList)appTypeCombo.getData();
        int pos = itemValueArray.indexOf(val);
        appTypeCombo.select(pos);

        str = pman.getProjectDefaultData(prj,"#COMPAT",Ntk.NTK_EN_DEFAULT);
        val = Long.valueOf(str);
        itemValueArray = (ArrayList)targetCombo.getData();
        pos = itemValueArray.indexOf(val);
        targetCombo.select(pos);
        str = pman.getProjectDefaultData(prj,"#CC",Ntk.NTK_EN_DEFAULT);
        compilerText.setText(str);

        str = pman.getProjectDefaultData(prj,"#USER_INCLUDE",Ntk.NTK_EN_DEFAULT);
        includeFlagText.setText(str);

        str = pman.getProjectDefaultData(prj,"#USER_RT_INCLUDE",Ntk.NTK_EN_DEFAULT);
        includeFlagText_runtime.setText(str);
        
        str = pman.getProjectDefaultData(prj,"#USER_DBG_INCLUDE",Ntk.NTK_EN_DEFAULT);
        includeFlagText_debug.setText(str);

        str = pman.getProjectDefaultData(prj,"#USER_FL",Ntk.NTK_EN_DEFAULT);
        compilerFlagText.setText(str);

        str = pman.getProjectDefaultData(prj,"#USER_RT_FL",Ntk.NTK_EN_DEFAULT);
        compilerFlagText_runtime.setText(str);

        str = pman.getProjectDefaultData(prj,"#USER_DBG_FL",Ntk.NTK_EN_DEFAULT);
        compilerFlagText_debug.setText(str);

        str = pman.getProjectDefaultData(prj,"#CMODE",Ntk.NTK_EN_DEFAULT);
        if (str == "1"){
           compileModeButton.setSelection(true);
        }else{
            compileModeButton.setSelection(false);
        }
        str = pman.getProjectDefaultData(prj,"#LD",Ntk.NTK_EN_DEFAULT);
        linkerText.setText(str);
        
        str = pman.getProjectDefaultData(prj,"#USER_LIB",Ntk.NTK_EN_DEFAULT);
        libFlagText.setText(str);
        
        str = pman.getProjectDefaultData(prj,"#USER_LD_FL",Ntk.NTK_EN_DEFAULT);
        linkerFlagText.setText(str);
        
        str = pman.getProjectDefaultData(prj,"#USER_RT_LIB",Ntk.NTK_EN_DEFAULT);
        libFlagText_runtime.setText(str);
        
        str = pman.getProjectDefaultData(prj,"#USER_DBG_LIB",Ntk.NTK_EN_DEFAULT);
        libFlagText_debug.setText(str);
        
        str = pman.getProjectDefaultData(prj,"#USER_RT_STLIB",Ntk.NTK_EN_DEFAULT);
        libFlagText_st_runtime.setText(str);
        
        str = pman.getProjectDefaultData(prj,"#USER_DBG_STLIB",Ntk.NTK_EN_DEFAULT);
        libFlagText_st_debug.setText(str);
        
        str = pman.getCurrentProjectName();
        outputText_runtime.setText(str);
        outputText_st_runtime.setText(str);
        
        str = str + "d";
        outputText_debug.setText(str);
        outputText_st_debug.setText(str);
        
        str = pman.getProjectDefaultData(prj,"#ST_LINK",Ntk.NTK_EN_DEFAULT);
        if (str == "1"){
           linkModeButton.setSelection(true);
        }else{
            linkModeButton.setSelection(false);
        }
        
    }
	
	public boolean performOk() {
        int langType = NtkManager.getNtkProjectManager().getCurrentProjectLangType();
        if (langType != Ntk.NTK_LANG_CPP){
            return true;
        }

		try {
            
            INtkProjectManager pman = NtkManager.getNtkProjectManager();
            long prj = pman.getCurrentProject();
            
            pman.setProjectData(prj,"#ENCODING",encodingCombo.getText(),Ntk.NTK_EN_DEFAULT);

 
            
            
            
            pman.setProjectData(prj,"#CC",compilerText.getText(),Ntk.NTK_EN_DEFAULT);
            pman.setProjectData(prj,"#USER_INCLUDE",includeFlagText.getText(),Ntk.NTK_EN_DEFAULT);
            pman.setProjectData(prj,"#USER_RT_INCLUDE",includeFlagText_runtime.getText(),Ntk.NTK_EN_DEFAULT);
            pman.setProjectData(prj,"#USER_DBG_INCLUDE",includeFlagText_debug.getText(),Ntk.NTK_EN_DEFAULT);
            pman.setProjectData(prj,"#USER_FL",compilerFlagText.getText(),Ntk.NTK_EN_DEFAULT);
            pman.setProjectData(prj,"#USER_RT_FL",compilerFlagText_runtime.getText(),Ntk.NTK_EN_DEFAULT);
            pman.setProjectData(prj,"#USER_DBG_FL",compilerFlagText_debug.getText(),Ntk.NTK_EN_DEFAULT);
            
            boolean fl = compileModeButton.getSelection();
            if (fl == false){
                pman.setProjectData(prj,"#CMODE","0",Ntk.NTK_EN_DEFAULT);
            }else{
                pman.setProjectData(prj,"#CMODE","1",Ntk.NTK_EN_DEFAULT);
            }
            pman.setProjectData(prj,"#LD",linkerText.getText(),Ntk.NTK_EN_DEFAULT);
            pman.setProjectData(prj,"#USER_LIB",libFlagText.getText(),Ntk.NTK_EN_DEFAULT);
            pman.setProjectData(prj,"#USER_LD_FL",linkerFlagText.getText(),Ntk.NTK_EN_DEFAULT);
            pman.setProjectData(prj,"#USER_RT_LIB",libFlagText_runtime.getText(),Ntk.NTK_EN_DEFAULT);
            pman.setProjectData(prj,"#USER_DBG_LIB",libFlagText_debug.getText(),Ntk.NTK_EN_DEFAULT);
            pman.setProjectData(prj,"#USER_RT_STLIB",libFlagText_st_runtime.getText(),Ntk.NTK_EN_DEFAULT);
            pman.setProjectData(prj,"#USER_DBG_STLIB",libFlagText_st_debug.getText(),Ntk.NTK_EN_DEFAULT);
            pman.setProjectData(prj,"#OUTOUT",outputText_runtime.getText(),Ntk.NTK_EN_DEFAULT);
            pman.setProjectData(prj,"#DBG_OUTPUT",outputText_debug.getText(),Ntk.NTK_EN_DEFAULT);
            pman.setProjectData(prj,"#STOUTPUT",outputText_st_runtime.getText(),Ntk.NTK_EN_DEFAULT);
            pman.setProjectData(prj,"#DBG_STOUTPUT",outputText_st_debug.getText(),Ntk.NTK_EN_DEFAULT);
          
          
            boolean fl2 = linkModeButton.getSelection();
            if (fl2 == false){
                pman.setProjectData(prj,"#ST_LINK","0",Ntk.NTK_EN_DEFAULT);
            }else{
                pman.setProjectData(prj,"#ST_LINK","1",Ntk.NTK_EN_DEFAULT);
            }
            int pos = appTypeCombo.getSelectionIndex();
            ArrayList itemValueArray2 = (ArrayList)appTypeCombo.getData();
            Long val = (Long)itemValueArray2.get(pos);
            pman.setProjectData(prj,"#LIB_CREATE",val.toString(),Ntk.NTK_EN_DEFAULT);
            Long prev_val = val;
            
            pos = targetCombo.getSelectionIndex();
            itemValueArray2 = (ArrayList)targetCombo.getData();
            val = (Long)itemValueArray2.get(pos);
            
            if (val.compareTo(target_type) != 0){
                MessageDialog dlg = new MessageDialog(
                    ttabfolder.getShell(), dTitle, null, UPDATE_MESSAGE,
                    MessageDialog.WARNING, new String[] { dBtn_001,dBtn_002}, 0);
                if (dlg.open() == 0){
                    pman.setProjectData(prj,"#COMPAT",val.toString(),Ntk.NTK_EN_DEFAULT);
                    target_type = val;
                    reloadValues();
                    {
                    	Long selected_val = null;
                        ArrayList itemNameArray = new ArrayList();
                        ArrayList itemValueArray = new ArrayList();

                        pman.doOperation(prj,Ntk.NTK_LOAD_LINKOPTIONS);
                        long cnt = 0;
                        while(true){
                            cnt = pman.getStaticData(Ntk.NTK_NEXT_LINK_OPT_ID,cnt);
                            if (cnt== 0){
                                break;
                            }
                            String item = pman.getStaticData(Ntk.NTK_LINK_OPT_NAME,cnt,Ntk.NTK_EN_DEFAULT);
                            itemNameArray.add(item);
                            val = new Long(cnt);
                            if( selected_val == null || val.compareTo(prev_val) == 0 ){
                            	selected_val = val;
                            }
                            itemValueArray.add(val);
                        }
                        
                        appTypeCombo.setItems((String[]) itemNameArray.toArray(new String[0]));
                        appTypeCombo.setData(itemValueArray);
                        appTypeCombo.select(itemValueArray.indexOf(selected_val));
                        pman.setProjectData(prj,"#LIB_CREATE",selected_val.toString(),Ntk.NTK_EN_DEFAULT);
                    	
                    }
                }
            }
		} catch (Exception e) {
            System.err.println("MwtProjectMiscPropertyPage.performOk.. Exception="+e);
			return false;
		}
		return true;
	}

}
