/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ab.view;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.core.search.matching.MatchLocatorParser.ClassButNoMethodDeclarationVisitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.swt.SWT;
import org.eclipse.nab.core.INtkContext;
import org.eclipse.nab.core.INtkInstanceManager;
import org.eclipse.nab.core.INtkProjectManager;
import org.eclipse.nab.core.Ntk;
import org.eclipse.nab.core.NtkManager;
import org.eclipse.nab.mwt.ab.core.CorePlugin;
import org.eclipse.nab.mwt.ab.core.UIMessages;
import org.eclipse.nab.mwt.ab.view.MwtInstancePropertyView.MwtPropertyData;

public class MwtInstanceAttributeView extends ViewPart{
    private static final String CLASS_NAME_TITLE = UIMessages.getString("MwtInstanceAttributeView.classNameTitle"); //$NON-NLS-1$
    private static final String WIN_TYPE_TITLE = UIMessages.getString("MwtInstanceAttributeView.windowTypeTitle"); //$NON-NLS-1$
    private static final String WIN_SETTINGS_TITLE = UIMessages.getString("MwtInstanceAttributeView.windowSettingsTitle"); //$NON-NLS-1$

    private static final String WIN_TYPE_APP1 = UIMessages.getString("MwtInstanceAttributeView.windowTypeApp1"); //$NON-NLS-1$
    private static final String WIN_TYPE_APP2 = UIMessages.getString("MwtInstanceAttributeView.windowTypeApp2"); //$NON-NLS-1$
    private static final String WIN_TYPE_APP3 = UIMessages.getString("MwtInstanceAttributeView.windowTypeApp3"); //$NON-NLS-1$
    
    private static final String WIN_SETTINGS_BTN1 = UIMessages.getString("MwtInstanceAttributeView.windowSettingsBtn1"); //$NON-NLS-1$
    private static final String WIN_SETTINGS_BTN2 = UIMessages.getString("MwtInstanceAttributeView.windowSettingsBtn2"); //$NON-NLS-1$
    private static final String WIN_SETTINGS_BTN3 = UIMessages.getString("MwtInstanceAttributeView.windowSettingsBtn3"); //$NON-NLS-1$
    private static final String WIN_SETTINGS_BTN4 = UIMessages.getString("MwtInstanceAttributeView.windowSettingsBtn4"); //$NON-NLS-1$
    private static final String CLASS_ICON_TITLE = UIMessages.getString("MwtInstanceAttributeView.classIconTitle"); //$NON-NLS-1$
    private static final String CLASS_COMMENT_TITLE = UIMessages.getString("MwtInstanceAttributeView.classCommentTitle"); //$NON-NLS-1$
    private static final String BASE_CLASS_TITLE = UIMessages.getString("MwtInstanceAttributeView.baseClassTitle"); //$NON-NLS-1$
    private static final String ACCESS_ATTR_TITLE = UIMessages.getString("MwtInstanceAttributeView.accessAttrTitle"); //$NON-NLS-1$
    private static final String ACCESS_ATTR_TITLE2 = UIMessages.getString("MwtInstanceAttributeView.accessAttrTitle2"); //$NON-NLS-1$
    private static final String GENERATE_REMOTE_CLASS_TITLE = UIMessages.getString("MwtInstanceAttributeView.generateRemoteClassTitle"); //$NON-NLS-1$
    private static final String GENERATE_REMOTE_CLASS_TITLE2 = UIMessages.getString("MwtInstanceAttributeView.generateRemoteClassTitle2"); //$NON-NLS-1$

    private int CANVAS_WIDTH = 270;
    private int CANVAS_WIDTH2 = 400;
    private int CANVAS_HEIGHT = 800;
    private int LABEL_WIDTH = 120;
    private int LABEL_HEIGHT = 30;
    
    
    private Composite baseCanvas = null;
    private Composite mainCanvas = null;
    private Label classNameLabel = null;
    private Button accessAttrBtn = null;
    private Combo winTypeCombo = null;
    private Button winSettingsBtn1 = null;
    private Button winSettingsBtn2 = null;
    private Button winSettingsBtn3 = null;
    private Button winSettingsBtn4 = null;
    private Text classIconText = null;
    private Text classCommentText = null;
    private Text baseClassText = null;
    private Button generateRemoteClassBtn = null;
    
    private Composite classSettingsArea1 = null;
    private Composite classSettingsArea2 = null;
    private Composite classSettingsArea3 = null;
    private Composite classSettingsArea4 = null;
    private Composite classSettingsArea5 = null;
    private Composite classSettingsArea6 = null;
    private Composite classSettingsArea7 = null;
    private Composite classSettingsArea8 = null;
    private Composite classSettingsArea9 = null;
    private Composite classSettingsArea10 = null;
    
    private long targetId = 0;  
    private boolean locked = false;
    private boolean no_set_action = false;
    
    private long proc1;
    private long proc2;
    /**
     * constructor
     */
    public MwtInstanceAttributeView() {
        if (NtkManager.isInitialized() == false){
            NtkManager.ntkInitialize();
        }
        proc1 = NtkManager.getEventCallbackManager().addProc("ve-instance-updated",this,"InstanceUpdated",null);
        proc2 = NtkManager.getEventCallbackManager().addProc("ve-prop-instance-selected",this,"InstanceUpdated",null);
    }
    public void dispose() {
        NtkManager.getEventCallbackManager().delProc(proc1);
        NtkManager.getEventCallbackManager().delProc(proc2);
        super.dispose();
    }
    public void setFocus(){
        baseCanvas.setFocus();
    }
   
    public void InstanceUpdated(Object param){
        Display display = baseCanvas.getDisplay();
        display.asyncExec(new Runnable() {
          public void run(){
              instanceUpdatedWork();
          }
        });
    }
    public void instanceUpdatedWork(){
        // MWT lock
        INtkContext context = NtkManager.getNtkContext();
        try{
            context.lock();
        } catch(Exception e){
            System.err.println("MwtInstanceAttributeView.instanceUpdateWork");
            return;
        }
        locked = true;
        
        try{
            
            long selectedId = Ntk.NTK_ROOT_INSTANCE_ID;
            long targetCount = 0;
            INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
            while(true){    
                long selectedNext = iman.getInstanceId(selectedId, Ntk.NTK_NEXT_SELECTED_INSTANCE_ID, 0);
                if (selectedNext == 0){
                    break;
                }
                targetCount++;
                selectedId = selectedNext;
            }
            
            if (targetCount > 1){
                targetId = 0;
                mainCanvas.setVisible(false);
                
                return;
            }
            
            if(targetId == selectedId) {
                // instance id is not change
                mainCanvas.setVisible(true);
                return;
            }
            targetId = selectedId;
            if (targetId == 0){
                mainCanvas.setVisible(false);
                return;
            }
            
            long nextChildId = Ntk.NTK_ROOT_INSTANCE_ID;
            boolean isRoot = false;
            
            while(true){    
                long childId = iman.getInstanceId(Ntk.NTK_ROOT_INSTANCE_ID, Ntk.NTK_NEXT_CHILD_INSTANCE_ID,nextChildId);
                if (childId == 0){
                    break;
                }
                if (childId == targetId){
                    isRoot = true;
                    break;
                }
                nextChildId = childId;
            }
            no_set_action = true;
            long class_attr = iman.getUserLongData(targetId,Ntk.NTK_CLASS_DEF);
            long store_attr = iman.getUserLongData(targetId,Ntk.NTK_STORE_DEF);
            if (class_attr != 0){
                classSettingsArea1.setVisible(true);
                classSettingsArea2.setVisible(true);
                classSettingsArea3.setVisible(true);
                classSettingsArea4.setVisible(true);
                classSettingsArea5.setVisible(true);
                classSettingsArea6.setVisible(true);
                classSettingsArea7.setVisible(true);
                classSettingsArea8.setVisible(true);
                classSettingsArea9.setVisible(false);
                winTypeCombo.setText(WIN_TYPE_APP2);
                if (isRoot){
                    classSettingsArea10.setVisible(true);
                }else{
                    classSettingsArea10.setVisible(false);
                }
                String icon_val = iman.getUserStringData(targetId,Ntk.NTK_CLASS_ICON);
                if (icon_val != null){
                    classIconText.setText(icon_val);
                }
                String cbase_val = iman.getUserStringData(targetId,Ntk.NTK_CLASS_BASE);
                if (cbase_val != null){
                    baseClassText.setText(cbase_val);
                }
                String com_val = iman.getUserStringData(targetId,Ntk.NTK_CLASS_COMMENT);
                if (com_val != null){
                    classCommentText.setText(com_val);
                }
                long rclass_generating = iman.getUserLongData(targetId,Ntk.NTK_GENERATE_REMOTE_CLASS);
                if (rclass_generating == 0){
                    generateRemoteClassBtn.setSelection(false);
                }else{
                    generateRemoteClassBtn.setSelection(true);
                }
            }else if (store_attr != 0){
                classSettingsArea1.setVisible(false);
                classSettingsArea2.setVisible(false);
                classSettingsArea3.setVisible(false);
                classSettingsArea4.setVisible(false);
                classSettingsArea5.setVisible(false);
                classSettingsArea6.setVisible(false);
                classSettingsArea7.setVisible(false);
                classSettingsArea8.setVisible(false);
                classSettingsArea9.setVisible(false);
                winTypeCombo.setText(WIN_TYPE_APP3);
                if (isRoot){
                    classSettingsArea10.setVisible(true);
                }else{
                    classSettingsArea10.setVisible(false);
                }
            }else{
                classSettingsArea1.setVisible(false);
                classSettingsArea2.setVisible(false);
                classSettingsArea3.setVisible(false);
                classSettingsArea4.setVisible(false);
                classSettingsArea5.setVisible(false);
                classSettingsArea6.setVisible(false);
                classSettingsArea7.setVisible(false);
                classSettingsArea8.setVisible(false);
                classSettingsArea9.setVisible(true);
                winTypeCombo.setText(WIN_TYPE_APP1);
                
                if (isRoot){
                    classSettingsArea9.setVisible(false);
                    classSettingsArea10.setVisible(true);
                }else{
                    classSettingsArea10.setVisible(false);
                    long ext_var = iman.getUserLongData(targetId,Ntk.NTK_EXT_VAR);
                    if (ext_var != 0){
                        accessAttrBtn.setSelection(true);
                    }else{
                        accessAttrBtn.setSelection(false);
                    }
                }
            }
            String cname = iman.getClassName(targetId);
            classNameLabel.setText(cname);
            mainCanvas.setVisible(true);
        }catch(Exception e){
            System.err.println("MwtInstanceAttributeView.instanceUpdatedWork(): " + e.toString());
        }finally{
            locked = false;
            no_set_action = false;
            context.unlock();
        }
    }
    
    /**
     * make Wedget Data
     */
    public void createPartControl(Composite parent){
        
        baseCanvas = new Canvas(parent , SWT.V_SCROLL | SWT.H_SCROLL);
        baseCanvas.getHorizontalBar().setValues(0, 0, CANVAS_WIDTH, 64, 8, 64);
        baseCanvas.getVerticalBar().setValues(0, 0, CANVAS_HEIGHT, 64, 8, 64);
        baseCanvas.setLayout(new GridLayout());
        
        mainCanvas = new Composite(baseCanvas, SWT.NONE);
        baseCanvas.setData(mainCanvas);
        mainCanvas.setSize(CANVAS_WIDTH, CANVAS_HEIGHT);
        mainCanvas.setLocation(0,0);
        mainCanvas.setVisible(true);
        mainCanvas.setLayout(new GridLayout());
        

        Display display = mainCanvas.getDisplay();
        NtkManager.setSyncDisplay(display);

        // label for class name
        Composite base = createDefaultComposite(mainCanvas);
        Label classNameTitleLabel = new Label(base, SWT.NONE);
        
        classNameTitleLabel.setText(CLASS_NAME_TITLE);
        GridData gdt1 = new GridData();
        gdt1.widthHint = LABEL_WIDTH;
        classNameTitleLabel.setLayoutData(gdt1);

        classNameLabel = new Label(base, SWT.SHADOW_IN);
        classNameLabel.setText("WSCwindow");
        gdt1 = new GridData();
        gdt1.widthHint = CANVAS_WIDTH - LABEL_WIDTH;
        classNameLabel.setLayoutData(gdt1);        
        
        addSeparator(mainCanvas);
        
        // combo for window type selection
        base = createDefaultComposite(mainCanvas);
        Label winTypeTitleLabel = new Label(base, SWT.NONE);
        classSettingsArea10 = base;
        
        winTypeTitleLabel.setText(WIN_TYPE_TITLE);
        gdt1 = new GridData();
        gdt1.widthHint = LABEL_WIDTH;
        winTypeTitleLabel.setLayoutData(gdt1);

        winTypeCombo = new Combo(base, SWT.READ_ONLY);
        gdt1 = new GridData();
        gdt1.widthHint = CANVAS_WIDTH - LABEL_WIDTH;
        winTypeCombo.setLayoutData(gdt1);        
        ArrayList itemNameArray = new ArrayList();
        itemNameArray.add(WIN_TYPE_APP1);
        itemNameArray.add(WIN_TYPE_APP2);
        itemNameArray.add(WIN_TYPE_APP3);
        winTypeCombo.setItems((String[]) itemNameArray.toArray(new String[0]));
        
        winTypeCombo.addSelectionListener(new SelectionListener(){
            public void widgetSelected(SelectionEvent ev) {
                if (no_set_action == true){
                    return;
                }
                Combo combo = (Combo)ev.getSource();
                selectWindowType(combo.getSelectionIndex());
            }
            public void widgetDefaultSelected(SelectionEvent ev) {
                if (no_set_action == true){
                    return;
                }
                Combo combo = (Combo)ev.getSource();
                selectWindowType(combo.getSelectionIndex());
            }
        });

        // access attributes of instance
        base = createDefaultComposite(mainCanvas);
        Label accessAttrTitleLabel = new Label(base, SWT.NONE);
        classSettingsArea9 = base;
        
        accessAttrTitleLabel.setText(ACCESS_ATTR_TITLE);
        gdt1 = new GridData();
        gdt1.widthHint = LABEL_WIDTH;
        accessAttrTitleLabel.setLayoutData(gdt1);

        accessAttrBtn = new Button(base, SWT.NONE | SWT.CHECK);
        accessAttrBtn.setText(ACCESS_ATTR_TITLE2);
        gdt1 = new GridData();
        gdt1.widthHint = CANVAS_WIDTH2 - LABEL_WIDTH;
        accessAttrBtn.setLayoutData(gdt1);
        accessAttrBtn.addSelectionListener(new SelectionListener(){
            public void widgetSelected(SelectionEvent ev) {
                if (no_set_action == true){
                    return;
                }
                Button btn = (Button)ev.getSource();
                setAccessAttr(btn.getSelection());
            }
            public void widgetDefaultSelected(SelectionEvent ev) {
                if (no_set_action == true){
                    return;
                }
                Button btn = (Button)ev.getSource();
                setAccessAttr(btn.getSelection());
            }
        });

        addSeparator(mainCanvas);

        // settings for class window type (properties)
        base = createDefaultComposite(mainCanvas);
        Label winSettingsTitleLabel = new Label(base, SWT.NONE);
        classSettingsArea1 = base;
        
        winSettingsTitleLabel.setText(WIN_SETTINGS_TITLE);
        gdt1 = new GridData();
        gdt1.widthHint = LABEL_WIDTH;
        winSettingsTitleLabel.setLayoutData(gdt1);

        winSettingsBtn1 = new Button(base, SWT.NONE);
        winSettingsBtn1.setText(WIN_SETTINGS_BTN1);
        gdt1 = new GridData();
        gdt1.widthHint = CANVAS_WIDTH - LABEL_WIDTH;
        winSettingsBtn1.setLayoutData(gdt1);
        winSettingsBtn1.addSelectionListener(new SelectionListener(){
            public void widgetSelected(SelectionEvent ev) {
                if (no_set_action == true){
                    return;
                }
                if (targetId == 0){
                    return;
                }
                NtkManager.getNtkInstanceManager().setInstanceId(Ntk.NTK_TARGET_INSTANCE_ID,targetId);
                NtkManager.getEventCallbackManager().execProc("ve-class-prop-editor-activated");
                
            }
            public void widgetDefaultSelected(SelectionEvent ev) {
                if (no_set_action == true){
                    return;
                }
                if (targetId == 0){
                    return;
                }
                NtkManager.getNtkInstanceManager().setInstanceId(Ntk.NTK_TARGET_INSTANCE_ID,targetId);
                NtkManager.getEventCallbackManager().execProc("ve-class-prop-editor-activated");
            }
        });
        
        // settings for class window type (triggers)
        base = createDefaultComposite(mainCanvas);
        winSettingsTitleLabel = new Label(base, SWT.NONE);
        classSettingsArea2 = base;
        
        winSettingsTitleLabel.setText("");
        gdt1 = new GridData();
        gdt1.widthHint = LABEL_WIDTH;
        winSettingsTitleLabel.setLayoutData(gdt1);

        winSettingsBtn2 = new Button(base, SWT.NONE);
        winSettingsBtn2.setText(WIN_SETTINGS_BTN2);
        gdt1 = new GridData();
        gdt1.widthHint = CANVAS_WIDTH - LABEL_WIDTH;
        winSettingsBtn2.setLayoutData(gdt1);
        winSettingsBtn2.addSelectionListener(new SelectionListener(){
            public void widgetSelected(SelectionEvent ev) {
                if (no_set_action == true){
                    return;
                }
                if (targetId == 0){
                    return;
                }
                NtkManager.getNtkInstanceManager().setInstanceId(Ntk.NTK_TARGET_INSTANCE_ID,targetId);
                NtkManager.getEventCallbackManager().execProc("ve-class-trg-editor-activated");
            }
            public void widgetDefaultSelected(SelectionEvent ev) {
                if (no_set_action == true){
                    return;
                }
                if (targetId == 0){
                    return;
                }
                NtkManager.getNtkInstanceManager().setInstanceId(Ntk.NTK_TARGET_INSTANCE_ID,targetId);
                NtkManager.getEventCallbackManager().execProc("ve-class-trg-editor-activated");
            }
        });

        // settings for class window type (user triggers)
        base = createDefaultComposite(mainCanvas);
        winSettingsTitleLabel = new Label(base, SWT.NONE);
        classSettingsArea3 = base;
        
        winSettingsTitleLabel.setText("");
        gdt1 = new GridData();
        gdt1.widthHint = LABEL_WIDTH;
        winSettingsTitleLabel.setLayoutData(gdt1);

        winSettingsBtn3 = new Button(base, SWT.NONE);
        winSettingsBtn3.setText(WIN_SETTINGS_BTN3);
        gdt1 = new GridData();
        gdt1.widthHint = CANVAS_WIDTH - LABEL_WIDTH;
        winSettingsBtn3.setLayoutData(gdt1);
        winSettingsBtn3.addSelectionListener(new SelectionListener(){
            public void widgetSelected(SelectionEvent ev) {
                if (no_set_action == true){
                    return;
                }
                if (targetId == 0){
                    return;
                }
                NtkManager.getNtkInstanceManager().setInstanceId(Ntk.NTK_TARGET_INSTANCE_ID,targetId);
                NtkManager.getEventCallbackManager().execProc("ve-class-utrg-editor-activated");
            }
            public void widgetDefaultSelected(SelectionEvent ev) {
                if (no_set_action == true){
                    return;
                }
                if (targetId == 0){
                    return;
                }
                NtkManager.getNtkInstanceManager().setInstanceId(Ntk.NTK_TARGET_INSTANCE_ID,targetId);
                NtkManager.getEventCallbackManager().execProc("ve-class-utrg-editor-activated");
            }
        });

        // settings for class window type (remote methods)
        base = createDefaultComposite(mainCanvas);
        winSettingsTitleLabel = new Label(base, SWT.NONE);
        classSettingsArea4 = base;
        
        winSettingsTitleLabel.setText("");
        gdt1 = new GridData();
        gdt1.widthHint = LABEL_WIDTH;
        winSettingsTitleLabel.setLayoutData(gdt1);

        winSettingsBtn4 = new Button(base, SWT.NONE);
        winSettingsBtn4.setText(WIN_SETTINGS_BTN4);
        gdt1 = new GridData();
        gdt1.widthHint = CANVAS_WIDTH - LABEL_WIDTH;
        winSettingsBtn4.setLayoutData(gdt1);
        winSettingsBtn4.addSelectionListener(new SelectionListener(){
            public void widgetSelected(SelectionEvent ev) {
                if (no_set_action == true){
                    return;
                }
                if (targetId == 0){
                    return;
                }
                NtkManager.getNtkInstanceManager().setInstanceId(Ntk.NTK_TARGET_INSTANCE_ID,targetId);
                NtkManager.getEventCallbackManager().execProc("ve-class-remote-method-editor-activated");
            }
            public void widgetDefaultSelected(SelectionEvent ev) {
                if (no_set_action == true){
                    return;
                }
                if (targetId == 0){
                    return;
                }
                NtkManager.getNtkInstanceManager().setInstanceId(Ntk.NTK_TARGET_INSTANCE_ID,targetId);
                NtkManager.getEventCallbackManager().execProc("ve-class-remote-method-editor-activated");
            }
        });

        addSeparator(mainCanvas);
        
        // text for class icon type selection
        base = createDefaultComposite(mainCanvas);
        classSettingsArea5 = base;

        Label classIconTitleLabel = new Label(base, SWT.NONE);
        classIconTitleLabel.setText(CLASS_ICON_TITLE);
        gdt1 = new GridData();
        gdt1.widthHint = LABEL_WIDTH;
        classIconTitleLabel.setLayoutData(gdt1);

        classIconText = new Text(base, SWT.SINGLE | SWT.BORDER);
        gdt1 = new GridData();
        gdt1.widthHint = CANVAS_WIDTH - LABEL_WIDTH;
        classIconText.setLayoutData(gdt1);        
        classIconText.addModifyListener(new ModifyListener(){
            public void modifyText(ModifyEvent ev) {
                if (no_set_action == true){
                    return;
                }
                Text text = (Text)ev.getSource();
                setClassIconAttr(text.getText());
            }
        });

        // text for comment of class
        base = createDefaultComposite(mainCanvas);
        classSettingsArea6 = base;

        Label classCommentTitleLabel = new Label(base, SWT.NONE);
        classCommentTitleLabel.setText(CLASS_COMMENT_TITLE);
        gdt1 = new GridData();
        gdt1.widthHint = LABEL_WIDTH;
        classCommentTitleLabel.setLayoutData(gdt1);

        classCommentText = new Text(base, SWT.SINGLE | SWT.BORDER);
        gdt1 = new GridData();
        gdt1.widthHint = CANVAS_WIDTH - LABEL_WIDTH;
        classCommentText.setLayoutData(gdt1);        
        classCommentText.addModifyListener(new ModifyListener(){
            public void modifyText(ModifyEvent ev) {
                if (no_set_action == true){
                    return;
                }
                Text text = (Text)ev.getSource();
                setClassCommentAttr(text.getText());
            }
        });

        // text for selection of instance of base class
        base = createDefaultComposite(mainCanvas);
        classSettingsArea7 = base;
        
        Label baseClassTitleLabel = new Label(base, SWT.NONE);
        baseClassTitleLabel.setText(BASE_CLASS_TITLE);
        gdt1 = new GridData();
        gdt1.widthHint = LABEL_WIDTH;
        baseClassTitleLabel.setLayoutData(gdt1);

        baseClassText = new Text(base, SWT.SINGLE | SWT.BORDER);
        gdt1 = new GridData();
        gdt1.widthHint = CANVAS_WIDTH - LABEL_WIDTH;
        baseClassText.setLayoutData(gdt1);        
        baseClassText.addModifyListener(new ModifyListener(){
            public void modifyText(ModifyEvent ev) {
                if (no_set_action == true){
                    return;
                }
                Text text = (Text)ev.getSource();
                setBaseClassInstanceAttr(text.getText());
            }
        });

        // access attributes of instance
        base = createDefaultComposite(mainCanvas);
        classSettingsArea8 = base;

        Label generateRemoteClassTitleLabel = new Label(base, SWT.NONE);
        
        generateRemoteClassTitleLabel.setText(GENERATE_REMOTE_CLASS_TITLE);
        gdt1 = new GridData();
        gdt1.widthHint = LABEL_WIDTH;
        generateRemoteClassTitleLabel.setLayoutData(gdt1);

        generateRemoteClassBtn = new Button(base, SWT.NONE | SWT.CHECK);
        generateRemoteClassBtn.setText(GENERATE_REMOTE_CLASS_TITLE2);
        gdt1 = new GridData();
        gdt1.widthHint = CANVAS_WIDTH2 - LABEL_WIDTH;
        generateRemoteClassBtn.setLayoutData(gdt1);
        generateRemoteClassBtn.addSelectionListener(new SelectionListener(){
            public void widgetSelected(SelectionEvent ev) {
                if (no_set_action == true){
                    return;
                }
                Button btn = (Button)ev.getSource();
                setGenerateRemoteClassAttr(btn.getSelection());
            }
            public void widgetDefaultSelected(SelectionEvent ev) {
                if (no_set_action == true){
                    return;
                }
                Button btn = (Button)ev.getSource();
                setGenerateRemoteClassAttr(btn.getSelection());
            }
        });


        addSeparator(mainCanvas);

        classSettingsArea1.setVisible(false);
        classSettingsArea2.setVisible(false);
        classSettingsArea3.setVisible(false);
        classSettingsArea4.setVisible(false);
        classSettingsArea5.setVisible(false);
        classSettingsArea6.setVisible(false);
        classSettingsArea7.setVisible(false);
        classSettingsArea8.setVisible(false);
        classSettingsArea9.setVisible(false);
        classSettingsArea10.setVisible(false);

        
 //       makeAction();
        setVerticalBarAction();
        setHorizontalBarAction();
        InstanceUpdated(null);
    }
    private void setAccessAttr(boolean fl){
        if (targetId == 0){
            return;
        }
        INtkContext context = NtkManager.getNtkContext();
        try{
            context.lock();
        }catch(Exception e){
            System.err.println("MwtInstanceAttributeView.setAccessAttr e="+e);
            return;
        }
        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
        if (fl){
            iman.setUserLongData(targetId,Ntk.NTK_EXT_VAR,1);
        }else{
            iman.setUserLongData(targetId,Ntk.NTK_EXT_VAR,0);
        }
        context.unlock();
    }
    private void setGenerateRemoteClassAttr(boolean fl){
        if (targetId == 0){
            return;
        }
        INtkContext context = NtkManager.getNtkContext();
        try{
            context.lock();
        }catch(Exception e){
            System.err.println("MwtInstanceAttributeView.setGenerateRemoteClassAttr e="+e);
            return;
        }
        
        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
        if (fl){
            iman.setUserLongData(targetId,Ntk.NTK_GENERATE_REMOTE_CLASS,1);
        }else{
            iman.setUserLongData(targetId,Ntk.NTK_GENERATE_REMOTE_CLASS,0);
        }
        context.unlock();
    }
    private void setClassIconAttr(String str){
        if (targetId == 0){
            return;
        }
        INtkContext context = NtkManager.getNtkContext();
        if (locked == false){
            try{
                context.lock();
            }catch(Exception e){
                System.err.println("MwtInstanceAttributeView.setClassIconAttr e="+e);
                return;
            }
        }
        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
        iman.setUserStringData(targetId,Ntk.NTK_CLASS_BASE,str);
        if (locked == false){
            context.unlock();    
        }
    }
    private void setBaseClassInstanceAttr(String str){
        if (targetId == 0){
            return;
        }
        INtkContext context = NtkManager.getNtkContext();
        if (locked == false){
            try{
            context.lock();
            }catch(Exception e){
                System.err.println("MwtInstanceAttributeVew.setBaseClassInsntaceAttr e="+e);
                return;
            }
        }
        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
        iman.setUserStringData(targetId,Ntk.NTK_CLASS_BASE,str);
        if (locked == false){
            context.unlock();    
        }
    }
    private void setClassCommentAttr(String str){
        if (targetId == 0){
            return;
        }
        INtkContext context = NtkManager.getNtkContext();
        if (locked == false){
            try{
                context.lock();
            }catch(Exception e){
                System.err.println("MwtInstanceAttributeView.setClassCommentAttr e="+e);
                return;
            }
        }
        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();
        iman.setUserStringData(targetId,Ntk.NTK_CLASS_COMMENT,str);
        if (locked == false){
            context.unlock();    
        }
    }
    private void selectWindowType(int val){
        if (targetId == 0){
            return;
        }
        INtkContext context = NtkManager.getNtkContext();
        try{
            context.lock();
        }catch(Exception e){
            System.err.println("MwtInstanceAttributeVew.selectWindowType e="+e);
            return;
        }
        INtkInstanceManager iman = NtkManager.getNtkInstanceManager();

        if (val == 0){
            iman.setUserLongData(targetId,Ntk.NTK_CLASS_DEF,0);
            iman.setUserLongData(targetId,Ntk.NTK_STORE_DEF,0);
        }else if (val == 1){
            iman.setUserLongData(targetId,Ntk.NTK_CLASS_DEF,1);
            iman.setUserLongData(targetId,Ntk.NTK_STORE_DEF,0);
        }else if (val == 2){
            iman.setUserLongData(targetId,Ntk.NTK_CLASS_DEF,0);
            iman.setUserLongData(targetId,Ntk.NTK_STORE_DEF,1);
        }
        context.unlock();
        targetId = 0;
        instanceUpdatedWork();
    }
    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData(gridData);
    }

    private void setVerticalBarAction(){
        baseCanvas.getVerticalBar().addSelectionListener(new SelectionListener(){
            public void widgetSelected(SelectionEvent ev) {
                ScrollBar vscr = (ScrollBar)ev.getSource();
                Composite baseCanvas = (Canvas)vscr.getParent();
                Composite mainCanvas = (Composite)baseCanvas.getData();
                Point loc = mainCanvas.getLocation();
                mainCanvas.setLocation(loc.x, -vscr.getSelection());
            }
            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }
    
    private void setHorizontalBarAction(){
        baseCanvas.getHorizontalBar().addSelectionListener(new SelectionListener(){
                public void widgetSelected(SelectionEvent ev) {
                    ScrollBar hscr = (ScrollBar)ev.getSource();
                    Composite baseCanvas = (Canvas)hscr.getParent();
                    Composite mainCanvas = (Composite)baseCanvas.getData();
                    Point loc = mainCanvas.getLocation();
                    mainCanvas.setLocation(-hscr.getSelection(), loc.y);               
                }
                public void widgetDefaultSelected(SelectionEvent e) {}
            }
        );
    }
    
 
    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, SWT.NULL);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout(layout);

        GridData data = new GridData();
        data.verticalAlignment = GridData.FILL;
        data.horizontalAlignment = GridData.FILL;
        composite.setLayoutData(data);

        return composite;
    }

}
