/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.mwt.ntkif;

import java.util.ArrayList;

import org.eclipse.nab.core.INtkInstanceManager;
import org.eclipse.nab.core.Ntk;
import org.widestudio.mwt.Mwt;
import org.widestudio.mwt.MwtManage;
import org.widestudio.mwt.WSDappDev;
import org.widestudio.mwt.WSCbase;
import org.widestudio.mwt.WSCbaseList;
import org.widestudio.mwt.WSCstring;
import org.widestudio.mwt.WSCindexData;
import org.widestudio.mwt.WSCprocedure;

public class MwtInstanceManager implements INtkInstanceManager{
    public MwtInstanceManager() {}
    public long readInstanceDataFile(String folder,String fname,int flag){
        WSCbase win = Mwt.WSGFreadWinFile(folder,fname,flag);
        if (win != null){
            long id = Mwt.WSGIappObjectList().getIdFromInstance(win);
            Mwt.WSGIappObjectList().setInstanceId(Mwt.WS_SET_ROOT_INSTANCE,id);
            Mwt.WSGIappObjectList().setInstanceId(Mwt.WS_SET_SELECTED_INSTANCE,id);
            return id;
        }
        return 0;
    }
    public int  saveInstanceDataFile(String path,long inst,int encoding){
        WSCbase instance = Mwt.WSGIappObjectList().getInstanceFromId(inst);

        int ret = Mwt.WSGFsaveWinFile(path,instance,encoding);
        if (ret == Mwt.WS_NO_ERR){
            return Ntk.NTK_NO_ERR;
        }
        return Ntk.NTK_ERR;
    }

    public long getNewInstance(String className,String instanceName,long parent){
        WSCbase pinst = null;
        if (parent != 0){
            pinst = Mwt.WSGIappObjectList().getInstanceFromId(parent);
        }
        WSCbase inst = WSCbase.getNewInstance(className,pinst,instanceName);
        if (inst == null){
            return 0;
        }
        inst.init();
        long ret = Mwt.WSGIappObjectList().getIdFromInstance(inst);
        return ret;
    }
    public long getInstance(String className,String instanceName){
        WSCbase inst = Mwt.WSGIappObjectList().getInstance(className,instanceName);
        if (inst == null){
            return 0;
        }
        long ret = Mwt.WSGIappObjectList().getIdFromInstance(inst);
        return ret;
    }
    
    public int setProperty(long id, String prop, int val){
        if (id == 0){
            return Ntk.NTK_ERR;
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        short ret = inst.setProperty(prop,val);
        if (ret == Mwt.True){
            return Ntk.NTK_NO_ERR;
        }
        return Ntk.NTK_ERR;
    }
    public int setProperty(long id, String prop, String val){
        if (id == 0){
            return Ntk.NTK_ERR;
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        short ret = inst.setProperty(prop,val);
        if (ret == Mwt.True){
            return Ntk.NTK_NO_ERR;
        }
        return Ntk.NTK_ERR;
    }
    public int getProperty(long id, String prop){
        if (id == 0){
            return Ntk.NTK_ERR;
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        return inst.getProperty(prop).getInt();
    }
    public String getProperty(long id, String prop, int encoding){
        if (id == 0){
            return "";
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        if (encoding == Ntk.NTK_EN_DEFAULT){
            return inst.getProperty(prop).getCharPtr();
        }
        String val = inst.getProperty(prop).getCharPtr();
        WSCstring str = new WSCstring(val);
        return str.getString(encoding);
    }

    public int setUserLongData(long id,String prop,long val){
        if (id == 0){
            Mwt.WSGIappObjectList().setUserLongData(prop,val);
            return Ntk.NTK_NO_ERR;
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        inst.setUserLongData(prop,val);
        return Ntk.NTK_NO_ERR;
    }
    public long getUserLongData(long id,String prop){
        if (id == 0){
            return Mwt.WSGIappObjectList().getUserLongData(prop);
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        return inst.getUserLongData(prop);
    }
    public int setUserStringData(long id,String prop,String val){
        if (id == 0){
            Mwt.WSGIappObjectList().setUserStringData(prop,val);
            return Ntk.NTK_NO_ERR;
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        inst.setUserStringData(prop,val);
        return Ntk.NTK_NO_ERR;
    }
    public String getUserStringData(long id,String prop){
        if (id == 0){
            return Mwt.WSGIappObjectList().getUserStringData(prop);
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        return inst.getUserStringData(prop);
    }
    public int setInstanceId(int kind, long id){
        if (id == 0){
            return Ntk.NTK_ERR;
        }
        Mwt.WSGIappObjectList().setInstanceId(kind,id);
        return Ntk.NTK_NO_ERR;
    }
    public String getInstanceData(long id,int kind,long val,int encode){
        if (id == 0){
            return "";
        }
        return Mwt.WSGIappObjectList().getInstanceData(id,kind,val).getString(encode);
    }

    public int setupInstance(long id){
        if (id == 0){
            return Ntk.NTK_ERR;
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        Mwt.WSGFsetupInstance(inst);
        return Ntk.NTK_NO_ERR;
    }
    public void setSelectedInstance(long id){
        Mwt.WSGIappObjectList().setInstanceId(Mwt.WS_SET_SELECTED_INSTANCE,id);
        WSCbase ptr = Mwt.WSGIappObjectList().getInstanceFromId(id);
        ptr.setPropertyEditExecute((short)1);
    }
    public int setVisible(long id,boolean fl){
        if (id == 0){
            return Ntk.NTK_ERR;
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        if (fl == false){
            inst.setVisible((short)0);
        }else{
            inst.setVisible((short)1);
        }
        return Ntk.NTK_NO_ERR;
        
    }
    public boolean getVisible(long id){
        if (id == 0){
            return false;
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        if (inst.getVisible() == (short)1){
            return true;
        }
        return false;
    }
    public long getParentWindow(long id){
        if (id == 0){
            return 0;
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        WSCbase parent = inst.getParentWindow();
        return Mwt.WSGIappObjectList().getIdFromInstance(parent);
    }
    public long getParent(long id){
        if (id == 0){
            return 0;
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        WSCbase parent = inst.getParent();
        return Mwt.WSGIappObjectList().getIdFromInstance(parent);
    }
    public boolean existInstance(long id){
        if (id == 0){
            return false;
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        short ret = Mwt.WSGIappObjectList().existInstance(inst);
        if (ret == (short)0){
            return false;
        }
        return true;
    }
    ArrayList copyInstanceList = null;
    ArrayList deleteInstanceList = null;
    public ArrayList setCopyList(ArrayList inst){
        if(copyInstanceList == null){
            copyInstanceList = new ArrayList(); 
        }
        return copyInstanceList = inst;
    }
    
    public ArrayList getCopyList() {
        return copyInstanceList;
    }
    
    public ArrayList setDeleteList(ArrayList inst){
        return deleteInstanceList = inst;
    }
    
    public ArrayList getDeleteList() {
        return deleteInstanceList;
    }
    public int pasteInstance(long id,long id2){
        if (id == 0 || id2 == 0){
            return Ntk.NTK_ERR;
        }

        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        WSCbase inst2 = Mwt.WSGIappObjectList().getInstanceFromId(id2);
        return Mwt.WSGFpasteInstance(inst,inst2);
    }
    public long getInstanceId(long id,int kind,long val){
        return Mwt.WSGIappObjectList().getInstanceId(id,kind,val);
    }
    public boolean existProperty(long id,String prop){
        if (id == 0){
            return false;
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        short val = inst.existProperty(prop);
        if (val == 0){
            return false;
        }
        return true;
    }
    public int deleteInstance(long id){
        if (id == 0){
            return Ntk.NTK_ERR;
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        return Mwt.WSGFdestroyWindow(inst);
    }
    public int redraw(long id){
        if (id == 0){
            return Ntk.NTK_ERR;
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        return inst.redraw();
    }
    public int getInstanceType(long id){
        if (id == 0){
            return Ntk.NTK_ERR;
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        return inst.getObjectType();
    }
    public String getClassName(long id){
        if (id == 0){
            return "void";
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        return inst.getClassName();
    }
    public long checkInstanceName(long id,String name) {

//      ret = 0                      //no exist
//      ret = NTK_PROCEDURE_NAME      //hit another procedure name
//      ret = NTK_OBJECT_NAME         //hit another externed GUI instance name
//      ret = NTK_OBJECT_ARRAY_NAME   //hit arrayed GUI instance name
//      ret = NTK_OBJECT_ARRAY_NAME_INVALID  //hit arrayed GUI instance name on another window
//      ret = NTK_OTHER_NAME 
//      ret = NTK_INVALID_NAME 
        
        long result = 0;
        long resStr = Mwt.WSGFcheckNameString(name);
        if (resStr == 0){
            if (Mwt.WSGFisArrayName(name) == (short)1){
                if (id != 0){
                    WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
                    long resExist = Mwt.WSGFexistName(name, inst);
                    WSCbase pwin = inst.getParentWindow();
                    long pwin_id = Mwt.WSGIappObjectList().getIdFromInstance(pwin);
                    if (id == pwin_id){
                        return Ntk.NTK_INVALID_WIN_NAME;
                    }
                    if (pwin_id == 0){
                        return Ntk.NTK_INVALID_WIN_NAME;                        
                    }
                    if (inst.getParentWindow().getUserLongData("WIN-CLASS") != 0){
                        return Ntk.NTK_INVALID_WIN_NAME;
                    }
                    if (resExist == 0 || resExist == Ntk.NTK_OBJECT_ARRAY_NAME){
                        return 0;
                    }
                    return resExist;
                }
                return 0;
            }else{
                return Ntk.NTK_INVALID_NAME;
            }
        }else{
            WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
            long resExist = Mwt.WSGFexistName(name, inst);
            
            if(id == 0) {
                if(resExist == Ntk.NTK_OBJECT_ARRAY_NAME) {
                    result = 0;
                }
            } else {
                result = resExist;
            }
            return result;
        }
    }
    public int setNewInstancePositionMode(boolean fl){
        if (fl == true){
            Mwt.WSGIappObjectList().setNewInstancePositionMode((short)1);
        }else{
            Mwt.WSGIappObjectList().setNewInstancePositionMode((short)0);
        }
        return Ntk.NTK_NO_ERR;
    }
    public int loadLibrary(String libname){
        Mwt.WSGFloadLibrary(0,libname);
        return Ntk.NTK_NO_ERR;
    }
    public int setNewInstanceClassName(String cname){
        Mwt.WSGIappObjectList().setNewInstanceClassName(cname);
        return Ntk.NTK_NO_ERR;
    }
    public boolean existTrigger(long id, int trig){
        if (id == 0){
            return false;
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        short ret = inst.existTrigger(trig);
        if (ret == (short)1){
            return true;
        }
        return false;
    }
    public int getExtTriggerList(long id,ArrayList namelist,ArrayList trglist){
        if (id == 0){
            return 0;
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);

        WSCindexData list = inst.getExtTriggerList();
        int num = list.getNum();
        for(int i = 0; i < num; i++) {
            trglist.add(new Integer(list.getData(i)));
            namelist.add(list.getIndex(i));
        }       
        return num;
    }
    public int  addProcedure(long id, String procedureName, String functionName, int triggerNum){
        if (id == 0){
            return 0;
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);
        return inst.addProcedure(procedureName,functionName,triggerNum);
    }
    public int configureProcedure(long procId, String procedureName, String functionName, int triggerNum){
        if (procId == 0){
            return Ntk.NTK_ERR;
        }
        WSCprocedure proc = Mwt.WSGFidToProcedure(procId);
        
        proc.setFunction(null,functionName);
        proc.setProcName(procedureName);
        proc.setTrigger(triggerNum);
        return Ntk.NTK_NO_ERR;
    }
    public int delProcedure(long id,long procId){
        if (id == 0){
            return 0;
        }
        WSCbase inst = Mwt.WSGIappObjectList().getInstanceFromId(id);

        if (procId == 0){
            return Ntk.NTK_ERR;
        }
        return inst.delProcedure((int)procId);
    }
    public long checkProcedureName(String pname){
        
        long result = 0;
        long resStr = Mwt.WSGFcheckNameString(pname);

        if(resStr == 0) {
            result = 6;
        }
        return result;
    }
    public String getProcedureName(long procId){
        WSCprocedure proc = Mwt.WSGFidToProcedure(procId);
        return proc.getProcName();
    }
    public String getFunctionName(long procId){
        WSCprocedure proc = Mwt.WSGFidToProcedure(procId);
        return proc.getFunctionName();
        
    }
    public int  getTrigger(long procId){
        WSCprocedure proc = Mwt.WSGFidToProcedure(procId);
        return proc.getTrigger();
    }
    public String getProcedureAttribute(long procId,String attr){
        if (attr == "independence"){
            WSCprocedure proc = Mwt.WSGFidToProcedure(procId);
            short val = proc.getUseFile();
            if (val == 0){
                return "false";
            }
            return "true";
        }
        return "";
    }
    public int setFunctionName(long procId,String fname){
        WSCprocedure proc = Mwt.WSGFidToProcedure(procId);
        proc.setFunction(null,fname);
        return Ntk.NTK_NO_ERR;
    }
    public int setProcedureName(long procId,String pname){
        WSCprocedure proc = Mwt.WSGFidToProcedure(procId);
        proc.setProcName(pname);
        return Ntk.NTK_NO_ERR;
        
    }
    public int setTrigger(long procId,int trigger){
        WSCprocedure proc = Mwt.WSGFidToProcedure(procId);
        return proc.setTrigger(trigger);
    }
    public int setProcedureAttribute(long procId,String attr,String val){
        if (attr == "independence"){
            WSCprocedure proc = Mwt.WSGFidToProcedure(procId);
            if (val == "true"){
                proc.setUseFile((short)1);
            }else{
                proc.setUseFile((short)0);
            }
        }
        return Ntk.NTK_NO_ERR;
    }
    public long getTargetInstance(){
        return MwtManage.getTargetInstance();
    }
    public int setTargetInstance(long id){
        MwtManage.setTargetInstance(id);
        return Ntk.NTK_NO_ERR;
    }
    public boolean isParent(long parent,long child){
        if (existInstance(parent) == false || existInstance(child) == false){
            return false;
        }
        WSCbase pinst = Mwt.WSGIappObjectList().getInstanceFromId(parent);
        WSCbase cinst = Mwt.WSGIappObjectList().getInstanceFromId(child);

        if (cinst.isParent(pinst) == 1){
            return true;
        }
        return false;
    }

}
