/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.android;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewAndroidLozalizationFileDialog
extends Dialog {
    private static final String DIALOG_TITLE = "New Android Localization File";
    private static final String COUNTRY_LABEL = "Country Code (3 digits):";
    private static final String LANGUAGE_LABEL = "Language:";
    private Text countryCode;
    private Text language;
    private Button bypassProxyButton;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            NewAndroidLozalizationFileDialog.this.validate();
        }
    };

    public NewAndroidLozalizationFileDialog(Shell parent) {
        super(parent);
    }

    protected Point getInitialSize() {
        return new Point(240, 290);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DIALOG_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite external = this.createDefaultComposite(parent, 1, 17);
        Composite fields = this.createDefaultComposite(external, 2, 0);
        int cols = 20;
        Label countryLabel = new Label(fields, 131072);
        this.countryCode = new Text(fields, parent.getStyle() | 0x800);
        Label languageLabel = new Label(fields, 131072);
        this.language = new Text(fields, parent.getStyle() | 0x800);
        GC gc = new GC((Drawable)this.countryCode.getDisplay());
        int width = gc.getFontMetrics().getAverageCharWidth() * cols;
        int height = gc.getFontMetrics().getHeight();
        GridData gridData = new GridData();
        gridData.heightHint = height;
        gridData.widthHint = width;
        countryLabel.setText(COUNTRY_LABEL);
        this.countryCode.setLayoutData((Object)gridData);
        this.countryCode.setSize(this.countryCode.computeSize(width, height));
        languageLabel.setText(LANGUAGE_LABEL);
        this.language.setSize(this.language.computeSize(width, height));
        this.language.setLayoutData((Object)gridData);
        this.createCombo(external);
        Composite bypassComposite = new Composite(external, 0);
        GridData gdata = new GridData(4, 4, true, false);
        bypassComposite.setLayoutData((Object)gdata);
        GridLayout glayout = new GridLayout();
        bypassComposite.setLayout((Layout)glayout);
        this.bypassProxyButton = new Button(bypassComposite, 32);
        Point p = this.bypassProxyButton.getLocation();
        this.bypassProxyButton.setLocation(p.x, p.y + 100);
        this.bypassProxyButton.setText("Create ID manually");
        this.countryCode.addModifyListener(this.listener);
        this.language.addModifyListener(this.listener);
        return external;
    }

    protected void okPressed() {
        String host = this.countryCode.getText();
        MessageDialog.openInformation((Shell)new Shell(), (String)"Ok pressed", (String)("Yeah baby" + host));
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true).setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false).setEnabled(true);
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    private Composite createDefaultComposite(Composite parent, int columns, int left) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        if (columns > 0) {
            layout.numColumns = columns;
        }
        layout.marginLeft = left + 5;
        layout.marginTop = 5;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private void createCombo(Composite composite) {
        Composite comboComposite = new Composite(composite, 0);
        GridData data = new GridData(4, 4, true, false);
        comboComposite.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout();
        comboComposite.setLayout((Layout)gridLayout);
        Label configListLabel = new Label(comboComposite, 0);
        configListLabel.setText("Orientation:");
        Combo orientationCombo = new Combo(comboComposite, 8);
        data = new GridData(4, 0x1000000, true, false);
        orientationCombo.setLayoutData((Object)data);
        orientationCombo.add("None");
        orientationCombo.add("Landscape");
        orientationCombo.add("Portrait");
        orientationCombo.select(1);
    }

    private void validate() {
        if (this.countryCode != null && this.language != null) {
            this.getButton(0).setEnabled(this.countryCode.getText().length() > 0 && this.language.getText().length() > 0);
        }
    }
}

