/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.vncviews.views;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tml.vncviewer.vncviews.views.VNCViewerView;

public class OpenConnectionDialog
extends TitleAreaDialog {
    private Text hostText;
    private Text portText;
    private Combo protocolVersion;

    public OpenConnectionDialog(Shell parent) {
        super(parent);
    }

    protected Point getInitialSize() {
        return new Point(260, 290);
    }

    protected Control createDialogArea(Composite parent) {
        Composite external = this.createDefaultComposite(parent, 1, 15);
        Composite fields = this.createDefaultComposite(external, 2, 0);
        this.setTitle("New VNC connection");
        this.setMessage("Enter values for the connection parameters");
        int cols = 20;
        Label hostLabel = new Label(fields, 131072);
        this.hostText = new Text(fields, parent.getStyle() | 0x800);
        Label portLabel = new Label(fields, 131072);
        this.portText = new Text(fields, parent.getStyle() | 0x800);
        GC gc = new GC((Drawable)this.hostText.getDisplay());
        int width = gc.getFontMetrics().getAverageCharWidth() * cols;
        int height = gc.getFontMetrics().getHeight();
        GridData gridData = new GridData();
        gridData.heightHint = height;
        gridData.widthHint = width;
        hostLabel.setText("Host:");
        this.hostText.setLayoutData((Object)gridData);
        this.hostText.setSize(this.hostText.computeSize(width, height));
        portLabel.setText("Port:");
        this.portText.setSize(this.portText.computeSize(width, height));
        this.portText.setLayoutData((Object)gridData);
        this.createCombo(external);
        return external;
    }

    protected void okPressed() {
        String host = this.hostText.getText();
        int port = Integer.valueOf(this.portText.getText());
        String version = this.protocolVersion.getItem(this.protocolVersion.getSelectionIndex());
        VNCViewerView.start(host, port, version);
        super.okPressed();
    }

    protected void cancelPressed() {
        VNCViewerView.stop();
        super.cancelPressed();
    }

    private Composite createDefaultComposite(Composite parent, int columns, int left) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        if (columns > 0) {
            layout.numColumns = columns;
        }
        layout.marginLeft = left;
        layout.marginTop = 5;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private void createCombo(Composite composite) {
        Composite comboComposite = new Composite(composite, 0);
        GridData data = new GridData(4, 4, true, false);
        comboComposite.setLayoutData((Object)data);
        GridLayout configAndDescriptionCompositeLayout = new GridLayout();
        comboComposite.setLayout((Layout)configAndDescriptionCompositeLayout);
        Label configListLabel = new Label(comboComposite, 0);
        configListLabel.setText("VNC Protocol used as base:");
        Combo protocolCombo = new Combo(comboComposite, 8);
        data = new GridData(4, 0x1000000, true, false);
        protocolCombo.setLayoutData((Object)data);
        protocolCombo.add("VNC 3.3");
        protocolCombo.add("VNC 3.7");
        protocolCombo.add("VNC 3.8");
        protocolCombo.select(2);
        this.protocolVersion = protocolCombo;
    }
}

