/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.vncviews.views;

import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tml.vncviewer.VNCViewerPlugin;
import org.eclipse.tml.vncviewer.graphics.RemoteDisplayFactory;
import org.eclipse.tml.vncviewer.graphics.swt.SWTRemoteDisplay;
import org.eclipse.tml.vncviewer.network.IProtoClient;
import org.eclipse.tml.vncviewer.network.ProtocolFactory;
import org.eclipse.ui.part.ViewPart;

public class VNCViewerView
extends ViewPart {
    private static SWTRemoteDisplay swtDisplay;
    private static boolean running;
    private static IProtoClient protocol;

    static {
        running = false;
    }

    public void createPartControl(Composite parent) {
        swtDisplay = (SWTRemoteDisplay)RemoteDisplayFactory.getDisplay((String)"SWTDisplay", (Composite)parent);
        running = true;
        if (protocol != null) {
            try {
                swtDisplay.start(protocol);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setFocus() {
        if (swtDisplay != null) {
            swtDisplay.setFocus();
        }
    }

    public void dispose() {
        running = false;
        if (swtDisplay != null) {
            swtDisplay.dispose();
        }
        super.dispose();
    }

    public static synchronized void start(String host, int port, String protoVersion) {
        if (running && swtDisplay != null) {
            if (swtDisplay.isActive()) {
                swtDisplay.stop();
            }
            try {
                IProtoClient protocol;
                VNCViewerView.protocol = protocol = ProtocolFactory.getProtocol((String)protoVersion);
                protocol.runProtocol(host, port);
                swtDisplay.start(protocol);
            }
            catch (Exception e) {
                VNCViewerPlugin.log(VNCViewerView.class).error((Object)("Viewer could not be started: " + e.getMessage()));
                GC gc = new GC((Drawable)swtDisplay.getCanvas());
                gc.fillRectangle(0, 0, swtDisplay.getScreenWidth(), swtDisplay.getScreenHeight());
                gc.dispose();
            }
        }
    }

    public static synchronized void stop() {
        if (running && swtDisplay != null && swtDisplay.isActive()) {
            swtDisplay.stop();
        }
    }
}

