/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.common.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.StringTokenizer;

public class FileUtil {
    public static void copyDir(File fromDir, File toDir) throws IOException {
        if (fromDir != null && fromDir.isDirectory() && fromDir.canRead() && toDir != null && toDir.isDirectory() && toDir.canWrite()) {
            File[] fileArray = fromDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isFile()) {
                    FileUtil.copyFile(child, new File(toDir, child.getName()));
                } else {
                    File newDir = new File(toDir.getAbsolutePath(), child.getName());
                    newDir.mkdir();
                    FileUtil.copyDir(child, newDir);
                }
                ++n2;
            }
        } else {
            String errorMessage = "";
            if (fromDir == null) {
                errorMessage = "Null pointer for source directory.";
            } else if (!fromDir.isDirectory()) {
                errorMessage = String.valueOf(fromDir.getName()) + " is not a directory.";
            } else if (!fromDir.canRead()) {
                errorMessage = "Cannot read from " + fromDir.getName() + ".";
            } else if (toDir == null) {
                errorMessage = "Null pointer for destination directory.";
            } else if (!toDir.isDirectory()) {
                errorMessage = String.valueOf(toDir.getName()) + " is not a directory.";
            } else if (!toDir.canWrite()) {
                errorMessage = "Cannot write to" + toDir.getName() + ".";
            }
            throw new IOException("Error copying directory: " + errorMessage);
        }
    }

    public static void copyFile(File source, File target) throws IOException {
        FileUtil.copyFile(source.getAbsolutePath(), target.getAbsolutePath());
    }

    private static void copyFile(String source, String target) throws IOException {
        FileChannel sourceFileChannel = null;
        AbstractInterruptibleChannel targetFileChannel = null;
        try {
            sourceFileChannel = new FileInputStream(source).getChannel();
            targetFileChannel = new FileOutputStream(target).getChannel();
            ((FileChannel)targetFileChannel).transferFrom(sourceFileChannel, 0L, sourceFileChannel.size());
        }
        finally {
            if (sourceFileChannel != null) {
                sourceFileChannel.close();
            }
            if (targetFileChannel != null) {
                targetFileChannel.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean deleteDirRecursively(File directory) throws IOException {
        String dirName = "";
        boolean success = true;
        if (!directory.exists()) {
            String errorMessage = "The directory does not exist.";
            success = false;
            throw new IOException(errorMessage);
        }
        if (!directory.isDirectory()) {
            String errorMessage = String.valueOf(directory.getName()) + " is not a diretory.";
            throw new IOException(errorMessage);
        }
        dirName = directory.getName();
        File[] children = directory.listFiles();
        int i = 0;
        while (i < children.length) {
            success = children[i].isFile() ? success && children[i].delete() : success && this.deleteDirRecursively(children[i]);
            ++i;
        }
        if (!success) return false;
        if (!directory.delete()) return false;
        boolean bl = true;
        success = bl;
        if (!success) return success;
        dirName.equals("");
        return success;
    }

    public void deleteFile(File fileToDelete) throws IOException {
        if (!(fileToDelete != null && fileToDelete.exists() && fileToDelete.isFile() && fileToDelete.canWrite())) {
            String errorMessage = "";
            if (fileToDelete == null) {
                errorMessage = "Null pointer for file to delete.";
            } else if (!fileToDelete.exists()) {
                errorMessage = "The file " + fileToDelete.getName() + " does not exist.";
            } else if (!fileToDelete.isFile()) {
                errorMessage = String.valueOf(fileToDelete.getName()) + " is not a file.";
            } else if (!fileToDelete.canWrite()) {
                errorMessage = "Cannot write to " + fileToDelete.getName();
            }
            throw new IOException("Cannot delete file: " + errorMessage);
        }
        fileToDelete.delete();
    }

    public void deleteFilesOnList(File[] filesToDelete) throws IOException {
        int index = 0;
        while (index < filesToDelete.length) {
            this.deleteFile(filesToDelete[index]);
            ++index;
        }
    }

    public static String getExtension(String fileName) {
        if (fileName != null) {
            int i = fileName.lastIndexOf(".") + 1;
            return i == 0 ? "" : fileName.substring(i);
        }
        return null;
    }

    public static String getRelativeFilename(File homeDir, File targetFile) throws IOException {
        throw new Error("Unresolved compilation problems: \n\tThe type List is not generic; it cannot be parameterized with arguments <File>\n\tThe method getFilesComposingPath(File) is undefined for the type FileUtil\n\tThe type List is not generic; it cannot be parameterized with arguments <File>\n\tThe method getFilesComposingPath(File) is undefined for the type FileUtil\n");
    }

    public static File getCanonicalFile(String absoluteFilename) {
        return FileUtil.getCanonicalFile(new File(absoluteFilename));
    }

    public static File getCanonicalFile(File location, String filename) {
        return FileUtil.getCanonicalFile(new File(location, filename));
    }

    /*
     * Unable to fully structure code
     */
    public static File getCanonicalFile(File aFile) {
        block5: {
            f = null;
            try {
                f = aFile.getCanonicalFile();
                break block5;
            }
            catch (IOException v0) {
                filename = aFile.getAbsolutePath();
                st = new StringTokenizer(filename, File.separator);
                sb = new StringBuffer();
                ** while (st.hasMoreTokens())
            }
lbl-1000:
            // 1 sources

            {
                token = (String)st.nextElement();
                if (token.equals("..")) {
                    lastDirIndex = sb.lastIndexOf(File.separator);
                    if (lastDirIndex <= 2) continue;
                    sb.delete(lastDirIndex, sb.length());
                    continue;
                }
                if (token.equals(".")) continue;
                if (sb.length() > 0) {
                    sb.append(File.separator);
                }
                sb.append(token);
                if (!token.endsWith(":")) continue;
                sb.append(File.separator);
                continue;
            }
lbl27:
            // 1 sources

            f = new File(sb.toString());
        }
        return f;
    }
}

