/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.common.utilities;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tml.common.utilities.FileUtil;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.common.utilities.exception.TmLExceptionHandler;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class PluginUtils {
    public static IProject getSelectedProjectInWorkbench() {
        IProject selectedProject = null;
        try {
            IWorkbench iworkbench = PlatformUI.getWorkbench();
            IWorkbenchWindow iworkbenchwindow = iworkbench.getActiveWorkbenchWindow();
            IWorkbenchPage iworkbenchpage = iworkbenchwindow.getActivePage();
            ISelection selection = iworkbenchpage.getSelection();
            IResource resource = PluginUtils.extractSelection(selection);
            if (resource == null) {
                IEditorPart editor = iworkbenchpage.getActiveEditor();
                IEditorInput input = editor.getEditorInput();
                resource = (IResource)input.getAdapter(IResource.class);
            }
            selectedProject = resource.getProject();
        }
        catch (Exception exception) {}
        return selectedProject;
    }

    public static IProject getSelectedProjectInWorkbench(ISelection selection) {
        IProject selectedProject = null;
        try {
            IWorkbench iworkbench = PlatformUI.getWorkbench();
            IWorkbenchWindow iworkbenchwindow = iworkbench.getActiveWorkbenchWindow();
            IWorkbenchPage iworkbenchpage = iworkbenchwindow.getActivePage();
            IResource resource = PluginUtils.extractSelection(selection);
            if (resource == null) {
                IEditorPart editor = iworkbenchpage.getActiveEditor();
                IEditorInput input = editor.getEditorInput();
                resource = (IResource)input.getAdapter(IResource.class);
            }
            selectedProject = resource.getProject();
        }
        catch (Exception exception) {}
        return selectedProject;
    }

    private static IResource extractSelection(ISelection sel) {
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ss = (IStructuredSelection)sel;
        IResource element = (IResource)ss.getFirstElement();
        if (element instanceof IResource) {
            return element;
        }
        if (!(element instanceof IAdaptable)) {
            return null;
        }
        IResource adaptable = element;
        Object adapter = adaptable.getAdapter(IResource.class);
        return (IResource)adapter;
    }

    public static Object getExecutable(String extensionId, String elementName) throws CoreException {
        Object executable = null;
        IExtension fromExtension = PluginUtils.getExtension(extensionId);
        if (fromExtension != null && elementName != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = fromExtension.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (elementName.equals(element.getName())) {
                    executable = element.createExecutableExtension("class");
                }
                ++n2;
            }
        }
        return executable;
    }

    public static IExtension getExtension(String extensionPointId, String extensionId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension extension = registry.getExtension(extensionPointId, extensionId);
        return extension;
    }

    public static IExtension getExtension(String extensionId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension extension = registry.getExtension(extensionId);
        return extension;
    }

    public static String getExtensionLabel(String extensionPointId, String extensionId) {
        IExtension extension = PluginUtils.getExtension(extensionPointId, extensionId);
        String extensionLabel = extension != null ? extension.getLabel() : extensionId;
        return extensionLabel;
    }

    public static String getExtensionLabel(String extensionId) {
        IExtension extension = PluginUtils.getExtension(extensionId);
        String extensionLabel = extension != null ? extension.getLabel() : extensionId;
        return extensionLabel;
    }

    public static String[] getInstalledPluginsAsArray(String extensionPointId) {
        throw new Error("Unresolved compilation problems: \n\tThe type Collection is not generic; it cannot be parameterized with arguments <String>\n\tThe method getInstalledPlugins(String) is undefined for the type PluginUtils\n");
    }

    public static String getPluginAttribute(String extensionPointId, String extensionId, String element, String attribute) {
        IExtension fromPlugin = PluginUtils.getExtension(extensionPointId, extensionId);
        return PluginUtils.getPluginAttribute(fromPlugin, element, attribute);
    }

    public static String getPluginAttribute(String extensionId, String element, String attribute) {
        IExtension fromPlugin = PluginUtils.getExtension(extensionId);
        return PluginUtils.getPluginAttribute(fromPlugin, element, attribute);
    }

    public static String getPluginAttribute(IExtension fromExtension, String element, String attribute) {
        String attributeValue = null;
        if (fromExtension != null) {
            IConfigurationElement[] ceArray;
            IConfigurationElement[] iConfigurationElementArray = ceArray = fromExtension.getConfigurationElements();
            int n = ceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                if (ce != null && ce.getName().equals(element)) {
                    attributeValue = ce.getAttribute(attribute);
                }
                ++n2;
            }
        }
        return attributeValue;
    }

    public static Object getExecutableAttribute(IExtension fromExtension, String elementName, String attribute) throws CoreException {
        Object executable = null;
        if (fromExtension != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = fromExtension.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (elementName.equals(element.getName())) {
                    executable = element.createExecutableExtension(attribute);
                }
                ++n2;
            }
        }
        return executable;
    }

    public static File getPluginInstallationPath(Plugin plugin) {
        Bundle pluginBundle = plugin.getBundle();
        return PluginUtils.getPluginInstallationPath(pluginBundle);
    }

    public static File getPluginInstallationPath(String extensionPointId, String extensionId) {
        IExtension extension = PluginUtils.getExtension(extensionPointId, extensionId);
        return PluginUtils.getPluginInstallationPath(extension);
    }

    public static File getPluginInstallationPath(IExtension extension) {
        String pluginId = extension.getNamespaceIdentifier();
        Bundle pluginBundle = Platform.getBundle((String)pluginId);
        return PluginUtils.getPluginInstallationPath(pluginBundle);
    }

    public static File getPluginInstallationPath(Bundle pluginBundle) {
        String pluginPath = pluginBundle.getLocation();
        int removeIndex = pluginPath.indexOf("file:");
        pluginPath = Platform.getOS().equals("win32") ? pluginPath.substring(removeIndex + 6) : pluginPath.substring(removeIndex + 5);
        File relativeInstalationPath = new File(pluginPath);
        return FileUtil.getCanonicalFile(relativeInstalationPath);
    }

    public static File getPluginResource(Plugin plugin, String resource) throws TmLException {
        File canonicalFile = null;
        try {
            File pluginPath = PluginUtils.getPluginInstallationPath(plugin);
            File resourceFile = new File(pluginPath, resource);
            canonicalFile = FileUtil.getCanonicalFile(resourceFile);
        }
        catch (Throwable t) {
            throw TmLExceptionHandler.exception(1001, t);
        }
        return canonicalFile;
    }

    public static boolean isInstalled(String extensionPointId, String extensionId) {
        return PluginUtils.getExtension(extensionPointId, extensionId) != null;
    }

    public static boolean isInstalled(String extensionId) {
        return PluginUtils.getExtension(extensionId) != null;
    }
}

