/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.protocol.lib.internal.model;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.tml.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.tml.protocol.lib.IProtocolHandshake;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.protocol.lib.exceptions.InvalidDefinitionException;
import org.eclipse.tml.protocol.lib.exceptions.InvalidInputStreamDataException;
import org.eclipse.tml.protocol.lib.exceptions.InvalidMessageException;
import org.eclipse.tml.protocol.lib.exceptions.MessageHandleException;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolHandshakeException;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolRawHandlingException;
import org.eclipse.tml.protocol.lib.internal.engine.ProtocolEngine;
import org.eclipse.tml.protocol.lib.internal.model.IModel;
import org.eclipse.tml.protocol.lib.internal.model.ServerProtocolEngineFactory;
import org.eclipse.tml.protocol.lib.msgdef.ProtocolMsgDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerModel
implements IModel {
    private static ServerModel instance;
    private Map<ProtocolHandle, ServerSocket> openedServerSockets = new HashMap<ProtocolHandle, ServerSocket>();
    private Map<ProtocolHandle, ServerProtocolEngineFactory> engineFactories = new HashMap<ProtocolHandle, ServerProtocolEngineFactory>();
    private Map<ProtocolHandle, Collection<ProtocolEngine>> connectedClients = new HashMap<ProtocolHandle, Collection<ProtocolEngine>>();

    private ServerModel() {
    }

    public static ServerModel getInstance() {
        if (instance == null) {
            instance = new ServerModel();
        }
        return instance;
    }

    public ProtocolHandle startListeningToPort(int portToBind, Map<Long, ProtocolMsgDefinition> allMessages, Collection<String> incomingMessages, Collection<String> outgoingMessages, IProtocolHandshake protocolInitializer, IProtocolExceptionHandler exceptionHandler, boolean isBigEndianProtocol) throws ProtocolHandshakeException, IOException {
        if (portToBind <= 0 || allMessages == null || incomingMessages == null || outgoingMessages == null) {
            throw new ProtocolHandshakeException("Invalid parameters provided to method");
        }
        ProtocolHandle handle = new ProtocolHandle();
        ServerSocket serverSocket = new ServerSocket(portToBind);
        ServerProtocolEngineFactory factory = new ServerProtocolEngineFactory(handle, protocolInitializer, allMessages, incomingMessages, outgoingMessages, exceptionHandler, isBigEndianProtocol);
        this.openedServerSockets.put(handle, serverSocket);
        this.engineFactories.put(handle, factory);
        ServerDeamon deamon = new ServerDeamon(handle, serverSocket, factory);
        Thread deamonThread = new Thread(deamon);
        deamonThread.start();
        return handle;
    }

    public void stopListeningToPort(ProtocolHandle handle) throws IOException {
        ServerSocket serverSocket = this.openedServerSockets.get(handle);
        if (serverSocket != null) {
            serverSocket.close();
        }
    }

    public void restartServerProtocol(ProtocolHandle handle) throws IOException, ProtocolHandshakeException {
        ServerSocket ss = this.openedServerSockets.get(handle);
        if (ss != null) {
            int portToBind = ss.getLocalPort();
            ServerProtocolEngineFactory factory = this.engineFactories.get(handle);
            this.stopListeningToPort(handle);
            this.startListeningToPort(portToBind, factory.getAllMessages(), factory.getIncomingMessages(), factory.getOutgoingMessages(), null, factory.getExceptionHandler(), factory.isBigEndianProtocol());
        }
    }

    @Override
    public void cleanStoppedProtocols() {
        Set<ProtocolHandle> keys = this.connectedClients.keySet();
        for (ProtocolHandle key : keys) {
            Collection<ProtocolEngine> aImplCollection = this.connectedClients.get(key);
            for (ProtocolEngine aImpl : aImplCollection) {
                if (aImpl.isConnected()) continue;
                aImplCollection.remove(aImpl);
            }
        }
    }

    private class ServerDeamon
    implements Runnable {
        private ProtocolHandle handle;
        private ServerSocket serverSocket;
        private ServerProtocolEngineFactory factory;

        public ServerDeamon(ProtocolHandle handle, ServerSocket serverSocket, ServerProtocolEngineFactory factory) {
            this.handle = handle;
            this.serverSocket = serverSocket;
            this.factory = factory;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block36: {
                    try {
                        if (this.serverSocket == null) {
                        }
                        if (this.factory == null) break block36;
                        while (true) {
                            Socket s;
                            try {
                                s = this.serverSocket.accept();
                            }
                            catch (IOException iOException) {
                            }
                            ProtocolEngine eng = this.factory.getServerProtocolEngine();
                            eng.startProtocol(s, null);
                            HashSet<ProtocolEngine> allClients = (HashSet<ProtocolEngine>)ServerModel.this.connectedClients.get(this.handle);
                            if (allClients == null) {
                                allClients = new HashSet<ProtocolEngine>();
                                ServerModel.this.connectedClients.put(this.handle, allClients);
                            }
                            allClients.add(eng);
                        }
                    }
                    catch (Exception e) {
                        IProtocolExceptionHandler exceptionHandler = this.factory.getExceptionHandler();
                        if (exceptionHandler != null) {
                            if (e instanceof IOException) {
                                exceptionHandler.handleIOException(this.handle, (IOException)e);
                            } else if (e instanceof ProtocolHandshakeException) {
                                exceptionHandler.handleProtocolInitException(this.handle, (ProtocolHandshakeException)e);
                            } else if (e instanceof MessageHandleException) {
                                exceptionHandler.handleMessageHandleException(this.handle, (MessageHandleException)e);
                            } else if (e instanceof InvalidMessageException) {
                                exceptionHandler.handleInvalidMessageException(this.handle, (InvalidMessageException)e);
                            } else if (e instanceof InvalidInputStreamDataException) {
                                exceptionHandler.handleInvalidInputStreamDataException(this.handle, (InvalidInputStreamDataException)e);
                            } else if (e instanceof InvalidDefinitionException) {
                                exceptionHandler.handleInvalidDefinitionException(this.handle, (InvalidDefinitionException)e);
                            } else if (e instanceof ProtocolRawHandlingException) {
                                exceptionHandler.handleProtocolRawHandlingException(this.handle, (ProtocolRawHandlingException)e);
                            }
                        }
                        try {
                            if (!this.serverSocket.isClosed()) {
                                this.serverSocket.close();
                            }
                            Collection allClients = (Collection)ServerModel.this.connectedClients.get(this.serverSocket.getLocalPort());
                            Iterator iterator = allClients.iterator();
                            while (true) {
                                if (!iterator.hasNext()) {
                                    ServerModel.this.openedServerSockets.remove(this.handle);
                                    ServerModel.this.engineFactories.remove(this.handle);
                                    ServerModel.this.connectedClients.remove(this.handle);
                                    return;
                                }
                                ProtocolEngine aClient = (ProtocolEngine)iterator.next();
                                aClient.stopProtocol();
                                allClients.remove(aClient);
                            }
                        }
                        catch (IOException e2) {
                            IProtocolExceptionHandler exceptionHandler2 = this.factory.getExceptionHandler();
                            if (exceptionHandler2 == null) return;
                            exceptionHandler2.handleIOException(this.handle, e2);
                            return;
                        }
                    }
                }
            }
            finally {
                try {
                    if (!this.serverSocket.isClosed()) {
                        this.serverSocket.close();
                    }
                    Collection allClients = (Collection)ServerModel.this.connectedClients.get(this.serverSocket.getLocalPort());
                    Iterator iterator = allClients.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            ServerModel.this.openedServerSockets.remove(this.handle);
                            ServerModel.this.engineFactories.remove(this.handle);
                            ServerModel.this.connectedClients.remove(this.handle);
                            return;
                        }
                        ProtocolEngine aClient = (ProtocolEngine)iterator.next();
                        aClient.stopProtocol();
                        allClients.remove(aClient);
                    }
                }
                catch (IOException e) {
                    IProtocolExceptionHandler exceptionHandler = this.factory.getExceptionHandler();
                    if (exceptionHandler == null) return;
                    exceptionHandler.handleIOException(this.handle, e);
                }
            }
        }
    }
}

