/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.stringeditor.editor.operations;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tml.localization.stringeditor.datatype.RowInfo;
import org.eclipse.tml.localization.stringeditor.editor.StringEditorPart;
import org.eclipse.tml.localization.stringeditor.editor.operations.EditorOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveKeyOperation
extends EditorOperation {
    private final List<RowInfo> rows;

    public RemoveKeyOperation(String label, StringEditorPart editor, List<RowInfo> rows) {
        super(label, editor);
        this.rows = rows;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.redo(monitor, info);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        for (RowInfo row : this.rows) {
            this.getEditor().removeRow(row.getKey());
        }
        this.getEditor().getEditorViewer().refresh();
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        for (RowInfo row : this.rows) {
            this.getEditor().addRow(row);
        }
        this.getEditor().getEditorViewer().refresh();
        return Status.OK_STATUS;
    }
}

