/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.stringeditor.editor.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tml.localization.stringeditor.datatype.CellInfo;
import org.eclipse.tml.localization.stringeditor.datatype.ColumnInfo;
import org.eclipse.tml.localization.stringeditor.editor.StringEditorPart;
import org.eclipse.tml.localization.stringeditor.editor.operations.EditorOperation;

public class TranslateOperation
extends EditorOperation {
    private final String sourceColumnID;
    private final ColumnInfo destinationColumn;

    public TranslateOperation(StringEditorPart editor, String sourceColumnID, ColumnInfo newColumnInfo) {
        super("Clone", editor);
        this.sourceColumnID = sourceColumnID;
        this.destinationColumn = newColumnInfo;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ColumnInfo source = this.getModel().getColumn(this.sourceColumnID);
        for (String cellKey : source.getCells().keySet()) {
            CellInfo cell = source.getCells().get(cellKey);
            if (cell == null) continue;
            this.destinationColumn.addCell(cellKey, new CellInfo(cell.getValue(), cell.getComment()));
        }
        return this.redo(monitor, info);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.getEditor().addColumn(this.destinationColumn, -1);
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.getEditor().removeColumn(this.destinationColumn.getId());
        return Status.OK_STATUS;
    }
}

