/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.android;

import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.localization.android.AndroidLocaleAttribute;
import org.eclipse.tml.localization.android.i18n.Messages;
import org.eclipse.tml.localization.stringeditor.datatype.ColumnInfo;
import org.eclipse.tml.localization.tools.datamodel.LocaleAttribute;
import org.eclipse.tml.localization.tools.datamodel.LocaleInfo;
import org.eclipse.tml.localization.tools.datamodel.LocalizationFile;
import org.eclipse.tml.localization.tools.datamodel.StringNode;
import org.eclipse.tml.localization.tools.datamodel.StringNodeComment;
import org.eclipse.tml.localization.tools.extensions.classes.ILocalizationSchema;
import org.eclipse.tml.localization.tools.managers.LocalizationManager;
import org.eclipse.tml.localization.tools.managers.ProjectLocalizationManager;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidLocalizationSchema
extends ILocalizationSchema {
    private final String RESOURCES_FOLDER = "res";
    private final String DEFAULT_LOCALE_TOOLTIP = Messages.AndroidLocalizationSchema_Default_Andr_Localization_File_Tooltip;
    public static final String LOCALIZATION_FILES_FOLDER = "values";
    public static final String LOCALIZATION_FILE_NAME = "strings.xml";
    private final String FILE_EXTENSION = "xml";
    private final String LF_REGULAR_EXPRESSION = "res/values.*/strings.xml";
    private final String XML_RESOURCES_TAG = "resources";
    private final String XML_STRING_TAG = "string";
    private final String XML_STRING_ATTR_NAME = "name";
    private final String NEW_COLUMN_TITLE = Messages.AndroidNewColumnProvider_NewColumnTitle;
    private final String NEW_COLUMN_DESCRIPTION = Messages.AndroidNewColumnProvider_NewColumnDescription;
    private final String NEW_COLUMN_TEXT = "values";
    private final String NEW_COLUMN_INVALID_ID = Messages.AndroidNewColumnProvider_InvalidNewColumID;
    private String MANDATORY_ID = "values";
    private final String QUALIFIER_SEP = "-";

    public IStatus isValueValid(String localeID, String key, String value) {
        Status result = new Status(0, "org.eclipse.tml.localization.android", "");
        if (localeID.toLowerCase().equals(this.MANDATORY_ID.toLowerCase())) {
            if (value == null) {
                result = new Status(4, "org.eclipse.tml.localization.android", Messages.EmptyKey_Discouraged);
            }
            if (value == null || value.length() == 0) {
                result = new Status(2, "org.eclipse.tml.localization.android", Messages.EmptyKey_Discouraged);
            }
        }
        return result;
    }

    public ColumnInfo promptCollumnName(final IProject project) {
        ColumnInfo newColumn = null;
        InputDialog dialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.NEW_COLUMN_TITLE, this.NEW_COLUMN_DESCRIPTION, LOCALIZATION_FILES_FOLDER, new IInputValidator(){

            public String isValid(String newText) {
                return AndroidLocalizationSchema.this.isValid2(newText, project);
            }
        });
        if (dialog.open() == 0) {
            newColumn = new ColumnInfo(dialog.getValue(), dialog.getValue(), null, true);
        }
        return newColumn;
    }

    private String isValid2(String value, IProject project) {
        String result = null;
        if (value.startsWith(LOCALIZATION_FILES_FOLDER)) {
            AndroidLocalizationSchema schema = new AndroidLocalizationSchema();
            String id = value.replace(LOCALIZATION_FILES_FOLDER, "");
            LocaleInfo info = schema.getLocaleInfoFromID(id);
            ProjectLocalizationManager manager = LocalizationManager.getInstance().getProjectLocalizationManager(project, false);
            if (info.getLocaleAttributes().size() > 0 || value.equalsIgnoreCase(LOCALIZATION_FILES_FOLDER)) {
                LocalizationFile file = manager.getLocalizationProject().getLocalizationFile(info);
                if (file != null && !file.isToBeDeleted()) {
                    result = Messages.AndroidNewColumnProvider_Dialog_FileAlreadyExists;
                }
            } else {
                result = this.NEW_COLUMN_INVALID_ID;
            }
        } else {
            result = this.NEW_COLUMN_INVALID_ID;
        }
        return result;
    }

    public String getEditorName() {
        return Messages.AndroidStringEditorInput_EditorTooltip;
    }

    public void createFile(LocalizationFile localizationFile) throws TmLException {
        try {
            String filePath = localizationFile.getFile().getFullPath().toOSString();
            IProject project = localizationFile.getLocalizationProject().getProject();
            Path temp = new Path(filePath);
            while (temp.segment(0).equals(project.getName())) {
                temp = temp.removeFirstSegments(1);
            }
            filePath = String.valueOf(File.separator) + temp.toOSString();
            if (!localizationFile.getFile().exists()) {
                localizationFile.getFile().getLocation();
                Object fileToSave = null;
                fileToSave = localizationFile.getLocalizationProject() != null ? new Path(localizationFile.getLocalizationProject().getProject().getLocation() + filePath) : localizationFile.getFile().getLocation();
                fileToSave.removeLastSegments(1).toFile().mkdirs();
                fileToSave.toFile().createNewFile();
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                if (localizationFile.getLocalizationProject() != null) {
                    IFile iFile = localizationFile.getLocalizationProject().getProject().getFile((IPath)new Path(filePath));
                    localizationFile.setFile(iFile);
                }
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.newDocument();
            Element resources = document.createElement("resources");
            for (StringNode stringNode : localizationFile.getStringNodes()) {
                Element string = document.createElement("string");
                string.setAttribute("name", stringNode.getKey());
                string.appendChild(document.createTextNode(stringNode.getValue()));
                StringNodeComment nodeComment = stringNode.getStringNodeComment();
                if (nodeComment != null && nodeComment.getComment() != null && nodeComment.getComment().length() > 0) {
                    Comment comment = document.createComment(nodeComment.getComment());
                    string.appendChild(comment);
                }
                resources.appendChild(string);
            }
            document.appendChild(resources);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 4);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            FileOutputStream fileOutputStream = null;
            fileOutputStream = new FileOutputStream(localizationFile.getFile().getLocation().toFile());
            StreamResult result = new StreamResult(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
        }
        catch (Exception exception) {
            throw new TmLException();
        }
    }

    public String getLocaleToolTip(IPath path) {
        LocaleInfo locale = this.getLocaleInfoFromPath(path);
        List attributes = locale.getLocaleAttributes();
        String result = "";
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            if (result.length() > 0) {
                result = String.valueOf(result) + "\n ";
            }
            LocaleAttribute localeAttribute = (LocaleAttribute)iterator.next();
            result = String.valueOf(result) + ((AndroidLocaleAttribute)localeAttribute).getDisplayName() + ": " + ((AndroidLocaleAttribute)localeAttribute).getDisplayValue();
        }
        if (result.length() == 0) {
            result = this.DEFAULT_LOCALE_TOOLTIP;
        }
        return result;
    }

    public List<LocaleAttribute> getLocaleAttributes() {
        ArrayList<LocaleAttribute> localeAttributes = new ArrayList<LocaleAttribute>();
        localeAttributes.add(new AndroidLocaleAttribute(new Integer(123), 0));
        localeAttributes.add(new AndroidLocaleAttribute(new Integer(0), 1));
        localeAttributes.add(new AndroidLocaleAttribute("pt", 2));
        localeAttributes.add(new AndroidLocaleAttribute("br", 3));
        localeAttributes.add(new AndroidLocaleAttribute(null, 4));
        localeAttributes.add(new AndroidLocaleAttribute(new Integer(12), 5));
        localeAttributes.add(new AndroidLocaleAttribute(null, 6));
        localeAttributes.add(new AndroidLocaleAttribute(null, 7));
        localeAttributes.add(new AndroidLocaleAttribute(null, 8));
        localeAttributes.add(new AndroidLocaleAttribute(null, 9));
        localeAttributes.add(new AndroidLocaleAttribute(new Dimension(1, 1), 10));
        return localeAttributes;
    }

    public List<String> getLocalizationFileExtensions() {
        ArrayList<String> localizationFileExtensions = new ArrayList<String>();
        localizationFileExtensions.add("xml");
        return localizationFileExtensions;
    }

    public Map<LocaleInfo, IFile> getLocalizationFiles(IProject project) {
        LinkedHashMap<LocaleInfo, IFile> localizationFiles;
        block12: {
            localizationFiles = new LinkedHashMap<LocaleInfo, IFile>();
            boolean hasDefault = false;
            try {
                IResource[] folders;
                IResource resourcesFolder = project.findMember("res");
                if (resourcesFolder != null && resourcesFolder instanceof IFolder && (folders = ((IFolder)resourcesFolder).members()) != null) {
                    IResource[] iResourceArray = folders;
                    int n = folders.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource folder = iResourceArray[n2];
                        if (folder.getName().startsWith(LOCALIZATION_FILES_FOLDER)) {
                            IResource[] files;
                            IResource[] iResourceArray2 = files = ((IFolder)folder).members();
                            int n3 = files.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IResource file = iResourceArray2[n4];
                                if (file instanceof IFile && this.isLocalizationFile((IFile)file)) {
                                    localizationFiles.put(this.getLocaleInfoFromPath(file.getProjectRelativePath()), (IFile)file);
                                    if (folder.getName().equals(LOCALIZATION_FILES_FOLDER)) {
                                        hasDefault = true;
                                    }
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                if (hasDefault || !(resourcesFolder instanceof IFolder)) break block12;
                IFolder folder = (IFolder)resourcesFolder;
                final IFolder valuesFolder = folder.getFolder(LOCALIZATION_FILES_FOLDER);
                try {
                    if (!valuesFolder.exists()) {
                        PlatformUI.getWorkbench().getProgressService().run(false, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    valuesFolder.create(true, true, monitor);
                                }
                                catch (CoreException coreException) {}
                            }
                        });
                    }
                    if (valuesFolder.exists()) {
                        IFile valuesFile = valuesFolder.getFile(LOCALIZATION_FILE_NAME);
                        localizationFiles.put(this.getLocaleInfoFromPath(valuesFile.getProjectRelativePath()), valuesFile);
                    }
                }
                catch (Exception exception) {}
            }
            catch (CoreException coreException) {}
        }
        return localizationFiles;
    }

    public boolean isLocalizationFile(IFile file) {
        boolean result = false;
        if (file != null && file.getProjectRelativePath().toString().matches("res/values.*/strings.xml")) {
            result = true;
        }
        return result;
    }

    public Map<LocaleInfo, LocalizationFile> loadAllFiles(IProject project) throws IOException {
        LinkedHashMap<LocaleInfo, LocalizationFile> filesMap = new LinkedHashMap<LocaleInfo, LocalizationFile>();
        Map<LocaleInfo, IFile> localizationFiles = this.getLocalizationFiles(project);
        for (Map.Entry<LocaleInfo, IFile> entry : localizationFiles.entrySet()) {
            filesMap.put(entry.getKey(), this.loadFile(entry.getValue()));
        }
        return filesMap;
    }

    public LocalizationFile loadFile(IFile file) throws IOException {
        LocalizationFile localizationFile = null;
        LocaleInfo localeInfo = this.getLocaleInfoFromPath(file.getFullPath());
        ArrayList<StringNode> stringNodes = new ArrayList<StringNode>();
        if (!file.exists()) {
            LocalizationFile tempFile = new LocalizationFile(file, localeInfo, stringNodes);
            try {
                this.createFile(tempFile);
            }
            catch (TmLException tmLException) {}
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(file.getLocation().toString()));
            NodeList stringNodeList = document.getElementsByTagName("string");
            String key = null;
            String value = null;
            int i = 0;
            while (i < stringNodeList.getLength()) {
                Element stringNode = (Element)stringNodeList.item(i);
                key = stringNode.getAttributeNode("name").getNodeValue();
                String comment = null;
                if (stringNode.hasChildNodes()) {
                    NodeList childs = stringNode.getChildNodes();
                    int j = 0;
                    while (j < childs.getLength()) {
                        Node childN = childs.item(j);
                        if (childN.getNodeType() == 8) {
                            comment = childN.getNodeValue();
                        }
                        ++j;
                    }
                }
                value = stringNode.getTextContent();
                StringNode stringNodeObj = new StringNode(key, value);
                if (comment != null) {
                    StringNodeComment nodeComment = new StringNodeComment();
                    nodeComment.setComment(comment);
                    stringNodeObj.setStringNodeComment(nodeComment);
                }
                stringNodes.add(stringNodeObj);
                ++i;
            }
            localizationFile = new LocalizationFile(file, localeInfo, stringNodes);
        }
        catch (Exception e) {
            throw new IOException(String.valueOf(Messages.AndroidLocalizationSchema_Exception_CouldNotLoadFile) + file.getName() + ". " + e.getMessage());
        }
        return localizationFile;
    }

    public void updateFile(LocalizationFile localizationFile) throws TmLException {
        this.createFile(localizationFile);
        localizationFile.setDirty(false);
    }

    private LocaleInfo getLocaleInfoFromPath(IPath path) {
        IPath folder = path;
        folder = path.removeLastSegments(1);
        String folderName = folder.lastSegment();
        String id = folderName.replace(LOCALIZATION_FILES_FOLDER, "");
        return this.getLocaleInfoFromID(id);
    }

    public String getPathFromLocaleInfo(LocaleInfo lang) {
        String result = lang.getLocaleAttributes().size() > 0 ? "res" + File.separator + LOCALIZATION_FILES_FOLDER + "-" + this.getLocaleID(lang) + File.separator + LOCALIZATION_FILE_NAME : "res" + File.separator + LOCALIZATION_FILES_FOLDER + File.separator + LOCALIZATION_FILE_NAME;
        return result;
    }

    public String getLocaleID(LocaleInfo localeInfo) {
        String localeID = "";
        List localeAttributes = localeInfo.getLocaleAttributes();
        for (LocaleAttribute localeAttribute : localeAttributes) {
            if (!((AndroidLocaleAttribute)localeAttribute).isSet()) continue;
            if (localeID.length() != 0) {
                localeID = String.valueOf(localeID) + "-";
            }
            localeID = String.valueOf(localeID) + localeAttribute.getFolderValue();
        }
        return localeID;
    }

    public LocaleInfo getLocaleInfoFromID(String ID) {
        LocaleInfo result = new LocaleInfo();
        String[] segments = ID.split("-");
        int lastQualifier = -1;
        ArrayList<AndroidLocaleAttribute> localeAttributes = new ArrayList<AndroidLocaleAttribute>();
        int i = 1;
        while (i < segments.length) {
            if (!segments[i].equals("")) {
                if (this.isCountryCodeSegment(segments[i]) && lastQualifier < 0) {
                    lastQualifier = 0;
                    localeAttributes.add(new AndroidLocaleAttribute(segments[i], 0));
                } else if (this.isNetworkCodeSegment(segments[i]) && lastQualifier < 1) {
                    lastQualifier = 1;
                    localeAttributes.add(new AndroidLocaleAttribute(segments[i], 1));
                } else if (this.isLanguageSegment(segments[i]) && lastQualifier < 2) {
                    lastQualifier = 2;
                    localeAttributes.add(new AndroidLocaleAttribute(segments[i], 2));
                } else if (this.isRegionSegment(segments[i]) && lastQualifier < 3) {
                    lastQualifier = 3;
                    localeAttributes.add(new AndroidLocaleAttribute(segments[i], 3));
                } else if (this.isOrientationSegment(segments[i]) && lastQualifier < 4) {
                    lastQualifier = 4;
                    localeAttributes.add(new AndroidLocaleAttribute(segments[i], 4));
                } else if (this.isPixelDensitySegment(segments[i]) && lastQualifier < 5) {
                    lastQualifier = 5;
                    localeAttributes.add(new AndroidLocaleAttribute(segments[i], 5));
                } else if (this.isTouchTypeSegment(segments[i]) && lastQualifier < 6) {
                    lastQualifier = 6;
                    localeAttributes.add(new AndroidLocaleAttribute(segments[i], 6));
                } else if (this.isKeyboardStateSegment(segments[i]) && lastQualifier < 7) {
                    lastQualifier = 7;
                    localeAttributes.add(new AndroidLocaleAttribute(segments[i], 7));
                } else if (this.isTextInputSegment(segments[i]) && lastQualifier < 8) {
                    lastQualifier = 8;
                    localeAttributes.add(new AndroidLocaleAttribute(segments[i], 8));
                } else if (this.isNavigationSegment(segments[i]) && lastQualifier < 9) {
                    lastQualifier = 9;
                    localeAttributes.add(new AndroidLocaleAttribute(segments[i], 9));
                } else if (this.isDimensionSegment(segments[i]) && lastQualifier < 10) {
                    lastQualifier = 10;
                    localeAttributes.add(new AndroidLocaleAttribute(segments[i], 10));
                } else {
                    localeAttributes = new ArrayList();
                    break;
                }
            }
            ++i;
        }
        result.setLocaleAttributes(localeAttributes);
        return result;
    }

    public String getDefaultID() {
        return LOCALIZATION_FILES_FOLDER;
    }

    private boolean isNetworkCodeSegment(String value) {
        return value.startsWith("mnc");
    }

    private boolean isLanguageSegment(String value) {
        return value.length() == 2;
    }

    private boolean isRegionSegment(String value) {
        return value.startsWith("r") && value.length() == 3;
    }

    private boolean isOrientationSegment(String value) {
        return value.equalsIgnoreCase("port") || value.equalsIgnoreCase("land") || value.equalsIgnoreCase("square");
    }

    private boolean isPixelDensitySegment(String value) {
        return value.endsWith("dpi");
    }

    private boolean isTouchTypeSegment(String value) {
        return value.equalsIgnoreCase("notouch") || value.equalsIgnoreCase("stylus") || value.equalsIgnoreCase("finger");
    }

    private boolean isKeyboardStateSegment(String value) {
        return value.equalsIgnoreCase("keysexposed") || value.equalsIgnoreCase("keyshidden");
    }

    private boolean isTextInputSegment(String value) {
        return value.equalsIgnoreCase("nokeys") || value.equalsIgnoreCase("qwerty") || value.equalsIgnoreCase("12key");
    }

    private boolean isNavigationSegment(String value) {
        return value.equalsIgnoreCase("dpad") || value.equalsIgnoreCase("trackball") || value.equalsIgnoreCase("wheel") || value.equalsIgnoreCase("nonav");
    }

    private boolean isDimensionSegment(String value) {
        String[] ints;
        boolean result = false;
        if (value.contains("x") && (ints = value.split("x")).length == 2) {
            result = true;
        }
        return result;
    }

    private boolean isCountryCodeSegment(String value) {
        return value.startsWith("mcc");
    }
}

