/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.linuxtools.tools.memorymap;

import java.io.IOException;
import java.util.List;
import org.eclipse.tml.linuxtools.network.IConnectionProvider;
import org.eclipse.tml.linuxtools.network.IConstants;
import org.eclipse.tml.linuxtools.tools.AbstractNotifier;
import org.eclipse.tml.linuxtools.tools.IListener;
import org.eclipse.tml.linuxtools.tools.INotifier;
import org.eclipse.tml.linuxtools.tools.ITool;
import org.eclipse.tml.linuxtools.tools.memorymap.MemoryMapProcessor;
import org.eclipse.tml.linuxtools.utilities.Extensions;
import org.eclipse.tml.linuxtools.utilities.ProtocolDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryMapTool
extends AbstractNotifier
implements IListener,
ITool {
    private IConnectionProvider connectionProvider = null;
    private MemoryMapProcessor processor = null;
    private String[] requiredCapabilities = new String[]{"GET_FILE"};

    public void connect(String host, int port, ProtocolDescriptor protocol) {
        Class connectionProviderClass = protocol.getConnectionProviderClass();
        try {
            Object aux = connectionProviderClass.newInstance();
            this.connectionProvider = (IConnectionProvider)aux;
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (ClassCastException classCastException) {}
        this.connectionProvider.addListener((IListener)this);
        try {
            this.connectionProvider.connect(host, port);
        }
        catch (IOException iOException) {}
        this.processor = new MemoryMapProcessor(this.connectionProvider);
        this.processor.addListener(this);
    }

    public void disconnect() {
        if (this.connectionProvider != null) {
            try {
                this.connectionProvider.disconnect();
            }
            catch (IOException iOException) {}
            this.connectionProvider = null;
        }
    }

    public void login(String user, String password) {
        try {
            this.connectionProvider.login(user, password);
        }
        catch (IOException iOException) {}
    }

    public List<ProtocolDescriptor> getProtocolsDescriptors() {
        List pdList = Extensions.findProcotols((String[])this.requiredCapabilities);
        return pdList;
    }

    public void notify(INotifier notifier, IConstants.EventCode event, Object result) {
        try {
            if (notifier == this.connectionProvider) {
                switch (event) {
                    case EVT_PROVIDER_CONNECT_FINISHED: {
                        if (IConstants.OperationCode.SUCCESS == result) {
                            this.processor.gatherData();
                        }
                        this.notifyListeners(IConstants.EventCode.EVT_TOOL_CONNECT_FINISHED, result);
                        break;
                    }
                    case EVT_PROVIDER_CONNECT_ERROR: {
                        break;
                    }
                    case EVT_PROVIDER_LOGIN_FINISHED: {
                        if (IConstants.OperationCode.SUCCESS == result) {
                            this.processor.gatherData();
                        }
                        this.notifyListeners(IConstants.EventCode.EVT_TOOL_LOGIN_FINISHED, result);
                        break;
                    }
                    case EVT_PROVIDER_SENDCOMMAND_FINISHED: {
                        break;
                    }
                    case EVT_PROVIDER_SENDCOMMAND_ERROR: {
                        break;
                    }
                    case EVT_PROVIDER_SENDDATA_FINISHED: {
                        break;
                    }
                    case EVT_PROVIDER_SENDDATA_ERROR: {
                        break;
                    }
                    case EVT_PROVIDER_DISCONNECT_FINISHED: {
                        this.notifyListeners(IConstants.EventCode.EVT_TOOL_DISCONNECT_FINISHED, result);
                    }
                }
            }
            if (notifier == this.processor) {
                switch (event) {
                    case EVT_PROCESSOR_GATHERDATA_FINISHED: {
                        this.notifyListeners(IConstants.EventCode.EVT_TOOL_REFRESH_VIEW, result);
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (IOException iOException) {}
    }

    public void refresh() {
        try {
            if (this.processor != null) {
                this.processor.gatherData();
            }
        }
        catch (IOException iOException) {}
    }

    public int getRefreshDelay() {
        return 0;
    }

    public void setRefreshDelay(int delay) {
    }

    public void start() {
    }

    public void stop() {
    }
}

