/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.tml.common.utilities.PluginUtils;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.common.utilities.exception.TmLExceptionHandler;
import org.eclipse.tml.framework.device.DevicePlugin;
import org.eclipse.tml.framework.device.events.InstanceEvent;
import org.eclipse.tml.framework.device.events.InstanceEventManager;
import org.eclipse.tml.framework.device.exception.DeviceExceptionHandler;
import org.eclipse.tml.framework.device.factory.InstanceRegistry;
import org.eclipse.tml.framework.device.manager.persistence.DeviceXmlReader;
import org.eclipse.tml.framework.device.manager.persistence.DeviceXmlWriter;
import org.eclipse.tml.framework.device.manager.persistence.TmLDevice;
import org.eclipse.tml.framework.device.model.IDevice;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.framework.device.model.IInstanceBuilder;
import org.eclipse.tml.framework.device.model.handler.IDeviceHandler;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceManager {
    private static final String ELEMENT_DEVICE = "device";
    private static final String ATTR_HANDLER = "handler";
    private static InstanceManager _instance;
    private IInstance currentInstance;
    private Map<String, TmLDevice> devices;

    private InstanceManager() {
        DeviceXmlReader.loadInstances(this);
        if (this.devices == null) {
            this.devices = new HashMap<String, TmLDevice>();
        }
        IWorkbench workbench = DevicePlugin.getDefault().getWorkbench();
        workbench.addWindowListener((IWindowListener)new WindowListener());
    }

    public static InstanceManager getInstance() {
        if (_instance == null) {
            _instance = new InstanceManager();
        }
        return _instance;
    }

    public void setInstance(IInstance instance) {
        this.currentInstance = instance;
    }

    public IInstance getCurrentInstance() {
        return this.currentInstance;
    }

    public IInstance createInstance(String name, String deviceId, String status, Properties properties) throws TmLException {
        IDeviceHandler deviceHandler = null;
        IInstance instance = null;
        try {
            IExtension fromPlugin = PluginUtils.getExtension((String)"org.eclipse.tml.device", (String)deviceId);
            deviceHandler = (IDeviceHandler)PluginUtils.getExecutableAttribute((IExtension)fromPlugin, (String)ELEMENT_DEVICE, (String)ATTR_HANDLER);
            instance = deviceHandler.createDeviceInstance(String.valueOf(name) + deviceId);
            instance.setDevice(deviceId);
            instance.setName(name);
            instance.setStatus(status);
            instance.setProperties((Properties)properties.clone());
        }
        catch (CoreException coreException) {
            TmLExceptionHandler.showException((TmLException)DeviceExceptionHandler.exception(202));
        }
        InstanceEventManager.getInstance().fireInstanceCreated(new InstanceEvent(instance));
        return instance;
    }

    public void deleteInstance(IInstance instance) {
        if (this.currentInstance == instance) {
            this.currentInstance = null;
        }
        InstanceRegistry registry = InstanceRegistry.getInstance();
        registry.removeInstance(instance);
        DeviceXmlWriter.saveInstances(this.devices);
        InstanceEventManager.getInstance().fireInstanceDeleted(new InstanceEvent(instance));
    }

    public void createProject(IDevice device, IInstanceBuilder projectBuilder, IProgressMonitor monitor) {
        try {
            IInstance inst = this.createInstance(projectBuilder.getProjectName(), device.getId(), "OFF", projectBuilder.getProperties());
            if (this.currentInstance == null) {
                this.currentInstance = inst;
            }
            InstanceRegistry registry = InstanceRegistry.getInstance();
            registry.addInstance(inst);
            DeviceXmlWriter.saveInstances(this.devices);
            InstanceEventManager.getInstance().fireInstanceDeleted(new InstanceEvent(inst));
        }
        catch (TmLException tmLException) {
            TmLExceptionHandler.showException((TmLException)DeviceExceptionHandler.exception(202));
        }
    }

    public List<IInstance> getInstancesByname(String name) {
        InstanceRegistry registry = InstanceRegistry.getInstance();
        List<IInstance> instanceList = registry.getInstances();
        ArrayList<IInstance> returnValue = new ArrayList<IInstance>();
        for (IInstance inst : instanceList) {
            if (!inst.getName().equals(name)) continue;
            returnValue.add(inst);
        }
        return returnValue;
    }

    public void setDevicesMap(Map<String, TmLDevice> devices) {
        this.devices = devices;
    }

    private class WindowListener
    implements IWindowListener {
        private WindowListener() {
        }

        public void windowClosed(IWorkbenchWindow window) {
            DeviceXmlWriter.saveInstances(InstanceManager.this.devices);
        }

        public void windowOpened(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowActivated(IWorkbenchWindow window) {
        }
    }
}

