/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.tml.common.utilities.PluginUtils;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.framework.device.DevicePlugin;
import org.eclipse.tml.framework.device.factory.ServiceFactory;
import org.eclipse.tml.framework.device.model.IService;

public class ServiceManager {
    private static ServiceManager _instance;
    private List<IService> services = new ArrayList<IService>();

    private ServiceManager() {
    }

    public static ServiceManager getInstance() {
        if (_instance == null) {
            _instance = new ServiceManager();
        }
        return _instance;
    }

    public void loadServices() {
        this.services.clear();
        Collection servicesIds = PluginUtils.getInstalledPlugins((String)"org.eclipse.tml.service");
        for (String serviceId : servicesIds) {
            try {
                this.services.add(ServiceFactory.createService(serviceId));
            }
            catch (TmLException tmLException) {}
        }
    }

    public void listServices() {
        for (IService service : this.services) {
            DevicePlugin.logInfo((String)service.toString());
        }
    }
}

