/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.status;

import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tml.common.utilities.PluginUtils;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.common.utilities.exception.TmLExceptionHandler;
import org.eclipse.tml.framework.device.DevicePlugin;
import org.eclipse.tml.framework.device.exception.DeviceExceptionHandler;
import org.eclipse.tml.framework.status.IStatus;
import org.eclipse.tml.framework.status.MobileStatus;
import org.osgi.framework.Bundle;

public class StatusFactory {
    private static final String ELEMENT_STATUS = "status";
    private static final String ATR_ID = "id";
    private static final String ATR_NAME = "name";
    private static final String ATR_IMAGE = "image";
    private static final String ATR_CANDELETE = "canDeleteInstance";

    public static IStatus createStatus(String statusId) {
        IExtension fromPlugin = PluginUtils.getExtension((String)"org.eclipse.tml.status", (String)statusId);
        String id = PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_STATUS, (String)ATR_ID);
        String name = PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_STATUS, (String)ATR_NAME);
        boolean canDelete = Boolean.parseBoolean(PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_STATUS, (String)ATR_CANDELETE));
        MobileStatus status = new MobileStatus(id, name);
        status.setCanDeleteInstance(canDelete);
        String imageName = PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_STATUS, (String)ATR_IMAGE);
        ImageDescriptor image = null;
        try {
            image = DevicePlugin.getPluginImage((Bundle)fromPlugin.getDeclaringPluginDescriptor().getPlugin().getBundle(), (String)imageName);
        }
        catch (Throwable throwable) {
            TmLExceptionHandler.showException((TmLException)DeviceExceptionHandler.exception(202));
        }
        status.setImage(image);
        return status;
    }

    public static IStatus createStatus(IExtension fromPlugin) {
        String id = PluginUtils.getPluginAttribute((IExtension)fromPlugin, (String)ELEMENT_STATUS, (String)ATR_ID);
        return StatusFactory.createStatus(id);
    }
}

