/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.stringeditor.editor.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.localization.stringeditor.datatype.CellInfo;
import org.eclipse.tml.localization.stringeditor.datatype.ColumnInfo;
import org.eclipse.tml.localization.stringeditor.datatype.RowInfo;
import org.eclipse.tml.localization.stringeditor.editor.input.IInputChangeListener;
import org.eclipse.ui.IEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IStringEditorInput
implements IEditorInput {
    private List<IInputChangeListener> inputChangeListeners = new ArrayList<IInputChangeListener>();

    public abstract void init(IProject var1) throws Exception;

    public abstract String getTitle();

    public abstract List<ColumnInfo> getColumns();

    public abstract boolean translate(String var1, String var2);

    public abstract void addColumn(String var1);

    public abstract void removeColumn(String var1);

    public abstract void setValue(String var1, String var2, String var3) throws TmLException;

    public abstract CellInfo getValue(String var1, String var2);

    public abstract Map<String, CellInfo> getValues(String var1);

    public abstract List<CellInfo> getAvailableKeysForColumn(String var1);

    public abstract boolean canSave();

    public abstract boolean save();

    public abstract boolean isDirty();

    public abstract boolean revert();

    public abstract boolean revert(String var1) throws IOException;

    public abstract boolean canRevertByColumn();

    public abstract void removeRow(String var1);

    public abstract void removeCell(String var1, String var2);

    public abstract void addRow(RowInfo var1);

    public abstract void dispose();

    public abstract void setCellTooltip(String var1, String var2, String var3) throws TmLException;

    public abstract IStatus validate();

    public abstract boolean canHandle(IFile var1);

    public void addInputChangeListener(IInputChangeListener inputChangeListener) {
        if (!this.inputChangeListeners.contains(inputChangeListener)) {
            this.inputChangeListeners.add(inputChangeListener);
        }
    }

    public void removeInputChangeListener(IInputChangeListener inputChangeListener) {
        this.inputChangeListeners.remove(inputChangeListener);
    }

    public void notifyInputChange(String columnID) {
        for (IInputChangeListener inputChangeListeener : this.inputChangeListeners) {
            inputChangeListeener.columnChanged(columnID);
        }
    }

    public void notifyProjectRemoved() {
        for (IInputChangeListener inputChangeListeener : this.inputChangeListeners) {
            inputChangeListeener.projectRemoved();
        }
    }
}

