/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.ui.view.provider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tml.framework.device.ui.DeviceUIPlugin;
import org.eclipse.tml.framework.device.ui.view.model.ViewerDeviceNode;
import org.eclipse.tml.framework.device.ui.view.model.ViewerInstanceNode;
import org.eclipse.tml.framework.status.IStatus;
import org.eclipse.tml.framework.status.StatusRegistry;

public class InstanceMgtViewLabelProvider
extends ColumnLabelProvider {
    public static final int INSTANCE_COLUMN_NUMBER = 0;
    public static final int STATUS_COLUMN_NUMBER = 1;
    private static final String NO_INSTANCE_NAME = "<none>";
    protected int columnIndex;
    protected int firstColumnIndex;
    private Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>(20);

    public void setFirstColumnIndex(int firstColumnIndex) {
        this.firstColumnIndex = firstColumnIndex;
    }

    public int getFirstColumnIndex() {
        return this.firstColumnIndex;
    }

    protected boolean isProvidingForFirstColumn() {
        return this.firstColumnIndex == this.columnIndex;
    }

    public String getText(Object element) {
        String label = "";
        if (element instanceof ViewerInstanceNode) {
            ViewerInstanceNode node = (ViewerInstanceNode)element;
            label = this.getText(node, this.columnIndex);
        } else if (element instanceof ViewerDeviceNode && this.isProvidingForFirstColumn()) {
            ViewerDeviceNode node = (ViewerDeviceNode)element;
            label = node.getDevice().getLabel();
        }
        return label;
    }

    public String getText(ViewerInstanceNode node, int columnIndex) {
        String label = "";
        if (node.containsInstance()) {
            if (columnIndex == 0) {
                label = node.getInstanceName();
            } else if (columnIndex == 1) {
                String status = node.getInstanceStatus();
                label = StatusRegistry.getInstance().getStatus(status).getName();
            }
        } else if (this.isProvidingForFirstColumn()) {
            label = NO_INSTANCE_NAME;
        }
        return label;
    }

    public Image getImage(Object element) {
        ImageDescriptor descriptor = null;
        Image image = null;
        if (element instanceof ViewerInstanceNode) {
            ViewerInstanceNode node = (ViewerInstanceNode)element;
            if (node.containsInstance()) {
                if (this.columnIndex == 0) {
                    descriptor = DeviceUIPlugin.getDefault().getImageDescriptor("ICON_DEVICE");
                } else if (this.columnIndex == 1) {
                    IStatus status = StatusRegistry.getInstance().getStatus(node.getInstanceStatus());
                    descriptor = status.getImage();
                }
            }
        } else if (element instanceof ViewerDeviceNode && this.isProvidingForFirstColumn()) {
            ViewerDeviceNode node = (ViewerDeviceNode)element;
            image = node.getDevice().getImage();
            return image;
        }
        if (descriptor != null && (image = this.imageCache.get(descriptor)) == null) {
            image = descriptor.createImage();
            this.imageCache.put(descriptor, image);
        }
        return image;
    }

    public void update(ViewerCell cell) {
        this.columnIndex = cell.getColumnIndex();
        super.update(cell);
        this.columnIndex = this.firstColumnIndex;
    }
}

