/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.graphics.swt;

import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.tml.protocol.PluginProtocolActionDelegate;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.protocol.lib.ProtocolMessage;
import org.eclipse.tml.vncviewer.VNCViewerPlugin;
import org.eclipse.tml.vncviewer.config.IPropertiesFileHandler;
import org.eclipse.tml.vncviewer.graphics.IRemoteDisplay;
import org.eclipse.tml.vncviewer.graphics.swt.ISWTPainter;
import org.eclipse.tml.vncviewer.graphics.swt.SWTVNCEventTranslator;
import org.eclipse.tml.vncviewer.graphics.swt.img.Painter;
import org.eclipse.tml.vncviewer.network.IVNCPainter;
import org.eclipse.tml.vncviewer.network.VNCProtocolData;
import org.eclipse.tml.vncviewer.registry.VNCProtocolRegistry;

public class SWTRemoteDisplay
extends Composite
implements IRemoteDisplay {
    private static final String REMOTE_DISPLAY_STOP_ERROR = "Remote Display Stop error: ";
    private static final String REMOTE_DISPLAY_MOUSE_EVENT_ERROR = "Remote Display mouse event error : ";
    private static final String REMOTE_DISPLAY_KEY_EVENT_ERROR = "Remote Display key event error : ";
    protected Canvas canvas;
    private ProtocolHandle handle;
    private VNCProtocolData protoClient;
    private Image screen = null;
    private Properties configurationProperties;
    private SWTVNCEventTranslator eventTranslator;
    private boolean active = false;
    private long firstRefreshDelayMs;
    private long refreshDelayPeriodMs;
    private int connectionRetries;
    private Timer refreshTimer;
    private Listener keyListener;
    private Listener mouseListener;
    protected PaintListener paintListener = null;
    private double zoomFactor;
    protected ISWTPainter painter;
    private IPropertiesFileHandler propertiesFileHandler;

    public SWTRemoteDisplay(Composite parent, Properties configProperties, IPropertiesFileHandler propertiesFileHandler) {
        super(parent, 8);
        VNCViewerPlugin.log(SWTRemoteDisplay.class).debug("Constructing SWT Remote Display");
        this.configurationProperties = configProperties;
        this.propertiesFileHandler = propertiesFileHandler;
        this.setLayout(parent.getLayout());
        this.canvas = new Canvas((Composite)this, 262144);
        this.eventTranslator = new SWTVNCEventTranslator(configProperties, propertiesFileHandler);
        this.initConfiguration();
    }

    protected int getCanvasStyle() {
        return 8;
    }

    private void initConfiguration() {
        this.connectionRetries = Integer.valueOf(this.configurationProperties.getProperty("CONNECTION_RETRIES"));
        this.zoomFactor = Double.valueOf(this.configurationProperties.getProperty("ZOOM_FACTOR"));
        this.firstRefreshDelayMs = Long.valueOf(this.configurationProperties.getProperty("FIRST_REFRESH_DELAY_MS"));
        this.refreshDelayPeriodMs = Long.valueOf(this.configurationProperties.getProperty("REFRESH_DELAY_PERIOD_MS"));
        VNCViewerPlugin.log(SWTRemoteDisplay.class).info("Using screen parameters: retries=" + this.connectionRetries + "; zoomFactor=" + this.zoomFactor + "; firstRefreshDelay(ms)=" + this.firstRefreshDelayMs + "; refreshDelay(ms)=" + this.refreshDelayPeriodMs + ".");
    }

    private void addKeyListener() {
        this.keyListener = new Listener(){

            public void handleEvent(Event event) {
                Event ev = event;
                if (SWTRemoteDisplay.this.isActive()) {
                    try {
                        SWTRemoteDisplay.this.keyEvent(ev);
                        SWTRemoteDisplay.this.updateRequest(true);
                        SWTRemoteDisplay.this.notifyListeners(ev.type, ev);
                    }
                    catch (Exception exception) {
                        VNCViewerPlugin.log(SWTRemoteDisplay.class).error("Remote Display error on key event.");
                    }
                }
            }
        };
        this.getCanvas().getDisplay().syncExec(new Runnable(){

            public void run() {
                SWTRemoteDisplay.this.canvas.addListener(1, SWTRemoteDisplay.this.keyListener);
                SWTRemoteDisplay.this.canvas.addListener(2, SWTRemoteDisplay.this.keyListener);
            }
        });
    }

    private void addMouseListener() {
        this.mouseListener = new Listener(){

            public void handleEvent(Event event) {
                Event ev = event;
                if (SWTRemoteDisplay.this.isActive()) {
                    try {
                        SWTRemoteDisplay.this.mouseEvent(ev);
                        SWTRemoteDisplay.this.notifyListeners(ev.type, ev);
                    }
                    catch (Exception exception) {
                        VNCViewerPlugin.log(SWTRemoteDisplay.class).error("Remote Display error on key event.");
                    }
                }
            }
        };
        this.getCanvas().getDisplay().syncExec(new Runnable(){

            public void run() {
                SWTRemoteDisplay.this.canvas.addListener(5, SWTRemoteDisplay.this.mouseListener);
                SWTRemoteDisplay.this.canvas.addListener(4, SWTRemoteDisplay.this.mouseListener);
                SWTRemoteDisplay.this.canvas.addListener(3, SWTRemoteDisplay.this.mouseListener);
            }
        });
    }

    private void addRefreshTimer() {
        this.refreshTimer = new Timer();
        final Display display = this.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                try {
                    SWTRemoteDisplay.this.updateRequest(false);
                }
                catch (Exception e) {
                    VNCViewerPlugin.log(SWTRemoteDisplay.class).warn("The first full screen request has failed. Cause: " + e.getMessage());
                }
            }
        });
        final Runnable updateRefresh = new Runnable(){

            public void run() {
                try {
                    SWTRemoteDisplay.this.updateRequest(true);
                }
                catch (Exception e) {
                    SWTRemoteDisplay.this.stop();
                    VNCViewerPlugin.log(SWTRemoteDisplay.class).error("Update screen error: " + e.getMessage());
                }
            }
        };
        this.refreshTimer.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                display.syncExec(updateRefresh);
            }
        }, this.firstRefreshDelayMs, this.refreshDelayPeriodMs);
    }

    public void restart() throws Exception {
        VNCViewerPlugin.log(SWTRemoteDisplay.class).info("Restarting SWT remote display.");
        this.stop();
        PluginProtocolActionDelegate.requestRestartProtocol((ProtocolHandle)this.handle);
        this.start(this.handle);
        VNCViewerPlugin.log(SWTRemoteDisplay.class).info("SWT remote display restarted.");
    }

    public synchronized void start(ProtocolHandle handle) throws Exception {
        VNCViewerPlugin.log(SWTRemoteDisplay.class).info("Starting SWT remote display.");
        this.handle = handle;
        this.protoClient = VNCProtocolRegistry.getInstance().get(handle);
        if (this.protoClient != null) {
            try {
                this.protoClient.setPaintEnabled(true);
                this.protoClient.setVncPainter((IVNCPainter)((Object)this.painter));
                ((Painter)this.painter).setPixelFormat(this.protoClient.getPixelFormat());
                ((IVNCPainter)((Object)this.painter)).setSize(this.protoClient.getFbWidth(), this.protoClient.getFbHeight());
                this.canvas.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        SWTRemoteDisplay.this.canvas.setSize(SWTRemoteDisplay.this.protoClient.getFbWidth(), SWTRemoteDisplay.this.protoClient.getFbHeight());
                    }
                });
                this.addRefreshTimer();
                this.addKeyListener();
                this.addMouseListener();
                Event event = new Event();
                event.x = 0;
                event.y = 0;
                this.mouseEvent(event);
            }
            catch (Exception e) {
                VNCViewerPlugin.log(SWTRemoteDisplay.class).error("Remote Display start error: " + e.getMessage());
            }
            this.setRunning(true);
            VNCViewerPlugin.log(SWTRemoteDisplay.class).info("SWT remote display started.");
        }
    }

    public synchronized void stop() {
        VNCViewerPlugin.log(SWTRemoteDisplay.class).info("Stopping SWT remote display.");
        this.setRunning(false);
        this.refreshTimer.cancel();
        this.canvas.getDisplay().syncExec(new Runnable(){

            public void run() {
                SWTRemoteDisplay.this.canvas.removeListener(2, SWTRemoteDisplay.this.keyListener);
                SWTRemoteDisplay.this.canvas.removeListener(1, SWTRemoteDisplay.this.keyListener);
                SWTRemoteDisplay.this.canvas.removeListener(5, SWTRemoteDisplay.this.mouseListener);
                SWTRemoteDisplay.this.canvas.removeListener(4, SWTRemoteDisplay.this.mouseListener);
                SWTRemoteDisplay.this.canvas.removeListener(3, SWTRemoteDisplay.this.mouseListener);
                SWTRemoteDisplay.this.canvas.removePaintListener(SWTRemoteDisplay.this.paintListener);
            }
        });
        if (this.canvas != null) {
            Point p = this.canvas.getSize();
            GC gc = new GC((Drawable)this.canvas);
            gc.fillRectangle(0, 0, p.x, p.y);
            gc.dispose();
        }
        this.canvas.getDisplay().asyncExec(new Runnable(){

            public void run() {
                SWTRemoteDisplay.this.canvas.setSize(0, 0);
            }
        });
        VNCViewerPlugin.log(SWTRemoteDisplay.class).info("SWT remote display stopped.");
    }

    public void updateRequest(boolean incremental) throws Exception {
        try {
            ProtocolMessage message = new ProtocolMessage(3L);
            message.setFieldValue("x-position", (Object)0);
            message.setFieldValue("y-position", (Object)0);
            message.setFieldValue("width", (Object)this.painter.getWidth());
            message.setFieldValue("height", (Object)this.painter.getHeight());
            message.setFieldValue("incremental", (Object)(incremental ? 1 : 0));
            PluginProtocolActionDelegate.sendMessageToServer((ProtocolHandle)this.handle, (ProtocolMessage)message);
        }
        catch (Exception e) {
            VNCViewerPlugin.log(SWTRemoteDisplay.class).error("Remote Display update screen error : " + e.getMessage());
            this.stop();
        }
        if (this.screen != null) {
            this.screen.dispose();
        }
    }

    public void updateScreen() throws Exception {
        this.updateRequest(true);
    }

    public void keyEvent(Event event) throws Exception {
        try {
            ProtocolMessage message = this.eventTranslator.getKeyEventMessage(event);
            PluginProtocolActionDelegate.sendMessageToServer((ProtocolHandle)this.handle, (ProtocolMessage)message);
            VNCViewerPlugin.log(SWTRemoteDisplay.class).debug("Sent key event");
        }
        catch (Exception e) {
            VNCViewerPlugin.log(SWTRemoteDisplay.class).error(REMOTE_DISPLAY_KEY_EVENT_ERROR + e.getMessage());
            this.stop();
        }
    }

    public void mouseEvent(Event event) throws Exception {
        try {
            ProtocolMessage message = this.eventTranslator.getMouseEventMessage(event);
            Integer x = (Integer)message.getFieldValue("x-position");
            Integer y = (Integer)message.getFieldValue("y-position");
            message.setFieldValue("x-position", (Object)((int)((double)x.intValue() / this.zoomFactor)));
            message.setFieldValue("y-position", (Object)((int)((double)y.intValue() / this.zoomFactor)));
            PluginProtocolActionDelegate.sendMessageToServer((ProtocolHandle)this.handle, (ProtocolMessage)message);
            VNCViewerPlugin.log(SWTRemoteDisplay.class).debug("Sent mouse event");
        }
        catch (Exception e) {
            VNCViewerPlugin.log(SWTRemoteDisplay.class).error(REMOTE_DISPLAY_MOUSE_EVENT_ERROR + e.getMessage());
            this.stop();
        }
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(Canvas canvas) {
        this.canvas = canvas;
    }

    public Image getScreen() {
        return this.screen;
    }

    public void setScreen(Image screen) {
        this.screen = screen;
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    private synchronized void setRunning(boolean running) {
        this.active = running;
    }

    public void dispose() {
        VNCViewerPlugin.log(SWTRemoteDisplay.class).debug("Disposing SWT Remote Display");
        try {
            if (this.protoClient != null) {
                this.protoClient.setPaintEnabled(false);
            }
        }
        catch (Exception e) {
            VNCViewerPlugin.log(SWTRemoteDisplay.class).error(REMOTE_DISPLAY_STOP_ERROR + e.getMessage());
        }
        if (this.screen != null) {
            this.screen.dispose();
        }
        if (this.canvas != null) {
            this.canvas.dispose();
        }
        super.dispose();
    }

    public int getScreenWidth() {
        return this.painter.getWidth();
    }

    public int getScreenHeight() {
        return this.painter.getHeight();
    }

    public Timer getRefreshTimer() {
        return this.refreshTimer;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
        VNCProtocolData data = this.getProtocolData();
        if (data != null) {
            Point canvasSize = new Point(0, 0);
            canvasSize.x = (int)((double)this.getProtocolData().getFbWidth() * zoomFactor);
            canvasSize.y = (int)((double)this.getProtocolData().getFbHeight() * zoomFactor);
            this.getCanvas().setSize(canvasSize);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.canvas != null) {
            this.canvas.setBackground(color);
        }
    }

    public VNCProtocolData getProtocolData() {
        return this.protoClient;
    }

    public void setPropertiesFileHandler(IPropertiesFileHandler propertiesFileHandler) {
        this.propertiesFileHandler = propertiesFileHandler;
    }

    public int getConnectionRetries() {
        return this.connectionRetries;
    }
}

